﻿var userSelectionID = 'AssignBLS';
var $treeDomain;
var $treeDomainMobile;
var $data;
var bind = false;
var desktopCall = false;

(function ($) {
    var blacklistsubscriptionvalidation = function () {
        $('form').validate({
            submitHandler: function (form) {
                $.blacklistsubscription.save();
            }
        });
    };
    var $grid; bind = false;
   
    $.blacklistsubscription = {
        init: function () {
            $.blacklistsubscription.saveButtonClickHandler($('.btn-save2'));
			$.blacklistsubscription.refreshButtonClickHandler($('#action-refresh-grid'));
            $.blacklistsubscription.searchHandler($('input[data-role="search-all-item"]'));
            $.blacklistsubscription.searchButtonClickHandler($('.btn-Search'));

			$.blacklistsubscription.searchUserNotSubscribedHandler($('input#searchBox-unsubscribed'));
			$.blacklistsubscription.searchUserNotSubscribedButtonClickHandler($('#btn-SearchUnsubscribed'));

			$.blacklistsubscription.searchUserSubscribedHandler($('input#searchBox-subscribed'));
			$.blacklistsubscription.searchUserSubscribedButtonClickHandler($('#btn-SearchSubscribed'));

            $.sectionproperties.FirstLevel($('.btn-back2'));     
            
            $.blacklistsubscription.initGrid();
        },
        initGrid: function () {
            /* Kendo grid initialization */
            var id = $('#grid');

            var dataSource = {
                transport: {
                    read: {
                        url: '/Admin/Blacklistsubscription/Read',
                        dataType: "json",
                        type: "GET"
                    },
                    parameterMap: function (options) {

                        var result = {
                            Filter: $('input[data-role="search-all-item"]').val(),
                            Skip: options.skip,
                            Take: options.take,
                            Page: options.page
                        };

                        if (options.sort && options.sort.length > 0) {
                            result.SortBy = options.sort[0].field;
                            result.Direction = options.sort[0].dir;
                        }

                        return result;
                    }
                },
                schema: {
                    data: "Records",
                    total: "Total",
                    model: {
                        id: "BLpID"
                    }
                },
                serverPaging: true,
                serverSorting: true
            };

            var col = [
                
                { field: 'Name', title: $blackListSubResource.name, width: 350, sortable: true },
                { field: 'Desc', title: $blackListSubResource.description, width: 300, sortable: true },
                { field: 'CrByUserName', title: $blackListSubResource.creator, width: 200, sortable: true },
                { field: 'CreatorID', hidden: true },
                { field: 'CrDate', hidden: true }
            ];

            var obj = {};
            obj.allowSelectMultipleRow = true;
            obj.customizeCheckbox = false;
            obj.onSelectionFn = $.blacklistsubscription.editButtonClickHandler;

            $grid = kendogridcustomization.init(id, dataSource, col, obj);

            blacklistsubscriptionvalidation();
        },
		editButtonClickHandler: function (e) {
			$("#editBlackListSubscription").addClass("visibleHidden");
			$("#editBlackListSubscription").parent().addClass("divLoading");

			$(".breadcrumb .add-edit-breadcrumb-item").text(e.Name);
			$.sectionproperties.SecondLevel();
            var domainID = $('#dashboardID').val();
            $('#DomainID').val(domainID);

            var bLpID = e.BLpID;
            $('input[name="RecordId"]').val(bLpID);

            $('#parameter-AssignBLS').val(bLpID);

			$.blacklistsubscription.reset();
        },
        initTreeView: function () {
            /* Domain Selection Treeview */
            $("#DomainSelection-" + userSelectionID + "-id").val($('#dashboardID').val());

            var objSelection = {};
            objSelection.expandAll = true;
            objSelection.declareType = "textbox";

            objSelection.postSelectFn = $.blacklistsubscription.initBLSUser;
			$treeDomain = treeview.init("DomainSelection-" + userSelectionID + "", "DomainSelection-" + userSelectionID + "-name", "DomainSelection-" + userSelectionID + "-id", objSelection);
		},
		initTreeViewMobile: function (e) {
			$('#domain-ddl').val($('#dashboardText').text());
			$("#domain-id").val($('#dashboardID').val());

			var objDomainSelection = {};
			objDomainSelection.expandAll = true;
			objDomainSelection.declareType = "textbox";
			objDomainSelection.postSelectFn = $.blacklistsubscription.selectMainTreeView;
			$treeDomainMobile = treeview.init("domain", "domain-name", "domain-id", objDomainSelection);
		},
		selectMainTreeView: function (currentDomainId) {
			if (!desktopCall)
			{
				var getSelectedNodeID = $treeDomain.getNodeById(currentDomainId);
				if (getSelectedNodeID != null) {
					$treeDomain.unselectAll();
					$treeDomain.select(getSelectedNodeID);
				}
				desktopCall = false;
			}
		},
		initBLSUser: function (currentDomainId) {
			desktopCall = true;

            /* Reflect the selected domain to the domain dropdown in mobile view */
			var getSelectedNodeID = $treeDomainMobile.getNodeById(currentDomainId);
			if (getSelectedNodeID != null) {
				$treeDomainMobile.unselectAll();
				$treeDomainMobile.select(getSelectedNodeID);
			}

            var obj = {
                blurForm: true,
                targetDiv: $("#editBlackListSubscription")
            };
            
            fxcRequest2.get('/Admin/BlackListSubscription/ReadDomain',
            {
                "DomainID": currentDomainId,
                "BLpID": $('input[name="RecordId"]').val()
                }, function (data) {
                /* Check if the domain has subscribed */
                if (data.length !== 0) {
                    $('#checkDomain-' + userSelectionID).prop("checked", true);
                } else {
                    $('#checkDomain-' + userSelectionID).prop("checked", false);
                }

				$.blacklistsubscription.initListBox(currentDomainId);
				desktopCall = false;
            }, obj);
        },
        initListBox: function () {            
             var listBoxID = "listUnsubscribed";
             var listBoxIDConnectWith = "listSubscribed";

            fxcRequest.get('/Admin/BlackListSubscription/ReadUser',
                {
                    BLpID: $('input[name="RecordId"]').val(),
                    DomainID: $('#DomainSelection-AssignBLS-id').val(),
                    SearchUnsub: $('#searchBox-unsubscribed').val(),
                    SearchSub: $('#searchBox-subscribed').val()
                },
                function (data) {
                    var returnObject = [];
                    var dataSourceSelection = {
                        data: data.Unsubscribed
                    };

                    var objUserSelection = {};
                    objUserSelection.dataTextField = "UserList";
                    objUserSelection.dataValueField = "UserID";
					objUserSelection.connectWith = listBoxIDConnectWith;
					objUserSelection.draggable = false;
					
                    var dataSourceSelected = {
                        data: data.Subscribed
                    };

                    listbox.mutual(listBoxID, dataSourceSelection, objUserSelection, dataSourceSelected);
                    
                    if (data.Unsubscribed.length === 0 && data.Subscribed.length === 0) {
                        $('.k-list').append('<div class="text-grey">No records available.</div>');
					}

					
					$("#editBlackListSubscription").removeClass("visibleHidden");
					$("#editBlackListSubscription").parent().removeClass("divLoading");
                },
                function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnLoad, "error");
                });
        },
        saveButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.blacklistsubscription.save();
            });
        },
        refreshButtonClickHandler: function (e) {
            $(e).on('click', function () {

                $('input[data-role="search-all-item"]').val("");

                $.blacklistsubscription.initGrid();
                $(this).blur();
            });
        },
        searchHandler: function (e) {
            $(e).keypress(function (event) {
                if (event.which == 13) {
                    $.blacklistsubscription.initGrid();
                }
            });
        },
        searchButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.blacklistsubscription.initGrid();
            });
        },
        searchUserNotSubscribedHandler: function (e) {
            $(e).keypress(function (event) {
                if (event.which == 13) {
					$.blacklistsubscription.searchUserNotSubscribed();
                }
            });
        },
        searchUserNotSubscribedButtonClickHandler: function (e) {
            $(e).on('click', function () {
				$.blacklistsubscription.searchUserNotSubscribed();
            });
		},

		searchUserSubscribedHandler: function (e) {
			$(e).keypress(function (event) {
				if (event.which == 13) {
					$.blacklistsubscription.searchUserSubscribed();
				}
			});
		},
		searchUserSubscribedButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$.blacklistsubscription.searchUserSubscribed();
			});
		},

        resetButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.blacklistsubscription.reset();
            });
        },
		searchUserNotSubscribed: function () {
			var searchUnsubscribed = $('input#searchBox-unsubscribed').val() != null ? $('input#searchBox-unsubscribed').val().trim() : "";
			$("#listUnsubscribed").getKendoListBox().dataSource.filter({ field: "UserList", operator: "contains", value: searchUnsubscribed });
		},
		searchUserSubscribed: function () {
			var searchSubscribed = $('input#searchBox-subscribed').val() != null ? $('input#searchBox-subscribed').val().trim() : "";
			$("#listSubscribed").getKendoListBox().dataSource.filter({ field: "UserList", operator: "contains", value: searchSubscribed });
		},
        reset: function () {
            $('input[data-role="search-all-user"]').val("");

            if (!bind) {
				$.blacklistsubscription.initTreeView();
                $.blacklistsubscription.initTreeViewMobile();
                treeview.mapState($treeDomain, $treeDomainMobile);

                bind = true;
            }
            else {
				/*Reselect Domain ID*/
				$treeDomain.expandAll();
                $("#DomainSelection-AssignBLS").tree().unselectAll();
                $("#DomainSelection-AssignBLS-id").val($('#dashboardID').val());
                var getData = $("#DomainSelection-AssignBLS").tree().getNodeById($("#DomainSelection-AssignBLS-id").val());

                if (getData != undefined) {
                    $("#DomainSelection-AssignBLS").tree().select(getData);
                }
            }
        },
        save: function () {
            var subUser = $.map($('#listSubscribed option'), function (option) {
                return option.value;
            });

            var saveUser = fxcRequest.post('/Admin/BlackListSubscription/Save', {
                Ids: subUser,
                BLpID: $('input[name="RecordId"]').val(),
                DomainID: $('#DomainSelection-AssignBLS-id').val(),
                SubscribedDomain: $('#checkDomain-AssignBLS').is(':checked') ? true : false
            },
                function (data) {
					swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");
                    $.blacklistsubscription.initGrid();
                },
                function (error) {
                }, false);
        },
        getGridSelections: function (grid) {
            var selectedId = [];
            var entityGrid = grid.data("kendoGrid");
            var rows = entityGrid.select();

            rows.each(function (index, row) {
                var selectedItem = entityGrid.dataItem(row);
                selectedId[index] = selectedItem.UserID;
            });

            return selectedId;
        }
    };
})(window.jQuery);