﻿(function ($) {
	var defaultDateTime = $("#defaultDateFormat").val() + " " + $("#defaultTimeFormat").val();

	var $PassIsEncrypted = false;
	var $TempPassword;

	var timeControl;
	var interval = 60;
	var maxTime = "11:00 PM";

	var tempFormData = null;

	var directorysyncValidation = function () {
		$('#formSubmit').validate({
			ignoreTitle: true,
			rules: {
				Server: {
					required: true,
					noSpace: true
				},
				DefaultUserPassword: {
					required: true,
                    noSpace: true,
                    passwordFormat: true
				},
				Priority: {
					required: true,
					number: true,
					noSpace: true
				},
				MaxUsers: {
					number: true
				},
				MaxLength: {
					number: true
				},
				TimeInterval: {
					required: true,
					noSpace: true
				},
				NextDay: { required: true, fxcDateFormat: [defaultDateTime] }
			},
			errorPlacement: function (error, element) {
				var p = element.parent('span').parent();
				if (p.hasClass('form-control')) {
					error.appendTo(p);
				} else {
					error.insertAfter(element);
				}
			},
			submitHandler: function (form) {
				$.directorysync.save();
			}
		});

	};
	var testConnectionValidation = function () {
		$('#testlogon_formSubmit').validate({
			rules: {
				TestUsername: {
					required: true
				},
				TestPassword: {
					required: true
				}
			},
			submitHandler: function (form) {
				$.directorysync.testlogon_testConn();
			}
		});

	};
	var resetfields = function () {
		$('#formSubmit').trigger("reset");
		$('#formSubmit').validate().resetForm();
		$PassIsEncrypted = true;
	};
	var testlogon_resetfields = function () {
        $('#testlogon_formSubmit').trigger("reset");
        $('#testlogon_formSubmit').validate().resetForm();
    };
    var readdirectory_resetfields = function () {
        $.directorysync.initGridADUser();
        $('.View2 label.form-control-static').text('');
    };

	$.directorysync = {
		init: function (e) {
			tempFormData = null;
			$PassIsEncrypted = true;

			$.directorysync.resetConnPassword();
			$.directorysync.initDateTime();

			$("#MaxUsers").mask('9999999999');
			$("#Priority").mask('9999999999');
			$("#MaxLength").mask('9999999999');

			$('.btn-save').on('click', function () {
				$("#formSubmit").submit();
			});

			$.directorysync.simulateButtonClickHandler($('.btn-Simulate'));
			$.directorysync.fullSyncButtonClickHandler($('.btn-FullSynchronization'));
			$.directorysync.testConButtonClickHandler($('.btn-TestConnection'));
			$.directorysync.resetHandler($('.btn-Reset'));
			$.directorysync.deleteHandler($('.btn-delete'));
			$.directorysync.refreshButtonClickHandler($('.btn-refresh'));
			$.directorysync.readdirectory_searchHandler($('input[data-role="search-all-item"]'));
			$.directorysync.readdirectory_searchButtonClickHandler($('.btn-Search'));
			$.directorysync.testlogon_resetmodalHandler($('button[data-role="reset-modal-value"]'));
			$.directorysync.testlogon_saveclosemodalHandler($('button[data-role="testlogon-modal"]'));

			$.sectionproperties.FirstLevel($('.btn-back2'));
			$('.btn-ReadDirectory').on('click', function () {
                $.directorysync.readDirHandler();
                $.sectionproperties.SecondLevel(this);
			});

			$('.Link-Advanced').on('click', function () {
				if ($(".HiddenAdvanced").hasClass("hide")) {
					$(".Link-Advanced").text($dirSyncResources.viewLess);
					$(".HiddenAdvanced").removeClass("hide");
				}
				else {
					$(".Link-Advanced").text($dirSyncResources.viewMore);
					$(".HiddenAdvanced").addClass("hide");
				}
			});

			$('select#ExchangeVersion').on('change', function (event, state) {
				var result = true;
				var returnValue = $(this).val();
				if (returnValue == "2003") {
					result = false;
				}

				$.sectionproperties.Hidden(this.id, result, true);
			});
			$("select#ExchangeVersion").change();
			directorysyncValidation();
			testConnectionValidation();

			$.directorysync.generateTempData();
		},
		constructmodel: function (action) {
			return {
				"Provider": { "Value": $('#Provider').val() },
				"Server": $('#Server').val(),
				"UserName": $('#UserName').val(),
				"Password": $('#Password').val(),
				"AuthType": { "Value": $('#AuthType').val() },

				"Domain": $('#Domain').val(),
				"OrganizationUnit": $('#OrganizationUnit').val(),
				"SecurityGroup": $('#SecurityGroup').val(),
				"Filter": $('#Filter').val(),

				"PropertyToRead": $('#PropertyToRead').val(),
				"MaxUsers": $('#MaxUsers').val(),

				"SyncMode": { "Value": $('#SyncMode').val() },
				"IsAutoSyncActive": $('#IsAutoSyncActive').prop("checked"),

				"IntervalType": { "Value": $('#Interval').val() },
				"IntervalValue": $('#TimeInterval').val(),
				"AutoSyncNextDate": $("#NextDay").val() ? moment($("#NextDay").val(), defaultDateTime).format() : "",

				"UserNameFormat": { "Value": $('#UserNameFormat').val() },
				"DefaultUserPassword": $('#DefaultUserPassword').val(),
				"DefaultPreferAddrTypeID": { "Value": $('#DefaultPreferAddrTypeID').val() },
				"IsExtAuthOn": { "Value": $('#IsExtAuthOn').val() },
				"NewUserInboundRouteHandle": { "Value": $('#NewUserInboundRouteHandle').val() },

				"ExistUserInboundRouteHandle": { "Value": $('#ExistUserInboundRouteHandle').val() },

				"CustomAttribute": $('#CustomAttribute').val(),
				"Priority": $('#Priority').val(),
				"PrefixAppend": $('#PrefixAppend').val(),
				"MaxLength": $('#MaxLength').val(),

				"DeleteUserHandle": { "Value": $('#DeleteUserHandle').val() },

				"ExchangeServer": $('#ExchangeServer').val(),
				"ExchangeVersion": { "Value": $('#ExchangeVersion').val() },
				"IsBasedAuthentication": $('#IsBasedAuthentication').prop("checked"),


				"DomainId": $('#DomainId').val(),
				PasswordIsEncrypted: $PassIsEncrypted

			};
		},
		save: function () {
			var model = $.directorysync.constructmodel("1");

			fxcRequest.post('/Admin/Domain/DirectorySync'
				, model
				, function (data) {
					swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");
					$("#NewRecord").val("False");
					$.directorysync.generateTempData();
				}
				, null);
		},
		delete: function () {
			fxcRequest.post('/admin/directorysync/delete'
				, {
					"DomainId": $('#DomainId').val(),
				}
				, function (dataItem) {
					swal($globalMessages.swal.success.title, $dirSyncResources.swal.successDeleteProfile, "success");
					$('#formSubmit').BindToForm(dataItem, '#', '');

					$.directorysync.generateTempData();
				}
				, function (error) {
					swal($globalMessages.swal.error.errorCap, $dirSyncResources.swal.errorDeleteProfile, "error");
				});
		},
		generateTempData: function () {
			tempFormData = $('#formSubmit').MapFormData();
			tempFormData.TimeIntervalHolder = $('#TimeInterval').val();

			console.log("generateTempData");
			console.log(tempFormData);

			setTimeout(function () { $('.btn-Reset').click(); }, 1000);
		},
		deleteHandler: function (e) {
			$(e).on('click', function () {
				swal({
					title: "",
					text: $dirSyncResources.swal.confirmDeleteProfile,
					type: "info",
					showCancelButton: true,
					closeOnConfirm: false,
					reverseButtons: true
				}, function () {
					$(".confirm").prop("disabled", true);
					$.directorysync.delete();
				});
			});
		},
		resetHandler: function (e) {
			$(e).on('click', function () {

				$(".LoadingDiv").show();
				$(".ContentDiv").hide();

                if (tempFormData != null && tempFormData.length > 0) {

					$.each(tempFormData, function (index, value) {
						var objId = value.Id;
						var objVal = value.Value;

						var controlId = '#' + value.Id;

						if (objId == "IsAutoSyncActive" || objId == "IsBasedAuthentication") {
							$(controlId).bootstrapSwitch('state', objVal);
						} else if (objId == "TimeInterval") {
							$.directorysync.setTime(tempFormData.TimeIntervalHolder);
						} else if (objId == "ExchangeVersion") {
							$(controlId).val(objVal).change();
						} else {
							$(controlId).val(objVal);
						}
					});

				} else {
					resetfields();
				}

				var getNewRecord = $("#NewRecord").val() + "";
				if (getNewRecord.toLowerCase() == "true") {
					$(".btn-delete").addClass("Hidden");
				}
				else {
					$(".btn-delete").removeClass("Hidden");
				}

				$(".LoadingDiv").hide();
				$(".ContentDiv").show();
			});
		},
		initDateTime: function (e) {

			var obj = {};
			obj.minDate = $("#MinDate").val();
			fxcDateTimePicker.init('#NextDay', defaultDateTime, obj);

			/*interval value*/
			timeControl = $("#TimeInterval").kendoTimePicker({
				interval: interval,
				format: "HH:mm"
			}).data("kendoTimePicker");

			var intervalVal = $('#IntervalValueString').val();
			if (intervalVal != null && intervalVal != "") {
				$.directorysync.setTime(intervalVal);
			}
		},
        setTime: function (intervalVal) {
            if (intervalVal != "") {
                var intervalTime = new Date();
                var valArr = intervalVal.split(":");
                intervalTime.setHours(valArr[0]);
                intervalTime.setMinutes(valArr[1]);
                timeControl.value(intervalTime);
            }
		},
		resetConnPassword: function (e) {
			$("#Password").focus(function () {
				if ($PassIsEncrypted) {
					$TempPassword = $("#Password").val();
					$("#Password").val("");
				}
			});
			$("#Password").keyup(function () {
				$PassIsEncrypted = false;
			});
			$("#Password").focusout(function () {
				if ($PassIsEncrypted) {
					$("#Password").val($TempPassword);
				}
			});
		},
		constructTestConnmodel: function () {
			return {
				"Provider": { "Value": $('#TestProvider').val() },
				"Server": $('#TestServer').val(),
				"UserName": $('#TestUsername').val(),
				"Password": $('#TestPassword').val()
			};
		},
		constructColumnObj: function (e) {
			jsonObj = [];
			$(e).each(function (index, data) {

				item = {};
				item["field"] = data.Field;
				item["title"] = data.Title;
                item["width"] = Number(data.Width);
                item["template"] = '<span class="ellipsis-row-3">#= ' + data.Field + ' #</span>';
                item["attributes"] = { 'title': '#= ' + data.Field + ' #' };

				jsonObj.push(item);
			});
			return jsonObj;
		},
		initgridinfolog: function (e, data) {
			var kendoControl = $('#gridinfolog').data("kendoGrid");
			if (kendoControl != null) {
				$('#gridinfolog').empty();
			}

			var row = data.InfoSyncLog;

			var col = [
                { field: 'Cell1', title: $dirSyncResources.grid.levelDate, width: 150, sortable: true },
                { field: 'Cell2', title: $dirSyncResources.grid.message, width: 300, sortable: true }
			];

			var id = $('#gridinfolog');

			var dataSource = {
				data: row
			};

			var obj = {};
			obj.allowSelectMultipleRow = true;
			obj.customizeCheckbox = true;

			kendogridcustomization.init(id, dataSource, col, obj);
		},
		initgriderrorlog: function (e, data) {

			var kendoControl = $('#griderrorlog').data("kendoGrid");
			if (kendoControl != null) {
				$('#griderrorlog').empty();
			}

			var row = data.ErrorSyncLog;

			var col = [
                { field: 'Cell1', title: $dirSyncResources.grid.levelDate, width: 150, sortable: true },
                { field: 'Cell2', title: $dirSyncResources.grid.message, width: 300, sortable: true }
			];

			var id = $('#griderrorlog');

			var dataSource = {
				data: row
			};

			var obj = {};
			obj.allowSelectMultipleRow = true;
			obj.customizeCheckbox = true;

			kendogridcustomization.init(id, dataSource, col, obj);
		},
		initgridextendlog: function (e, data) {

			var kendoControl = $('#gridextendlog').data("kendoGrid");
			if (kendoControl != null) {
				$('#gridextendlog').empty();
			}

			var row = data.ExtendedSyncLog;

			var col = [
                { field: 'Cell1', title: $dirSyncResources.grid.levelDate, width: 150, sortable: true },
                { field: 'Cell2', title: $dirSyncResources.grid.message, width: 300, sortable: true }
			];

			var id = $('#gridextendlog');

			var dataSource = {
				data: row
			};

			var obj = {};
			obj.allowSelectMultipleRow = true;
			obj.customizeCheckbox = true;

			kendogridcustomization.init(id, dataSource, col, obj);
		},
		initGridADUser: function (data) {
			var kendoControl = $("#gridReadDir").data("kendoGrid");
			if (kendoControl != null) {
				$("#gridReadDir").empty();
			}

            var row, col = [{ 'field': 'Default', 'title': ' ' }];

            if (data != null) {
                row = JSON.parse(data.ADUserList);
                col = $.directorysync.constructColumnObj(data.ADUserColumn);
            }

			var id = $('#gridReadDir');

			var dataSource = {
				data: row
			};

			var obj = {};
			obj.allowSelectMultipleRow = true;
			obj.customizeCheckbox = true;

			kendogridcustomization.init(id, dataSource, col, obj);
		},
		populateSyncLogTable: function (e) {

			$('span#lblTotalAbortedUsr').text(e.LblTotalAbortedUsr);
			$('span#lblTotalProcUsr').text(e.LblTotalProcUsr);
			$('span#lblTotalSkipUsr').text(e.LblTotalSkipUsr);
			$('span#lblTotalUsrAdded').text(e.LblTotalUsrAdded);
			$('span#lblTotalUsrDel').text(e.LblTotalUsrDel);
			$('span#lblTotalUsrInact').text(e.LblTotalUsrInact);
			$('span#lblTotalUsrUpd').text(e.LblTotalUsrUpd);
			$('span#lblTotalProcTime').text(e.LblTotalProcTime);

			$.directorysync.initgridinfolog($('#gridinfolog'), e);
			$.directorysync.initgridextendlog($('#gridextendlog'), e);
			$.directorysync.initgriderrorlog($('#griderrorlog'), e);
		},
		simulateButtonClickHandler: function (e) {
			$(e).on('click', function () {
				var model = $.directorysync.constructmodel("1");

				fxcRequest.post('/admin/directorysync/simulate'
					, model
					, function (data) {
						$('#simulation-fullsynchronization-modal').modal('show');
						$.directorysync.populateSyncLogTable(data);
						swal.close();
					}
					, function (error) {
                        swal($globalMessages.swal.error.errorCap, $dirSyncResources.swal.errorSimulate, "error");
					});

			});
		},
		fullSyncButtonClickHandler: function (e) {
			$(e).on('click', function () {
				fxcRequest.post('/admin/directorysync/fullSynchronization'
					, $.directorysync.constructmodel("1")
					, function (data) {
						$('#simulation-fullsynchronization-modal').modal('show');
						$.directorysync.populateSyncLogTable(data);
						swal.close();
					}
					, function (error) {
                        swal($globalMessages.swal.error.errorCap, $dirSyncResources.swal.errorFullSync, "error");
					});

			});

		},
        readDirHandler: function () {
            readdirectory_resetfields();

			fxcRequest.post('/admin/directorysync/readdirectory'
				, $.directorysync.constructmodel("1")
				, function (data) {
					$.directorysync.populateReadDirData(data);
                    swal.close();
                }
				, function (error) {
                    swal($globalMessages.swal.error.errorCap, $dirSyncResources.swal.errorReadDir, "error");
				});
		},
		populateReadDirData: function (e) {
			console.log(e);
			$.directorysync.initGridADUser(e);

			$('label#SearchPath').text(e.TxtSrchPath);
			$('label#SearchFilter').text(e.TxtSrchFilter);
			$('label#TotalUser').text(e.TxtTotalUsr);

			$('label#Description').text(e.TxtDesc);
			$('label#DisplayName').text(e.TxtDispNm);
			$('label#FirstName').text(e.TxtFirstNm);
			$('label#MiddleName').text(e.TxtMidNm);
			$('label#LastName').text(e.TxtLastNm);

			$('label#CompanyName').text(e.TxtCompNm);
			$('label#UserName').text(e.TxtUsrNm);
			$('label#TelNo').text(e.TxtTelNum);
			$('label#FaxNo').text(e.TxtFxNum);
			$('label#Email').text(e.TxtEml);
			$('label#RoutingDigits').text(e.TxtRouteDigit);
			$('label#SyncID').text(e.TxtSyncID);
			$('label#Groups').text(e.TxtGroup);

			$('label#DistinguishedName').text(e.TxtDistNm);
			$('label#CoverPage').text(e.TxtCP);
			$('label#Priority').text('');
		},
		testConButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$('#test-connection-modal').modal('show');
				testlogon_resetfields();
			});
		},
		refreshButtonClickHandler: function (e) {
			$(e).on('click', function () {
				gridcustomization.clearNoRecords($grid);
				$('input[data-role="search-all-item"]').val("");
				$grid.reload({
					page: 1,
					searchText: ""
				});
			});
		},
		readdirectory_searchButtonClickHandler: function (e) {
			$(e).on('click', function () {
				var searchResult = $('input[data-role="search-all-item"]').val();
				gridcustomization.clearNoRecords($grid);
				$grid.reload({
					page: 1,
					searchText: searchResult
				});
			});
		},
		readdirectory_searchHandler: function (e) {
			$(e).keypress(function (event) {
				if (event.which === 13) {
					gridcustomization.clearNoRecords($grid);
					$grid.reload({
						page: 1,
						searchText: $(this).val()
					});
				}
			});
		},
		testlogon_resetmodalHandler: function (e) {
            $(e).on('click', function () {
				testlogon_resetfields();
			});
		},
		testlogon_saveclosemodalHandler: function (e) {
			$(e).on('click', function () {
				$('#testlogon_formSubmit').submit();
			});
		},
		testlogon_testConn: function () {
			fxcRequest.post('/admin/directorysync/testconnection'
				, $.directorysync.constructTestConnmodel()
				, function (data) {
					if (data == true) {
						swal($dirSyncResources.authTitle, $dirSyncResources.authSuccess, "success");
					} else {
						swal($dirSyncResources.authTitle, $dirSyncResources.authFailed, "error");
					}
				}
				, function (error) {
                    swal($globalMessages.swal.error.errorCap, $dirSyncResources.swal.errorTestConnection, "error");
				});
		}
	};
})(window.jQuery);
