﻿(function ($) {
	var domainsettingsValidation = function () {
		$('#formSubmit').validate({
			ignoreTitle: true,
			rules: {
				'CompanyName.Value': { required: true, noSpace: true },
				'GeneralDeliveryFrm.Value': { email: true },
				'GeneralNotificationFrm.Value': { email: true },
				'GeneralPwdSenderFrm.Value': { email: true },
				QueuePriorityDec: { number: true },
				SendXmitRetryDelayFax: { number: true },
				SendXmitRetryDelayFaxRaw: { number: true },
				SendXmitRetryDelayEmail: { number: true },
				SendXmitRetryDelayHttp: { number: true },
				SendXmitRetryDelayFtp: { number: true },
				SendXmitRetryDelayFile: { number: true },
				SendXmitRetryDelayPrinter: { number: true },
				'SupportEmailFrm.Value': { email: true },
				'SupportReqEmail.Value': { email: true },
				'Enforce2FAProvider': {
					required: {
						depends: function (element) {
							return $('#Enforce2FA').prop("checked");
						}
					}
				},
			},
			submitHandler: function (form) {
				if ($("#form-action").val() === 'ApplyAll') {
					$.domainsettings.applyall();
				}
				else {
					$.domainsettings.save();
				}
			}
		});

	};

	var showSweet = function () {
		swal({
			title: $globalMessages.swal.warningTitle,
			text: $areaResources.swal.applyToAllDomain,
			type: "warning",
			showConfirmButton: true,
			showCancelButton: true,
			closeOnConfirm: false
		}, function (isConfirmed) {
			if (isConfirmed) {
				$("#form-action").val("ApplyAll");
				$("#formSubmit").submit();
			}
		});
	}


	$.domainsettings = {
		init: function (e) {
			$("#QueuePriorityDec").mask('99999999999999');
			$("#SendXmitRetryDelayFax").mask('99999999999999');
			$("#SendXmitRetryDelayFaxRaw").mask('99999999999999');
			$("#SendXmitRetryDelayEmail").mask('99999999999999');
			$("#SendXmitRetryDelayHttp").mask('99999999999999');
			$("#SendXmitRetryDelayFtp").mask('99999999999999');
			$("#SendXmitRetryDelayFile").mask('99999999999999');
			$("#SendXmitRetryDelayPrinter").mask('99999999999999');

			domainsettingsValidation();
			$('.btn-save').on('click', function () {
				$("#form-action").val("");
				$("#formSubmit").submit();
			});

			$('.btn-apply-all').on('click', function () {
				showSweet();
			});

			$('#btn-UsrPreferFileFormat').on('click', function () {
				$.domainsettings.applyallContactClick();
			});

			$('#btn-Enforce2FA').on('click', function () {
				$.domainsettings.applyallUserClick();
			});
			
			$(document).on('keyup', function (e) {
				var code = e.code;
				if (code == 'Space') {
					if ($('.sweet-alert.visible').length > 0) {
						swal.close();
					}
				}
			});

			$(document).on('keydown', function (e) {
				var code = e.code;
				if (code == 'Enter') {
					if ($('.sweet-alert.visible').length > 0) {
						swal.close();
					}
				}
			});

			$('.btn-apply-all').bind("click", showSweet).focus();
		},
		constructmodel: function (action) {
			return {
				"CompanyName": { "Value": $('#CompanyName').val(), "IsSet": $('#CompanyName_IsSet').prop("checked") },
				"CompanyAddrStreet1": { "Value": $('#CompanyAddrStreet1').val(), "IsSet": $('#CompanyAddrStreet1_IsSet').prop("checked") },
				"CompanyAddrStreet2": { "Value": $('#CompanyAddrStreet2').val(), "IsSet": $('#CompanyAddrStreet2_IsSet').prop("checked") },
				"CompanyAddrStreet3": { "Value": $('#CompanyAddrStreet3').val(), "IsSet": $('#CompanyAddrStreet3_IsSet').prop("checked") },
				"CompanyAddrCity": { "Value": $('#CompanyAddrCity').val(), "IsSet": $('#CompanyAddrCity_IsSet').prop("checked") },
				"CompanyAddrState": { "Value": $('#CompanyAddrState').val(), "IsSet": $('#CompanyAddrState_IsSet').prop("checked") },
				"CompanyAddrPostal": { "Value": $('#CompanyAddrPostal').val(), "IsSet": $('#CompanyAddrPostal_IsSet').prop("checked") },
				"CompanyAddrCountry": { "Value": $('#CompanyAddrCountry').val(), "IsSet": $('#CompanyAddrCountry_IsSet').prop("checked") },

				"CultureLanguage": { "Value": $('#CultureLanguage').val(), "IsSet": $('#CultureLanguage_IsSet').prop("checked") },
				"CultureDateFormat": { "Value": $('#CultureDateFormat').val(), "IsSet": $('#CultureDateFormat_IsSet').prop("checked") },
				"CultureTimeFormat": { "Value": $('#CultureTimeFormat').val(), "IsSet": $('#CultureTimeFormat_IsSet').prop("checked") },
				"CultureTimeZone": { "Value": $('#CultureTimeZone').val(), "IsSet": $('#CultureTimeZone_IsSet').prop("checked") },

				"QueuePriority": { "Value": $('#QueuePriority').val(), "IsSet": $('#QueuePriority_IsSet').prop("checked") },
				"QueuePriorityDec": { "Value": $('#QueuePriorityDec').val(), "IsSet": $('#QueuePriorityDec_IsSet').prop("checked") },

				"GeneralPwdSenderFrm": { "Value": $('#GeneralPwdSenderFrm').val(), "IsSet": $('#GeneralPwdSenderFrm_IsSet').prop("checked") },
				"GeneralNotificationFrm": { "Value": $('#GeneralNotificationFrm').val(), "IsSet": $('#GeneralNotificationFrm_IsSet').prop("checked") },
				"GeneralDeliveryFrm": { "Value": $('#GeneralDeliveryFrm').val(), "IsSet": $('#GeneralDeliveryFrm_IsSet').prop("checked") },

				"SupportComp": { "Value": $('#SupportComp').val(), "IsSet": $('#SupportComp_IsSet').prop("checked") },
				"SupportAddr": { "Value": $('#SupportAddr').val(), "IsSet": $('#SupportAddr_IsSet').prop("checked") },
				"SupportPhone": { "Value": $('#SupportPhone').val(), "IsSet": $('#SupportPhone_IsSet').prop("checked") },
				"SupportWebsite": { "Value": $('#SupportWebsite').val(), "IsSet": $('#SupportWebsite_IsSet').prop("checked") },
				"SupportEmailFrm": { "Value": $('#SupportEmailFrm').val(), "IsSet": $('#SupportEmailFrm_IsSet').prop("checked") },
				"SupportReqEmail": { "Value": $('#SupportReqEmail').val(), "IsSet": $('#SupportReqEmail_IsSet').prop("checked") },
				"SupportReqUrl": { "Value": $('#SupportReqUrl').val(), "IsSet": $('#SupportReqUrl_IsSet').prop("checked") },

				"AuthApprovalUserID": { "Value": $("#AuthApprovalUserID").val(), "IsSet": $('#AuthApprovalUserID_IsSet').prop("checked") },
				"SendCtrlTrackMax": { "Value": $('#SendCtrlTrackMax').val(), "IsSet": $('#SendCtrlTrackMax_IsSet').prop("checked") },

				"TemplateDelivery": { "Value": $('#TemplateDelivery').val(), "IsSet": $('#TemplateDelivery_IsSet').prop("checked") },
				"TemplateNotifyMSS": { "Value": $('#TemplateNotifyMSS').val(), "IsSet": $('#TemplateNotifyMSS_IsSet').prop("checked") },
				"TemplateNotifyMSF": { "Value": $('#TemplateNotifyMSF').val(), "IsSet": $('#TemplateNotifyMSF_IsSet').prop("checked") },
				"TemplateNotifyMRS": { "Value": $('#TemplateNotifyMRS').val(), "IsSet": $('#TemplateNotifyMRS_IsSet').prop("checked") },
				"TemplateNotifyMRF": { "Value": $('#TemplateNotifyMRF').val(), "IsSet": $('#TemplateNotifyMRF_IsSet').prop("checked") },
				"TemplateNotifyRRS": { "Value": $('#TemplateNotifyRRS').val(), "IsSet": $('#TemplateNotifyRRS_IsSet').prop("checked") },
				"TemplateNotifyRRF": { "Value": $('#TemplateNotifyRRF').val(), "IsSet": $('#TemplateNotifyRRF_IsSet').prop("checked") },
				"TemplateNotifyMAR": { "Value": $('#TemplateNotifyMAR').val(), "IsSet": $('#TemplateNotifyMAR_IsSet').prop("checked") },
				"TemplateNotifyMFR": { "Value": $('#TemplateNotifyMFR').val(), "IsSet": $('#TemplateNotifyMFR_IsSet').prop("checked") },
				"TemplateNotifySP": { "Value": $('#TemplateNotifySP').val(), "IsSet": $('#TemplateNotifySP_IsSet').prop("checked") },
				"TemplateResetPwd": { "Value": $('#TemplateResetPwd').val(), "IsSet": $('#TemplateResetPwd_IsSet').prop("checked") },
				"TemplatePrintMsg": { "Value": $('#TemplatePrintMsg').val(), "IsSet": $('#TemplatePrintMsg_IsSet').prop("checked") },
				"TemplateNotifyAR": { "Value": $('#TemplateNotifyAR').val(), "IsSet": $('#TemplateNotifyAR_IsSet').prop("checked") },
				"TemplateNotifyARS": { "Value": $('#TemplateNotifyARS').val(), "IsSet": $('#TemplateNotifyARS_IsSet').prop("checked") },
				"TemplateNotifyARF": { "Value": $('#TemplateNotifyARF').val(), "IsSet": $('#TemplateNotifyARF_IsSet').prop("checked") },
				"TemplateNotifyMSB": { "Value": $('#TemplateNotifyMSB').val(), "IsSet": $('#TemplateNotifyMSB_IsSet').prop("checked") },

				"SendXmitRetryDelayFax": { "Value": $('#SendXmitRetryDelayFax').val(), "IsSet": $('#SendXmitRetryDelayFax_IsSet').prop("checked") },
				"SendXmitRetryDelayFaxRaw": { "Value": $('#SendXmitRetryDelayFaxRaw').val(), "IsSet": $('#SendXmitRetryDelayFaxRaw_IsSet').prop("checked") },
				"SendXmitRetryDelayEmail": { "Value": $('#SendXmitRetryDelayEmail').val(), "IsSet": $('#SendXmitRetryDelayEmail_IsSet').prop("checked") },
				"SendXmitRetryDelayHttp": { "Value": $('#SendXmitRetryDelayHttp').val(), "IsSet": $('#SendXmitRetryDelayHttp_IsSet').prop("checked") },
				"SendXmitRetryDelayFtp": { "Value": $('#SendXmitRetryDelayFtp').val(), "IsSet": $('#SendXmitRetryDelayFtp_IsSet').prop("checked") },
				"SendXmitRetryDelayFile": { "Value": $('#SendXmitRetryDelayFile').val(), "IsSet": $('#SendXmitRetryDelayFile_IsSet').prop("checked") },
				"SendXmitRetryDelayPrinter": { "Value": $('#SendXmitRetryDelayPrinter').val(), "IsSet": $('#SendXmitRetryDelayPrinter_IsSet').prop("checked") },
				"SendXmitMxAttemptFax": { "Value": $('#SendXmitMxAttemptFax').val(), "IsSet": $('#SendXmitMxAttemptFax_IsSet').prop("checked") },
				"SendXmitMxAttemptFaxRaw": { "Value": $('#SendXmitMxAttemptFaxRaw').val(), "IsSet": $('#SendXmitMxAttemptFaxRaw_IsSet').prop("checked") },
				"SendXmitMxAttemptEmail": { "Value": $('#SendXmitMxAttemptEmail').val(), "IsSet": $('#SendXmitMxAttemptEmail_IsSet').prop("checked") },
				"SendXmitMxAttemptHttp": { "Value": $('#SendXmitMxAttemptHttp').val(), "IsSet": $('#SendXmitMxAttemptHttp_IsSet').prop("checked") },
				"SendXmitMxAttemptFtp": { "Value": $('#SendXmitMxAttemptFtp').val(), "IsSet": $('#SendXmitMxAttemptFtp_IsSet').prop("checked") },
				"SendXmitMxAttemptFile": { "Value": $('#SendXmitMxAttemptFile').val(), "IsSet": $('#SendXmitMxAttemptFile_IsSet').prop("checked") },
				"SendXmitMxAttemptPrinter": { "Value": $('#SendXmitMxAttemptPrinter').val(), "IsSet": $('#SendXmitMxAttemptPrinter_IsSet').prop("checked") },

				"RenderEmailAttachFormat": { "Value": $('#RenderEmailAttachFormat').prop("checked"), "IsSet": $('#RenderEmailAttachFormat_IsSet').prop("checked") },

				"Enforce2FA": { "Value": $('#Enforce2FA').prop("checked"), "IsSet": $('#Enforce2FA_IsSet').prop("checked") },
				"Enforce2FAProvider": { "Value": $('#Enforce2FAProvider').val(), "IsSet": $('#Enforce2FAProvider_IsSet').prop("checked") },

				"UsrPreferPrintSaveFormat": { "Value": $('#UsrPreferPrintSaveFormat').prop("checked"), "IsSet": $('#UsrPreferPrintSaveFormat_IsSet').prop("checked") },
				"UsrPreferFileFormat": { "Value": $('#UsrPreferFileFormat').prop("checked"), "IsSet": $('#UsrPreferFileFormat_IsSet').prop("checked") },
				"UsrDefaultGridPageSize": { "Value": $('#UsrDefaultGridPageSize').val(), "IsSet": $('#UsrDefaultGridPageSize_IsSet').prop("checked") },
				"UsrDefaultGridRefreshInterval": { "Value": $('#UsrDefaultGridRefreshInterval').val(), "IsSet": $('#UsrDefaultGridRefreshInterval_IsSet').prop("checked") },
				"UsrPreferSendernameFilter": { "Value": $('#UsrPreferSendernameFilter').val(), "IsSet": $('#UsrPreferSendernameFilter_IsSet').prop("checked") },

				"DomainId": $('#DomainId').val(),
				"Action": action
			};
		},
		save: function () {
			fxcRequest.post('/Admin/Domain/DomainSetting'
				, $.domainsettings.constructmodel("1")
				, function (data) {
					swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");
					fxcUserConn.onDomainChanges($('#DomainId').val(), false, true, true);
					$("#Enforce2FAProvider").attr("disabled", $('#Enforce2FA').prop('checked'));
				}
				, function (error) {
					swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
				});
		},
        applyall: function () {
            fxcRequest.post('/Admin/Domain/DomainSetting'
                , $.domainsettings.constructmodel("2")
				, function (data) {
                    swal($globalMessages.swal.success.title, $areaResources.swal.applyToAll, "success");
					fxcUserConn.onDomainChanges($('#DomainId').val(), true, true, true);
					$("#Enforce2FAProvider").attr('disabled', $('#Enforce2FA').prop('checked'));
                }
                , null);
		},
		applyallContactClick: function () {
			swal({
				title: $globalMessages.swal.warningTitle,
				text: $areaResources.swal.applyToAllContactDomainWarning,
				type: "warning",
				showConfirmButton: true,
				showCancelButton: true,
				closeOnConfirm: false
			}, function (isConfirmed) {
				if (isConfirmed) {
					$.domainsettings.applyallContact();
				}
			});
		},
		applyallUserClick: function () {
			var checkEnforce2FA = $('#Enforce2FA').prop("checked");
			var checkEnforce2FAProvider = $('#Enforce2FAProvider').val().length > 0;

			if (!checkEnforce2FA || (checkEnforce2FA && checkEnforce2FAProvider)) {
				swal({
					title: $globalMessages.swal.warningTitle,
					text: $areaResources.swal.applyToAllUserDomainWarning,
					type: "warning",
					showConfirmButton: true,
					showCancelButton: true,
					closeOnConfirm: false
				}, function (isConfirmed) {
					if (isConfirmed) {
						$.domainsettings.applyallUser();
					}
				});
			}
			else if (checkEnforce2FA && !checkEnforce2FAProvider)
			{
				swal({
					title: $globalMessages.swal.error.title,
					text: $areaResources.swal.ApplyToAllUserRequired,
					type: "warning"
				})
            }
		},
		applyallContact: function () {
			fxcRequest.post('/Admin/DomainSetting/ApplyAllContact',
				{
					"DomainId": $('#DomainId').val(),
					"FormatFileIsPDF": $('#UsrPreferFileFormat').bootstrapSwitch('state'),
					"InclSubDomain": true
				},
				function (data) {
					swal($globalMessages.swal.success.title, $areaResources.swal.applyToAllContactDomainSuccess, "success");
				}, null);
		},
		applyallUser: function () {
			fxcRequest.post('/Admin/DomainSetting/ApplyAllUserEnforce2FA',
				{
					"DomainId": $('#DomainId').val(),
					"Enable2FA": $('#Enforce2FA').bootstrapSwitch('state'),
					"Enable2FAProvider": $('#Enforce2FAProvider').val(),
					"InclSubDomain": true
				},
				function (data) {
					swal($globalMessages.swal.success.title, $areaResources.swal.applyToAllUserDomainSuccess, "success");
				}, null);
		}
	};
})(window.jQuery);
