﻿(function ($) {
	var setGrid = true;
	var validation = function () {
		$('#formSubmit').validate({
			ignoreTitle: true,
			rules: {
				'TelcoDialRulesCountryCode.Value': {
					required: true,
					number: true,
					noSpace: true
				},
				FaxRecvUnassignedUserName: {
					required: true,
					noSpace: true
				},
				TelcoDialRulesAreaCode: { number: true },
				FaxSendPageCountLimit: { number: true },
				SendCtrlUsrXsactLimit: { number: true }
			},
			submitHandler: function (form) {
				$.faxSetting.save($('input[name="form-action"]').val());
			}
		});
	};

	var showSweet = function () {
		swal({
			title: $globalMessages.swal.warningTitle,
			text: $areaResources.swal.applyToAllDomain,
			type: "warning",
			showConfirmButton: true,
			showCancelButton: true,
			closeOnConfirm: false
		}, function (isConfirmed) {
			if (isConfirmed) {
				$('input[name="form-action"]').val("2");
				$('#formSubmit').submit();
			}
		});
	}

	$.faxSetting = {
		init: function (e) {
			/*Form Validation*/
			validation();
			admincontrol.init();

			$("#TelcoDialRulesCountryCode").mask('99999999999999');
			$("#TelcoDialRulesAreaCode").mask('99999999999999');
			$("#FaxSendPageCountLimit").mask('99999999999999');
			$("#SendCtrlUsrXsactLimit").mask('99999999999999');

			$.faxSetting.applyAllButtonClickHandler($('.btn-apply-all'));
			$.faxSetting.customDialRulesClickHandler($('#Link-CustomDialRules'));
			$.faxSetting.saveButtonClickHandler($('.btn-save'));
			$.faxSetting.selectOnChangehandler($('select#FaxSendRawDialRuleOn'));

			/*Custom Dialing Rules*/
			$.dialRules.init();

			$(document).on('keyup', function (e) {
				var code = e.code;
				if (code == 'Space') {
					if ($('.sweet-alert.visible').length > 0) {
						swal.close();
					}
				}
			});

			$(document).on('keydown', function (e) {
				var code = e.code;
				if (code == 'Enter') {
					if ($('.sweet-alert.visible').length > 0) {
						swal.close();
					}
				}
			});

			$('.btn-apply-all').bind("click", showSweet).focus();
		},

		/*Btn Action*/
		applyAllButtonClickHandler: function (e) {
            $(e).on('click', function () {
				showSweet();
			});
		},
		customDialRulesClickHandler: function (e) {
			$(e).on('click', function () {
				$.sectionproperties.SecondLevel(this);
				$('input[data-role="search-all-item"]').val("");
				$.dialRules.initGrid();
			});
		},
		saveButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$('input[name="form-action"]').val("1");
				$('#formSubmit').submit();
			});
		},
		selectOnChangehandler: function (e) {
			$(e).on('change', function (event, state) {
				var result = true;
				var returnValue = $(this).val();
				if (returnValue > 0) {
					result = false;
				}
				$.sectionproperties.Hidden(this.id, result, true);
			});
			$(e).change();
		},

		/* Logic */
		loadTagInput: function(val, source) {
			var control = $("#FaxRecvUnassignedUser");
			control.tagsinput({
				itemValue: 'id',  /* this will be used to set id of tag*/
				itemText: 'label' /* this will be used to set text of tag*/
			});

			if (val.lastIndexOf(';') == val.length - 1) {
				val = val.substring(0, val.lastIndexOf(';'));
			}
			var selectedItem = val == "" ? [] : val.split(';');

			source = source == null || source.length == 0 ? val : source;

			var selectedSource = source == "" ? [] : source.split(';');

			control.tagsinput('removeAll');
			$.each(selectedItem, function (index, obj) {
				control.tagsinput('add', { id: obj, label: selectedSource[index] });
			});
		},


		/*Post or Get Function*/
		save: function (action) {
			fxcRequest.post('/Admin/FaxSetting/Save',
				{
					"Action": action,
					"TelcoDialRulesCountryCode": { "Value": $('#TelcoDialRulesCountryCode').val(), "IsSet": $('#TelcoDialRulesCountryCode_IsSet').prop("checked") },
					"TelcoDialRulesAreaCode": { "Value": $('#TelcoDialRulesAreaCode').val(), "IsSet": $('#TelcoDialRulesAreaCode_IsSet').prop("checked") },
					"FaxSendDialPrefix": { "Value": $('#FaxSendDialPrefix').val(), "IsSet": $('#FaxSendDialPrefix_IsSet').prop("checked") },
					"FaxSendDialPrefixRule": { "Value": $('#FaxSendDialPrefixRule').val(), "IsSet": $('#FaxSendDialPrefixRule_IsSet').prop("checked") },
					"FaxSendDialSuffix": { "Value": $('#FaxSendDialSuffix').val(), "IsSet": $('#FaxSendDialSuffix_IsSet').prop("checked") },
					"FaxSendDialSuffixRule": { "Value": $('#FaxSendDialSuffixRule').val(), "IsSet": $('#FaxSendDialSuffixRule_IsSet').prop("checked") },
					"FaxSendRawDialRuleOn": { "Value": $('#FaxSendRawDialRuleOn').val(), "IsSet": $('#FaxSendRawDialRuleOn_IsSet').prop("checked") },

					"FaxSendLocalCSID": { "Value": $('#FaxSendLocalCSID').val(), "IsSet": $('#FaxSendLocalCSID_IsSet').prop("checked") },
					"FaxSendLocalCallerID": { "Value": $('#FaxSendLocalCallerID').val(), "IsSet": $('#FaxSendLocalCallerID_IsSet').prop("checked") },
					"FaxSendLocalNumber": { "Value": $('#FaxSendLocalNumber').val(), "IsSet": $('#FaxSendLocalNumber_IsSet').prop("checked") },
					"FaxSendDefaultAddrType": { "Value": $('#FaxSendDefaultAddrType').val(), "IsSet": $('#FaxSendDefaultAddrType_IsSet').prop("checked") },
					"FaxSendNotifyAttachEmail": { "Value": $('#FaxSendNotifyAttachEmail').val(), "IsSet": $('#FaxSendNotifyAttachEmail_IsSet').prop("checked") },
					"FaxSendNotifyAttachSizeEmail": { "Value": $('#FaxSendNotifyAttachSizeEmail').val(), "IsSet": $('#FaxSendNotifyAttachSizeEmail_IsSet').prop("checked") },
					"FaxSendXmitReso": { "Value": $('#FaxSendXmitReso').val(), "IsSet": $('#FaxSendXmitReso_IsSet').prop("checked") },
					"FaxSendXmitHeader": { "Value": $('#FaxSendXmitHeader').val(), "IsSet": $('#FaxSendXmitHeader_IsSet').prop("checked") },
					"FaxSendPageCountLimit": { "Value": $('#FaxSendPageCountLimit').val(), "IsSet": $('#FaxSendPageCountLimit_IsSet').prop("checked") },
					"SendCtrlUsrXsactLimit": { "Value": $('#SendCtrlUsrXsactLimit').val(), "IsSet": $('#SendCtrlUsrXsactLimit_IsSet').prop("checked") },

					"FaxRecvAllowPartial": { "Value": $('#FaxRecvAllowPartial').prop("checked"), "IsSet": $('#FaxRecvAllowPartial_IsSet').prop("checked") },
					"FaxRecvFwdAttachEmail": { "Value": $('#FaxRecvFwdAttachEmail').val(), "IsSet": $('#FaxRecvFwdAttachEmail_IsSet').prop("checked") },
					"FaxRecvFwdAttachSizeEmail": { "Value": $('#FaxRecvFwdAttachSizeEmail').val(), "IsSet": $('#FaxRecvFwdAttachSizeEmail_IsSet').prop("checked") },
					"FaxRecvUnassignedUser": { "Value": $('#FaxRecvUnassignedUser').val(), "IsSet": $('#FaxRecvUnassignedUser_IsSet').prop("checked") },

					"UsrDefaultCP": { "Value": $('#UsrDefaultCP').val(), "IsSet": $('#UsrDefaultCP_IsSet').prop("checked") },

					"DomainId": $('#DomainId').val()
				},
				function (data) {
					switch (action) {
						case "1":
                            swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");
                            fxcUserConn.onDomainChanges($('#DomainId').val(), false, true, true);
							break;
						case "2":
                            swal($globalMessages.swal.success.title, $areaResources.swal.applyToAll, "success");
                            fxcUserConn.onDomainChanges($('#DomainId').val(), true, true, true);
							break;
						default:
					}
				},
				function (error) {
					swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
				});
		}
	};

	var dialingRulesValidation = function () {
		$("#formSubmit-swapRow").validate({
			ignoreTitle: true,
			rules: {
				txtMoveToRow: {
					required: true,
					noSpace: true
				}
			},
			submitHandler: function (form) {
				$.dialRules.saveSwapRule();
			}
		});
	};
	$.dialRules = {
		init: function (e) {
			/*Form Validation*/
			/*Form*/
			$.dialRules.saveFormButtonClickHandler($('.btn-save2'));
			$.sectionproperties.FirstLevel($(".View2 .btn-back2"));

			/*Grid*/
			$.dialRules.createButtonClickHandler($(".btn-new-grid"));
			$.dialRules.deleteButtonClickHandler($(".btn-delete-grid"));
			$.dialRules.exportButtonClickHandler($(".btn-export-grid"));
			$.dialRules.importButtonClickHandler($(".btn-import-grid"));
			$.dialRules.refreshButtonClickHandler($(".btn-refresh-grid"));
			$.dialRules.searchPressEnter($('input[data-role="search-all-item"]'));
			$.dialRules.searchButtonClickHandler($('.btn-search-grid'));

			/*Validation*/
			dialingRulesValidation();

			/*Init New Dial String*/
			$.faxagent_newDialingRules.init();

			/*Init Import Dial String*/
			$.faxagent_importDialingRules.init();
		},
		initGrid: function (e) {
			var id = $('#grid');
			var dataSource = {
				transport: {
					read: {
						url: '/Admin/FaxSetting/CustomDialRules',
						dataType: "json",
						type: "GET"
					},
					parameterMap: function (options) {
						/* Fix url param for sort values */
						var result = {
							DomainId: $('#DomainId').val()
						};
						return result;
					}
				},
				schema: {
					data: function (response) {
						$("#DomainRules2_IsSet").prop("checked", response.InheritDomainRules);
						return response.Records;
					},
					total: "Total",
					model: {
						id: "Id"
					}
				},
				serverPaging: false,
				serverSorting: false
			};
			var col = [
				{
					selectable: true, width: 45,
					filterable: {
						cell: {
							enabled: false
						}
					},
					attributes: {
						"class": "checkboxSelection"
					}
				},
				{
					field: 'Id',
					hidden: true
				},
				{
					attributes: {
						"class": "disabledClickableRow"
					},
					width: 60,
					sortable: false,
					filterable: {
						cell: {
							enabled: false
						}
					},
					template: function (dataRow) {
						var result = '<div class="k-move-up-row"><a class="grid-navIcon text-green-color nav-link waves-effect moveUp" data-id="' + dataRow.Id + '" id="moveUp-' + dataRow.Id + '" href="javascript:void(0)"><i class="mdi mdi-arrow-up-bold"></i></a>';
						return result;
					}
				},
				{
					attributes: {
						"class": "disabledClickableRow"
					},
					width: 60,
					sortable: false,
					filterable: {
						cell: {
							enabled: false
						}
					},
					template: function (dataRow) {
						var result = '<div class="k-move-down-row"><a class="grid-navIcon text-blue-color nav-link waves-effect moveDown" data-id="' + dataRow.Id + '" id="moveDown-' + dataRow.Id + '" href="javascript:void(0)"><i class="mdi mdi-arrow-down-bold"></i></a>';
						return result;
					}
				},
				{
					attributes: {
						"class": "disabledClickableRow"
					},
					width: 60,
					sortable: false,
					filterable: {
						cell: {
							enabled: false
						}
					},
					template: function (dataRow) {
						var result = '<div class="k-move-swap-row"><a class="grid-navIcon text-blue-color nav-link waves-effect moveSwap" data-id="' + dataRow.Id + '" id="moveSwap-' + dataRow.Id + '" href="javascript:void(0)"><i class="mdi mdi-swap-vertical"></i></a>';
						return result;
					}
				},
				{
					field: 'Seq',
					title: $faxSetting.grid.seq,
					type: 'number',
					sortable: true,
					width: 100
				},
				{
					field: 'DialString',
					title: $faxSetting.grid.dialString,
					sortable: true,
					width: 200
				},
				{
					field: 'ReplaceWith',
					title: $faxSetting.grid.replaceWith,
					sortable: true,
					width: 250
				},
				{
					field: 'AppendWith',
					title: $faxSetting.grid.appendWith,
					sortable: true,
					width: 250
				},
				{
					attributes: {
						"class": "checkboxSelection"
					},
					field: "IsActive",
					title: $faxSetting.grid.active,
					filterable: {
						cell: {
							enabled: false
						}
					},
					width: 200,
					template: '<div class="custom-checkbox"><input class="k-checkbox-custom rrf" #= IsActive == true ? \'checked="checked"\' : "" # data-role="checkbox" data-id="#= IsActive #" id="IsActive-#= Id #" type="checkbox"> '
						+ '     <label for="IsActive-#= Id #" class="k-checkbox-custom-label k-no-text"></label></div>'
				}
			];

			var obj = {};
			obj.allowSelectMultipleRow = true;
			obj.customizeCheckbox = true;
			obj.totalInputType = ".TotalGrid";
			obj.customizeCheckboxFn = $.dialRules.gridChecboxActionHandler;

			var $grid = kendogridcustomization.init(id, dataSource, col, obj);
			if (setGrid) {
				$.dialRules.moveDialClickHandler();
				setGrid = false;
			}
		},

		/*Btn Action*/
		createButtonClickHandler: function (e) {
			$(e).on('click', function (x) {
				$("#newDialString-modal").modal("show");
				$.faxagent_newDialingRules.resetFields();
			});
		},
		deleteButtonClickHandler: function (e) {
			$(e).on('click', function (x) {
				$(this).blur();
				$.dialRules.delete();
			});
		},
		gridChecboxActionHandler: function (dataItem, e) {
			$.dialRules.updateCheckBox(dataItem);
		},
		exportButtonClickHandler: function (e) {
			$(e).on('click', function (x) {
				$.dialRules.export();
				$(this).blur();
			});
		},
		importButtonClickHandler: function (e) {
			$(e).on('click', function (x) {
				$("#importDialString-modal").modal("show");
				$.faxagent_importDialingRules.resetFields();
			});
		},
		moveDialClickHandler: function (e) {
			/*Move Up Click Handler*/
			$("#grid tbody").on("click", "a.moveUp", function (e) {
				var tr = $(e.target).closest("tr");
				var row = $("#grid").data("kendoGrid").dataItem(tr);
				if (row != null) {
					$.dialRules.moveDial(row.Id, '2', null);
				}
			});

			$("#grid tbody").on("click", "a.moveDown", function (e) {
				var tr = $(e.target).closest("tr");
				var row = $("#grid").data("kendoGrid").dataItem(tr);
				if (row != null) {
					$.dialRules.moveDial(row.Id, '1', null);
				}
			});

			$("#grid tbody").on("click", "a.moveSwap", function (e) {
				var tr = $(e.target).closest("tr");
				var row = $("#grid").data("kendoGrid").dataItem(tr);
				if (row != null) {
					$("#swapRow-Modal").modal("show");
					$('#formSubmit-swapRow').trigger("reset");
					$('#formSubmit-swapRow').validate().resetForm();
					var countGrid = $(".TotalGrid").val();
					var labelText = $faxSetting.customRuleMoveRow + " " + countGrid + " :";
					$("label[for='txtMoveToRow']").text(labelText);
					$("#txtMoveToRow").attr("min", 1);
					$("#txtMoveToRow").attr("max", countGrid);
					$("#txtMoveToRowId").val(row.Id);
				}

			});
		},
		refreshButtonClickHandler: function (e) {
			$(e).on('click', function (x) {
				$.dialRules.refresh();
				$(this).blur();
			});
		},
		saveFormButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$.dialRules.save();
			});
		},
		searchButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$.dialRules.search(e);
			});
		},
		searchPressEnter: function (e) {
			$(e).on('keypress', function (enter) {
				if (enter.which === 13) {
					$.dialRules.search(e);
				}
			});
		},
		/* END BTN Action */

		/*logic*/
		getGridSelections: function (event) {
			var entityGrid = event.data("kendoGrid");
			var rows = entityGrid.select();
			var $selectedItem = [];
			rows.each(function (index, row) {
				var selectedItem = entityGrid.dataItem(row);
				$selectedItem[index] = selectedItem.Id;

			});

			return $selectedItem;
		},
		refresh: function (e) {
			$('input[data-role="search-all-item"]').val("");
			$.dialRules.initGrid();
		},
		saveSwapRule: function () {
			var moveTo = $('#txtMoveToRow').val();
			var rowId = $('#txtMoveToRowId').val();
			$('#swapRow-Modal').modal('hide');
			$.dialRules.moveDial(rowId, '3', moveTo);

		},
		search: function (e) {
			var val = $('input[data-role="search-all-item"]').val() != null ? $('input[data-role="search-all-item"]').val().trim() : "";
			var grid = $("#grid").data("kendoGrid");

			if (val) {
				var filters = [];

				$.each(grid.options.columns, function (index, value) {

					var checkCellEnabled = typeof value.filterable === 'undefined' ? true : value.filterable.cell.enabled;
					var checkCellType = value.type === 'number' ? "eq" : "contains";
					if (!value.hidden && checkCellEnabled) {
						var filter = {
							field: value.field,
							operator: checkCellType,
							value: val
						};
						filters.push(filter);
					}
				});
				grid.dataSource.filter({
					logic: "or",
					filters: filters
				});
			}
			else {
				grid.dataSource.filter({
					logic: "or",
					filters: []
				});
			}
		},

		/*Post or Get Function*/
		delete: function (e) {
			var selectedItem = $.dialRules.getGridSelections($("#grid"));

			if (selectedItem.length === 0) {
				swal("", $globalMessages.swal.alert.noItemSelected);
				return false;
			}

			swal({
				title: "",
				text: $globalMessages.swal.alert.deleteConfirmation,
				type: "info",
				showCancelButton: true,
				closeOnConfirm: false,
				reverseButtons: true,
				showLoaderOnConfirm: true
			}, function () {
				fxcRequest.post('/Admin/FaxSetting/DeleteDial',
					{ Ids: selectedItem.join().split(',') },
					function (data) {
						swal($globalMessages.swal.success.title, $globalMessages.swal.success.delete, "success");
						$.dialRules.refresh();
					}, function () {
						swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnDelete, "error");
					}, true);
			});
		},
		save: function (e) {
			fxcRequest.post('/Admin/FaxSetting/CustomDialRulesSave',
				{
					"DomainId": $('#DomainId').val(),
					InheritDomainRules: $("#DomainRules2_IsSet").prop("checked")
				},
				function (data) {
                    swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");
				},
				function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
				});
		},
		export: function (e) {
			var winPopup;
			var url = "/admin/FaxSetting/exportcustomdial/?did=" + $('#DomainId').val();
			var name = "ExportCustomDial";

			var features = 'status=no,menubar=no,location=no,resizable=yes,width=300px,height=300px,scrollbars=yes,toolbar=no';
			winPopup = window.open(url, name, features);

			winPopup.focus();
		},
		moveDial: function (customID, command, rowNumber) {
			fxcRequest.post('/Admin/FaxSetting/MoveDial', {
				"CustomID": customID,
				"Command": command,
				"RowNumber": rowNumber
			},
				function (data) {
					$.toast({
						heading: $globalMessages.toast.success,
						text: $globalMessages.swal.success.updateDialString,
						position: 'top-right',
						loaderBg: '#ff6849',
						icon: 'success',
						hideAfter: 3500,
						stack: 6
					});

					$.dialRules.refresh();
				},
				function (error) {
					swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnMove, "error");
				}, false);

		},
		updateCheckBox: function (dataItem) {
			fxcRequest.post('/Admin/FaxSetting/UpdateCheckBox',
				{ "CustomID": dataItem.Id, "IsActive": dataItem.IsActive },
				function (data) {
					$.toast({
						heading: $globalMessages.toast.success,
						text: $globalMessages.swal.success.updateDialString,
						position: 'top-right',
						loaderBg: '#ff6849',
						icon: 'success',
						hideAfter: 3500,
						stack: 6
					});
					$.dialRules.refresh();
				},
				null, false);
		}
	};

	var newDialingRulesValidation = function () {

		$("#formSubmit-newDialString").validate({
			ignoreTitle: true,
			rules: {
				DialString: {
					required: true,
					noSpace: true
				}
			},
			submitHandler: function (form) {
				$.faxagent_newDialingRules.save();
			}
		});
	};
	$.faxagent_newDialingRules = {
		init: function (e) {
			/*Form*/
			$.faxagent_newDialingRules.resetFormButtonClickHandler($('#BtnResetNewDialString'));
			$.faxagent_newDialingRules.saveclosemodalHandler($("#BtnSaveCloseNewDialString"));
			/*Validation*/
			newDialingRulesValidation();
		},

		/*Logic*/
		resetFields: function (obj) {
			$('#formSubmit-newDialString').trigger("reset");
			$('#formSubmit-newDialString').validate().resetForm();
		},
		/* End Logic */

		/* BTN Action */
		resetFormButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$.faxagent_newDialingRules.resetFields();
			});
		},
		saveclosemodalHandler: function (e) {
			$(e).on('click', function () {
				$('input[name="newDialingrules-modal-action"]').val('save & close');
			});
		},

		/*Post or Get Function*/
		save: function () {
			var formData = JSON.stringify($("#formSubmit-newDialString").serializeArray());

			fxcRequest.post('/Admin/FaxSetting/SaveNewRule'
				, { "FormData": formData, "DomainId": $('#DomainId').val() }
				, function (data) {
					$.dialRules.initGrid();
					if ($('input[name="newDialingrules-modal-action"]').val() === 'save & close') {
						$("#newDialString-modal").modal("hide");
					}
					$('input[name="newDialingrules-modal-action"]').val('');
					swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");
				}
				, null);
		}
	};

	var importDialingRulesValidation = function () {
		$("#formSubmit-importDialString").validate({
			rules: {
				domain: {
					required: true,
					noSpace: true
				},
				ImportDR: {
					required: true,
					noSpace: true
				}
			},
			submitHandler: function (form) {
				$.faxagent_importDialingRules.save();
			}
		});
	};
	$.faxagent_importDialingRules = {
		init: function (e) {
			/*Form*/
			/*Validation*/
			importDialingRulesValidation();
		},
		initTreeViewDomain: function (e) {
			/* Text box: Domain Treeview */
			$("#domainImport-id").val($('#dashboardID').val());
			var objDomainSelection = {};
			objDomainSelection.expandAll = true;
			objDomainSelection.declareType = "textbox";
			treeview.init("domainImport", "domainImport-name", "domainImport-id", objDomainSelection);
		},

		/*Logic*/
		resetFields: function (obj) {
			$('#formSubmit-importDialString').trigger("reset");
			$('#formSubmit-importDialString').validate().resetForm();
			$.faxagent_importDialingRules.initTreeViewDomain();
		},
		/* End Logic */

		/*Post or Get Function*/
		save: function () {
			fxcRequest.post('/Admin/FaxSetting/ImportCustomDial',
				{ "DomainId": $('#domainImport').val(), "ImportDR": $('#ImportDR').val() },
				function (data) {
					$.dialRules.initGrid();
					$("#importDialString-modal").modal("hide");
					$.toast({
						heading: $globalMessages.toast.success,
						text: $globalMessages.swal.success.updateDialString,
						position: 'top-right',
						loaderBg: '#ff6849',
						icon: 'success',
						hideAfter: 3500,
						stack: 6
					});
				}, null, false);
		}
	};
})(window.jQuery);
