﻿(function ($) {
	var validation = function () {
		$('#formSubmit').validate({
			ignoreTitle: true,
			rules: {
				'Server.Value': {
					required: true,
					noSpace: true
				},
				'LogUserName.Value': {
					required: true,
					noSpace: true
				},
				LogUserPwd: {
					required: true,
					noSpace: true
				},
				Timeout: {
					number: true
				},
				Port: {
					number: true
				}
			},
			submitHandler: function (form) {
				$.smtpRelaySettings.save($('input[name="form-action"]').val());
			}
		});
	};

	var showSweet = function () {
		swal({
			title: $globalMessages.swal.warningTitle,
			text: $areaResources.swal.applyToAllDomain,
			type: "warning",
			showConfirmButton: true,
			showCancelButton: true,
			closeOnConfirm: false
		}, function (isConfirmed) {
			if (isConfirmed) {
				$('input[name="form-action"]').val("2");
				$('#formSubmit').submit();
			}
		});
	}

	var $PassIsEncrypted = false;
	var $TempPassword;
	var $username;

	$.smtpRelaySettings = {
		init: function (e) {
			/*Form Validation*/
			validation();
			admincontrol.init();

			$("#Timeout").mask('99999999999');
			$("#Port").mask('99999');

			$.smtpRelaySettings.applyAllButtonClickHandler($('.btn-apply-all'));
			$.smtpRelaySettings.saveButtonClickHandler($('.btn-save'));
			$.smtpRelaySettings.testSendButtonClickHandler($('.btn-TestSend'));

			/*Form*/
			$.smtpRelaySettings.resetButtonClickHandler($('.btn-Reset'));
			$.smtpRelaySettings.resetPassword();

			$.testSend.init();

			$(document).on('keyup', function (e) {
				var code = e.code;
				if (code == 'Space') {
					if ($('.sweet-alert.visible').length > 0) {
						swal.close();
					}
				}
			});

			$(document).on('keydown', function (e) {
				var code = e.code;
				if (code == 'Enter') {
					if ($('.sweet-alert.visible').length > 0) {
						swal.close();
					}
				}
			});

			$('.btn-apply-all').bind("click", showSweet).focus();

			$username = $("#LogUserName").val();

			$("#LogUserName").val("********" + $.smtpRelaySettings.getLastCharacter($username, 5));

			$("#LogUserName").blur(function () {
				$username = $("#LogUserName").val();

				if ($username.length > 0) {
					$("#LogUserName").val("********" + $.smtpRelaySettings.getLastCharacter($username, 5));
				}
				else {
					$("#LogUserName").val($username);
				}
			});
			$("#LogUserName").focus(function () {
				$("#LogUserName").val($username);
			});

		},
		resetPassword: function (e) {
			$PassIsEncrypted = $("#LogUserPwdValueEncrypted").val().toUpperCase() == "TRUE" ? true : false;
			$("#LogUserPwd").focus(function () {
				if ($PassIsEncrypted) {
					$TempPassword = $("#LogUserPwd").val();
					$("#LogUserPwd").val("");
				}
			});
			$("#LogUserPwd").keyup(function () {
				$PassIsEncrypted = false;
				$("#LogUserPwdValueEncrypted").val($PassIsEncrypted);
			});
			$("#LogUserPwd").focusout(function () {
				if ($PassIsEncrypted) {
					$("#LogUserPwd").val($TempPassword);
				}
			});
		},
		getLastCharacter: function (text, lastNumber) {
			var getLength = text.length;
			if (getLength > lastNumber) {
				text = text.substr(text.length - lastNumber);
			}
			else {
				text = text.substr(text.length - 2);
            }

			return text;
        },
		getValue: function (e) {
			console.log($username);
        },

		/*Btn Action*/
		applyAllButtonClickHandler: function (e) {
			$(e).on('click', function () {
				showSweet();
			});
		},
		resetButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$.smtpRelaySettings.resetFields();
			});
		},
		saveButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$('input[name="form-action"]').val("1");
				$('#formSubmit').submit();
			});
		},
		testSendButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$('#test-modal').modal('show');
				$.testSend.resetFields();
			});
		},

		/* Logic */
		resetFields: function () {
			$("#formSubmit").trigger("reset");
			$("#formSubmit").validate().resetForm();

			$PassIsEncrypted = $("#LogUserPwdValueEncrypted").val().toUpperCase() == "TRUE" ? true : false;

			$username = $("#LogUserName").val();

			$("#LogUserName").val("********" + $.smtpRelaySettings.getLastCharacter($username, 5));
		},
		save: function (action) {
			fxcRequest.post('/Admin/SMTPRelaySettings/Save',
				{
					"Action": action,
					"DomainId": $('#DomainId').val(),
					"Server": { "Value": $('#Server').val(), "IsSet": $('#Server_IsSet').prop("checked") },
					"Port": { "Value": $('#Port').val(), "IsSet": $('#Port_IsSet').prop("checked") },
					"Timeout": { "Value": $('#Timeout').val(), "IsSet": $('#Timeout_IsSet').prop("checked") },
					"LogUserName": { "Value": $username, "IsSet": $('#LogUserName_IsSet').prop("checked") },
					"LogUserPwd": { "Value": $('#LogUserPwd').val(), "IsSet": $('#LogUserPwd_IsSet').prop("checked") },
					"DefaultCredentialOn": { "Value": $('#DefaultCredentialOn').prop("checked"), "IsSet": $('#DefaultCredentialOn_IsSet').prop("checked") },
					"SSLEnabled": { "Value": $('#SSLEnabled').val(), "IsSet": $('#SSLEnabled_IsSet').prop("checked") },
					"LogUserPwdValueEncrypted": $("#LogUserPwdValueEncrypted").val()
				},
				function (data) {
					switch (action) {
						case "1":
                            swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");
                            fxcUserConn.onDomainChanges($('#DomainId').val(), false, true, true);
							break;
						case "2":
                            swal($globalMessages.swal.success.title, $areaResources.swal.applyToAll, "success");
                            fxcUserConn.onDomainChanges($('#DomainId').val(), true, true, true);
							break;
						default:
					}
				},
				function (error) {
					swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
				});
		},
	};

	var validationTesting = function () {
		$('#test_formSubmit').validate({
			rules: {
				SenderEmail: {
					required: true,
					email: true
				},
				RecipientEmail: {
					required: true,
					email: true
				},
				Subject: {
					required: true
				}
			},
			submitHandler: function (form) {
				$.testSend.Email();
			}
		});
	};
	$.testSend = {
		init: function (e) {
			validationTesting();
			$.testSend.resetButtonClickHandler($('#BtnResetdefault'));
		},

		/*Btn Action*/
		resetButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$.testSend.resetFields();
			});
		},

		/* Logic */
		resetFields: function () {
			$("#test_formSubmit").trigger("reset");
			$("#test_formSubmit").validate().resetForm();
		},

		/*Post or Get Function*/
		Email: function () {
			fxcRequest.post('/Admin/SMTPRelaySettings/TestEmail',
				{
					"Action": "3",
					"DomainId": $('#DomainId').val(),
					"SenderEmail": $('input[name="SenderEmail"').val(),
					"RecipientEmail": $('input[name="RecipientEmail"').val(),
					"Priority": $('#Priority').val(),
					"Subject": $('input[name="Subject"').val(),
					"MessageBody": $('#Message').val()
				},
				function (data) {
					swal($globalMessages.swal.success.title, $smtpRelayResource.testEmailSent, "success");
				},
				null);
		}
	};
})(window.jQuery);
