﻿(function ($) {
	var userpermissionsValidation = function () {
		$('#formSubmit').validate({
			rules: {
			},
			messages: {
			},
			submitHandler: function (form) {
				if ($("#form-action").val() === 'ApplyAll') {
					$.userpermissions.applyall();
				}
				else {
					$.userpermissions.save();
				}
			}
		});
	};

	var showSweet = function () {
		swal({
			title: $globalMessages.swal.warningTitle,
			text: $areaResources.swal.applyToAllDomain,
			type: "warning",
			showConfirmButton: true,
			showCancelButton: true,
			closeOnConfirm: false
		}, function (isConfirmed) {
			if (isConfirmed) {
				$("#form-action").val("ApplyAll");
				$("#formSubmit").submit();
			}
		});
	}

	$.userpermissions = {
		init: function (e) {
			$('.btn-save').on('click', function () {
				$("#form-action").val("");
				$("#formSubmit").submit();
			});

			$('.btn-apply-all').on('click', function () {
				showSweet();
			});

			$(document).on('keyup', function (e) {
				var code = e.code;
				if (code == 'Space') {
					if ($('.sweet-alert.visible').length > 0) {
						swal.close();
					}
				}
			});

			$(document).on('keydown', function (e) {
				var code = e.code;
				if (code == 'Enter') {
					if ($('.sweet-alert.visible').length > 0) {
						swal.close();
					}
				}
			});

			$('.btn-apply-all').bind("click", showSweet).focus();

			userpermissionsValidation();
		},
		constructmodel: function (action) {
			return {

				"UsrMsgAssign": { "Value": $('#UsrMsgAssign').prop("checked"), "IsSet": $('#UsrMsgAssign_IsSet').prop("checked") },
				"UsrMsgDeletePermanentAllow": { "Value": $('#UsrMsgDeletePermanentAllow').prop("checked"), "IsSet": $('#UsrMsgDeletePermanentAllow_IsSet').prop("checked") },
				"UsrOptionSet": { "Value": $('#UsrOptionSet').val(), "IsSet": $('#UsrOptionSet_IsSet').prop("checked") },
				"UsrExchIntEnable": { "Value": $('#UsrExchIntEnable').prop("checked"), "IsSet": $('#UsrExchIntEnable_IsSet').prop("checked") },
				"UsrBroadcastAllow": { "Value": $('#UsrBroadcastAllow').prop("checked"), "IsSet": $('#UsrBroadcastAllow_IsSet').prop("checked") },
				"UsrDelegationAllow": { "Value": $('#UsrDelegationAllow').prop("checked"), "IsSet": $('#UsrDelegationAllow_IsSet').prop("checked") },
				"UsrMsgAutoResumeOn": { "Value": $('#UsrMsgAutoResumeOn').prop("checked"), "IsSet": $('#UsrMsgAutoResumeOn_IsSet').prop("checked") },
				"UsrMsgHistoryViewAllow": { "Value": $('#UsrMsgHistoryViewAllow').prop("checked"), "IsSet": $('#UsrMsgHistoryViewAllow_IsSet').prop("checked") },
				"UsrMsgDownload": { "Value": $('#UsrMsgDownload').prop("checked"), "IsSet": $('#UsrMsgDownload_IsSet').prop("checked") },
				"UsrMsgPrint": { "Value": $('#UsrMsgPrint').prop("checked"), "IsSet": $('#UsrMsgPrint_IsSet').prop("checked") },

				"UsrAddrBookEdit": { "Value": $('#UsrAddrBookEdit').prop("checked"), "IsSet": $('#UsrAddrBookEdit_IsSet').prop("checked") },
				"UsrAddrBookEditPriv": { "Value": $('#UsrAddrBookEditPriv').val(), "IsSet": $('#UsrAddrBookEditPriv_IsSet').prop("checked") },

				"UsrPFolderLevelAllow": { "Value": $('#UsrPFolderLevelAllow').val(), "IsSet": $('#UsrPFolderLevelAllow_IsSet').prop("checked") },

				"UsrMsgRecvSuccess": { "Value": $('#UsrMsgRecvSuccess').prop("checked"), "IsSet": $('#UsrMsgRecvSuccess_IsSet').prop("checked") },
				"UsrMsgRecvFail": { "Value": $('#UsrMsgRecvFail').prop("checked"), "IsSet": $('#UsrMsgRecvFail_IsSet').prop("checked") },
				"UsrMsgSendSuccess": { "Value": $('#UsrMsgSendSuccess').prop("checked"), "IsSet": $('#UsrMsgSendSuccess_IsSet').prop("checked") },
				"UsrMsgSendFail": { "Value": $('#UsrMsgSendFail').prop("checked"), "IsSet": $('#UsrMsgSendFail_IsSet').prop("checked") },
				"UsrMsgSendBatch": { "Value": $('#UsrMsgSendBatch').prop("checked"), "IsSet": $('#UsrMsgSendBatch_IsSet').prop("checked") },

				"RecvCtrlUsrFwdOn": { "Value": $('#RecvCtrlUsrFwdOn').prop("checked"), "IsSet": $('#RecvCtrlUsrFwdOn_IsSet').prop("checked") },
				"RecvCtrlUsrFwdFax": { "Value": $('#RecvCtrlUsrFwdFax').prop("checked"), "IsSet": $('#RecvCtrlUsrFwdFax_IsSet').prop("checked") },
				"RecvCtrlUsrFwdFaxRaw": { "Value": $('#RecvCtrlUsrFwdFaxRaw').prop("checked"), "IsSet": $('#RecvCtrlUsrFwdFaxRaw_IsSet').prop("checked") },
				"RecvCtrlUsrFwdEmail": { "Value": $('#RecvCtrlUsrFwdEmail').prop("checked"), "IsSet": $('#RecvCtrlUsrFwdEmail_IsSet').prop("checked") },
				"RecvCtrlUsrFwdAttachEmail": { "Value": $('#RecvCtrlUsrFwdAttachEmail').prop("checked"), "IsSet": $('#RecvCtrlUsrFwdAttachEmail_IsSet').prop("checked") },
				"RecvCtrlUsrFwdAttachSizeEmail": { "Value": $('#RecvCtrlUsrFwdAttachSizeEmail').val(), "IsSet": $('#RecvCtrlUsrFwdAttachSizeEmail_IsSet').prop("checked") },
				"RecvCtrlUsrFwdPrinter": { "Value": $('#RecvCtrlUsrFwdPrinter').prop("checked"), "IsSet": $('#RecvCtrlUsrFwdPrinter_IsSet').prop("checked") },
				"RecvCtrlUsrFwdHttp": { "Value": $('#RecvCtrlUsrFwdHttp').prop("checked"), "IsSet": $('#RecvCtrlUsrFwdHttp_IsSet').prop("checked") },
				"RecvCtrlUsrFwdFtp": { "Value": $('#RecvCtrlUsrFwdFtp').prop("checked"), "IsSet": $('#RecvCtrlUsrFwdFtp_IsSet').prop("checked") },
				"RecvCtrlUsrFwdFile": { "Value": $('#RecvCtrlUsrFwdFile').prop("checked"), "IsSet": $('#RecvCtrlUsrFwdFile_IsSet').prop("checked") },

				"SendCtrlUsrOn": { "Value": $('#SendCtrlUsrOn').prop("checked"), "IsSet": $('#SendCtrlUsrOn_IsSet').prop("checked") },
				"SendCtrlUsrFax": { "Value": $('#SendCtrlUsrFax').prop("checked"), "IsSet": $('#SendCtrlUsrFax_IsSet').prop("checked") },
				"SendCtrlUsrFaxIntl": { "Value": $('#SendCtrlUsrFaxIntl').prop("checked"), "IsSet": $('#SendCtrlUsrFaxIntl_IsSet').prop("checked") },
				"SendCtrlUsrFaxColor": { "Value": $('#SendCtrlUsrFaxColor').prop("checked"), "IsSet": $('#SendCtrlUsrFaxColor_IsSet').prop("checked") },
				"SendCtrlUsrFaxRaw": { "Value": $('#SendCtrlUsrFaxRaw').prop("checked"), "IsSet": $('#SendCtrlUsrFaxRaw_IsSet').prop("checked") },
				"SendCtrlUsrEmail": { "Value": $('#SendCtrlUsrEmail').prop("checked"), "IsSet": $('#SendCtrlUsrEmail_IsSet').prop("checked") },
				"SendCtrlUsrAttachEmail": { "Value": $('#SendCtrlUsrAttachEmail').prop("checked"), "IsSet": $('#SendCtrlUsrAttachEmail_IsSet').prop("checked") },
				"SendCtrlUsrAttachSizeEmail": { "Value": $('#SendCtrlUsrAttachSizeEmail').val(), "IsSet": $('#SendCtrlUsrAttachSizeEmail_IsSet').prop("checked") },
				"SendCtrlUsrHttp": { "Value": $('#SendCtrlUsrHttp').prop("checked"), "IsSet": $('#SendCtrlUsrHttp_IsSet').prop("checked") },
				"SendCtrlUsrFtp": { "Value": $('#SendCtrlUsrFtp').prop("checked"), "IsSet": $('#SendCtrlUsrFtp_IsSet').prop("checked") },
				"SendCtrlUsrFile": { "Value": $('#SendCtrlUsrFile').prop("checked"), "IsSet": $('#SendCtrlUsrFile_IsSet').prop("checked") },
				"SendCtrlUsrPrinter": { "Value": $('#SendCtrlUsrPrinter').prop("checked"), "IsSet": $('#SendCtrlUsrPrinter_IsSet').prop("checked") },

				"FwdCtrlUsrOn": { "Value": $('#FwdCtrlUsrOn').prop("checked"), "IsSet": $('#FwdCtrlUsrOn_IsSet').prop("checked") },

				"DocCtrlUsrUploadAllow": { "Value": $('#DocCtrlUsrUploadAllow').prop("checked"), "IsSet": $('#DocCtrlUsrUploadAllow_IsSet').prop("checked") },
				"DocCtrlUsrUploadQuota": { "Value": $('#DocCtrlUsrUploadQuota').val(), "IsSet": $('#DocCtrlUsrUploadQuota_IsSet').prop("checked") },

				"DomainId": $('#DomainId').val(),
				"Action": action
			};
		},
		save: function () {
			fxcRequest.post('/Admin/Domain/UserPermission'
				, $.userpermissions.constructmodel("1")
				, function (data) {
					swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");
					fxcUserConn.onDomainChanges($('#DomainId').val(), false, true, true);
				}
				, function (error) {
					swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
				});
		},
		applyall: function () {
			fxcRequest.post('/Admin/Domain/UserPermission'
				, $.userpermissions.constructmodel("2")
				, function (data) {
					swal($globalMessages.swal.success.title, $areaResources.swal.applyToAll, "success");
					fxcUserConn.onDomainChanges($('#DomainId').val(), true, true, true);
				}
				, null);
		}
	};
})(window.jQuery);
