﻿(function ($) {
	var blacklistpublicationvalidation = function () {
		$('#form-blp').validate({
			ignoreTitle: true,
			rules: {
				Name: { required: true, noSpace: true }
			},
			submitHandler: function (form) {
				$.blacklistpublication.save();
			}
		});
	};

	var blacklistentryvalidation = function () {
		$('#form-ble').validate({
			ignoreTitle: true,
			rules: {
				DialString: { required: true, noSpace: true }
			},
			submitHandler: function (form) {

				if ($('input[name="Action"]').val() === "1") /* Add = 1, Update = 2*/
					$.blacklistpublication.addBlackListEntry();
				else
					$.blacklistpublication.editBlackListEntry();
			}
		});
	};

	var resetfields = function (e) {
		$('#form-blp').trigger("reset");
		$('#form-blp').validate().resetForm();
		if (e) {
			$(".Add-Edit-header h4").text($areaResources.actionTitle.editEntry);
			$(".breadcrumb .add-edit-breadcrumb-item").text($areaResources.actionTitle.editEntry);
			$('input[name="RecordId"]').val(e.Id);
			$('input[name="UserID"]').val(e.CreatorID).change();
			$('input[name="Creator"]').val(e.CrByUserName).change();
			$('input[name="Name"]').val(e.Name).change();
			$('input[name="Description"]').val(e.Desc);
			$('#MsgTypeID').val(e.MsgTypeID);
			$('#Activate').bootstrapSwitch('state', $.parseJSON(e.IsActive));
		}
		$.blacklistpublication.getBlackListEntry();
	};

	var resetBLEfields = function (e) {
		$('#form-ble').trigger("reset");
		$('#form-ble').validate().resetForm();
		if (e) {
			$('input[name="BLeID"]').val(e.Id);
			$('input[name="BLpID"]').val(e.BLpID);
			$('input[name="BLeUid"]').val(e.uid);
			$('input[name="DialString"]').val(e.DialString).change();
			$('#ActivateBLE').bootstrapSwitch('state', $.parseJSON(e.IsActive));
		}
	};

	var constructmodel = function () {
		var blpID = $('input[name="RecordId"]').val();

		return {
			"blpID": blpID,
			"SearchText": $('input[data-role="search-dial-string"]').val()
		};
	};

	var constructsavemodel = function () {

		var blgrid = $('#gridBLE').data("kendoGrid").dataSource.data();
		var blData = [];

		/* Backend Requires newly added item BLeID = 0 */
		if (blgrid.length > 0) {
			$.each(blgrid, function (i, v) {
				blData[i] = { "Id": v.Id, "DialString": v.DialString, "IsActive": v.IsActive, "IsActiveLabel": v.IsActiveLabel, "BLpID": v.BLpID };
			});
		}

		var id = $('input[name="RecordId"]').val();
		if (id == '') { id = '0'; }

		return {
			'Id': id,
			'Name': $('input[name="Name"]').val(),
			'Desc': $('input[name="Description"]').val(),
			'MsgTypeID': $('#MsgTypeID').val(),
			'IsActive': $('#Activate').prop('checked'),
			'BlackListEntryList': blData
		};
	};

	var successCallback = function (data) {

	};

	var $grid, bind = false;
	var $grid2, bind2 = false;
	var dataBLP, dataBLE;
	$.blacklistpublication = {
		initBLP: function (e) {
			$('.btn-save2').on('click', function () {
				$("#form-blp").submit();
			});

			$.blacklistpublication.initGrid();

			blacklistpublicationvalidation();
			blacklistentryvalidation();
		},
		initGrid: function (e, resetFields) {
			var id = $('#grid');

			var dataSource = {
				transport: {
					read: {
						url: '/Admin/BlackListPublication/ReadBlackListPubGrid',
						dataType: "json",
						type: "GET"
					},
					parameterMap: function (options) {

						var result = {
							Filter: $('input[data-role="search-all-item"]').val(),
							Skip: options.skip,
							Take: options.take,
							Page: options.page
						};

						if (options.sort && options.sort.length > 0) {
							result.SortBy = options.sort[0].field;
							result.Direction = options.sort[0].dir;
						}

						return result;
					}
				},
				schema: {
					data: "BLPubRecords",
					total: "Total",
					model: {
						id: "Id"
					}
                },
                /* To avoid form data disappeared after saved (If record is selected from page 2 onwards) */
				serverPaging: false, 
				serverSorting: false
			};

			var col = [
				{
					selectable: true, width: "45px",
					attributes: {
						"class": "checkboxSelection"
					}
				},
				{ field: 'Id', hidden: true },
				{ field: 'CreatorID', hidden: true },
				{ field: 'MsgTypeID', hidden: true },
				{ field: 'IsActiveLabel', title: $blackListResource.active, width: 120, sortable: true, hidden: true },
				{
					field: "IsActive",
					title: $blackListResource.active,
					width: 100,
					filterable: {
						cell: {
							enabled: false
						}
					},
					template: '<div class="kendo-container"> <i #= IsActive == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
				},
				{ field: 'MsgTypeName', title: $blackListResource.type, width: 200, sortable: true },
				{ field: 'Name', title: $blackListResource.name, width: 300, sortable: true },
				{ field: 'CrByUserName', title: $blackListResource.creator, width: 250, sortable: true },
				{ field: 'Desc', title: $blackListResource.description, width: 250, sortable: true }
			];

			var obj = {};
			obj.allowSelectMultipleRow = true;
			obj.customizeCheckbox = true;
			obj.onSelectionFn = $.blacklistpublication.editButtonClickHandler;
			obj.dataSourceOnSuccessFn = $.blacklistpublication.resetFieldsHandler;
			$grid = kendogridcustomization.init(id, dataSource, col, obj);
		},
		getGridSelections: function (grid) {
			var selectedId = [];
			var entityGrid = grid.data("kendoGrid");
			var rows = entityGrid.select();

			rows.each(function (index, row) {
				var selectedItem = entityGrid.dataItem(row);
				selectedId[index] = selectedItem.Id;
			});

			return selectedId;
		},
		getBLEGridSelections: function (grid) {
			var selectedId = [];
			var entityGrid = grid.data("kendoGrid");
			var rows = entityGrid.select();

			rows.each(function (index, row) {
				var selectedItem = entityGrid.dataItem(row);
				selectedId[index] = selectedItem.uid;
			});

			return selectedId;
		},
		createButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$(".Add-Edit-header h4").text($areaResources.actionTitle.createNewEntry);
				$(".breadcrumb .add-edit-breadcrumb-item").text($areaResources.actionTitle.createNewEntry);
				$('input[name="RecordId"]').val("");
				$("#form-action").val("Create");
				$.sectionproperties.SecondLevel($(e));
				resetfields();
				$.blacklistpublication.getBlackListEntry();
			});
		},
		createBLEButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$("#BLEHeader").text($areaResources.actionTitle.createNewEntry);
				$('#add-edit-ble-modal').modal('show');
				dataBLE = null;
				resetBLEfields();

				$('input[name="Action"]').val(1); /* Add = 1, Update = 2, Delete = 3 */

				$.blacklistpublication.renderAddUpdateButton();
				$('#add-edit-ble-modal').css('overflow', 'auto');
				$('#add-edit-modal').css('overflow', 'auto');
			});
		},
		editButtonClickHandler: function (e) {
			$(".Add-Edit-header h4").text($areaResources.actionTitle.editEntry);
			$(".breadcrumb .add-edit-breadcrumb-item").text($areaResources.actionTitle.editEntry);
			$("#form-action").val("Edit");

			dataBLP = e;
			resetfields(dataBLP);
			$.sectionproperties.SecondLevel();
		},
		editBLEButtonClickHandler: function (e) {
			$("#BLEHeader").text($areaResources.actionTitle.editEntry);
			$('input[name="RecordId"]').val();
			$('input[name="Action"]').val(2); /* Add = 1, Update = 2, Delete = 3 */
			dataBLE = e;
			resetBLEfields(dataBLE);
			$('#add-edit-ble-modal').modal('show');
			$.blacklistpublication.renderAddUpdateButton();
			$('#add-edit-ble-modal').css('overflow', 'auto');
			$('#add-edit-modal').css('overflow', 'auto');
		},
		resetFieldsHandler: function (e) {
			dataBLP = null;
			var getData = $("#grid").data("kendoGrid").dataSource.get($('input[name="RecordId"]').val());
			dataBLP = getData;

			resetfields(dataBLP);
		},
		renderAddUpdateButton: function (e) {
			/* Add = 1, Update = 2, Delete = 3 */
			var action = $('input[name="Action"]').val();
			if (action == "2") {
				$('#add-blpentry').hide();
				$('#addclose-blpentry').hide();
				$('#update-blpentry').show();
				$('#updateclose-blpentry').show();
			} else if (action == "1") {
				$('#add-blpentry').show();
				$('#addclose-blpentry').show();
				$('#update-blpentry').hide();
				$('#updateclose-blpentry').hide();
			}
		},
		addCloseHandler: function (e) {
			$(e).on('click', function (event) {
				$('#CloseModal').val("1");
				$('#form-ble').submit();
				event.preventDefault();
			});
		},
		updateCloseHandler: function (e) {
			$(e).on('click', function (event) {
				$('#CloseModal').val("1");
				$('#form-ble').submit();
				event.preventDefault();
			});
		},
		deleteButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$(this).blur();
				var selectedItem = $.blacklistpublication.getGridSelections($('#grid'));

				if (selectedItem.length === 0) {
					swal("", $globalMessages.swal.alert.noItemSelected);
					return false;
				}

				swal({
					title: "",
					text: $blackListResource.deleteBlackList,
					type: "info",
					showCancelButton: true,
					closeOnConfirm: false,
					reverseButtons: true,
					showLoaderOnConfirm: true
				}, function () {
					$.blacklistpublication.delete();
				});
			});
		},
		deleteBLEButtonClickHandler: function (e) {
			$(e).on('click', function () {
                $(this).blur();
				$('input[name="Action"]').val(3); /* Add = 1, Update = 2, Delete = 3 */
				var selectedItem = $.blacklistpublication.getBLEGridSelections($('#gridBLE'));

				if (selectedItem.length === 0) {
					swal("", $blackListResource.noDialString);
					return false;
				}

				$.blacklistpublication.deleteBlacklistEntry(selectedItem);

				$.toast({
					text: $globalMessages.toast.updated,
					position: 'bottom-right',
					loaderBg: '#ff6849',
					loader: false,
					icon: 'info',
					hideAfter: 3500,
					stack: 6
				});
			});
		},
		refreshButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$('input[data-role="search-all-item"]').val("");
				$.blacklistpublication.initGrid();
				$(this).blur();
			});
		},
		searchButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$.blacklistpublication.initGrid();
			});
		},
		searchHandler: function (e) {
			$(e).keypress(function (event) {
				if (event.which == 13) {
					$.blacklistpublication.initGrid();
				}
			});
		},
		refreshBLEButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$(this).blur();
				$('input[data-role="search-dial-string"]').val("");
				$.blacklistpublication.getBlackListEntry();
			});
		},
		searchBLEButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$.blacklistpublication.searchBlackListEntry();
			});
		},
		searchBLEHandler: function (e) {
			$(e).keypress(function (event) {
				if (event.which == 13) {
					$.blacklistpublication.searchBlackListEntry();
				}
			});
		},
		searchBlackListEntry: function (e) {
			var val = $('input[data-role="search-dial-string"]').val() != null ? $('input[data-role="search-dial-string"]').val().trim(): "";
			var grid = $("#gridBLE").data("kendoGrid");

			if (val) {
				var filters = [];

				$.each(grid.options.columns, function (index, value) {

					var checkCellEnabled = typeof value.filterable === 'undefined' ? true : value.filterable.cell.enabled;
					var checkCellType = value.type === 'number' ? "eq" : "contains";
					if (!value.hidden && checkCellEnabled) {
						var filter = {
							field: value.field,
							operator: checkCellType,
							value: val
						};
						filters.push(filter);
					}
				});
				grid.dataSource.filter({
					logic: "or",
					filters: filters
				});
			}
			else {
				grid.dataSource.filter({
					logic: "or",
					filters: []
				});
			}
		},
		resetmodalHandler: function (e) {
			$(e).on('click', function (x) {
				resetfields(dataBLP);
			});

		},
		resetmodalBLEHandler: function (e) {
			$(e).on('click', function () {
				resetBLEfields(dataBLE);
			});
		},
		saveclosemodalHandler: function (e) {
			$('input[name="modal-action"]').val('save & close');
		},
		save: function () {
			var model = constructsavemodel();

			fxcRequest.post('/Admin/BlackListPublication/Save',
				model,
				function (data) {
					$('input[name="RecordId"]').val(data.BLpID);
					$.blacklistpublication.initGrid();
					$.blacklistpublication.getBlackListEntry();

					swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");
				});
		},
		addBlackListEntry: function (e) {
			var id = "0";
			$.blacklistpublication.createBLEntryRow(id);
			var closemodal = $('#CloseModal').val();
			if (closemodal == "1") {
				$('#add-edit-ble-modal').modal('hide');
				$('#CloseModal').val("0");
			}
			$.toast({
				text: $globalMessages.toast.updated,
				position: 'bottom-right',
				loaderBg: '#ff6849',
				loader: false,
				icon: 'info',
				hideAfter: 3500,
				stack: 6
			});
		},
		editBlackListEntry: function (e) {
			var id = $('input[name="BLeID"]').val();
			if (id == "0") {
				var uid = $('input[name="BLeUid"]').val();
				var row = $("[data-uid='" + uid + "']");
				var selectedItem = $('#gridBLE').data("kendoGrid").dataItem(row);
				selectedItem.set("IsActive", $('#ActivateBLE').prop('checked'));
				selectedItem.set("DialString", $('input[name="DialString"]').val());
			} else {
				var dataItem = $('#gridBLE').data("kendoGrid").dataSource.get(id);

				dataItem["IsActive"] = $('#ActivateBLE').prop('checked');
				dataItem["DialString"] = $('input[name="DialString"]').val();
				$('#gridBLE').data("kendoGrid").refresh();
			}

			var closemodal = $('#CloseModal').val();
			if (closemodal == "1") {
				$('#add-edit-ble-modal').modal('hide');
				$('#CloseModal').val("0");
			}
			$.toast({
				text: $globalMessages.toast.updated,
				position: 'bottom-right',
				loaderBg: '#ff6849',
				loader: false,
				icon: 'info',
				hideAfter: 3500,
				stack: 6
			});
		},
		createBLEntryRow: function (id) {
			var IsActiveLabel;
			if ($('#ActivateBLE').prop('checked') === true) {
				IsActiveLabel = $globalMessages.yes;
			}
			else {
				IsActiveLabel = $globalMessages.no;
			}

			var data = {
				'Id': id, 'BLpID': $('input[name="RecordId"]').val(), 'IsActive': $('#ActivateBLE').prop('checked'), 'DialString': $('input[name="DialString"]').val(), 'IsActiveLabel': IsActiveLabel
			};
			var grid = $('#gridBLE').data("kendoGrid");
			grid.dataSource.add(data);
			grid.refresh();
		},
		removeBleRowByIndex: function (index) {
			var grid = $('#gridBLE').data("kendoGrid");
			var ds = grid.dataSource.at(index);
			grid.dataSource.remove(ds);
			grid.refresh();
		},
		delete: function (e) {
			fxcRequest.post('/Admin/BlackListPublication/Delete',
				{
					Ids: $.blacklistpublication.getGridSelections($('#grid'))
				},
				function (data) {
					$.blacklistpublication.initGrid();
					swal($globalMessages.swal.success.title, $globalMessages.swal.success.delete, "success");
				});
		},
		deleteBlacklistEntry: function (deleteIds) {
			var bledata = $('#gridBLE').data("kendoGrid").dataSource.data();
			$.each(deleteIds, function (i, v) {
				var id = v;
				if (bledata.length > 0) {

					for (j = 0; j < bledata.length; j++) {
						rowdata = bledata[j];
						if (rowdata.uid == id) {
							$.blacklistpublication.removeBleRowByIndex(j);
						}
					}
				}
			});
		},
		getBlackListEntry: function () {
			var action = "0";
			/*console.log(constructmodel());*/

			var blpID = $('input[name="RecordId"]').val();
			if (blpID == '') { blpID = '0'; }

			var filter = $('input[data-role="search-dial-string"]').val();

			var id = $('#gridBLE');

			var dataSource = {
				transport: {
					read: {
						url: '/Admin/BlackListPublication/ReadBlackListEntryGrid',
						dataType: "json",
						type: "GET"
					},
					parameterMap: function (options) {

						var result = {
							BlpID: blpID,
							Filter: filter,
							Skip: options.skip,
							Take: options.take,
							Page: options.page
						};

						if (options.sort && options.sort.length > 0) {
							result.SortBy = options.sort[0].field;
							result.Direction = options.sort[0].dir;
						}

						return result;
					}
				},
				schema: {
					data: "BLEntryRecords",
					total: "Total",
					model: {
						id: "Id"
					}
				},
				serverPaging: false,
				serverSorting: false
			};

			var col = [
				{
					selectable: true, width: "45px",
					filterable: {
						cell: {
							enabled: false
						}
					},
					attributes: {
						"class": "checkboxSelection"
					}
				},
				{ field: 'Id', hidden: true },
				{ field: 'BLpID', hidden: true },
				{ field: 'DialString', title: $blackListResource.dialString, width: 500, sortable: true },
				{ field: 'IsActiveLabel', title: $blackListResource.active, width: 200, sortable: true, hidden: true },
				{
					field: "IsActive",
					title: $blackListResource.active,
					width: 120,
					filterable: {
						cell: {
							enabled: false
						}
					},
					template: '<div class="kendo-container"> <i #= IsActive == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
				}
			];

			var obj = {};
			obj.allowSelectMultipleRow = true;
			obj.customizeCheckbox = true;
			obj.onSelectionFn = $.blacklistpublication.editBLEButtonClickHandler;
			$grid2 = kendogridcustomization.init(id, dataSource, col, obj);
		}
	};
})(window.jQuery);