﻿(function ($) {
    var editTempData, tempRouteSettings;

    jQuery.validator.addMethod("didNumber", function (value, element) {
        return didNumberInput.isValidNumber();
    }, "Invalid Number!");

    var didpoolvalidation = function () {
        $('#formSubmit').validate({
            ignoreTitle: true,
            errorPlacement: function (error, element) {
                var p = element.parent(".iti");
                if (p.length) {
                    error.insertAfter(p);
                }
            },
            rules: {
                DIDNumber: { required: true, noSpace: true, didNumber: true }
            },
            submitHandler: function (form) {
                $.didpool.save();
            }
        });
    };

    var importValidation = function () {
        $('#formSubmit_import').validate({
            ignoreTitle: true,
            rules: {
                ImportTxtArea: { required: true }
            },
            submitHandler: function (form) {
                $.didpool.import();
            }
        });
    };

    var resetDomain = function () {
        $('#Domain-id').val($('#dashboardID').val());
        $('#Domain-ddl').val($('#dashboardText').text());
    };

    var resetImportDomain = function () {
        $('#ImportDomain-id').val($('#dashboardID').val());
        $('#ImportDomain-ddl').val($('#dashboardText').text());
    };

    var resetfields = function () {
        $.didpool.initTreeViewDomain();

        if (editTempData !== null) {
            $.didpool.mapData(editTempData);
        } else {
            $('#formSubmit').trigger("reset");

            $('#Id').val("0");
            $('#InboundRouteCount').val("0");
            resetDomain();
        }

        $('#formSubmit').validate().resetForm();
    };

    var resetImportFields = function () {
        $("#importResult").hide();
        $('#formSubmit_import').trigger("reset");
        $.didpool.initTreeViewImportDomain();
        resetImportDomain();
        $("#importResultList").empty();
        $('#formSubmit_import').validate().resetForm();
    };

    var settingsValidation = function () {
        $('#formSubmit_Settings').validate({
            ignoreTitle: true,
            rules: {
                PrefixRuleDigits: {
                    number: true, noSpace: true,
                },
                PrefixRule: {
                    prefixRuleFormat: true, noSpace: true,
                },
                IBPriority: {
                    required: true,
                    noSpace: true,
                    number: true,
                    max: 9999,
                    min: 1
                }
            },
            errorPlacement: function (error, element) {
                var p = $('#settingsErrorMsg');
                if (p.length) {
                    error.appendTo(p);
                }
            },
            submitHandler: function (form) {
                $.didpool.saveSettings();
            }
        });
    };

    var resetSettingModalFields = function (e) {
        $('#formSubmit_Settings').trigger("reset");
        $('#formSubmit_Settings').validate().resetForm();

        $('#PrefixRule').val(e.PrefixRule);
        $('#PrefixRuleDigits').val(e.PrefixRuleDigits);
        $('#IBPriority').val(e.IBPriority);
    };

    $.didpool = {
        init: function (e) {
            $.didpool.submitButtonClickHandler();
            $.didpool.createButtonClickHandler($('.View1 .btn-new'));
            $.didpool.deleteButtonClickHandler($('.View1 .btn-delete'));
            $.didpool.refreshButtonClickHandler($('.View1 .btn-refresh'));
            $.didpool.settingsButtonClickHandler($('.View1 .btn-settings'));
            $.didpool.searchHandler($('.View1 input[data-role="search-all-item"]'));
            $.didpool.searchButtonClickHandler($('.View1 .btn-Search'));
            $.didpool.importButtonClickHandler($('.View1 .btn-import'));
            $.didpool.backButtonClickHandler($('.btn-back2'));
            $.didpool.backButtonClickHandler($('.btn-back3'));

            $.didpool.resetHandler($('.btn-Reset2'));
            $.didpool.domainResetHandler($('#Domain-reset'));

            $.didpool.importResetHandler($('.btn-Reset3'));
            $.didpool.importToDomainResetHandler($('#ImportDomain-reset'));
            $.didpool.resetmodalHandler($('button[data-role="reset-modal-value"]'));
            $.didpool.saveclosemodalHandler($('input[data-role="save-close-modal"]'));

            $.didpool.initGrid();
            $.didpool.readSettings();

            $.didpool.initTreeViewDomain();
            didpoolvalidation();
            
            $.didpool.initTreeViewImportDomain();
            importValidation();

            settingsValidation();
        },
        initTreeViewDomain: function (e) {
            var objDomainSelection = {};
            objDomainSelection.expandAll = true;
            objDomainSelection.declareType = "textbox";
            treeview.init("Domain", "Domain-name", "Domain-id", objDomainSelection);

            resetDomain();
        },
        initTreeViewImportDomain: function (e) {
            var objDomainSelection = {};
            objDomainSelection.expandAll = true;
            objDomainSelection.declareType = "textbox";
            treeview.init("ImportDomain", "ImportDomain-name", "ImportDomain-id", objDomainSelection);

            resetImportDomain();
        },
        mapData: function (dataItem) {
            /*console.log(dataItem);*/
            $('#formSubmit').BindToForm(dataItem, '#', '');

            $('#Id').val(dataItem.Id);
            $('#InboundRouteCount').val(dataItem.InboundRouteCount);
            didNumberInput.setCountry(dataItem.CountryCode);

            var dialCode = "+" + didNumberInput.getSelectedCountryData().dialCode;
            didNumberInput.setNumber(dataItem.DIDNumber.replace(dialCode, ""));
            $('#Domain-ddl').val(dataItem.DomainName);
            $("#Domain-id").val(dataItem.DomainId);
        },
        initGrid: function (e) {
            var id = $('#grid');

            var dataSource = {
                transport: {
                    read: {
                        url: '/admin/didpool/read',
                        dataType: "json",
                        type: "GET"
                    },
                    parameterMap: function (options) {
                        var result = {
                            FilterFields: "didpool,DomainName",
                            Filter: $('input[data-role="search-all-item"]').val(),
                            Skip: options.skip,
                            Take: options.take,
                            Page: options.page
                        };

                        if (options.sort && options.sort.length > 0) {
                            result.SortBy = options.sort[0].field;
                            result.Direction = options.sort[0].dir;
                        }

                        return result;
                    }
                },
                schema: {
                    data: "Records",
                    total: "Total",
                    model: {
                        id: "Id"
                    }
                },
                serverPaging: true,
                serverSorting: true
            };

            var col = [
                {
                    selectable: true, width: "45px",
                    attributes: {
                        "class": "checkboxSelection"
                    }
                },
                { field: 'Id', hidden: true },
                { field: 'InboundRouteCount', hidden: true },
                { field: 'DomainId', hidden: true },
                {
                    field: 'CountryCode', title: " ", width: 50, template: function (dataRow) {
                        var result = '<div status="kendo-container">' +
                            '<i class="flag-icon flag-icon-' + dataRow.CountryCode + '" title="' + dataRow.CountryCode.toUpperCase() + '"></i>' +
                            '</div>';
                        return result;
                    }
                },
                { field: 'DIDNumber', title: $didpoolResource.didpool, width: 200, sortable: true },
                { field: 'DomainName', title: $didpoolResource.domain, width: 200, sortable: true }
            ];

            var obj = {};
            obj.allowSelectMultipleRow = true;
            obj.customizeCheckbox = true;
            obj.onSelectionFn = $.didpool.editButtonClickHandler;

            kendogridcustomization.init(id, dataSource, col, obj);
        },
        submitButtonClickHandler: function() {
            $('.btn-save2').on('click', function () {
                var editedNumber = didNumberInput.getNumber(intlTelInputUtils.numberFormat.E164)
                var inboundRouteCount = $('#InboundRouteCount').val() ? Number.parseInt($('#InboundRouteCount').val()) : 0;

                if (inboundRouteCount > 0 && (editTempData.DIDNumber != editedNumber)) {
                    var msg = $didpoolResource.swal.saveMessage;
                    msg = msg.replace("{0}", editTempData.DIDNumber);
                    msg = msg.replace("{1}", editedNumber);

                    swal({
                        title: $didpoolResource.swal.saveTitle,
                        text: msg,
                        type: "warning",
                        showCancelButton: true
                    }, function (e) {
                        $("#formSubmit").submit();
                    });
                } else {
                    $("#formSubmit").submit();
                }
            });

            $('.btn-import3').on('click', function () {
                $("#formSubmit_import").submit();
            });
        },
        createButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $(this).blur();
                $(".Add-Edit-header h4").text($areaResources.actionTitle.createNewEntry);
                $(".breadcrumb .add-edit-breadcrumb-item").text($areaResources.actionTitle.createNewEntry);
                $.sectionproperties.SecondLevel($(e));
                editTempData = null;
                resetfields();
            });
        },
        editButtonClickHandler: function (dataItem) {
            $(".Add-Edit-header h4").text($areaResources.actionTitle.editEntry);
            $(".breadcrumb .add-edit-breadcrumb-item").text($areaResources.actionTitle.editEntry);

            $.sectionproperties.SecondLevel();
            editTempData = dataItem;
            resetfields();
        },
        deleteButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $(this).blur();
                var ids = $.didpool.getGridSelections();
                var isBeingUsed = $.didpool.isSelectedNumberBeingUsed();

                if (ids.length > 0) {
                    if (isBeingUsed) {
                        swal({
                            title: $didpoolResource.swal.deleteTitle,
                            text: $didpoolResource.swal.deleteMessage,
                            type: "warning",
                            showConfirmButton: true,
                            showCancelButton: true,
                            closeOnConfirm: false,
                            reverseButtons: true,
                            showLoaderOnConfirm: true
                        }, function () {
                            $.didpool.delete(ids);
                        });
                    }
                    else {
                        swal({
                            title: "",
                            text: $globalMessages.swal.alert.deleteConfirmation,
                            type: "info",
                            showCancelButton: true,
                            closeOnConfirm: false,
                            reverseButtons: true,
                            showLoaderOnConfirm: true
                        }, function () {
                            $.didpool.delete(ids);
                        });
                    }
                } else {
                    swal("", $globalMessages.swal.alert.noItemSelected);
                }
            });
        },
        refreshButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $(this).blur();
                $('input[data-role="search-all-item"]').val("");
                $.didpool.initGrid();
            });
        },
        settingsButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $('#add-edit-modal').modal('show');
            });
        },
        selectButtonClickHandler: function (e) {
            $(e).on('click', function () {
                if ($(this).text() === $globalMessages.button.selectAll) {
                    $grid.selectAll();
                    $(this).text($globalMessages.button.unSelectAll);
                } else {
                    $grid.unSelectAll();
                    $(this).text($globalMessages.button.selectAll);
                }
            });
        },
        searchButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.didpool.initGrid();
            });
        },
        importButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $(this).blur();
                $(".Add-Edit-header h4").text($areaResources.actionTitle.createNewEntry);
                $(".breadcrumb .add-edit-breadcrumb-item").text($areaResources.actionTitle.createNewEntry);
                $.sectionproperties.ThirdLevel($(e));
                resetImportFields();
            });
        },
        backButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.sectionproperties.FirstLevelView();
                $.didpool.initGrid();
            });
        },
        searchHandler: function (e) {
            $(e).keypress(function (event) {
                if (event.which === 13) {
                    $.didpool.initGrid();
                }
            });
        },
        resetHandler: function (e) {
            $(e).on('click', function () {
                resetfields();
            });
        },
        importResetHandler: function (e) {
            $(e).on('click', function () {
                resetImportFields();
            });
        },
        domainResetHandler: function (e) {
            $(e).on('click', function () {
                $('#Domain-id').val('');
                $('#Domain-ddl').val('');
            });
        },
        importToDomainResetHandler: function (e) {
            $(e).on('click', function () {
                $('#ImportDomain-id').val('');
                $('#ImportDomain-ddl').val('');
            });
        },
        resetmodalHandler: function (e) {
            $(e).on('click', function () {
                resetSettingModalFields(tempRouteSettings);
            });
        },
        saveclosemodalHandler: function (e) {
            $(e).on('click', function () {
                $('input[name="modal-action"]').val('save & close');
            });
        },
        getGridSelections: function (e) {
            var selectedId = [];
            var grid = $('#grid').data("kendoGrid");
            var rows = grid.select();
            rows.each(function (index, row) {
                var selectedItem = grid.dataItem(row);
                selectedId[index] = selectedItem.id;
            });

            return selectedId;
        },
        isSelectedNumberBeingUsed: function (e) {
            var isBeingUsed = false;
            var grid = $('#grid').data("kendoGrid");
            var rows = grid.select();
            rows.each(function (index, row) {
                var selectedItem = grid.dataItem(row);
                if (selectedItem.InboundRouteCount && selectedItem.InboundRouteCount > 0) {
                    isBeingUsed = true;
                }
            });
            return isBeingUsed;
        },
        createSaveModel: function (e) {
            var modelArr = $('#formSubmit').MapFormData();
            var saveObj = {};
            $.each(modelArr, function (index, formModel) {
                saveObj[formModel.Id] = formModel.Value;
            });

            saveObj.DIDNumber = didNumberInput.getNumber(intlTelInputUtils.numberFormat.E164);
            saveObj.CountryCode = didNumberInput.getSelectedCountryData().iso2;
            saveObj.DomainID = $('#Domain-id').val();
            return saveObj;
        },
        resetImportFields: function () {
            $('#formSubmit_import').trigger("reset");
            $('#formSubmit_import').validate().resetForm();
        },
        /* AJAX END */
        save: function () {
            var id = $('input[name="RecordId"]').val();
            if (id === '') { id = '0'; }
            var model = $.didpool.createSaveModel();
            /*console.log(model);*/
            fxcRequest.post('/admin/didpool/save',
                model,
                function (data) {
                    $.didpool.initGrid();
                    if (editTempData === null) {
                        resetfields();
                        $('#formSubmit').validate().resetForm();
                    }
                    swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");
                },
                function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
                });
        },
        saveSettings: function () {
            var model = {
                PrefixRule: $('#PrefixRule').val(),
                PrefixRuleDigits: $('#PrefixRuleDigits').val(),
                IBPriority: $('#IBPriority').val()
            };
            fxcRequest.post('/admin/didpool/SaveSettings',
                model,
                function (data) {
                    if ($('input[name="modal-action"]').val() === 'save & close') {
                        $('#add-edit-modal').modal('hide');
                        $('input[name="modal-action"]').val('');                    }

                    tempRouteSettings = null;
                    swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");
                },
                function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
                });
        },
        delete: function (ids) {
            fxcRequest.post('/admin/didpool/delete',
                {
                    Ids: ids
                },
                function (data) {
                    $.didpool.initGrid();
                    swal($globalMessages.swal.success.title, $globalMessages.swal.success.delete, "success");
                },
                null);
        },
        import: function () {
            var countryCode = importInput.getSelectedCountryData().iso2;
            var didNumbers = $('#ImportTxtArea').val().split("\n");
            var oriDIDNumbers = [];
            var formattedDIDNumbers = [];

            var formattedNum;
            hiddenInput.setCountry(countryCode);
            $.each(didNumbers, function (key, value) {
                if (value) {
                    oriDIDNumbers.push(value);

                    hiddenInput.setNumber(value);
                    formattedNum = hiddenInput.getNumber(intlTelInputUtils.numberFormat.E164);
                    formattedDIDNumbers.push(formattedNum);
                }
            });

            var importData = {
                oriDIDNumbers: oriDIDNumbers,
                DIDNumbers: formattedDIDNumbers,
                CountryCode: countryCode,
                DomainID: $('#ImportDomain-id').val()
            };

            fxcRequest.post('/admin/didpool/import',
                importData,
                function (data) {
                    console.log(data);

                    $("#importResult").show();

                    $("#errorCount").text(data.ErrorCount);
                    $("#warningCount").text(data.WarningCount);
                    $("#successCount").text(data.SuccessCount);

                    var errorNumbers = "";
                    var errorListHtml = "";
                    $("#importResultList").empty();

                    if (data.Error.length == 0) {
                        swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");
                    }
                    else {
                        /* Show error message */
                        $.each(data.Error, function (key, value) {
                            errorListStyle = value.IsWarning ? "warning" : "danger";
                            errorNumbers += (value.OriDIDNumber + '\n');

                            errorListHtml = '<li class="list-group-item list-group-item-' + errorListStyle + '">' + value.OriDIDNumber + '<span class="float-right">' + value.ErrorMessage + '</span></li>';

                            $("#importResultList").append(errorListHtml);
                        });   

                        $("#ImportTxtArea").val(errorNumbers);

                        swal($globalMessages.swal.warningTitle, $didpoolResource.swal.recordNotAdded, "warning");
                    }                    
                },
                function(error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
                });
        },
        readSettings: function () {
            fxcRequest.post('/admin/didpool/ReadSettings',
                {
                },
                function (data) {
                    tempRouteSettings = data;

                    $('#PrefixRule').val(data.PrefixRule);
                    $('#PrefixRuleDigits').val(data.PrefixRuleDigits);
                    $('#IBPriority').val(data.IBPriority);

                    swal.close();
                },
                null, false);
        }
    };
})(window.jQuery);
