﻿(function ($) {
	var validation = function () {
		$('#formSubmit').validate({
			rules: {
				Name: { required: true, noSpace: true },
				RootPath: { required: true, noSpace: true },
				Username: { checkRequired: "Password", noSpace:true },
				Password: { checkRequired: "Username" }
			},
			submitHandler: function (form) {
				$.docstore.save();
			},
			ignoreTitle: true
		});
	};

	var $grid, bind = false;
	var $data;
	var $PassIsEncrypted = false;
	var $TempPassword;
	$.docstore = {
		init: function (e) {
			validation();

			/*Btn Action*/
			$.docstore.createButtonClickHandler($(".btn-new-grid"));
			$.docstore.deleteButtonClickHandler($(".btn-delete-grid"));
			$.docstore.refreshButtonClickHandler($(".btn-refresh-grid"));
			$.docstore.searchPressEnter($('input[data-role="search-all-item"]'));
			$.docstore.searchButtonClickHandler($('.btn-search-grid'));

			/*Form*/
			$.docstore.resetButtonClickHandler($('#reset-docstore'));
			$.docstore.saveclosemodalHandler($('#saveClose-docstore'));
			$.docstore.initGrid();
			$.docstore.resetPassword();
		},
		resetPassword: function (e) {
			$("#Password").focus(function () {
				if ($PassIsEncrypted) {
					$TempPassword = $("#Password").val();
					$("#Password").val("");
				}
			});
			$("#Password").keyup(function () {
				$PassIsEncrypted = false;
			});
			$("#Password").focusout(function () {
				if ($PassIsEncrypted) {
					$("#Password").val($TempPassword);
				}
			});
		},
		initGrid: function (e) {
			var id = $('#grid');
			var dataSource = {
				transport: {
					read: {
						url: '/Admin/DocStore/Read',
						dataType: "json",
						type: "GET"
					},
					parameterMap: function (options) {
						/* Fix url param for sort values */
						var result = {
							Skip: options.skip,
							Take: options.take,
							Sort: options.sort,
							SearchText: $('input[data-role="search-all-item"]').val()
						};
						if (options.sort && options.sort.length > 0) {
							result.SortBy = options.sort[0].field;
							result.Direction = options.sort[0].dir;
						}
						return result;
					}
				},
				schema: {
					data: "Records",
					total: "Total",
					model: {
						id: "Id"
					}
				},
				serverPaging: false,
				serverSorting: false
			};

			var col = [
				{
					selectable: true, width: 45,
					attributes: {
						"class": "checkboxSelection"
					}
				},
				{ field: 'Id', hidden: true },
				{ field: 'Name', title: $areaResources.grid.name, sortable: true, minWidth: 150, width: 150 },
				{ field: 'Label', title: $docStoreResource.label, sortable: true, minWidth: 100, width: 150 },
				{ field: 'RootPath', title: $docStoreResource.rootPath, minWidth: 200, width: 250, sortable: true },
				{ field: 'MaskPath', title: $docStoreResource.maskPath, minWidth: 200, width: 250, sortable: true },
				{ field: 'Description', title: $areaResources.grid.description, sortable: true, minWidth: 300, width: 350 }
			];

			var obj = {};
			obj.allowSelectMultipleRow = true;

			obj.onSelectionFn = $.docstore.editHandler;

			var $grid = kendogridcustomization.init(id, dataSource, col, obj);
		},
		initForm: function (e) {
			var obj = {
				blurForm: true,
				targetDiv: $("form#formSubmit")
			};
			fxcRequest2.get('/Admin/DocStore/GetDoc',
				{
					Id: e
				},
				function (data) {
					/* map data to inputs*/
					$data = data;
					$.docstore.resetFields();
				},
				obj);
		},

		/*Btn Action*/
		createButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$(".modal-header h4#docstore").text($areaResources.actionTitle.createNewEntry);
				$data = null;
				$('#modalDocStore').modal('show');
				$.docstore.resetFields();
			});
		},
		editHandler: function (e) {
			$(".modal-header h4#docstore").text($areaResources.actionTitle.editEntry);
			$('#modalDocStore').modal('show');
			$.docstore.initForm(e.Id);
		},
		deleteButtonClickHandler: function (e) {
			$(e).on('click', function (x) {
				$(this).blur();
				$.docstore.delete();
			});
		},
		refreshButtonClickHandler: function (e) {
			$(e).on('click', function (x) {
				$.docstore.refresh();
				$(this).blur();
			});
		},
		searchButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$.docstore.search(e);
			});
		},
		searchPressEnter: function (e) {
			$(e).on('keypress', function (enter) {
				if (enter.which === 13) {
					$.docstore.search(e);
				}
			});
		},

		resetButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$.docstore.resetFields();
			});
		},
		saveclosemodalHandler: function (e) {
			$(e).on('click', function () {
				$('input[name="modal-action"]').val('save & close');
			});
		},

		/* Logic */
		refresh: function (e) {
			$('input[data-role="search-all-item"]').val("");
			$.docstore.initGrid();
		},
		resetFields: function () {
			if ($data !== null) {
				/* console.log($data); */
				$("#Label").attr("disabled", true);
				
				$('input[name="RecordId"]').val($data.Id);
				$('#Name').val($data.Name);
				$('#Label').val($data.Label);
				$('#Description').val($data.Description);
				$('#RootPath').val($data.RootPath);
				$('#AddressMark').val($data.MaskPath);
				$('#Username').val($data.Username);
				$('#Password').val($data.Password);

				$.sectionproperties.Disabled("IsEncrypted", $data.Id == "107");

				$('#IsEncrypted').bootstrapSwitch('state', $data.IsEncrypted);
				$PassIsEncrypted = $data.PassIsEncrypted;
			}
			else {
                $PassIsEncrypted = false;
                $('input[name="RecordId"]').val(0);
                $("#Label").attr("disabled", false);
				$("#formSubmit").trigger("reset");
			}
			$("#formSubmit").validate().resetForm();
		},
		search: function (e) {
			$.docstore.initGrid();
		},
		/* End Logic */

		/*Post or Get Function*/
		delete: function (e) {
			var selectedItem = $.docstore.getGridSelections($("#grid"));

			if (selectedItem.length === 0) {
				swal("", $docStoreResource.noDocStoreSelected);
				return false;
			}

			swal({
				title: "",
				text: $docStoreResource.docStoreDelQuest,
				type: "info",
				showCancelButton: true,
				closeOnConfirm: false,
				reverseButtons: true,
				showLoaderOnConfirm: true
			}, function () {
				fxcRequest.post('/admin/docstore/delete',
					{ Ids: selectedItem.join().split(',') },
					function (data) {
						swal($globalMessages.swal.done, $docStoreResource.docStoreDel, "success");
						/* Refresh grid everytime after save*/
						$.docstore.refresh();
						$('#delete-modal').modal('hide');
					}, function () {
						swal($globalMessages.swal.error.errorCap, error.errorOnDelete, "error");
					}, true);
			});
		},
		getGridSelections: function (event) {
			var entityGrid = event.data("kendoGrid");
			var rows = entityGrid.select();
			var $selectedUser = [];
			rows.each(function (index, row) {
				var selectedItem = entityGrid.dataItem(row);
				$selectedUser[index] = selectedItem.Id;
			});

			return $selectedUser;
		},
		save: function () {
			var idval = $('input[name="RecordId"]').val();
			fxcRequest.post('/admin/docstore/save',
				{
					Id: idval,
					Name: $('#Name').val(),
					Label: $('#Label').val(),
					RootPath: $('#RootPath').val(),
					MaskPath: $('#AddressMark').val(),
					Description: $('#Description').val(),
					Username: $('#Username').val(),
					Password: $('#Password').val(),
					IsEncrypted: idval == "107" ? false: $('#IsEncrypted').prop('checked'),
					PassIsEncrypted: $PassIsEncrypted
				},
				function (data) {
					if ($('input[name="RecordId"]').val() > 0)
						$.docstore.initForm($('input[name="RecordId"]').val());

					$.docstore.refresh();
					if ($('input[name="modal-action"]').val() === 'save & close') {
						$('#modalDocStore').modal('hide');
						$('input[name="modal-action"]').val('');
					}
					swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");
				},
				function (error) {
					swal($globalMessages.swal.error.errorCap, error.statusText, "error");
				});
		}
	};
})(window.jQuery);