﻿(function ($) {
	var domainpermissionValidation = function () {
        $('#formSubmit').validate({
            submitHandler: function (form) {
                if ($("#form-action").val() === 'ApplyAll') {
                    $.domainpermission.applyall();
                }
                else {
                    $.domainpermission.save();
                }
            }
        });
	};

	var showSweet = function () {
		swal({
			title: $globalMessages.swal.warningTitle,
			text: $areaResources.swal.applyToAllGlobal,
			type: "warning",
			showConfirmButton: true,
			showCancelButton: true,
			closeOnConfirm: false
		}, function (isConfirmed) {
			if (isConfirmed) {
				$("#form-action").val("ApplyAll");
				$("#formSubmit").submit();
			}
		});
	}

	$.domainpermission = {
		init: function (e) {
			domainpermissionValidation();

			/*Btn Action*/
			$.domainpermission.saveButtonClickHandler($(".btn-save"));
			$.domainpermission.applyAllButtonClickHandler($(".btn-apply-all"));

			$(document).on('keyup', function (e) {
				var code = e.code;
				if (code == 'Space') {
					if ($('.sweet-alert.visible').length > 0) {
						swal.close();
					}
				}
			});

			$(document).on('keydown', function (e) {
				var code = e.code;
				if (code == 'Enter') {
					if ($('.sweet-alert.visible').length > 0) {
						swal.close();
					}
				}
			});

			$('.btn-apply-all').bind("click", showSweet).focus();
		},

		/*Btn Action*/
		saveButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$("#form-action").val("");
				$("#formSubmit").submit();
			});
		},
		applyAllButtonClickHandler: function (e) {
            $(e).on('click', function () {
				showSweet();
			});
		},

		/* Logic */
		constructmodel: function (action) {
			return {
				"Action": action,
				"DomainId": $('#DomainId').val(),
				"SendEmailAttachSize": { "Value": $('#SendEmailAttachSize_Value').val(), "IsSet": $('#SendEmailAttachSize_IsSet').prop("checked") },
				"FwdEmailAttachMaxSize": { "Value": $('#FwdEmailAttachMaxSize_Value').val(), "IsSet": $('#FwdEmailAttachMaxSize_IsSet').prop("checked") },
				"DocumentQuotaSize": { "Value": $('#DocumentQuotaSize_Value').val(), "IsSet": $('#DocumentQuotaSize_IsSet').prop("checked") },
				"ExchAddrBookInt": { "Value": $('#ExchAddrBookInt').prop("checked"), "IsSet": $('#ExchAddrBookInt_IsSet').prop("checked") },
				"AllowMsgDelegate": { "Value": $('#AllowMsgDelegate').prop("checked"), "IsSet": $('#AllowMsgDelegate_IsSet').prop("checked") },
				"SendOn": { "Value": $('#SendOn').prop("checked"), "IsSet": $('#SendOn_IsSet').prop("checked") },
				"SendFax": { "Value": $('#SendFax').prop("checked"), "IsSet": $('#SendFax_IsSet').prop("checked") },
				"SendFaxIntl": { "Value": $('#SendFaxIntl').prop("checked"), "IsSet": $('#SendFaxIntl_IsSet').prop("checked") },
				"SendFaxColor": { "Value": $('#SendFaxColor').prop("checked"), "IsSet": $('#SendFaxColor_IsSet').prop("checked") },
				"SendRawFax": { "Value": $('#SendRawFax').prop("checked"), "IsSet": $('#SendRawFax_IsSet').prop("checked") },
				"SendEmail": { "Value": $('#SendEmail').prop("checked"), "IsSet": $('#SendEmail_IsSet').prop("checked") },
				"SendEmailAttach": { "Value": $('#SendEmailAttach').prop("checked"), "IsSet": $('#SendEmailAttach_IsSet').prop("checked") },
				"SendHttp": { "Value": $('#SendHttp').prop("checked"), "IsSet": $('#SendHttp_IsSet').prop("checked") },
				"SendFtp": { "Value": $('#SendFtp').prop("checked"), "IsSet": $('#SendFtp_IsSet').prop("checked") },
				"SendFile": { "Value": $('#SendFile').prop("checked"), "IsSet": $('#SendFile_IsSet').prop("checked") },
				"SendPrint": { "Value": $('#SendPrint').prop("checked"), "IsSet": $('#SendPrint_IsSet').prop("checked") },
				"ForwardOn": { "Value": $('#ForwardOn').prop("checked"), "IsSet": $('#ForwardOn_IsSet').prop("checked") },
				"ForwardFax": { "Value": $('#ForwardFax').prop("checked"), "IsSet": $('#ForwardFax_IsSet').prop("checked") },
				"ForwardRawFax": { "Value": $('#ForwardRawFax').prop("checked"), "IsSet": $('#ForwardRawFax_IsSet').prop("checked") },
				"ForwardEmail": { "Value": $('#ForwardEmail').prop("checked"), "IsSet": $('#ForwardEmail_IsSet').prop("checked") },
				"ForwardEmailAttach": { "Value": $('#ForwardEmailAttach').prop("checked"), "IsSet": $('#ForwardEmailAttach_IsSet').prop("checked") },
				"ForwardPrint": { "Value": $('#ForwardPrint').prop("checked"), "IsSet": $('#ForwardPrint_IsSet').prop("checked") },
				"ForwardHttp": { "Value": $('#ForwardHttp').prop("checked"), "IsSet": $('#ForwardHttp_IsSet').prop("checked") },
				"ForwardFtp": { "Value": $('#ForwardFtp').prop("checked"), "IsSet": $('#ForwardFtp_IsSet').prop("checked") },
				"ForwardFile": { "Value": $('#ForwardFile').prop("checked"), "IsSet": $('#ForwardFile_IsSet').prop("checked") },
				"ForwardUserOn": { "Value": $('#ForwardUserOn').prop("checked"), "IsSet": $('#ForwardUserOn_IsSet').prop("checked") },
				"AllowDoc": { "Value": $('#AllowDoc').prop("checked"), "IsSet": $('#AllowDoc_IsSet').prop("checked") },
				"MsgDownload": { "Value": $('#MsgDownload').prop("checked"), "IsSet": $('#MsgDownload_IsSet').prop("checked") },
				"MsgPrint": { "Value": $('#MsgPrint').prop("checked"), "IsSet": $('#MsgPrint_IsSet').prop("checked") }
			};
		},
		/* End Logic */

		/*Post or Get Function*/
		save: function () {
			fxcRequest.post('/Admin/Global/DomainPermission',
				$.domainpermission.constructmodel("1"),
				function (data) {
					$swal.success($globalMessages.swal.success.text);
					fxcUserConn.onDomainChanges($('#DomainId').val(), false, true, true);
				},
				null);
		},
		applyall: function () {
			fxcRequest.post('/Admin/Global/DomainPermission',
				$.domainpermission.constructmodel("2"),
				function (data) {
					$swal.success($areaResources.swal.applyToAll);
					fxcUserConn.onDomainChanges($('#DomainId').val(), true, true, true);
				},
				null);
		}
	};
})(window.jQuery);
