﻿(function ($) {    
    var editTempData;
    var $PassIsEncrypted = false;
    var $TempPassword;

    var printersettingvalidation = function () {
        $('#formSubmit').validate({
			ignore: ".ignored",
			ignoreTitle: true,
            rules: {
                PrinterLabel: {required: true, noSpace: true },
                PrinterName: { required: true, noSpace: true }
            },            
            submitHandler: function (form) {
                $.printersetting.save();
			}
        });
    };
    var resetfields = function () {
       
        $PassIsEncrypted = false;

        $.printersetting.initTreeViewDomain();

        if (editTempData !== null) {
            $.printersetting.mapData(editTempData);
        } else {
            $('#PrinterID').val("0");
            $('#domain-ddl').val($('#dashboardText').text());
            $("#domain-id").val($('#dashboardID').val());

            $('#formSubmit').trigger("reset");
            var defaultBanner = "-----------------------------------------\n--  FaxCore Network Print Job\n--\n--  User:   $$USER.USERNAME$$\n--  Domain: $$USER.DOMAIN_NAME$$\n--  Name:   $$USER.DISPLAY_NAME$$\n--  Date:   $$UTIL.DATE_TIME$$\n-----------------------------------------";
            $('#BannerPageValue').val(defaultBanner);
        }

        $('#formSubmit').validate().resetForm();
    };
    
    $.printersetting = {
        init: function (e) {
            $("#HorizontalMargin").mask('99999.99');
            $("#VerticalMargin").mask('99999.99');

            $('.btn-save2').on('click', function () {
                $("#form-action").val("");
                $("#formSubmit").submit();
            });

            $.printersetting.createButtonClickHandler($('.View1 .btn-new'));
            $.printersetting.deleteButtonClickHandler($('.View1 .btn-delete'));
            $.printersetting.refreshButtonClickHandler($('.View1 .btn-refresh'));
            $.printersetting.searchHandler($('.View1 input[data-role="search-all-item"]'));
            $.printersetting.searchButtonClickHandler($('.View1 .btn-Search'));
            $.printersetting.resetHandler($('.btn-Reset2'));
            $.printersetting.testPrintHandler($('.btn-Test2'));

            $.printersetting.initGrid();
            $.printersetting.resetPassword();

            $.printersetting.initTreeViewDomain();
            printersettingvalidation();
        },
        initTreeViewDomain: function (e) {
            $('#Domain-ddl').val($('#dashboardText').text());
            $("#Domain-id").val($('#dashboardID').val());

            var objDomainSelection = {};
            objDomainSelection.expandAll = true;
            objDomainSelection.declareType = "textbox";
            treeview.init("Domain", "Domain-name", "Domain-id", objDomainSelection);
        },
        resetPassword: function (e) {
            $("#NetUserPwdX").focus(function () {
                if ($PassIsEncrypted) {
                    $TempPassword = $("#NetUserPwdX").val();
                    $("#NetUserPwdX").val("");
                }
            });
            $("#NetUserPwdX").keyup(function () {
                $PassIsEncrypted = false;
            });
            $("#NetUserPwdX").focusout(function () {
                if ($PassIsEncrypted) {
                    $("#NetUserPwdX").val($TempPassword);
                }
            });
        },
        mapData: function (dataItem) {
            /*console.log(dataItem);*/
            $('#formSubmit').BindToForm(dataItem, '#', '');
            
            $('#Domain-ddl').val(dataItem.DomainName);
            $("#Domain-id").val(dataItem.DomainID);
            $PassIsEncrypted = true;
        },
        initGrid: function(e) {
            var hideVisibility = false;
            var id = $('#grid');
            
            var dataSource = {
                transport: {
                    read: {
                        url: '/admin/printersetting/read',
                        dataType: "json",
                        type: "GET"
                    },
                    parameterMap: function (options) {
                        var result = {
                            FilterFields: "VisibilityLabel,PrinterLabel,DomainName,ServerName,PrinterName,Desc",
                            Filter: $('input[data-role="search-all-item"]').val(),
                            Skip: options.skip,
                            Take: options.take,
                            Page: options.page
                        };

                        if (options.sort && options.sort.length > 0) {
                            result.SortBy = options.sort[0].field;
                            result.Direction = options.sort[0].dir;
                        }

                        return result;
                    }
                },
                schema: {
                    data: "Records",
                    total: "Total",
                    model: {
                        id: "PrinterID"
                    }
                },
                serverPaging: true,
                serverSorting: true
            };

            var col = [
                {
                    selectable: true, width: "45px",
                    attributes: {
                        "class": "checkboxSelection"
                    }
                },
                { field: 'PrinterID', hidden: true },
                { field: 'DomainID', hidden: true },
                { field: 'PrinterLabel', title: $printerResource.label, width: 200, sortable: true },
                { field: 'DomainName', title: $printerResource.domainName, width: 200, sortable: true },
                { field: 'ServerName', title: $printerResource.serverName, width: 200, sortable: true },
                { field: 'PrinterName', title: $printerResource.name, width: 250, sortable: true },
                {
                    field: "VisibilityLabel",
                    title: $printerResource.visibility,
                    width: 150,
                    template: function (dataRow) {
                        var icon = '<i class="mdi mdi-check"></i>';
						var statusClass = "visibility" + dataRow.VisibilityID + "";

                        var result = '<div status="kendo-container">' +
                            '<span class="badge kendo-span-status badge-pill badge-' + statusClass.toLowerCase() + '">' + dataRow.VisibilityLabel + '</span> ' +
                            '</div>';
                        return result;
                    },
                    hidden: hideVisibility
                },
                { field: 'Desc', title: $areaResources.grid.description, width: 250, sortable: true },
                
                { field: 'IsActive', hidden: true },
                { field: 'VisibilityID', hidden: true },
                { field: 'PageSize', hidden: true },
                { field: 'FontName', hidden: true },
                { field: 'FontSize', hidden: true },
                { field: 'FontWeight', hidden: true },
                { field: 'HorizontalMargin', hidden: true },
                { field: 'VerticalMargin', hidden: true },
                { field: 'PrintDuplex', hidden: true },
                { field: 'NetDomainName', hidden: true },
                { field: 'NetUserName', hidden: true },
                { field: 'CrDate', hidden: true },
                { field: 'NetUserPwdX', hidden: true },
                { field: 'AllowBannerPage', hidden: true },
                { field: 'BannerPageValue', hidden: true }
            ];

            var obj = {};
            obj.allowSelectMultipleRow = true;
            obj.customizeCheckbox = true;
            obj.onSelectionFn = $.printersetting.editButtonClickHandler;

            kendogridcustomization.init(id, dataSource, col, obj);
        },
        createButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $(this).blur();
                $(".Add-Edit-header h4").text($areaResources.actionTitle.createNewEntry);
                $(".breadcrumb .add-edit-breadcrumb-item").text($areaResources.actionTitle.createNewEntry);
                $.sectionproperties.SecondLevel($(e));
                editTempData = null;
                resetfields();
            });
        },
        editButtonClickHandler: function (dataItem) {
            $(".Add-Edit-header h4").text($areaResources.actionTitle.editEntry);
            $(".breadcrumb .add-edit-breadcrumb-item").text($areaResources.actionTitle.editEntry);

            $.sectionproperties.SecondLevel();
            editTempData = dataItem;
            resetfields();
        },
        deleteButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $(this).blur();
                var ids = $.printersetting.getGridSelections();
                if (ids.length > 0) {
                    swal({
                        title: "",
						text: $globalMessages.swal.alert.deleteConfirmation,
                        type: "info",
                        showCancelButton: true,
                        closeOnConfirm: false,
                        reverseButtons: true,
                        showLoaderOnConfirm: true
                    }, function () {
                        $.printersetting.delete(ids);
                    });
                } else {
					swal("", $globalMessages.swal.alert.noItemSelected);
                }                
            });
        },
        refreshButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $(this).blur();
                $('input[data-role="search-all-item"]').val("");
                $.printersetting.initGrid();
            });
        },
        selectButtonClickHandler: function (e) {
            $(e).on('click', function () {
                if ($(this).text() === $globalMessages.button.selectAll) {
                    $grid.selectAll();
                    $(this).text($globalMessages.button.unSelectAll);
                } else {
                    $grid.unSelectAll();
                    $(this).text($globalMessages.button.selectAll);
                }
            });
        },
        searchButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.printersetting.initGrid();
            });
        },
        searchHandler: function (e) {
            $(e).keypress(function (event) {
                if (event.which === 13) {
                    $.printersetting.initGrid();
                }
            });
        },
        resetHandler: function (e) {
            $(e).on('click', function () {
                resetfields();
            });
        },
        testPrintHandler: function (e) {
            $(e).on('click', function () {
                var model = $.printersetting.createSaveModel();
                fxcRequest.post('/Admin/PrinterSetting/TestPrint',
                    model,
                    function (data) {
						swal($globalMessages.swal.success.title, $printerResource.swal.success.testPrint, "success");
                    });
            });
        },
        createSaveModel: function (e) {
            var modelArr = $('#formSubmit').MapFormData();
            var saveObj = {};
            $.each(modelArr, function (index, formModel) {
                saveObj[formModel.Id] = formModel.Value;
            });

            saveObj.DomainID = $('#Domain-id').val();
            saveObj.IsEncrypted = $PassIsEncrypted;
            return saveObj;
        },
        save: function () {
            var id = $('input[name="RecordId"]').val();
            if (id === '') { id = '0'; }
            var model = $.printersetting.createSaveModel();
            /*console.log(model);*/
            fxcRequest.post('/admin/printersetting/save',
                model,
                function (data) {
                    $.printersetting.initGrid();
                    if (editTempData === null) {
                        resetfields();
                        $('#formSubmit').validate().resetForm();
                    }
                    swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");
                },
                function (error) {
					swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
                });
        },
        delete: function (ids) {
            fxcRequest.post('/admin/printersetting/delete',
                {
                    Ids: ids
                },
                function (data) {
                    $.printersetting.initGrid();
                    swal($globalMessages.swal.success.title, $globalMessages.swal.success.delete, "success");
                },
                null);
        },
        getGridSelections: function (e) {
            var selectedId = [];
            var grid = $('#grid').data("kendoGrid");
            var rows = grid.select();
            rows.each(function (index, row) {
                var selectedItem = grid.dataItem(row);
                selectedId[index] = selectedItem.id;
            });

            return selectedId;
        }
    };
})(window.jQuery);
