﻿(function ($) {
    var serversettingsValidation = function () {
        $('#formSubmit').validate({
            rules: {
                'Server.Value': {
					required: true,
					noSpace: true
                },
                'Port.Value': {
                    required: true,
					number: true,
					noSpace: true
                }
            },
            submitHandler: function (form) {
                if ($("#form-action").val() === 'ApplyAll') {
                    $.serversettings.applyall();
                }
                else {
                    $.serversettings.save();
                }
			},
			ignoreTitle: true
        });
    };

    var showSweet = function () {
        swal({
            title: $globalMessages.swal.warningTitle,
            text: $areaResources.swal.applyToAllGlobal,
            type: "warning",
            showConfirmButton: true,
            showCancelButton: true,
			closeOnConfirm: false
        }, function (isConfirmed) {
            if (isConfirmed) {
                $("#form-action").val("ApplyAll");
                $("#formSubmit").submit();
            }
        });
    }

    $.serversettings = {
        init: function (e) {
            $("#Port").mask('99999');
            $.serversettings.saveButtonClickHandler($('.btn-save'));
            $.serversettings.applyAllButtonClickHandler($('.btn-apply-all'));

            $(document).on('keyup', function (e) {
                var code = e.code;
                if (code == 'Space') {
                    if ($('.sweet-alert.visible').length > 0) {
                        swal.close();
                    }
                }
            });

            $(document).on('keydown', function (e) {
                var code = e.code;
                if (code == 'Enter') {
                    if ($('.sweet-alert.visible').length > 0) {
                        swal.close();
                    }
                }
            });

            $('.btn-apply-all').bind("click", showSweet).focus();

            serversettingsValidation();
        },
        /*Btn Action*/
        saveButtonClickHandler: function (e) {
            $(e).on('click', function (x) {
                $("#form-action").val("");
                $("#formSubmit").submit();
            });
        },
        applyAllButtonClickHandler: function (e) {
            $(e).on('click', function (x) {
                showSweet();
            });
        },
        /*End Btn Action*/

        /* Logic */
        constructmodel: function (action) {
            return {
                "Server": { "Value": $('#Server').val(), "IsSet": $('#Server_IsSet').prop("checked") },
                "Port": { "Value": $('#Port').val(), "IsSet": $('#Port_IsSet').prop("checked") },
                "HttpMode": { "Value": $('#HttpMode_Value').val(), "IsSet": $('#HttpMode_IsSet').prop("checked") },
                "OutFileType": { "Value": $('#OutFileType_Value').val(), "IsSet": $('#OutFileType_IsSet').prop("checked") },
                "PageType": { "Value": $('#PageType_Value').val(), "IsSet": $('#PageType_IsSet').prop("checked") },
                "AllowOcr": { "Value": $('#AllowOcr').prop("checked"), "IsSet": $('#AllowOcr_IsSet').prop("checked") },
                "OcrLanguage": { "Value": $('#OcrLanguage_Value').val(), "IsSet": $('#OcrLanguage_IsSet').prop("checked") },
                "SkipBlankPage": { "Value": $('#SkipBlankPage').prop("checked"), "IsSet": $('#SkipBlankPage_IsSet').prop("checked") },
                "DomainId": $('#DomainId').val(),
                "Action": action
            };
        },
        save: function () {
			fxcRequest.post('/Admin/Global/ServerSetting',
				$.serversettings.constructmodel("1"),
				function (data) {
					$swal.success($globalMessages.swal.success.text);
                    fxcUserConn.onDomainChanges($('#DomainId').val(), false, true, true);
				},
				null);
        },
        applyall: function () {
			fxcRequest.post('/Admin/Global/ServerSetting',
				$.serversettings.constructmodel("2"), function (data) {
					$swal.success($areaResources.swal.applyToAll);
                    fxcUserConn.onDomainChanges($('#DomainId').val(), true, true, true);
				},
				null);
        }
        /* End Logic */
    };
})(window.jQuery);

