﻿(function ($) {
	var $obTree = false;
	var mainData = null; /*Get Main Address Book Data on Edit */
	var intContactData = null; /*Get Internal Contact Data on Edit */
	var intGroupData = null; /*Get Internal Contact Group Data on Edit */
	var $DomainPassIsEncrypted = false;
	var $TempDomainPassword;
    var $contactTree, $contactTreeMobile;
	var contactTreeCall = false;
	var submitTriggered = false;
	
	var firstInternalAddrBook = true;
	var validation = function () {
		$('#formSubmit').validate({
			ignoreTitle: true,
			rules: {
				AddrBookName: {
					required: true,
					noSpace: true
				},
				ServerAddress: {
					required: true,
					noSpace: true
				},
				ConnectionString: {
					required: true,
					noSpace: true
				},
				QueryExpression: {
					required: true,
					noSpace: true
				},
				LoginUserID: {
					required: true,
					noSpace: true
				},
				LoginPassword: {
					required: true,
					noSpace: true
				},
				ClientId: {
					required: true,
					noSpace: true
				},
				TenantId: {
					required: true,
					noSpace: true
				}
			},
			errorPlacement: function (error, element) {
				var p = element.parent('span').parent();
				if (p.hasClass('form-control')) {
					error.appendTo(p);
				} else {
					error.insertAfter(element);
				}
			},
			submitHandler: function (form) {
				var formAction = $('.View2 #form-action').val();
				switch (formAction) {

					case 'test':
						$.addrbookForm.testConnection();
						break;
					case 'readdata':
						$.addrbookForm.readData();
						break;
					default:
						$.addrbookForm.save();
						break;
				}
			}
		});
		$('#form-submit-contact').validate({
			ignore: ".ignored",
			ignoreTitle: true,
			rules: {
				DisplayName: { required: true, noSpace: true },
				/*List of Address Book */
				"ContactModel.ContactAddrBookList.Value": { required: true, noSpace: true },
				/*List of Prefferd Address Type */
				"ContactModel.ContactPreferAddrTypeList.Value": { required: true, noSpace: true },
				Email: {
					email: true,
					required: {
						depends: function (element) {
							return parseInt($("#PreferAddressTypeID").val()) === 1;
						}
					},
					noSpace: true
				},
				FaxNumber: {
					required: {
						depends: function (element) {
							return parseInt($("#PreferAddressTypeID").val()) === 2;
						}
					},
					noSpace: true
				},
				RawFax: {
					required: {
						depends: function (element) {
							return parseInt($("#PreferAddressTypeID").val()) === 9;
						}
					},
					noSpace: true
				},
				PhoneNumber: {
					required: {
						depends: function (element) {
							return parseInt($("#PreferAddressTypeID").val()) === 10;
						}
					},
					noSpace: true
				},
				MobileNumber: {
					required: {
						depends: function (element) {
							return parseInt($("#PreferAddressTypeID").val()) === 7;
						}
					},
					noSpace: true
				},
				/*List of Printer */
				"ContactModel.NetworkPrinterList.Value": {
					required: {
						depends: function (element) {
							return parseInt($("#PreferAddressTypeID").val()) === 6;
						}
					}
				},
				"UrlFTP": {
					checkRequired: "DomainFTP",
					required: {
						depends: function (element) {
							return parseInt($("#PreferAddressTypeID").val()) === 4;
						}
					},
					noSpace: true
				},
				"DomainFTP": {
					checkRequired: "PasswordFTP",
					noSpace: true
				},
				"PasswordFTP": {
					checkRequired: "DomainFTP"
				},
				

				"UrlHTTP": {
					checkRequired: "DomainHTTP",
					required: {
						depends: function (element) {
							return parseInt($("#PreferAddressTypeID").val()) === 3;
						}
					},
					noSpace: true
				},
				"DomainHTTP": {
					checkRequired: "PasswordHTTP",
					noSpace: true
				},
				"PasswordHTTP": { checkRequired: "DomainHTTP" },

				"FolderFile": {
					checkOptionalRequired: ["ServerFile", "DomainFile"],
					required: {
						depends: function (element) {
							return parseInt($("#PreferAddressTypeID").val()) === 5;
						}
					},
					noSpace: true
				},
				"DomainFile": {
					checkRequired: "PasswordFile",
					noSpace: true
				},
				"PasswordFile": { checkRequired: "DomainFile" }
			},
			submitHandler: function (form) {
				submitTriggered = true; 
				$.intAddrBookContactForm.save();
			}
		});
		$('#form-submit-contactgrp').validate({
			ignore: ".ignored",
			ignoreTitle: true,
			rules: {
				GroupName: { required: true, noSpace: true },
				"TotalGrid-Generic_grid": { required: true, min: 1 }
			},
			messages: {
				"TotalGrid-Generic_grid": {
					required: $globalMessages.validation.gridMinLength,
					min: $globalMessages.validation.gridMinLength
				}
			},
			submitHandler: function (form) {
				/* 0 == add , 1 == edit */
				$.intAddrBookGroupForm.save();
			}
		});
		$('#form-user-contactListGeneral').validate({
			ignoreTitle: true,
			rules: {
				recipient_name: { required: true, noSpace: true },
				recipient_address: { required: true, noSpace: true },
				recipient_email: { email: true, noSpace: true },
				recipient_addressemail: { required: true, email: true, noSpace: true },
				recipient_faxNumber: { required: true, noSpace: true },
				recipient_path: { required: true, noSpace: true },
				recipient_mobilenumber: { required: true, noSpace: true },
				recipient_phonenumber: { required: true, noSpace: true }
			},
			
			submitHandler: function (form) {
				$.intAddrBookGroupModal.saveGenericContact();
			}
		});
		$('#form-user-contactListAddressBook').validate({
			ignoreTitle: true,
			rules: {
			},
			submitHandler: function (form) {
				var items = $.intAddrBookGroupModal.getGridSelections($('#gridAddressBook'));

				if (items.length > 0) {
					$.intAddrBookGroupModal.saveAddBookContact(items);
				}
				else
					swal("", $addrBookResource.swal.noContactAdded);
			}
		});
	};
	$.addrbook = {
		init: function () {
			$.addrbook.initGrid();
			$.addrbook.initMoveDomainTreeView();
			$.addrbook.createButtonClickHandler($('.View1 .btn-new-mainGrid'));
			$.addrbook.deleteButtonClickHandler($('.View1 .btn-delete-mainGrid'));
			$.addrbook.refreshButtonClickHandler($('.View1 .btn-refresh-mainGrid'));
			$.addrbook.searchHandler($('.View1 #searchBox-mainGrid'));
			$.addrbook.searchButtonClickHandler($('.View1 #btn-search-mainGrid'));

			$.addrbookForm.init();
		},
		initGrid: function () {
			/* Kendo grid initialization */

			var id = $('#mainGrid');

			var hideVisibility = false;

			var dataSource = {
				transport: {
					read: {
						url: '/Admin/AddressBooks/ReadAddr',
						dataType: "json",
						type: "GET"
					},
					parameterMap: function (options) {

						var result = {
							Filter: $('.View1 #searchBox-mainGrid').val(),
							Skip: options.skip,
							Take: options.take,
							Page: options.page
						};

						if (options.sort && options.sort.length > 0) {
							result.SortBy = options.sort[0].field;
							result.Direction = options.sort[0].dir;
						}

						return result;
					}
				},
				schema: {
					data: "Records",
					total: "Total",
					model: {
						id: "Id"
					}
				},
				serverPaging: true,
				serverSorting: true
			};

			var col = [
				{
					selectable: true, width: "45px",
					attributes: {
						"class": "checkboxSelection"
					}
				},
				{ field: 'Id', hidden: true },
				{ field: 'IsAddrBookExt', hidden: true },
				{ field: 'AddrBookName', title: $addrBookResource.field.addressBookName, width: 200, sortable: true },
				{ field: 'AddrBookDesc', title: $addrBookResource.field.description, width: 200, sortable: true },
				{
					field: "VisibilityLabel",
					title: $addrBookResource.field.visibility,
					width: 150,
					template: function (dataRow) {
						var icon = '<i class="mdi mdi-check"></i>';
						var statusClass = dataRow.VisibilityID + "";

						var result = '<div status="kendo-container">' +
							'<span class="badge kendo-span-status badge-pill badge-visibility' + statusClass.toLowerCase() + '">' + dataRow.VisibilityLabel + '</span> ' +
							'</div>';
						return result;
					},
					hidden: hideVisibility
				},
				{ field: 'VisibilityID', hidden: true },
				{ field: 'IsAddrBookExt', hidden: true },
				{ field: 'AddrBookConnTypeID', hidden: true },
				{ field: 'AddrBookConnTypeLabel', title: $addrBookResource.field.connectionType, width: 200, sortable: true }
			];

			var obj = {};
			obj.allowSelectMultipleRow = true;
			obj.customizeCheckbox = true;
			obj.onSelectionFn = $.addrbook.editButtonClickHandler;

			$grid = kendogridcustomization.init(id, dataSource, col, obj);
		},
		initMoveDomainTreeView: function () {
			/*debugger*/

			var objDomainSelection = {};
			objDomainSelection.expandAll = true;
			objDomainSelection.declareType = 'textbox';
			objDomainSelection.postSelectFn = $.addrbook.moveToDomainClickHandler;

			treeview.init("moveDomain", "moveDomain-name", "moveDomain-id", objDomainSelection);
		},

		/*Button Handler*/
		createButtonClickHandler: function (e) {
			$(e).on('click', function () {
				/*debugger*/
				$(".breadcrumb .add-edit-breadcrumb-item").text($addrBookResource.createNewEntry);

				$.sectionproperties.Disabled("AddressBookType", false);
				$.sectionproperties.Hidden("AddressDetail", true);
				$.sectionproperties.SecondLevel($(e));

				mainData = null;
				$.addrbookForm.resetFields();
			});
		},
		deleteButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$(this).blur();
				var ids = $.addrbook.getGridSelections($('#mainGrid'));
				if (ids.length > 0) {
					if (ids.length > 0) {
						swal({
							title: "",
							text: $addrBookResource.swal.delAddrBook,
							type: "info",
							showCancelButton: true,
							closeOnConfirm: false,
							reverseButtons: true,
							showLoaderOnConfirm: true
						}, function () {
							$.addrbook.delete(ids);
						});
					}
				}
				else {
					swal("", $addrBookResource.swal.noAddrBook);
				}
			});
		},
        editButtonClickHandler: function (e) {
			/*debugger*/
            mainData = e;
			$.sectionproperties.SecondLevel($(e));
			$(".breadcrumb .add-edit-breadcrumb-item").text($addrBookResource.editEntry);
			$.sectionproperties.Hidden("AddressDetail", true);
			$.sectionproperties.Disabled("AddressBookType", true);

			$.addrbookForm.resetFields();
		},
		refreshButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$(this).blur();
				$.addrbook.refreshGrid();
			});
		},
		searchButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$.addrbook.initGrid();
			});
		},
		searchHandler: function (e) {
			$(e).keypress(function (event) {
				if (event.which === 13) {
					$.addrbook.initGrid();
				}
			});
		},
		moveToDomainClickHandler: function (e, f) {
			$.addrbook.moveToDomain(e, f);
		},

		/**/
		delete: function (ids) {
			/*debugger*/
			fxcRequest.post('/Admin/AddressBooks/DeleteAddrBooks',
				{
					Ids: ids
				},
				function (data) {
					$.addrbook.refreshGrid();
					$.addrbook.reinitDropdown();

					swal($globalMessages.swal.success.title, $globalMessages.swal.success.delete, "success");
				},
				function (error) {
					swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnDelete, "error");
				});
		},
		getGridSelections: function (grid) {
			var selectedId = [];
			var entityGrid = grid.data("kendoGrid");
			var rows = entityGrid.select();

			rows.each(function (index, row) {
				var selectedItem = entityGrid.dataItem(row);
				selectedId[index] = selectedItem.id;
			});

			return selectedId;
		},
		refreshGrid: function () {
			$('.View1 #searchBox-mainGrid').val("");
			$.addrbook.initGrid();
		},
		reinitDropdown: function () {

			fxcRequest.get('/Admin/AddressBooks/PopulateContactAddrBookList',
				{},
				function (data) {
					/*debugger*/
					$('#AddrBookID').empty();
					$('#GroupAddrBookID').empty();
					$('#MoveAction .menu-scrollbar').empty();

					$.sectionproperties.selectGenerator('AddrBookID', data.ContactAddrBookList.Source, "", 0);
					$.sectionproperties.selectGenerator('GroupAddrBookID', data.ContactAddrBookList.Source, "", 0);
					$.sectionproperties.moveActionGenerator('MoveAction', data.ContactAddrBookList.Source, "", 0);
				},
				function (error) {
					swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnRefresh, "error");
				});
		},
		moveToDomain: function (e, f) {
			/*debugger*/
			var ids = $.addrbook.getGridSelections($('#mainGrid'));
			var domainName = f.text;
			var domainId = e;

			setTimeout(function () {
				$("#moveDomain-ddl").val("");
				$('#moveDomain').tree().unselectAll();
			}, 100);

			if (ids.length > 0) {
				fxcRequest.post('/Admin/AddressBooks/MoveToDomain',
					{
						"Ids": ids,
						"DomainId": domainId
					},
					function (data) {
						$.addrbook.refreshGrid();
						var msg = $addrBookResource.swal.addrBookMove + " " + domainName + " " + $addrBookResource.swal.successfully;
						swal($globalMessages.swal.success.title, msg, "success");
					},
					function (error) {
						swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnMove, "error");
					});
			}
			else {
				swal("", $addrBookResource.swal.noAddrBook);
			}

		},
	};

	$.addrbookForm = {
		init: function () {
			validation();
			$.addrbookForm.initDomainTreeView();
			$.sectionproperties.FirstLevel($('.btn-back2'));
			$.addrbookForm.saveButtonClickHandler($('.View2 .btn-save2'));
			$.addrbookForm.testButtonClickHandler($('.View2 .btn-Test2'));
			$.addrbookForm.readDataButtonClickHandler($('.View2 .btn-ReadData2'));
			$.addrbookForm.resetButtonClickHandler($('.btn-Reset2'));

			$.addrbookForm.addressBookTypeChangeHandler($('.View2 #AddressBookType'));
			$.addrbookForm.moveButtonClickHandler($('#MoveAction'));
			$.addrbookForm.resetLoginPassword();
		},
		initDomainTreeView: function () {
			/*debugger*/
			$('#obTree-ddl').val($('#dashboardText').text());
			$('#obTree-id').val($('#dashboardID').val());

			var objDomainSelection = {};
			objDomainSelection.expandAll = true;
			objDomainSelection.declareType = 'textbox';

			$obTree = treeview.init("obTree", "obTree-name", "obTree-id", objDomainSelection);

		},

		/*Button Handler*/

		addressBookTypeChangeHandler: function (e) {
			$(e).on('change', function () {
				/*debugger*/
				var isAddrBookExt = $.addrbookForm.isExternal();

				if (isAddrBookExt) {
					$('.btn-Test2').show();
					$('.btn-ReadData2').show();
				}
				else {
					$('.btn-Test2').hide();
					$('.btn-ReadData2').hide();
				}
			});
		},
		filterMoveButtonHandler: function (e) {
			var col = $('#MoveAction a');

			$.each(col, function (i, l) {
				if (e === l.id) {
					$('#MoveAction a#' + e + '').addClass('hide');
				}
				else {
					$('#MoveAction a#' + l.id + '').removeClass('hide');
				}
			});

			if ($('#MoveAction a:not(.hide)').length > 0) {
				$('#btn-MoveAction').attr('disabled', false);
			}
			else {
				$('#btn-MoveAction').attr('disabled', true);
			}
		},
		moveButtonClickHandler: function (e) {
			$(e).children().on('click', function (e) {
				/*debugger*/
				var ids = $.addrbook.getGridSelections($('#internalAddrBook'));
				if (ids.length > 0) {
					$.addrbookForm.moveContact(ids, e.target.id);
				}
				else {
					swal("", $addrBookResource.swal.noRecord);
				}
			});
		},
		readDataButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$(".View2 #form-action").val("readdata");
				$("#formSubmit").submit();

			});
		},
		resetButtonClickHandler: function (e) {
			$(e).on('click', function () {
				/*debugger*/
				$.addrbookForm.resetFields();
			});
		},
		saveButtonClickHandler: function (e) {
			$(e).on('click', function () {
				/*debugger*/
				$(".View2 #form-action").val("save");
				$("#formSubmit").submit();
			});
		},
		testButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$(".View2 #form-action").val("test");
				$("#formSubmit").submit();
			});
		},


		/*Logic*/
		isExternal: function () {
			return $('.View2 #AddressBookType').val() === '0' ? false : true;
		},
		moveContact: function (ids, AddrBookId) {
			fxcRequest.post('/Admin/AddressBooks/MoveToContact',
				{
					"Ids": ids,
					"AddrBookID": AddrBookId
				},
				function (data) {
					$.intAddrBook.initGrid();
					swal($globalMessages.swal.success.title, $addrBookResource.swal.successMove, "success");

				},
				function (error) {
					swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnMove, "error");
				});
		},
		readData: function () {
			var isExternal = $.addrbookForm.isExternal();

			fxcRequest.post('/Admin/AddressBooks/ReadData',
				{
					Id: $('#RecordId').val(),
					DomainID: $('#obTree-id').val(),
					AddrBookName: $('#AddrBookName').val(),
					Desc: $('#Desc').val(),
					VisibilityID: $('#Visibility').val(),
					IsAddrBookExt: isExternal,
					ConnectionType: $('#ConnectionType').val(),
					ConnectionString: $('#ConnectionString').val(),
					QueryExpression: $('#QueryExpression').val(),
					ServerAddress: $('#ServerAddress').val(),
					LoginDomain: $('#LoginDomain').val(),
					LoginUserID: $('#LoginUserID').val(),
					LoginPassword: $('#LoginPassword').val(),
					LoginPasswordIsEncrypted: $DomainPassIsEncrypted,
					PublicAddressBook: $('#PublicAddressBook').val(),
                    FormBasedAuthExch2003: $('#FormBasedAuthExch2003').prop('checked'),
                    ClientID: $('#ClientId').val(),
                    TenantID: $('#TenantId').val(),
					Action: 11 /* Read Data */
				},
				function (data) {
					if (data.JsonArryExternalSource !== null) {
						/*Pass data to ReadExternal Modal Page */
						$.readExternal.initGrid(data);
						$('#read-ext-modal').modal('show');
					}
					swal.close();
				},
				function (error) {
					swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorDBConnection, "error");
				});
		},
		resetFields: function () {
			mainData = mainData || null;
			$DomainPassIsEncrypted = false;
			$('#formSubmit').trigger("reset");
			$('#formSubmit').validate().resetForm();
			var DomainId = $('#dashboardID').val();
			
			if (mainData !== null) {
				$('input[name="RecordId"]').val(mainData.Id);
				$('#UID').val(mainData.uid);
				$('#AddrBookName').val(mainData.AddrBookName);
				$('#Desc').val(mainData.AddrBookDesc);
				$('#Visibility').val(mainData.VisibilityID).change();
				$('#ConnectionType').val(mainData.AddrBookConnTypeID);
				DomainId = mainData.DomainId;

				var isAddrBookExt = $.parseJSON(mainData.IsAddrBookExt.toLowerCase());
				$("#AddressBookType").val(isAddrBookExt ? 1 : 0);
				if (isAddrBookExt) {
					$.addrbookForm.populateExtAddressbook();
					
				} else {
					$.sectionproperties.Hidden("AddressDetail", false);
					$.addrbookForm.populateIntAddressbook();
				}
			}
			$.addrbookForm.filterMoveButtonHandler($('input[name="RecordId"]').val());
			treeview.selectNode($obTree, DomainId);

			$("#AddressBookType").change();
			$('#ConnectionType').change();
		},
		resetLoginPassword: function (e) {
			$("#LoginPassword").focus(function () {
				if ($DomainPassIsEncrypted) {
					$TempDomainPassword = $("#LoginPassword").val();
					$("#LoginPassword").val("");
				}
			});
			$("#LoginPassword").keyup(function () {
				$DomainPassIsEncrypted = false;
			});
			$("#LoginPassword").focusout(function () {
				if ($DomainPassIsEncrypted) {
					$("#LoginPassword").val($TempDomainPassword);
				}
			});
		},
		save: function () {
			var isExternal = $.addrbookForm.isExternal();

			var arry = {};
			arry = {
				Id: $('#RecordId').val(),
				DomainID: $('#obTree-id').val(),
				AddrBookName: $('#AddrBookName').val(),
				Desc: $('#Desc').val(),
				VisibilityID: $('#Visibility').val(),
				IsAddrBookExt: isExternal,
				ConnectionType: $('#ConnectionType').val(),
				ConnectionString: $('#ConnectionString').val(),
				QueryExpression: $('#QueryExpression').val(),
                ServerAddress: $('#ServerAddress').val(),
				LoginDomain: $('#LoginDomain').val(),
				LoginUserID: $('#LoginUserID').val(),
				LoginPassword: $('#LoginPassword').val(),
				LoginPasswordIsEncrypted: $DomainPassIsEncrypted,
				PublicAddressBook: $('#PublicAddressBook').val(),
                FormBasedAuthExch2003: $('#FormBasedAuthExch2003').prop('checked'),
                ClientId: $('#ClientId').val(),
                TenantId: $('#TenantId').val()
            };

			/*debugger*/
			fxcRequest.post('/Admin/AddressBooks/SaveAddrBooks',
				arry,
				function (data) {
					$.addrbook.initGrid();
					$.addrbook.reinitDropdown();
					$.sectionproperties.FirstLevelView();
					swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");
				},
				function (error) {
					swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSave, "error");
				});
		},
		testConnection: function () {
			var isExternal = $.addrbookForm.isExternal();
			fxcRequest.post('/Admin/AddressBooks/TestConnection',
				{
					Id: $('#RecordId').val(),
					DomainID: $('#obTree-id').val(),
					AddrBookName: $('#AddrBookName').val(),
					Desc: $('#Desc').val(),
					VisibilityID: $('#Visibility').val(),
					IsAddrBookExt: isExternal,
					ConnectionType: $('#ConnectionType').val(),
					ConnectionString: $('#ConnectionString').val(),
					QueryExpression: $('#QueryExpression').val(),
					ServerAddress: $('#ServerAddress').val(),
					LoginDomain: $('#LoginDomain').val(),
					LoginUserID: $('#LoginUserID').val(),
					LoginPassword: $('#LoginPassword').val(),
					LoginPasswordIsEncrypted: $DomainPassIsEncrypted,
					PublicAddressBook: $('#PublicAddressBook').val(),
                    FormBasedAuthExch2003: $('#FormBasedAuthExch2003').prop('checked'),
                    ClientId: $('#ClientId').val(),
                    TenantId: $('#TenantId').val(),
					Action: 12 /* Test Data */
				},
				function (data) {
					if (data.result === true)
						swal($globalMessages.swal.success.title, $addrBookResource.swal.successExtSource, "success");
					else
						swal($globalMessages.swal.error.errorCap, data.ErrMsg, "error");
				},
				function (error) {
					swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorDBConnection, "error");
				});
		},
		populateExtAddressbook: function () {
			fxcRequest.get('/Admin/AddressBooks/PopulateAddrBooks',
				{
					Id: $('#RecordId').val()
				},
				function (data) {
                    if (data !== null) {
						$DomainPassIsEncrypted = data.LoginPasswordIsEncrypted;
						$('#ConnectionString').val(data.AddrBookConnString);
						$('#QueryExpression').val(data.QueryExpr);
						$('#FormBasedAuthExch2003').bootstrapSwitch('state', data.FormBasedAuthentication);
						$('#LoginPasswordIsEncrypted').val($DomainPassIsEncrypted);
						$('#LoginDomain').val(data.LogDomain);
						$('#LoginUserID').val(data.LogUserID);
						$('#LoginPassword').val(data.LogPassword);

						$('#PublicAddressBook').val(data.PublicAddrBook);
                        $('#ServerAddress').val(data.ServerName);
                        $('#ClientId').val(data.ClientID);
                        $('#TenantId').val(data.TenantID);
					}
				},
				function (error) {
					swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorDBConnection, "error");
				});
		},
		populateIntAddressbook: function () {
			/* Kendo grid initialization */
			if (firstInternalAddrBook) {
				$.intAddrBook.init();
				$.intAddrBookContactForm.init();
				$.intAddrBookGroupForm.init();
				$.intAddrBookGroupModal.init();
				$.intAddrBookImport.init();
				firstInternalAddrBook = false;
			}
			
			$.intAddrBook.refreshGrid();
		}
	};

	$.readExternal = {
		initGrid: function (e) {
			/*debugger*/
			var data = JSON.parse(e.JsonArryExternalSource);
			var Total = data.length;
			var id = $('#gridReadExt');
			var extraParam = "1";
			var dataSource = {
				data: data,
				schema: {
					model: {
						xIsRRSOn: "boolean",
						xIsRRFOn: "boolean"
					}
				},
				serverPaging: false,
				serverSorting: false
			};

			var col = [

				{ field: 'xDisplayName', title: $addrBookResource.field.displayName, width: 200, sortable: true },
				{ field: 'xCompanyName', title: $addrBookResource.field.companyName, width: 200, sortable: true },
				{ field: 'xAddress', title: $addrBookResource.field.address, width: 250, sortable: true },
				{ field: 'xAddressTypeLabel', title: $addrBookResource.field.addressType, width: 150, sortable: true },
				{ field: 'xNotifyAddress', title: $addrBookResource.field.notifyAddress, width: 300, sortable: true },
				{
					field: "xIsRRSOn",
					title: $addrBookResource.field.ns,
					sortable: false,
					width: 72,
					template: '<div class="kendo-container"> <i #= xIsRRSOn == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
				},
				{
					field: "xIsRRFOn",
					title: $addrBookResource.field.ne,
					sortable: true,
					width: 72,
					template: '<div class="kendo-container minWidth80"> <i #= xIsRRFOn == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
				}
			];

			var obj = {};
			obj.customizeCheckbox = true;

			kendogridcustomization.init(id, dataSource, col, obj);

		},
	};

	$.intAddrBook = {
		init: function () {
			$.intAddrBook.createContactButtonClickHandler($('.View2 #btnAddContact'));
			$.intAddrBook.createGroupButtonClickHandler($('.View2 #btnAddGroup'));
			$.intAddrBook.deleteButtonClickHandler($('.View2 #action-delete'));
			$.intAddrBook.importButtonClickHandler($('.View2 #action-import'));
			$.intAddrBook.refreshButtonClickHandler($('.View2 #action-refresh-grid'));
			$.intAddrBook.searchButtonClickHandler($('.View2 #searchButton-internalAddrBook'));
			$.intAddrBook.searchHandler($('.View2 #searchBox-internalAddrBook'));

		},
        initGrid: function (e) {
			var id = $('#internalAddrBook');

			var dataSource = {
				transport: {
					read: {
						url: '/Admin/AddressBooks/ReadAddrContact',
						dataType: "json",
						type: "GET"
					},
					parameterMap: function (options) {

						var result = {
							Filter: $('.View2 #searchBox-internalAddrBook').val(),
							Id: $('#RecordId').val(),
							Skip: options.skip,
							Take: options.take,
							Page: options.page
						};

						if (options.sort && options.sort.length > 0) {
							result.SortBy = options.sort[0].field;
							result.Direction = options.sort[0].dir;
						}

						return result;
					}
				},
				schema: {
					data: "Records",
					total: "Total",
					model: {
						id: "ContactID"
					}
				},
				serverPaging: true,
				serverSorting: true
			};

			var col = [
				{
					selectable: true, width: "45px",
					attributes: {
						"class": "checkboxSelection"
					}
				},
				{ field: 'RowNum', hidden: true },
				{ field: 'ContactID', hidden: true },
				{ field: 'ContactTypeID', hidden: true },
				{ field: 'DisplayName', title: $addrBookResource.field.displayName, width: 200, sortable: true },
				{ field: 'ContactType', title: $addrBookResource.field.contactType, width: 200, sortable: true },
				{ field: 'LastName', title: $addrBookResource.field.lastName, width: 200, sortable: true },
				{ field: 'FirstName', title: $addrBookResource.field.firstName, width: 200, sortable: true },
				{ field: 'CompanyName', title: $addrBookResource.field.companyName, width: 200, sortable: true },
				{ field: 'PreferAddress', title: $addrBookResource.field.preferDeliveryAdd, width: 500, sortable: true }
			];

			var obj = {};
			obj.allowSelectMultipleRow = true;
			obj.customizeCheckbox = true;
			obj.onSelectionFn = $.intAddrBook.editButtonClickHandler;

			kendogridcustomization.init(id, dataSource, col, obj);

        },

		/*Button Click Handler*/
		createContactButtonClickHandler: function (e) {
			$(e).on('click', function (e) {
				/*debugger*/
				$.sectionproperties.ThirdLevel($(e));
				$('.contact-bc').text($addrBookResource.createContactProfile);
				$('.btn-savenew3').hide();
				intContactData = null;
				$.intAddrBookContactForm.resetFields();
			});
		},
		createGroupButtonClickHandler: function (e) {
			$(e).on('click', function (e) {
				$.sectionproperties.FourthLevel($(e));
				$('.contact-bc').text($addrBookResource.createContactGroupProfile);
				$('.btn-savenew4').hide();
				intGroupData = null;
				$.intAddrBookGroupForm.resetFields();
			});
		},
		deleteButtonClickHandler: function (e) {
			$(e).on('click', function () {
				var ids = $.addrbook.getGridSelections($('#internalAddrBook'));
				$(this).blur();
				if (ids.length > 0) {
					swal({
						title: "",
						text: $addrBookResource.swal.delContent,
						type: "info",
						showCancelButton: true,
						closeOnConfirm: false,
						reverseButtons: true,
						showLoaderOnConfirm: true
					}, function () {
						$.intAddrBook.delete(ids);
					});
				}
				else {
					swal("", $addrBookResource.swal.noRecord);
				}
			});
		},
		editButtonClickHandler: function (e) {
			/*debugger*/
			/* 1 == Contact, 2 == Contact Group */
			if (e.ContactTypeID === '1') {
				$.sectionproperties.ThirdLevel($(e));
				$('.btn-savenew3').show();
				$('.contact-bc').text($addrBookResource.editContactProfile);

				$.intAddrBookContactForm.populatecontact(e.ContactID);
			}
			else {
				intGroupData = e;
				$.sectionproperties.FourthLevel($(e));
				$('.contactgroup-bc').text($addrBookResource.editContactGroupProfile);
				$.intAddrBookGroupForm.resetFields();
			}
		},
		importButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$(this).blur();
				/*Refer to address book*/
				$('#SelectedAddressBook').val($('#RecordId').val());
				$('#SelectedAddressBookType').val("adminaddressbook");
				$.importcontact.resetAddressBook();
				
				$.sectionproperties.FifthLevel();
			});
		},
		refreshButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$(this).blur();
				$.intAddrBook.refreshGrid();
			});
		},
		searchButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$.intAddrBook.initGrid();
			});
		},
		
		searchHandler: function (e) {
			$(e).keypress(function (event) {
				if (event.which === 13) {
					$.intAddrBook.initGrid();
				}
			});
		},

		/*Delete*/
		delete: function (ids) {
			fxcRequest.post('/Admin/AddressBooks/DeleteContact',
				{
					Ids: ids
				},
				function (data) {
					$.intAddrBook.refreshGrid();
					swal($globalMessages.swal.success.title, $globalMessages.swal.success.delete, "success");
				},
				function (error) {
					swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnDelete, "error");
				});
		},
		refreshGrid: function () {
			$('.View2 #searchBox-internalAddrBook').val("");
			$.intAddrBook.initGrid();
		}
	};

	var $FtpPasswordIsEncrypted = false;
	var $TempFTPPassword;

	var $HttpPasswordIsEncrypted = false;
	var $TempHTTPPassword;

	var $FilePasswordIsEncrypted = false;
	var $TempFilePassword;

	$.intAddrBookContactForm = {
		init: function () {
			$.intAddrBookContactForm.backButtonClickHandler($('.View3 .btn-back3'));
			$.intAddrBookContactForm.saveButtonClickHandler($('.View3 .btn-save3'));
			$.intAddrBookContactForm.saveNewButtonClickHandler($('.View3 .btn-savenew3'));
			$.intAddrBookContactForm.resetButtonClickHandler($('.View3 .btn-Reset3'));

			/*Reset Password*/
			$.intAddrBookContactForm.resetFilePassword();
			$.intAddrBookContactForm.resetFTPPassword();
			$.intAddrBookContactForm.resetHTTPPassword();

			$.intAddrBookContactForm.addrTypeOnChangeHandler($('.View3 #PreferAddressTypeID'));
		},

		/*Button Click Handler*/
		backButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$.sectionproperties.SecondLevel($(e));
			});
		},
		resetButtonClickHandler: function (e) {
			$(e).on('click', function () {
				/*debugger*/
				$.intAddrBookContactForm.resetFields();
			});
		},
		saveButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$.intAddrBookContactForm.submitForm();
			});
		},
		saveNewButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$("#ContactID").val("");
				$('#contact-Action').val("0");
				$.intAddrBookContactForm.submitForm();
			});
		},
		addrTypeOnChangeHandler: function (elem) {
			$(elem).on('change', function (e) {
				var getElemValue = parseInt($(this).val());
				
				if ($("#form-submit-contact").validate().toShow.length > 0 || submitTriggered)
				{
					$('#Email').valid();
					$("#FaxNumber").valid();
					$('#RawFax').valid();
					$("#PhoneNumber").valid();
					$("#MobileNumber").valid();
					$('#NetworkPrinterID').valid();
					$("#UrlFTP").valid();
					$('#UrlHTTP').valid();
					$("#FolderFile").valid();
				}

				if (!$("#collapseContact").is(':visible') && (getElemValue === 3 || getElemValue === 4 || getElemValue === 5)) {
					$("#collapseContact").attr("data-scrollTo", "false");
					$('#collapseContact').collapse('show');
				}
			});
		},

		/*Logic*/
        submitForm: function () {
			submitTriggered = true;
        /*Handle error form*/
			var getItems = $("#form-submit-contact").validate().toShow;
			for (var i = 0; i < getItems.length; i++) {
				if ($(getItems[i]).closest("#collapseContact").length > 0 && !$("#collapseContact").is(':visible'))
				{
					$('#collapseContact').collapse('show');
					$('#collapseContact').attr("data-scrollTo", $(getItems[0]).offset().top);
					break;
				}
			}
			$("#form-submit-contact").submit();
		},
		resetFields: function () {
			submitTriggered = false;
			intContactData = intContactData || null;

			$FtpPasswordIsEncrypted = false;
			$HttpPasswordIsEncrypted = false;
			$FilePasswordIsEncrypted = false;

			$('#form-submit-contact').trigger("reset");
			$('#form-submit-contact').validate().resetForm();

			if ($("#collapseContact").is(':visible')) {
				$('#collapseContact').collapse('hide');
            }

            $('#AddrBookID').val($('#RecordId').val());

			if (intContactData !== null) {
				$('#contact-Action').val("1");
				$('input[name="ContactID"]').val(intContactData.ContactID);
				$('#DisplayName').val(intContactData.DisplayName);
				$('#FirstName').val(intContactData.FirstName);
				$('#MiddleName').val(intContactData.MiddleName);
				$('#LastName').val(intContactData.LastName);
				$('#CompanyName').val(intContactData.CompName);
				$('#Description').val(intContactData.Desc);
				$('#AddrBookID').val(intContactData.AddrBookID);
				$('#PreferAddressTypeID').val(intContactData.PreferAddressTypeID)
				$('#VisibilityID').val(intContactData.VisibilityID);
				$('#IsRRFOn').prop('checked', intContactData.IsRRFOn);
				$('#IsRRSOn').prop('checked', intContactData.IsRRSOn);
				$('#Email').val(intContactData.Email);

				var emailType = $.parseJSON(isPDFFileType.toLowerCase());
				if (intContactData.EmailFormat === "PDF") {
					emailType = true;
				}
				else if (intContactData.EmailFormat === "TIF") {
					emailType = false;
				}

				$('#EmailType').bootstrapSwitch('state', emailType);

				$('#FaxNumber').val(intContactData.FaxNumber);
				$('#PhoneNumber').val(intContactData.PhoneNumber);
				$('#MobileNumber').val(intContactData.MobileNumber);
				$('#UrlFTP').val(intContactData.FtpAddress);
				$('#DomainFTP').val(intContactData.FtpAuthUsr);
				$('#PasswordFTP').val(intContactData.FtpAuthPwd);
				$FtpPasswordIsEncrypted = intContactData.FtpAuthPwdEncrypted;

				var ftyType = $.parseJSON(isPDFFileType.toLowerCase());
				if (intContactData.FtpFileFormat === "PDF") {
					ftyType = true;
				}
				else if (intContactData.FtpFileFormat === "TIF") {
					ftyType = false;
				}

				$('#FTPType').bootstrapSwitch('state', ftyType);

				$('#UrlHTTP').val(intContactData.HttpAddress);
				$('#DomainHTTP').val(intContactData.HttpAuthUsr);
				$('#PasswordHTTP').val(intContactData.HttpAuthPwd);
				$HttpPasswordIsEncrypted = intContactData.HttpAuthPwdIsEncrypted;

				var httpType = $.parseJSON(isPDFFileType.toLowerCase());
				if (intContactData.HttpFileFormat === "PDF") {
					httpType = true;
				}
				else if (intContactData.HttpFileFormat === "TIF") {
					httpType = false;
				}
				$('#HTTPType').bootstrapSwitch('state', httpType);

				var printer;
				if (intContactData.Printer === null)
					printer = 0;
				else
					printer = intContactData.Printer;

				$('#NetworkPrinterID').val(printer);
				$('#RawFax').val(intContactData.RawFax);
				$('#ServerFile').val(intContactData.FileServer);
				$('#FolderFile').val(intContactData.FilePath);
				$('#DomainFile').val(intContactData.FileLoginName);
				$('#PasswordFile').val(intContactData.FilePassword);
				$FilePasswordIsEncrypted = intContactData.FilePasswordIsEncrypted;

				var fileType = $.parseJSON(isPDFFileType.toLowerCase());
				if (intContactData.FileFormat === "PDF") {
					fileType = true;
				}
				else if (intContactData.FileFormat === "TIF") {
					fileType = false;
				}

				$('#FileType').bootstrapSwitch('state', fileType);

				$('#CSID').val(intContactData.CSID);
			}

			if ($('#PreferAddressTypeID').val() == null )
			{
				$('#PreferAddressTypeID').get(0).selectedIndex = 0;
			}

			$('#PreferAddressTypeID').change();
		},
		resetFilePassword: function (e) {
			$("#PasswordFile").focus(function () {
				if ($FilePasswordIsEncrypted) {
					$TempFilePassword = $("#PasswordFile").val();
					$("#PasswordFile").val("");
				}
			});
			$("#PasswordFile").keyup(function () {
				$FilePasswordIsEncrypted = false;
			});
			$("#PasswordFile").focusout(function () {
				if ($FilePasswordIsEncrypted) {
					$("#PasswordFile").val($TempFilePassword);
				}
			});
		},
		resetFTPPassword: function (e) {
			$("#PasswordFTP").focus(function () {
				if ($FtpPasswordIsEncrypted) {
					$TempFTPPassword = $("#PasswordFTP").val();
					$("#PasswordFTP").val("");
				}
			});
			$("#PasswordFTP").keyup(function () {
				$FtpPasswordIsEncrypted = false;
			});
			$("#PasswordFTP").focusout(function () {
				if ($FtpPasswordIsEncrypted) {
					$("#PasswordFTP").val($TempFTPPassword);
				}
			});
		},
		resetHTTPPassword: function (e) {
			$("#PasswordHTTP").focus(function () {
				if ($HttpPasswordIsEncrypted) {
					$TempHTTPPassword = $("#PasswordHTTP").val();
					$("#PasswordHTTP").val("");
				}
			});
			$("#PasswordHTTP").keyup(function () {
				$HttpPasswordIsEncrypted = false;
			});
			$("#PasswordHTTP").focusout(function () {
				if ($HttpPasswordIsEncrypted) {
					$("#PasswordHTTP").val($TempHTTPPassword);
				}
			});
		},
		populatecontact: function (contactId) {
			/*debugger*/
			fxcRequest.get('/Admin/AddressBooks/PopulateContact',
				{
					Id: contactId
				},
				function (data) {
					/*debugger*/
					if (data !== null) {
						intContactData = data;
						intContactData.ContactID = contactId;
						$.intAddrBookContactForm.resetFields();
					}
				},
				function (error) {
					swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorDBConnection, "error");
				});
		},
        save: function () {
			var arry = {};

			var checkEmailType = "TIF";
			if ($('#EmailType').prop('checked')) {
				checkEmailType = "PDF";
			}
			var checkFTPType = "TIF";
			if ($('#FTPType').prop('checked')) {
				checkFTPType = "PDF";
			}
			var checkHTTPType = "TIF";
			if ($('#HTTPType').prop('checked')) {
				checkHTTPType = "PDF";
			}
			var checkFileType = "TIF";
			if ($('#FileType').prop('checked')) {
				checkFileType = "PDF";
			}
			arry = {
				Action: $('#contact-Action').val(),
				ContactID: $('#ContactID').val(),
				AddrBookID: $('#AddrBookID').val(),
				DisplayName: $('#DisplayName').val(),
				FirstName: $('#FirstName').val(),
				MiddleName: $('#MiddleName').val(),
				LastName: $('#LastName').val(),
				CompanyName: $('#CompanyName').val(),
				Description: $('#Description').val(),
				VisibilityID: $('#VisibilityID').val(),
				PreferAddressTypeID: $('#PreferAddressTypeID').val(),
				Desc: $('#Description').val(),
				IsRRFOn: $('#IsRRFOn').prop('checked'),
				IsRRSOn: $('#IsRRSOn').prop('checked'),
				Email: $('#Email').val(),
				EmailType: checkEmailType,
				FaxNumber: $('#FaxNumber').val(),
				CSID: $('#CSID').val(),
				PhoneNumber: $('#PhoneNumber').val(),
				NetworkPrinterID: $('#NetworkPrinterID').val(),
				RawFax: $('#RawFax').val(),
				MobileNumber: $('#MobileNumber').val(),
				UrlFTP: $('#UrlFTP').val(),
				FTPType: checkFTPType,
				DomainFTP: $('#DomainFTP').val(),
				FTPPasswordIsEncrypted: $FtpPasswordIsEncrypted,
				PasswordFTP: $('#PasswordFTP').val(),
				UrlHTTP: $('#UrlHTTP').val(),
				HTTPType: checkHTTPType,
				DomainHTTP: $('#DomainHTTP').val(),
				HTTPPasswordIsEncrypted: $HttpPasswordIsEncrypted,
				PasswordHTTP: $('#PasswordHTTP').val(),
				ServerFile: $('#ServerFile').val(),
				FolderFile: $('#FolderFile').val(),
				FileType: checkFileType,
				DomainFile: $('#DomainFile').val(),
				FilePasswordIsEncrypted: $FilePasswordIsEncrypted,
				PasswordFile: $('#PasswordFile').val()
			};
			var id = $('#RecordId').val() !== '' ? $('#RecordId').val() : 0;
			fxcRequest.post('/Admin/AddressBooks/SaveContact',
				arry,
				function (data) {
					$.intAddrBook.refreshGrid();
					$.sectionproperties.SecondLevel();
					swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");
				},
				function (error) {
					swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
				});
		}

	};

	var $GenericGrid;
	var totalGenericGrid = "#TotalGrid-Generic_grid";
	$.intAddrBookGroupForm = {
		init: function () {
			$.intAddrBookGroupForm.backButtonClickHandler($('.View4 .btn-back4'));
			$.intAddrBookGroupForm.createButtonClickHandler($('.View4 .btn-addContact'));
			$.intAddrBookGroupForm.deleteButtonClickHandler($('.View4 #action-delete-contactlist'));
			$.intAddrBookGroupForm.saveButtonClickHandler($('.View4 .btn-save4'));
			$.intAddrBookGroupForm.saveNewButtonClickHandler($('.View4 .btn-savenew4'));
			$.intAddrBookGroupForm.resetButtonClickHandler($('.View4 .btn-Reset4'));

			/*Reset Password*/

			$('#collapseContact').on('shown.bs.collapse', function (e) {
				var getItemPosition = null;
				if ($('#collapseContact').attr("data-scrollTo") != null )
				{
					getItemPosition = parseInt($('#collapseContact').attr("data-scrollTo"));
				}
				else if ($('#collapseContact').attr("data-scrollTo") === 'false') {
					return false;
				}
				else {
					getItemPosition = $(this).offset().top;
				}
				$(".fxc-main-content").scrollTop(getItemPosition);
				$('#collapseContact').removeAttr("data-scrollTo");
			});
		},
		initGrid: function () {
			var id = $('#Generic_grid');

			var dataSource = {
				transport: {
					read: {
						url: '/Admin/AddressBooks/ReadAddrContactGrp',
						dataType: "json",
						type: "GET"
					},
					parameterMap: function (options) {

						var result = {
							Id: $('input[name="GroupContactId"]').val(),
							Skip: options.skip,
							Take: options.take,
							Page: options.page
						};

						if (options.sort && options.sort.length > 0) {
							result.SortBy = options.sort[0].field;
							result.Direction = options.sort[0].dir;
						}

						return result;
					}
				},
				schema: {
					data: "Records",
					total: "Total",
					model: {
						id: "GroupListID",
						IsRRSOn: { type: 'bool' },
						IsRRFOn: { type: 'bool' }
					}
				},
				serverPaging: false,
				serverSorting: false
			};

			var col = [
				{
					selectable: true, width: "45px",
					attributes: {
						"class": "checkboxSelection"
					}
				},
				{ field: "ContactID", hidden: true },
				{ field: "AddressID", hidden: true },
				{ field: "AddressTypeID", hidden: true },
				{
					field: "IsRRSOn",
					title: $addrBookResource.field.ns,
					sortable: false,
					width: 52,
					template: '<div class="kendo-container"> <i #= IsRRSOn == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
				},
				{
					field: "IsRRFOn",
					title: $addrBookResource.field.ne,
					sortable: false,
					width: 52,
					template: '<div class="kendo-container"> <i #= IsRRFOn == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
				},
				{ field: "DisplayName", title: $addrBookResource.field.name, width: 150, filterable: true },
				{ field: "CompanyName", title: $addrBookResource.field.company, width: 150, filterable: true },
				{ field: "DisplayAddress", title: $addrBookResource.field.deliveryAddress, width: 300, filterable: true },
				{ field: "AddressTypeLabel", title: $addrBookResource.field.addressType, width: 150 },
				{ field: "NotifyAddr", title: $addrBookResource.field.notifyAddress, width: 200 },
				{
					attributes: {
						"class": "disabledClickableRow"
					},
					field: "Status",
					title: " ",
					width: 60,
					sortable: false,
					template: function (dataRow) {
						var result = '<div class="k-delete-row"><a class="imageSizeTopBarIcons nav-link color-red waves-effect remove" data-id="' + dataRow.ContactId + '" id="del-' + dataRow.AddressID + '-' + dataRow.AddressTypeID + '" href="javascript:void(0)"><i class="fa fa-trash-o"></i></a>';
						return result;
					}
				}
			];

			var obj = {};
			obj.totalInputType = totalGenericGrid;
			obj.allowSelectMultipleRow = true;

			$GenericGrid = kendogridcustomization.init(id, dataSource, col, obj);

			$.intAddrBookGroupForm.deleteByRow(id);
		},

		/*Button Click Handler*/
		backButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$.sectionproperties.SecondLevel($(e));
			});
		},
		createButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$("#add-contact-modal").modal("show");
				$.intAddrBookGroupModal.resetFields();
			});
		},
		deleteButtonClickHandler: function (e) {
			$(e).on('click', function () {
				/*debugger*/
				$(this).blur();
				var grid = $('#Generic_grid').data("kendoGrid");
				var selectedItem = grid.select();

				if (selectedItem.length > 0) {
					$.intAddrBookGroupForm.delete(selectedItem);
				}
				else {
					swal("", $addrBookResource.swal.noRecord);
				}
			});
		},
		resetButtonClickHandler: function (e) {
			$(e).on('click', function () {
				/*debugger*/
				$.intAddrBookGroupForm.resetFields();
			});
		},
		saveButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$("#form-submit-contactgrp").submit();
			});
		},
		saveNewButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$("#GroupContactId").val('');
				$("#GroupContact-Action").val(0);
				$("#form-submit-contactgrp").submit();
			});
		},


		/*Logic*/
		delete: function (selectedItem) {
			/*debugger*/
			var grid = $('#Generic_grid').data("kendoGrid");
			var ArrayList = new Array();

			for (i = 0; i < selectedItem.length; i++) {
				for (j = 0; j < grid.dataSource.data().length; j++) {
					var gridSource = grid.dataSource.at(j);
					if (gridSource.uid === selectedItem[i].dataset.uid) {
						grid.dataSource.remove(gridSource);
					}
				}
			}
			$.toast({
				text: $globalMessages.toast.updating,
				position: 'bottom-right',
				loaderBg: '#ff6849',
				icon: 'info',
				hideAfter: 2000,
				stack: 6
			});
		},
		deleteByRow: function (e) {
			$("#Generic_grid .k-grid-content").on("click", "a.remove", function (e) {

				var tr = $(e.target).closest("tr");
				var row = $("#Generic_grid").data("kendoGrid").dataItem(tr);
				if (row !== null && row !== undefined) {
					$('#Generic_grid').data("kendoGrid").dataSource.remove(row);

					$.toast({
						text: $globalMessages.toast.updating,
						position: 'bottom-right',
						loaderBg: '#ff6849',
						icon: 'info',
						hideAfter: 2000,
						stack: 6
					});

					kendogridcustomization.refreshTotalCount($GenericGrid, totalGenericGrid);
				}
			});
		},
		
		refreshGrid: function () {
			$.intAddrBookGroupForm.initGrid();
		},
		resetFields: function () {
			intGroupData = intGroupData || null;

			$('#form-submit-contactgrp').trigger("reset");
			$('#form-submit-contactgrp').validate().resetForm();

            $('#GroupAddrBookID').val($('#RecordId').val());

			if (intGroupData !== null) {
				$('#GroupContact-Action').val('1');

				$(".infoContactGroup").text(intGroupData.DisplayName);
				$('input[name="GroupContactId"]').val(intGroupData.ContactID);
				$('#GroupContactUID').val(intGroupData.uid);

				$('#GroupName').val(intGroupData.DisplayName).change();
				$("#GroupDescription").val(intGroupData.Desc).change();
				$("#GroupAddrBookID").val($('input[name="RecordId"]').val()).change();
				$("#GroupVisibilityID").val(intGroupData.VisibilityID).change();
				
			}
			$.intAddrBookGroupForm.refreshGrid();
		},
		populatecontact: function (contactId) {

		},
		save: function () {
			var groupContactID = $('input[name="GroupContactId"]').val() !== '' ? $('input[name="GroupContactId"]').val() : 0;

			var arry = {};
			var list = [];
			var source = $('#Generic_grid').data("kendoGrid").dataSource.data();

			$.each(source, function (i, v) {
				var contactArry = {};

				contactArry = {
					ContactID: v.ContactID,
					AddressID: v.AddressID,
					IsRRFOn: v.IsRRFOn,
					IsRRSOn: v.IsRRSOn
				};

				list[i] = contactArry;
			});

			arry = {
				Action: $('#GroupContact-Action').val(),
				GroupContactID: groupContactID,
				GroupName: $('#GroupName').val(),
				Desc: $('#GroupDescription').val(),
				AddrBookID: $('#GroupAddrBookID').val(),
				VisibilityID: $('#GroupVisibilityID').val(),

				ContactAddrList: list
			};
			fxcRequest.post('/Admin/AddressBooks/SaveContactGrp',
				arry,
				function (data) {
					$.sectionproperties.SecondLevel();
					$.intAddrBook.refreshGrid();
					swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");
				},
				function (error) {
					swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
				});
		}
	};

	var selectedFilter = 0;
	var addressTab = false;
	var requestObj;
	$.intAddrBookGroupModal = {
		init: function () {
			$.intAddrBookGroupModal.recipientDeliveryOnChangeHandler($('#RecipientDelivery'));
			$.intAddrBookGroupModal.initTab();
			$.intAddrBookGroupModal.searchButtonClickHandler($('#userAddressBookSearchButton'));
			$.intAddrBookGroupModal.searchHandler($('#userAddressBookSearch'));
		},
		initGrid: function (e, obj) {
			var contactcat = "";
			var searchText = $.trim($('#userAddressBookSearch').val());
			var addrBookID = "";

			var id = $("#gridAddressBook");
			if (obj != null) {
				requestObj = obj;
				contactcat = obj.category;
			}

			if (e != null) {
				addrBookID = e;
            }

            contactTreeCall = true;
            var getData = $contactTreeMobile.getNodeById(addrBookID);
            if (getData != undefined) {
                $contactTreeMobile.unselectAll();
                $contactTreeMobile.select(getData);
            }

			var columns = [];
			columns = [
				{ field: "checkboxSelection", selectable: true, width: 64, sortable: false },
				{ field: "id", title: $addrBookResource.field.id, hidden: true, width: 100 },
				{ field: "SelectableContact", title: $globalMessages.grid.contactName, width: 300, hidden: false },
				{ field: "EncryptStatus", title: $addrBookResource.field.encryptStatus, hidden: true }
			];

			var dataSource = {
				transport: {
					read: {
						url: "/Common/GetUser",
						dataType: "json",
						type: "GET"
					},
					parameterMap: function (options) {
						/* Fix url param for sort values */
						var sortBy = "";
						var direction = "";
						if (options.sort != null && options.sort.length > 0) {
							var s = options.sort[0];
							sortBy = s.field;
							direction = s.dir;
						}

						var result = {
							Type: "4",
							Category: Number(contactcat),
							AddrBookID: addrBookID,
							SearchText: searchText,
							Page: options.page,
							Limit: options.pageSize,
							SortBy: sortBy,
							Direction: direction,
							SelectedFilter: selectedFilter
						};
						return result;
					}
				},
				schema: {
					data: "UserAddrBookList",
					total: "Total"
				},
				serverPaging: true,
				serverSorting: true
			};

			var objA = {};
			objA.allowSelectMultipleRow = true;

			kendogridcustomization.init(id, dataSource, columns, objA);

            contactTreeCall = false;
		},
		initTab: function (e) {
			$('ul#MsgRecipient a[data-bs-toggle="tab"]').on('shown.bs.tab', function (h) {
				var target = $(h.target).attr("href");
				switch (target) {
					case "#addAddressBook":
						if (!addressTab) {
							var objContact = {};
							objContact.postSelectFn = $.intAddrBookGroupModal.initGrid;
							objContact.dataSource = "/Common/ConfigureAddrBook?removeexternalab=true";
							objContact.reselectChild = true;
							objContact.selectFirstNode = true;
							objContact.lazyLoading = true;

                            $contactTree = treeview.init("recContactTree", "recContactName", "recContactID", objContact);

                            /* Mobile */
                            var objAddBook = {};
                            objAddBook.postSelectFn = $.intAddrBookGroupModal.selectContactAddBook;
                            objAddBook.dataSource = "/Common/ConfigureAddrBook?removeexternalab=true";
                            objAddBook.reselectChild = true;
                            objAddBook.selectFirstNode = true;
                            objAddBook.lazyLoading = true;
                            objAddBook.declareType = "textbox";

                            $contactTreeMobile = treeview.init("recAddBookTree", "recAddBook-name", "recAddBook-id", objAddBook);

                            treeview.mapState($contactTree, $contactTreeMobile, true);

							addressTab = true;

							fxcRequest.get('/Common/GetUserDataSources',
								{
									"RetrieveTypes": 7
								},
								function (data) {
									var optAll = [{ Disabled: false, Group: null, Selected: false, Text: "All", Value: "0" }];
									var updArray = $.merge(optAll, data.Results);
									$.sectionproperties.selectGenerator('DdlABFilter', updArray, 0, 0);
								});
						}
						
						break;
					default:
						break;
				}
			});
        },
        selectContactAddBook: function (currentAddBookId) {
            if (!contactTreeCall) {
                var getData = $contactTree.getNodeById(currentAddBookId);
                if (getData != undefined) {
                    $contactTree.unselectAll();
                    $contactTree.select(getData);
                }

                contactTreeCall = false;
            }
        },
		/**/
		recipientDeliveryOnChangeHandler: function (e) {
			$(e).on('change', function () {
				$('#form-user-contactListGeneral').validate().resetForm();
			});
		},
		searchButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$.intAddrBookGroupModal.initGrid(requestObj.id, requestObj);
			});
		},

		searchHandler: function (e) {
			$(e).keypress(function (event) {
				if (event.which === 13) {
					event.preventDefault();
					$.intAddrBookGroupModal.initGrid(requestObj.id, requestObj);
				}
				
			});
		},

		/*Logic*/
		getGridSelections: function (grid) {
			var list = [];
			var selectedItem = [];
			var entityGrid = grid.data("kendoGrid");
			var rows = entityGrid.select();

			rows.each(function (index, row) {
				var selectedItem = entityGrid.dataItem(row);

				var contactArry = {};

				contactArry = {
					ContactID: selectedItem.ContactID,
					AddressID: selectedItem.AddressID,
					DisplayName: selectedItem.DisplayName,
					CompanyName: selectedItem.CompanyName,
					AddressTypeID: selectedItem.AddressTypeID,
					AddressTypeLabel: selectedItem.AddressTypeLabel,
					DisplayAddress: selectedItem.DisplayAddress,
					NotifyAddr: selectedItem.NotifyAddress,
					IsRRSOn: selectedItem.IsRRSOn,
					IsRRFOn: selectedItem.IsRRFOn,
					Cat: selectedItem.Cat,
					CanonicalAddress: selectedItem.CanonicalAddress
				};
				list[index] = contactArry;
			});

			return list;
		},
		onChangeFilter: function (e) {
			selectedFilter = e;
			$.intAddrBookGroupModal.initGrid(requestObj.id, requestObj);
		},
		refreshGrid: function () {
			selectedFilter = 0;
			$('#userAddressBookSearch').val("");
			$.intAddrBookGroupModal.initGrid(requestObj.id, requestObj);
		},
		resetFields: function () {

			$('#form-user-contactListGeneral').trigger("reset");
			$('#form-user-contactListGeneral').validate().resetForm();

			$("#RecipientDelivery").change();

			if (addressTab) 
				$.intAddrBookGroupModal.refreshGrid();
		},
		saveGenericContact: function () {
			/*debugger*/
			var data = $('#GenericAddressBookUserSecret').text();
			var address = $('#RecipientDelivery').val() === '1' ?
				$('#recipient_addressemail').val() : $('#recipient_address').val();
			fxcRequest.post('/Admin/AddressBooks/AddGenericContact',
				{
					AddressTypeId: $('#RecipientDelivery').val(),
					DisplayName: $('#recipient_name').val(),
					CompanyName: $('#recipient_company').val(),
					Address: $('#recipient_address').val(),
					Url: $('#recipient_address').val(),
					Email: $('#recipient_addressemail').val(),
					FaxNumber: $('#recipient_faxNumber').val(),
					MobileNumber: $('#recipient_mobilenumber').val(),
					PhoneNumber: $('#recipient_phonenumber').val(),
					Server: $('#recipient_server').val(),
					Path: $('#recipient_path').val(),
					Username: $('#recipient_userID').val(),
					Password: $('#recipient_userPassword').val(),
					NotifyEmail: $('#recipient_email').val(),

					IsContactGroupViewOnly: $('#recipient_viewonly').prop('checked'),
					AddressBookId: $('input[name="RecordId"]').val(),
					ContactId: 0,
					Printer: $('#recipient_printer').val(),
					Format: $('#recipient_Format').prop('checked')
				},
				function (data) {
					$.toast({
						text: $globalMessages.toast.updating,
						position: 'bottom-right',
						loaderBg: '#ff6849',
						icon: 'info',
						hideAfter: 2000,
						stack: 6
					});

					$('#add-contact-modal').modal("hide");
					var grid = $('#Generic_grid').data("kendoGrid");

					var dataC = $.makeArray(data);
					grid.dataSource.add(dataC[0]);

					$.intAddrBook.initGrid();
				},
				function (error) {
					swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
				}, false
			);

		}, 
		saveAddBookContact: function (items) {
			var list = [];
			var source = $('#Generic_grid').data("kendoGrid").dataSource.data();

			$.each(source, function (i, v) {
				var contactArry = {};

				contactArry = {
					ContactID: v.ContactID,
					AddressID: v.AddressID,
					DisplayName: v.DisplayName,
					CompanyName: v.CompanyName,
					AddressTypeID: v.AddressTypeID,
					AddressTypeLabel: v.AddressTypeLabel,
					DisplayAddress: v.DisplayAddress,
					NotifyAddr: v.NotifyAddr,
					IsRRSOn: v.IsRRSOn,
					IsRRFOn: v.IsRRFOn
				};

				list[i] = contactArry;
			});

			var arry = {
				Action: $('#GroupContact-modal-action').val(),
				SelectedContactAddrList: items,
				CurrentContactAddrList: list
			};

			fxcRequest.post('/Admin/AddressBooks/AddFromAddrBookContact',
				arry,
				function (data) {
					/*debugger*/
					
					$.toast({
						text: $globalMessages.toast.updating,
						position: 'bottom-right',
						loaderBg: '#ff6849',
						icon: 'info',
						hideAfter: 2000,
						stack: 6
					});

					$('#add-contact-modal').modal("hide");
					var grid = $('#Generic_grid').data("kendoGrid");

					$.each(data.ContactList, function (i, v) {
						var data = $.makeArray(v);
						grid.dataSource.add(data[0]);
					});

					$.intAddrBook.initGrid();
				
				},
				function (error) {
					swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
				}, false
			);
		},
	};

	$.intAddrBookImport = {
		init: function () {
			$.importcontact.init('View5', false, true, '/admin');
			$.intAddrBookImport.backButtonClickHandler($('.View5 .btn-back5'));
		},

		/*Button Click Handler*/
		backButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$.sectionproperties.SecondLevel($(e));
			});
		},
	};
})(window.jQuery);