﻿(function ($) {
    var validation = function () {
        $('#formSubmit').validate({
			ignoreTitle: true,
            rules: {
                DomainName: { required: true, noSpace: true }
            },
            submitHandler: function (form) {
                $.domain.save();
            }
        });
    };

    $.domain = {
        init: function (e) {
            validation();
            /*Form*/
            $.domain.resetButtonClickHandler($('.btn-Reset'));
            $.domain.saveButtonClickHandler($('.btn-save'));
        },
        resetButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.domain.resetFields();
            });
        },
        saveButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $('#formSubmit').submit();
            });
        },

        /* Logic */
        resetFields: function () {
            $("#formSubmit").trigger("reset");
            $("#formSubmit").validate().resetForm();

            fxcRequest.get('/Admin/DomainInfo/RefreshDomainInfo',
            {},
            function ($data) {
                $('#DomainName').val($data.DomainName);
                $('#Description').val($data.Description);
                $('#DomainActive').bootstrapSwitch('state', $data.IsActive);
                $('#DomainID').val($data.DomainID);
                $('#DomainActive').bootstrapSwitch('disabled', $data.IsActiveDisabled);
            },
            null);
        },

        save: function () {
            var isactive = $('#DomainActive').prop("checked");
            fxcRequest.post('/Admin/DomainInfo/Save',
            {
                "DomainName": $('#DomainName').val(),
                "Description": $('#Description').val(),
                "DomainActive": $('#DomainActive').val(),
                "IsActive": isactive,
                "DomainId": $('#DomainID').val()
            },
            function (data) {
                $.domain.resetFields();
				swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");
                fxcUserConn.onDomainChanges($('#DomainID').val(), false, true, isactive);
            },
            null);
        }
    };
})(window.jQuery);