﻿(function ($) {
    var assigneeControl;
    var editTempData;

    $.faxNumbers = {
        init: function (e) {
            $.faxNumbers.refreshButtonClickHandler($('.View1 .btn-refresh'));
            $.faxNumbers.searchButtonClickHandler($('.View1 .btn-Search'));            
            $.faxNumbers.searchHandler($('.View1 input[data-role="search-all-item"]'));            
            $.faxNumbers.saveButtonClickHandler($('.View2 .btn-save2'));
            $.faxNumbers.resetButtonClickHandler($('.View2 .btn-Reset2'));
            $.faxNumbers.backButtonClickHandler($('.View2 .btn-back2'));
            $.faxNumbers.assigneeTypeSelectionChangeEvent();

            $.faxNumbers.initGrid();

            formValidation();

            assigneeControl = $('#Assignees');
            assigneeControl.tagsinput({
                itemValue: 'id',
                itemText: 'label'
            });
        },
        /* Button Handlers */
        refreshButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $(this).blur();
                $('input[data-role="search-all-item"]').val("");
                $.faxNumbers.initGrid();
            });
        },
        saveButtonClickHandler: function (e) {
            $(e).on('click', function () {
                if ($('#AssigneeType').val() == '0') {
                    swal({
                        title: $faxNumbersResource.swal.typeNoneTitle,
                        text: $faxNumbersResource.swal.typeNoneMsg,
                        type: "warning",
                        showCancelButton: true
                    }, function () {
                        $("#formSubmit").submit();
                    }, null);
                } else {
                    $("#formSubmit").submit();
                }
            });
        },
        resetButtonClickHandler: function (e) {
            $(e).on('click', function () {
                resetfields();
            });
        },
        backButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.sectionproperties.FirstLevelView();
                $.faxNumbers.initGrid();
            });
        },
        searchButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.faxNumbers.initGrid();
            });
        },
        searchHandler: function (e) {
            $(e).keypress(function (event) {
                if (event.which === 13) {
                    $.faxNumbers.initGrid();
                }
            });
        },        
        assigneeTypeSelectionChangeEvent: function () {
            $('#AssigneeType').on('change', function (e) {
                $('input[name="Assignees"]').val('');
                assigneeControl.tagsinput('removeAll');

                if ($('#AssigneeType').val() === "11") {
                    $('#modal-AssigneesSelection h4').text('User Selection');
                    $('#getUserRequestType-AssigneesSelection').val("1");
                } else {
                    $('#modal-AssigneesSelection h4').text('Group Selection');
                    $('#getUserRequestType-AssigneesSelection').val("2");
                }
            });
        },
        createSaveModel: function (e) {
            var modelArr = $('#formSubmit').MapFormData();
            var saveObj = {};
            $.each(modelArr, function (index, formModel) {
                saveObj[formModel.Id] = formModel.Value;
            });

            saveObj.Assignees = [];
            if ($('input[name="Assignees"]').val().length > 0) {
                saveObj.Assignees = $('input[name="Assignees"]').val().split(",");
            }
            return saveObj;
        },
        /* Main Grid */
        initGrid: function (e) {
            var id = $('#grid');

            var dataSource = {
                transport: {
                    read: {
                        url: '/admin/faxnumbers/read',
                        dataType: "json",
                        type: "GET"
                    },
                    parameterMap: function (options) {
                        var result = {
                            FilterFields: "DIDNumber,DomainName",
                            Filter: $('input[data-role="search-all-item"]').val(),
                            Skip: options.skip,
                            Take: options.take,
                            Page: options.page,
                            DomainId: $('#dashboardID').val()
                        };

                        if (options.sort && options.sort.length > 0) {
                            result.SortBy = options.sort[0].field;
                            result.Direction = options.sort[0].dir;
                        }

                        return result;
                    }
                },
                schema: {
                    data: "Records",
                    total: "Total",
                    model: {
                        id: "DIDPoolId"
                    }
                },
                serverPaging: true,
                serverSorting: true
            };

            var col = [
                {
                    selectable: true, width: "45px",
                    attributes: {
                        "class": "checkboxSelection"
                    }
                },
                { field: 'DIDPoolId', hidden: true },
                { field: 'DomainId', hidden: true },
                {
                    field: 'CountryCode', title: " ", width: 20, hidden: true, template: function (dataRow) {
                        var result = '<div status="kendo-container">' +
                            '<i class="flag-icon flag-icon-' + dataRow.CountryCode + '" title="' + dataRow.CountryCode.toUpperCase() + '"></i>' +
                            '</div>';
                        return result;
                    }
                },
                { field: 'DIDNumber', title: $faxNumbersResource.number, width: 150, sortable: true },
                { field: 'DomainName', title: $faxNumbersResource.domain, width: 250, sortable: true },
                {
                    field: 'AssigneeType', title: " ", width: 20, template: function (dataRow) {
                        var result = '';
                        var assigneeTypeIcon = '';

                        if (dataRow.AssigneeType != 0) { 
                            if (dataRow.AssigneeType == 11)
                                assigneeTypeIcon = 'account';
                            else if (dataRow.AssigneeType == 12)
                                assigneeTypeIcon = 'account-multiple';

                            var result = '<div status="kendo-container" class="text-right">' +
                                '<i class="mdi zmdi-hc-lg mdi-' + assigneeTypeIcon + '"></i>' +
                                '</div>';
                        }
                        return result;
                    }
                },
                { field: 'Assignees', hidden: true },
                { field: 'AssigneesDesc', title: $faxNumbersResource.assignedTo, width: 250, sortable: true }
            ];

            var obj = {};
            obj.allowSelectMultipleRow = true;
            obj.customizeCheckbox = true;
            obj.onSelectionFn = $.faxNumbers.editButtonClickHandler;

            kendogridcustomization.init(id, dataSource, col, obj);
        },
        editButtonClickHandler: function (dataItem) {
            $.sectionproperties.SecondLevel();
            editTempData = dataItem;
            resetfields();
        },
        mapData: function (dataItem) {
            /*console.log(dataItem);*/
            $('#formSubmit').BindToForm(dataItem, '#', '');
            $('#DIDNumDomainId').val(dataItem.DomainId);
            $('#DomainSelection-AssigneesSelection-ddl').attr('disabled', true);
            $('#DomainSelection-AssigneesSelection-ddl').attr('readonly', false);
            $('#defaultSelectedID-AssigneesSelection').val('#DIDNumDomainId');

            didNumberInput.setCountry(dataItem.CountryCode);

            var dialCode = "+" + didNumberInput.getSelectedCountryData().dialCode;
            didNumberInput.setNumber(dataItem.DIDNumber.replace(dialCode, ""));
            $('#AssigneeType').val(dataItem.AssigneeType);

            $.sectionproperties.initHiddenProperties();

            var assigneeList = dataItem.Assignees.split(',');
            var assigneeDescList = dataItem.AssigneesDesc.split(', ');
            if (dataItem.AssigneeType != 0 && assigneeList.length > 0) {
                $.each(assigneeDescList, function (index, obj) {
                    assigneeControl.tagsinput('add', { id: assigneeList[index], label: obj });
                });
            }    
        },
        /* AJAX */
        save: function () {
            var id = $('input[name="DIDPoolId"]').val();
            if (id === '') { id = '0'; }
            var model = $.faxNumbers.createSaveModel();
            /*console.log(model);*/
            fxcRequest.post('/admin/faxnumbers/save',
                model,
                function (data) {
                    swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");

                    var assigneeType = $('#AssigneeType').val();
                    if (assigneeType != 0) {
                        var assignedMsg = $faxNumbersResource.assignedMsg;
                        assignedMsg = assignedMsg.replace('{0}', '<u class="text-bold">' + editTempData.DIDNumber + '</u>');

                        if (assigneeType == 11)
                            assignedMsg = assignedMsg.replace('{1}', $faxNumbersResource.user);
                        else if (assigneeType == 12)
                            assignedMsg = assignedMsg.replace('{1}', $faxNumbersResource.group);

                        var assigneesInStr = $.map(assigneeControl.tagsinput('items'), function (obj) {
                            return obj.label
                        }).join(', ');

                        assignedMsg = assignedMsg.replace('{2}', '<br /><span class="text-bold">' + assigneesInStr + '</span>');
                        $('#assignSuccessMsg').html(assignedMsg);
                    }
                    else {
                        $('#assignSuccessMsg').html('');
                    }
                },
                function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
                });
        },
    };
    
    var formValidation = function () {
        $('#formSubmit').validate({
            ignore: ".ignored",
            ignoreTitle: true,
            rules: {
                Assignees: { required: true }
            },
            submitHandler: function (form) {
                $.faxNumbers.save();
            }
        });
    };

    var resetfields = function () {
        assigneeControl.tagsinput('removeAll');
        $('#formSubmit').trigger("reset");
        $.sectionproperties.initHiddenProperties();
        $('#assignSuccessMsg').html('');

        if (editTempData !== null) {
            $.faxNumbers.mapData(editTempData);
        } else {
            $('#formSubmit').trigger("reset");
            $('#Id').val("0");
            resetDomain();
        }

        $('#formSubmit').validate().resetForm();
    };

})(window.jQuery);