﻿(function ($) {
	var validation = function () {
		$('#formSubmit').validate({
			rules: {
				Name: { required: true },
				DomainName: { required: true},
				TTL: {
					required: true,
					number: true,
					noSpace: true
				}
			},
			submitHandler: function (form) {
				$.onboarding.save();
			},
			ignoreTitle: true
		});
	};

	var $grid, bind = false;
	var $data;
	var $PassIsEncrypted = false;
	var $TempPassword;
	var $onDetail;
	var $treeDomain;
	$.onboarding = {
		init: function (e) {
			validation();

			/*Btn Action*/
			$.onboarding.createButtonClickHandler($(".btn-new-grid"));
			$.onboarding.deleteButtonClickHandler($(".btn-delete-grid"));
			$.onboarding.refreshButtonClickHandler($(".btn-refresh-grid"));
			$.onboarding.searchPressEnter($('input[data-role="search-all-item"]'));
			$.onboarding.searchButtonClickHandler($('.btn-search-grid'));
			
			/*Form*/
			$.onboarding.resetButtonClickHandler($('#reset-onboarding'));
			$.onboarding.saveclosemodalHandler($('#saveClose-onboarding'));
			$.onboarding.copyButtonClickHandler($('.btn-CopyToClipboard'));
			$.onboarding.initTreeViewDomain();
			$.onboarding.initGrid();
		},
		resetPassword: function (e) {
			$("#Password").focus(function () {
				if ($PassIsEncrypted) {
					$TempPassword = $("#Password").val();
					$("#Password").val("");
				}
			});
			$("#Password").keyup(function () {
				$PassIsEncrypted = false;
			});
			$("#Password").focusout(function () {
				if ($PassIsEncrypted) {
					$("#Password").val($TempPassword);
				}
			});
		},
		initGrid: function (e) {
			var id = $('#grid');
			var dataSource = {
				transport: {
					read: {
						url: '/Admin/Onboarding/Read',
						dataType: "json",
						type: "GET"
					},
					parameterMap: function (options) {
						/* Fix url param for sort values */
						var result = {
							Skip: options.skip,
							Take: options.take,
							Sort: options.sort,
							SearchText: $('input[data-role="search-all-item"]').val()
						};
						if (options.sort && options.sort.length > 0) {
							result.SortBy = options.sort[0].field;
							result.Direction = options.sort[0].dir;
						}
						return result;
					}
				},
				schema: {
					data: "Records",
					total: "Total",
					model: {
						id: "Id"
					}
				},
				serverPaging: false,
				serverSorting: false
			};

			var col = [
				{
					selectable: true, width: 45,
					attributes: {
						"class": "checkboxSelection"
					}
				},
				{ field: 'Id', hidden: true },
				{ field: 'Name', title: $onboardingResource.name, sortable: true, minWidth: 150, width: 150 },
				{ field: 'DomainName', title: $onboardingResource.domainName, sortable: true, minWidth: 100, width: 150 },
				{ field: 'TTL', title: $onboardingResource.ttl, sortable: true, minWidth: 100, width: 150 },
				{ field: 'DateCreated', title: $onboardingResource.dateCreated, sortable: true, minWidth: 100, width: 150 },
				{
					field: "IsExpired",
					title: "STATUS",
					width: 150,
					template: function (dataRow) {
						console.log(dataRow)
						var result = '<div class="kendo-container">' 

						if (dataRow.IsExpired === true)
							result += '<span class="fa fa-lock text-danger">EXPIRED</span>'
						else
							result += '<span class="text-primary">ACTIVE</span>'

						result += '</div>';
						return result;
					}
				},
			];

			var obj = {};
			obj.allowSelectMultipleRow = true;

			obj.onSelectionFn = $.onboarding.editHandler;

			var $grid = kendogridcustomization.init(id, dataSource, col, obj);

			$.onboarding.copytoClipBoardClickHandler($(".btn-copyToClip"));
		},

		initForm: function (e) {
			var obj = {
				blurForm: true,
				targetDiv: $("form#formSubmit")
			};
			fxcRequest2.get('/Admin/Onboarding/GetOnboarding',
				{
					Id: e
				},
				function (data) {
					/* map data to inputs*/
					$data = data;
					$.onboarding.resetFields();
				},
				obj);
		},

		/*Btn Action*/
		copytoClipBoardClickHandler: function (e) {
			$(e).on('click', function () {
				var value = this.attr("data-link"); 
				alert(value);
			});
		},
		searchButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$.onboarding.search(e);
			});
		},
		searchPressEnter: function (e) {
			$(e).on('keypress', function (enter) {
				if (enter.which === 13) {
					$.onboarding.search(e);
				}
			});
		},
		createButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$(".modal-header h4#onboarding").text($areaResources.actionTitle.createNewEntry);
				$data = null;
				$('#modalOnboarding').modal('show');
				$.onboarding.resetFields();
			});
		},
		deleteButtonClickHandler: function (e) {
			$(e).on('click', function (x) {
				$(this).blur();
				$.onboarding.delete();
			});
		},
		editHandler: function (e) {
			$(".modal-header h4#onboarding").text($onboardingResource.onboardingDetail);
			$('#modalOnboarding').modal('show');
			$.onboarding.initForm(e.Id);
		},
		resetButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$.onboarding.resetFields();
			});
		},
		copyButtonClickHandler: function (e) {
			$(e).on('click', function () {
				console.log("test copy");
				$('#copy-me').val($data.Link);
				copyToClipboard.init("#copy-me", "#modalOnboarding");
			});
		},
		refreshButtonClickHandler: function (e) {
			$(e).on('click', function (x) {
				$.onboarding.refresh();
				$(this).blur();
			});
		},
		saveclosemodalHandler: function (e) {
			$(e).on('click', function () {
				$('input[name="modal-action"]').val('save & close');
			});
		},


		/* Logic */
		refresh: function (e) {
			$('input[data-role="search-all-item"]').val("");
			$.onboarding.initGrid();
		},
		resetFields: function () {
			if ($data !== null) {
				$('#NameDetail').val($data.Name);
				$('#NameDetail').attr("disabled", "disabled"); 
				$('#DomainNameDetail').val($data.DomainName);
				$('#DomainNameDetail').attr("disabled", "disabled");
				$('#TTLDetail').val($data.TTL);
				$('#TTLDetail').attr("disabled", "disabled");
				$('#LinkDetail').val($data.Link);
				$('#LinkDetail').attr("disabled", "disabled");
				$('#detailDiv').show();
				$('#createDiv').hide();
				$('#saveResetDiv').hide();
				$('#copyLinkDiv').show();
			}
			else {
				$('input[name="RecordId"]').val(0);
				$('#detailDiv').hide();
				$('#createDiv').show();
				$('#saveResetDiv').show();
				$('#copyLinkDiv').hide();
				$("#formSubmit").trigger("reset");
			}
			$("#formSubmit").validate().resetForm();
		},
		search: function (e) {
			$.onboarding.initGrid();
		},
		/* End Logic */

		/*Post or Get Function*/
		delete: function (e) {
			var selectedItem = $.onboarding.getGridSelections($("#grid"));

			if (selectedItem.length === 0) {
				swal("", $onboardingResource.noOnboardingSelected);
				return false;
			}

			swal({
				title: "",
				text: $onboardingResource.onboardingDelQuest,
				type: "info",
				showCancelButton: true,
				closeOnConfirm: false,
				reverseButtons: true,
				showLoaderOnConfirm: true
			}, function () {
				fxcRequest.post('/admin/onboarding/delete',
					{ Ids: selectedItem.join().split(',') },
					function (data) {
						swal($globalMessages.swal.done, $onboardingResource.onboardingDel, "success");
						/* Refresh grid everytime after save*/
						$.onboarding.refresh();
						$('#delete-modal').modal('hide');
					}, function () {
						swal($globalMessages.swal.error.errorCap, error.errorOnDelete, "error");
					}, true);
			});
		},
		getGridSelections: function (event) {
			var entityGrid = event.data("kendoGrid");
			var rows = entityGrid.select();
			var $selectedUser = [];
			rows.each(function (index, row) {
				var selectedItem = entityGrid.dataItem(row);
				$selectedUser[index] = selectedItem.Id;
			});

			return $selectedUser;
		},
		initTreeViewDomain: function (e) {
			$('#domain-ddl').val($('#dashboardText').text());
			$("#domain-id").val($('#dashboardID').val());

			var objDomainSelection = {};
			objDomainSelection.expandAll = true;
			objDomainSelection.declareType = "textbox";
			$treeDomain = treeview.init("domain", "domain-name", "domain-id", objDomainSelection);
		},
		save: function () {
			var idval = $('input[name="RecordId"]').val();
			fxcRequest.post('/admin/onboarding/save',
				{
					Id: idval,
					Name: $('#Name').val(),
					DomainID: $('#domain-id').val(),
					DomainName: $('#domain-name').val(),
					TTL: $('#TTL').val()
				},
				function (data) {
					$.onboarding.refresh();
					if ($('input[name="modal-action"]').val() === 'save & close') {
						$('#modalOnboarding').modal('hide');
						$('input[name="modal-action"]').val('');
					}
					swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");
				},
				function (error) {
					swal($globalMessages.swal.error.errorCap, error.statusText, "error");
				});
		}
	};
})(window.jQuery);