﻿(function ($) {
    var firstLoadGrid = false;
    var firstLoadDelegatee = true;
    var showLoaderBar = false;
    var selectedProfileID;
    var validation = function () {
		$("#formDelegationProfile").validate({
			ignoreTitle: true,
            rules: {
                "Name.Value": {
					required: true,
					noSpace: true
                }
            },
            submitHandler: function (form) {
                $.delegation.save();
            }
        });
    };
    $.delegation = {
        init: function () {
            validation();
            $.delegation.createButtonClickHandler($(".btn-new-delegation"));
            $.delegation.deleteButtonClickHandler($(".btn-delete-delegation"));
            $.delegation.refreshButtonClickHandler($(".btn-refresh-delegation"));
            $.delegation.backButtonClickHandler($(".btn-back-delegation"));
            $.delegation.searchPressEnter($('input[data-role="search-delegation-item"]'));
            $.delegation.searchButtonClickHandler($('.btn-search-delegation'));
            $.delegation.initAccordion($("#accordion"));
            $.delegation.resetButtonClickHandler($('#btn-reset-delegation'));
            $.delegation.saveButtonClickHandler($("#btn-save-delegation"));
            $.delegation.saveCloseButtonClickHandler($("#btn-save-close-delegation"));
        },
        initAccordion: function (e) {
            $(e).on('hide.bs.collapse', function (e) {                
            });
        },
        initGrid: function (e) {
            var id = $('.grid-delegation');

            var dataSource = {
                transport: {
                    read: {
                        url: '/Admin/Manage/Delegation/Read',
                        dataType: "json",
                        type: "GET"
                    },
                    parameterMap: function (options) {
                        /* Fix url param for sort values */
                        var result = {
                            UserId: $("#defaultSelectedID").val(),
                            Skip: options.skip,
                            Take: options.take,
                            SearchText: $('input[data-role="search-delegation-item"]').val()
                        };
                        if (options.sort && options.sort.length > 0) {
                            result.SortBy = options.sort[0].field;
                            result.Direction = options.sort[0].dir;
                        }
                        return result;
                    }
                },
                schema: {
                    data: "Records",
                    total: "Total",
                    model: {
                        id: "UserID"
                    }
                },
                serverPaging: true,
                serverSorting: true
            };

            var col = [
                {
                    selectable: true, width: 45,
                    attributes: {
                        "class": "checkboxSelection"
                    }
                },
                { field: 'ProfileID', hidden: true },
				{ field: 'Name', title: $delegation.grid.name, minWidth: 200, width: 300, sortable: true },
                {
                    field: 'MoveToTrash',
					title: $delegation.grid.moveTrash,
                    minWidth: 100, width: 200,
                    sortable: true,
                    template: '<div class="kendo-container kendo-container-checkbox"> <i #= MoveToTrash == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
                },
                {
                    field: 'ForwardToUser',
					title: $delegation.grid.fwdUser,
                    minWidth: 100, width: 200,
                    sortable: true,
					template: '<div class="kendo-container kendo-container-checkbox"> <i #= ForwardToUser == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
                },
                {
                    field: 'ForwardToFax',
					title: $delegation.grid.fwdFax,
                    minWidth: 100, width: 200,
                    sortable: true,
					template: '<div class="kendo-container kendo-container-checkbox"> <i #= ForwardToFax == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
                },
                {
                    field: 'Print',
					title: $delegation.grid.print,
                    minWidth: 100, width: 100,
                    sortable: true,
					template: '<div class="kendo-container kendo-container-checkbox"> <i #= Print == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
                },
                { field: 'SendLabel', title: 'Send', minWidth: 150, width: 200, sortable: true },
                {
                    field: 'ResendMsg',
					title: $delegation.grid.resend,
                    minWidth: 100, width: 100,
                    sortable: true,
					template: '<div class="kendo-container kendo-container-checkbox"> <i #= ResendMsg == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
                },
                {
                    field: 'RetryFailed',
					title: $delegation.grid.retryFailed,
                    minWidth: 100, width: 150,
                    sortable: true,
					template: '<div class="kendo-container kendo-container-checkbox"> <i #= RetryFailed == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
                },
                {
                    field: 'Assign',
					title: $delegation.grid.assign,
                    minWidth: 100, width: 100,
                    sortable: true,
					template: '<div class="kendo-container kendo-container-checkbox"> <i #= Assign == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
                },
                {
                    field: 'Delete',
					title: $delegation.grid.delete,
                    minWidth: 100, width: 100,
                    sortable: true,
					template: '<div class="kendo-container kendo-container-checkbox"> <i #= Delete == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
                },
                {
                    field: 'Approval',
					title: $delegation.grid.approval,
                    minWidth: 100, width: 150,
                    sortable: true,
					template: '<div class="kendo-container kendo-container-checkbox"> <i #= Approval == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
                },
                {
                    field: 'Tracking',
					title: $delegation.grid.tracking,
                    minWidth: 100, width: 150,
                    sortable: true,
					template: '<div class="kendo-container kendo-container-checkbox"> <i #= Tracking == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
                },
				{ field: 'PersonalFolderLabel', title: $delegation.grid.personalFolder, minWidth: 200, width: 250, sortable: true },
				{ field: 'DelegateeCount', title: $delegation.grid.count, minWidth: 100, width: 200, sortable: true }
                
            ];

            var obj = {};
            obj.allowSelectMultipleRow = true;
            obj.onSelectionFn = $.delegation.editHandler;

            var $grid = kendogridcustomization.init(id, dataSource, col, obj);
        },

        /*Btn Action*/
        backButtonClickHandler: function(e){
            $(e).on('click', function (x) {
                $.sectionproperties.Hidden("DelegationTable", false);
                $.sectionproperties.Hidden("DelegationForm", true);
                $.delegation.refresh(e);
            });
        },
        createButtonClickHandler: function (e) {
            $(e).on('click', function (x) {
                selectedProfileID = "";
                $.sectionproperties.Hidden("DelegationTable", true);
                $.sectionproperties.Hidden("DelegationForm", false);
                $.delegation.resetFields();
                disabledClick = true;
                $("#collapseOne").collapse('show');
            });
        },
        deleteButtonClickHandler: function (e) {
            $(e).on('click', function (x) {
                $(this).blur();
                $.delegation.delete();
            });
        },
        editHandler: function (dataItem) {
            $.sectionproperties.Hidden("DelegationTable", true);
            $.sectionproperties.Hidden("DelegationForm", false);

            selectedProfileID = dataItem === null ? "" : dataItem.ProfileID;
            $.delegation.resetFields(selectedProfileID);

        },
        refreshButtonClickHandler: function (e) {
            $(e).on('click', function (x) {
                $.delegation.refresh(e);
                $(this).blur();
            });
        },
        resetButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.delegation.resetFields(selectedProfileID);
            });
        },
        saveCloseButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $('input[name="formDelegation-action"]').val('save & close');
                showLoaderBar = false;
                $("#formDelegationProfile").submit();
            });
        },
        saveButtonClickHandler: function(e){
            $(e).on('click', function () {
                $('input[name="formDelegation-action"]').val('');
                showLoaderBar = false;
                $("#formDelegationProfile").submit();
            });
        },
        searchButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.delegation.search(e);
            });
        },
        searchPressEnter: function (e) {
            $(e).on('keypress', function (enter) {
                if (enter.which === 13) {
                    $.delegation.search(e);
                }
            });
        },
        /*End Btn Action*/

        /* Logic */
        refresh: function (e) {
            $('input[data-role="search-delegation-item"]').val("");
            $.delegation.initGrid();
        },
        resetFields: function (data) {
            data = data || null;
            $("#formDelegationProfile").trigger("reset");
            $("#formDelegationProfile").validate().resetForm();

            $("#formDelegation-profileID").val("");
            $.sectionproperties.Visible("EditGrid", false);
            $.sectionproperties.Hidden("EditGrid", true);
            $.delegation.getDelegationProfile(data);

            if (data !== null) {
                $("#formDelegation-profileID").val(data);               

                $.sectionproperties.Visible("EditGrid", true);
                $.sectionproperties.Hidden("EditGrid", false);

                disabledClick = false;
                if (firstLoadDelegatee)
                {
                    $.delegatee.init();
                    firstLoadDelegatee = false;
                }

                $.delegatee.initGrid();
                $("#collapseTwo").collapse('show');
            }
        },
        search: function (e) {
            $.delegation.initGrid();
        },
        /* End Logic */

        /*Post or Get Function*/
        getDelegationProfile: function (profileID) {
            fxcRequest.get('/Admin/Manage/Delegation/GetDelegationProfile'
                , { "ProfileID": profileID }
                , function (data) {
                    $('#formDelegationProfile').BindJson(data, '#', '');
                    if (data.Name !== null)
                    {
                        $(".infoDelegationProfile").text(data.Name.Value);
                    }
                });
        },
        delete: function (e) {
            var selectedItem = $.delegation.getGridSelections($(".grid-delegation"));

            if (selectedItem.length === 0) {
				swal("", $globalMessages.swal.alert.noItemSelected);
                return false;
            }

            swal({
                title: "",
				text: $globalMessages.swal.alert.deleteConfirmation,
                type: "info",
                showCancelButton: true,
                closeOnConfirm: false,
                reverseButtons: true,
                showLoaderOnConfirm: true
            }, function () {
                fxcRequest.post('/Admin/Manage/Delegation/Delete',
                    { Ids: selectedItem.join().split(',') },
                    function (data) {
                        swal.close();
                        $.toast({
							text: $globalMessages.swal.success.delete,
                            position: 'top-right',
                            loaderBg: '#ff6849',
                            icon: 'success',
                            hideAfter: 3500,
                            stack: 6
                        });
                        /* Refresh grid everytime after save*/
                        $.delegation.initGrid();
                    }, null, false);
            });
        },
        getGridSelections: function (event) {
            var entityGrid = event.data("kendoGrid");
            var rows = entityGrid.select();
            var $selectedUser = [];
            rows.each(function (index, row) {
                var selectedItem = entityGrid.dataItem(row);
                $selectedUser[index] = selectedItem.ProfileID;
            });

            return $selectedUser;
        },
        save: function (e) {
            fxcRequest.post('/Admin/Manage/Delegation/SaveDelegationProfile',
            {
                "ProfileID": $("#formDelegation-profileID").val(),
                "UserID": $("#defaultSelectedID").val(),
                "Name": $("#Name").val(),
                "Desc": $("#Desc").val(),
                "MoveToTrash": $('#AllowMoveToTrash').bootstrapSwitch('state'),
                "ForwardToUser": $('#AllowForwardToUser').bootstrapSwitch('state'),
                "ForwardToFax": $('#AllowForwardToFax').bootstrapSwitch('state'),
                "Print": $('#AllowPrint').bootstrapSwitch('state'),
                "Download": $('#AllowDownload').bootstrapSwitch('state'),
                "ViewImage": $('#AllowViewImage').bootstrapSwitch('state'),
                "Send": parseInt($('#AllowSend').val()),
                "ResendMsg": $('#AllowResendMsg').bootstrapSwitch('state'),
                "RetryFailed": $('#AllowRetryFailed').bootstrapSwitch('state'),
                "Assign": $('#AllowAssign').bootstrapSwitch('state'),
                "Delete": $('#AllowDelete').bootstrapSwitch('state'),
                "Approval": $('#AllowApproval').bootstrapSwitch('state'),
                "Tracking": $('#AllowTracking').bootstrapSwitch('state'),
                "PersonalFolder": parseInt($('#AllowPersonalFolder').val())
            },
            /*constructsavemodel(),*/
            function (data) {
                $.delegation.refresh(e);

                if ($('input[name="formDelegation-action"]').val() === 'save & close') {
                    $('input[name="formDelegation-action"]').val('');
                    showLoaderBar = false;
					swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");
                    $.sectionproperties.Hidden("DelegationTable", false);
                    $.sectionproperties.Hidden("DelegationForm", true);
                }
                else {
                    var selectedProfileID = data === null ? "" : data.ProfileID;
                    $.delegation.resetFields(selectedProfileID);

                    $.toast({
						text: $globalMessages.swal.success.text,
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'success',
                        hideAfter: 3500,
                        stack: 6
                    });
                }
            },
            function (error) {
                swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSave, "error");
            }, showLoaderBar);
        }
    };

    $.delegatee = {
        init: function () {
            $.delegatee.createButtonClickHandler($(".btn-new-delegatee"));
            $.delegatee.deleteButtonClickHandler($(".btn-delete-delegatee"));
            $.delegatee.refreshButtonClickHandler($(".btn-refresh-delegatee"));
            $.delegatee.searchPressEnter($('input[data-role="search-delegatee-item"]'));
            $.delegatee.searchButtonClickHandler($('.btn-search-delegatee'));
        },
        initGrid: function (e) {
            var id = $('.grid-delegatee');

            if ($(id).data("kendoGrid") != null) {
                $(id).data("kendoGrid").dataSource.data([]);
            }

            var dataSource = {
                transport: {
                    read: {
                        url: '/Admin/Manage/Delegation/GetDelegationDelegatee',
                        dataType: "json",
                        type: "GET"
                    },
                    parameterMap: function (options) {
                        /* Fix url param for sort values */
                        var result = {
                            Skip: options.skip,
                            Take: options.take,
                            SearchText: $('input[data-role="search-delegatee-item"]').val(),
                            ProfileID: $("#formDelegation-profileID").val(),
                            UserID: $("#defaultSelectedID").val()
                        };
                        if (options.sort && options.sort.length > 0) {
                            result.SortBy = options.sort[0].field;
                            result.Direction = options.sort[0].dir;
                        }
                        return result;
                    }
                },
                schema: {
                    data: "Records",
                    total: "Total",
                    model: {
                        Id: "AssignID"
                    }
                },
                serverPaging: true,
                serverSorting: true
            };

            var col = [
                {
                    selectable: true, width: 45,
                    attributes: {
                        "class": "checkboxSelection"
                    }
                },
                { field: 'AssignID', hidden: true },
                { field: 'Name', title: $delegation.grid.name, minWidth: 200, width: 400, sortable: true },
                { field: 'DomainName', title: $delegation.grid.domainName, minWidth: 150,  width: 250, sortable: true }
            ];

            var obj = {};
            obj.allowSelectMultipleRow = true;

            var $grid = kendogridcustomization.init(id, dataSource, col, obj);
        },

        /*Btn Action*/
        createButtonClickHandler: function (e) {
            $(e).on('click', function (x) {
                $("#modal-delegateeUser").modal("show");
            });
        },
        deleteButtonClickHandler: function (e) {
			$(e).on('click', function (x) {
				$(this).blur();
                $.delegatee.delete();
            });
        },
        refreshButtonClickHandler: function (e) {
            $(e).on('click', function (x) {
                $.delegatee.refresh();
                $(this).blur();
            });
        },
        searchButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.delegatee.search(e);
            });
        },
        searchPressEnter: function (e) {
            $(e).on('keypress', function (enter) {
                if (enter.which === 13) {
                    $.delegatee.search(e);
                }
            });
        },
        /*End Btn Action*/

        /* Logic */
        refresh: function (e) {
            $('input[data-role="search-delegatee-item"]').val("");
            $.delegatee.initGrid();
        },
        search: function (e) {
            $.delegatee.initGrid();
        },

        /*Post or Get Function*/
        delete: function (e) {

            var selectedItem = $.delegatee.getGridSelections($(".grid-delegatee"));

            if (selectedItem.length === 0) {
                swal("", "No delegatee(s) selected!");
                return false;
            }

            swal({
                title: "",
                text: "Are you sure you want to delete selected delegatee(s)?",
                type: "info",
                showCancelButton: true,
                closeOnConfirm: false,
                reverseButtons: true,
                showLoaderOnConfirm: true
            }, function () {
                fxcRequest.post('/Admin/Manage/Delegation/GetDelegationDelegateeDelete',
                    {
                        Ids: selectedItem.join().split(','),
                        ProfileID: $("#formDelegation-profileID").val(),
                        UserID: $("#defaultSelectedID").val()
                    },
                    function (data) {
                        swal.close();
                        $.toast({
                            text: $delegation.swal.successDelDelegatee,
                            position: 'top-right',
                            loaderBg: '#ff6849',
                            icon: 'success',
                            hideAfter: 3500,
                            stack: 6
                        });
                        /* Refresh grid everytime after save*/
                        $.delegatee.refresh();
                    }, function () {
                        swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnDelete, "error");
                    }, false);
            });
        },
        getGridSelections: function (event) {
            var entityGrid = event.data("kendoGrid");
            var rows = entityGrid.select();
            var $selectedUser = [];
            rows.each(function (index, row) {
                var selectedItem = entityGrid.dataItem(row);
                $selectedUser[index] = selectedItem.AssignID;
            });

            return $selectedUser;
        },
        getGridUserSelections: function (event) {
            var entityGrid = event.data("kendoGrid");
            var rows = entityGrid.select();
            var $selectedUser = [];
            rows.each(function (index, row) {
                var selectedItem = entityGrid.dataItem(row);
                $selectedUser[index] = selectedItem.id;
            });

            return $selectedUser;
        },
        add: function () {
            var selectedItem = $.delegatee.getGridUserSelections($('.grid-delegateeUser'));

            if (selectedItem.length === 0) {
                swal("", $userResource.swal.noUser);
                return false;
            }

            fxcRequest.post('/Admin/Manage/Delegation/AssignDelegatee',
                    {
                        Ids: selectedItem.join().split(','),
                        ProfileID: $("#formDelegation-profileID").val(),
                        UserID: $("#defaultSelectedID").val()
                    },
                    function (data) {
                        
                        $.toast({
                            text: $globalMessages.swal.success.text,
                            position: 'top-right',
                            loaderBg: '#ff6849',
                            icon: 'success',
                            hideAfter: 3500,
                            stack: 6
                        });

                        $("#modal-delegateeUser").modal("hide").on('hidden.bs.modal', function () {
                            $.delegatee.initGrid();
                        });

                    }, function () {
                        swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnDelete, "error");
                    }, false);
        }
    };
})(window.jQuery);
