﻿(function ($) {
	var $currentSelected, $userProfileData;
	var deletedAddress = [];
	var emailValidation = true;
	var sequence = 1;
	var $PassIsEncrypted = false;
	var $TempPassword;

	$.profile = {
		init: function (profileFormInit) {
			/*Btn Action*/
			$.profile.applyFileFormatButtonClickHandler($(".btn-applyfileformat-profile"));
			$.profile.createButtonClickHandler($(".btn-add-profile"));
			$.profile.deleteButtonClickHandler($(".btn-delete-profile"));
			$.profile.refreshButtonClickHandler($(".btn-refresh-profile"));
			$.profile.searchPressEnter($('input[data-role="search-address-item"]'));
			$.profile.searchButtonClickHandler($('.btn-search-profile'));
			$.profile.updateMFPSyncButtonClickHandler($('#btnUpdateMFPSync'));
			$.profile.resetPassword();
			$.profile.ddlOnChange();

			$.mfpSync.init();
		},
		initForm: function () {
			$userProfileData = {};

			$("#formUserProfile").trigger("reset");
			$.profile.initTreeViewDomain();
			$("#formUserProfile").validate().resetForm();
			$('#PrimaryAddress').html("");
			$('#AccessRights').val('');
			$('#completeProfileTab').val(false);

			var obj = {
				blurForm: true,
				targetDiv: $("#ProfileTab")
			};

			fxcRequest2.get('/Admin/Manage/Profile/Read',
				{
					UserId: $("#defaultSelectedID").val(),
					DomainId: $('#domain-id').val(),
				},
				function (data) {
					/* map data to inputs*/
					$userProfileData = data;
					mapModelToView();
				}, obj);
		},
		initGrid: function (e) {
			var id = $('.grid-profile');

			if ($(id).data("kendoGrid") != null) {
				$(id).data("kendoGrid").dataSource.data([]);
            }
			
			deletedAddress = [];
			var dataSource = {
				transport: {
					read: {
						url: '/Admin/Manage/Profile/Addresses',
						dataType: "json",
						type: "GET"
					},
					parameterMap: function (options) {
						/* Fix url param for sort values */
						return {
							Skip: options.skip,
							Take: options.take,
							SearchText: $('input[data-role="search-address-item"]').val(),
							UserId: $("#defaultSelectedID").val()
						};
					}
				},
				schema: {
					data: "Addresses",
					total: "Total",
					model: {
						id: "uid",
						fields: {
							Id: { type: "string" },
							ReceiveNotification: { type: "boolean" },
							SendNotification: { type: "boolean" },
							IsPrimary: { type: "boolean" },
							Type: { type: "string" },
							Value: { type: "string" },
							Format: { type: "string" },
							AddressTypeId: { type: "int" },
							AddressValue: { type: "string" },
							Number: { type: "string" },
							LoginUser: { type: "string" },
							LoginPass: { type: "string" },
							Server: { type: "string" },
							Path: { type: "string" },
							PrinterType: { type: "string" },
							Sequence: { type: "int" }
						}
					}
				},
				serverPaging: false
			};
			var col = [
				{
					selectable: true, width: 45,
					attributes: {
						"class": "checkboxSelection"
					}
				},
				{ field: 'Id', hidden: true },
				{
					attributes: {
						"class": "checkboxSelection"
					},
					field: "ReceiveNotification",
					title: $userResource.field.nor,
					width: 90,
					template: '<div class="custom-checkbox"><input class="k-checkbox-custom rrs" #= ReceiveNotification == true ? \'checked="checked"\' : "" # data-role="checkbox" data-id="#= Id #" id="NOR-#= Id #-#= Sequence #" type="checkbox"> '
						+ '    <label for="NOR-#= Id #-#= Sequence #" class="k-checkbox-custom-label k-no-text"></label></div>'
				},
				{
					attributes: {
						"class": "checkboxSelection"
					},
					field: "SendNotification",
					title: $userResource.field.nos,
					width: 90,
					template: '<div class="custom-checkbox"><input class="k-checkbox-custom rrs" #= SendNotification == true ? \'checked="checked"\' : "" # data-role="checkbox" data-id="#= Id #" id="NOS-#= Id #-#= Sequence #" type="checkbox"> '
						+ '    <label for="NOS-#= Id #-#= Sequence #" class="k-checkbox-custom-label k-no-text"></label></div>'
				},
				{
					attributes: {
						"class": "checkboxSelection"
					},
					field: "IsPrimary",
					title: $userResource.field.primary,
					width: 120,
					template: '<div class="custom-checkbox"><input class="k-checkbox-custom rrs" #= IsPrimary == true ? \'checked="checked"\' : "" # data-role="checkbox" data-id="#= Id #" id="Primary-#= Id #-#= Sequence #" type="checkbox"> '
						+ '    <label for="Primary-#= Id #-#= Sequence #" class="k-checkbox-custom-label k-no-text"></label></div>'
				},
				{ field: 'Type', title: $userResource.field.addressType, minWidth: 150, width: 150, sortable: true },
				{ field: 'Value', title: $userResource.field.address, sortable: true, width: 300 },
				{ field: 'Format', title: $userResource.field.format, sortable: true, width: 80 },
				{ field: 'AddressTypeId', hidden: true },
				{ field: 'AddressValue', hidden: true },
				{ field: 'Number', hidden: true },
				{ field: 'LoginUser', hidden: true },
				{ field: 'LoginPass', hidden: true },
				{ field: 'Server', hidden: true },
				{ field: 'Path', hidden: true },
				{ field: 'PrinterType', hidden: true },
				{ field: 'Sequence', hidden: true }
			];
			var obj = {};
			obj.totalInputType = "#TotalGrid-profile";
			obj.allowSelectMultipleRow = false;
			obj.onSelectionFn = $.profile.editHandler;
			obj.customizeCheckbox = true;
			obj.customizeCheckboxFn = $.address.gridChecboxActionHandler;

			var $grid = kendogridcustomization.init(id, dataSource, col, obj);
		},
		initTreeViewDomain: function (e) {
			/* Text box: Domain Treeview */
			$("#domain-id").val($('#dashboardID').val());
			var objDomainSelection = {};
			objDomainSelection.expandAll = true;
			objDomainSelection.declareType = "textbox";
			treeview.init("domain", "domain-name", "domain-id", objDomainSelection);
		},

		/*Btn Action*/
		applyFileFormatButtonClickHandler: function (e) {
			$(e).on('click', function (x) {
				$(this).blur();
				$.profile.applyFileFormat(this);
			});
		},
		createButtonClickHandler: function (e) {
			$(e).on('click', function (x) {
				$currentSelected = null;
				$.address.reset();
				$(this).blur();
			});
		},
		editHandler: function (dataItem) {
			$currentSelected = dataItem;
			$.address.reset();
		},
		deleteButtonClickHandler: function (e) {
			$(e).on('click', function (x) {
				$(this).blur();
				$.profile.delete(this);
			});
		},
		refreshButtonClickHandler: function (e) {
			$(e).on('click', function (x) {
				$.profile.refresh();
				$(this).blur();
			});
		},
		searchButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$.profile.search(e);
			});
		},
		searchPressEnter: function (e) {
			$(e).on('keypress', function (enter) {
				if (enter.which === 13) {
					$.profile.search(e);
				}
			});
		},
		updateMFPSyncButtonClickHandler: function(e) {
			$(e).on('click', function () {
				$('#mfpSync_ID').val($userProfileData.MFPSyncID);

				$("#formModalMFPSync").validate().resetForm();
				$('#modalMFPSync').modal('show');
			});
		},
			
		/*End Btn Action*/

		/* Logic */
		applyFileFormat: function (e) {
			var grid = $(".grid-profile").data("kendoGrid");
			var selectedItem = grid.select();
			if (selectedItem.length === 0) {
				swal("", $userResource.swal.noAddress);
				$(e).attr("disabled", false);
				return false;
			}

			$.fileFormat.reset();
		},
		delete: function (e) {
			var grid = $(".grid-profile").data("kendoGrid");
			var selectedItem = grid.select();
			if (selectedItem.length === 0) {
				swal("", $userResource.swal.noAddress);
				$(e).attr("disabled", false);
				return false;
			}

			for (i = 0; i < selectedItem.length; i++) {
				for (j = 0; j < grid.dataSource.data().length; j++) {
					var gridSource = grid.dataSource.at(j);
					if (gridSource.uid == selectedItem[i].dataset.uid) {
						deletedAddress.push(gridSource);
						grid.dataSource.remove(gridSource);
					}
				}
			}

			$.profile.rebindPrimaryAddress();
			$.toast({
				text: $globalMessages.toast.updatedManualSave,
				position: 'bottom-right',
				loaderBg: '#ff6849',
				loader: false,
				icon: 'info',
				hideAfter: 5000,
				stack: 6
			});
		},
		ddlOnChange: function (e) {
			$("#Role").on('change', function (event, state) {
                $("#RoleID").val($("#Role").val());

                updateAccessRightVisibility();
			});
		},
		getGridSelections: function (event) {
			var entityGrid = event.data("kendoGrid");
			var rows = entityGrid.select();
			var $selectedUser = [];
			rows.each(function (index, row) {
				var selectedItem = entityGrid.dataItem(row);
				$selectedUser[index] = selectedItem.Id;
			});
			return $selectedUser;
		},
		reset: function (e) {
			$.profile.initForm();
			$.profile.refresh();
		},
        rebindPrimaryAddress: function (e) {
			var primaryAddressSource = [];
			var selectedValue = $("#PrimaryAddress").val();

			$("#PrimaryAddress").empty();

			var grid = $(".grid-profile").data("kendoGrid");
			var dataItem = grid.dataSource.data();
			if (dataItem.length === 0) {
				return false;
			}

			for (j = 0; j < dataItem.length; j++) {
                var gridSource = grid.dataSource.at(j);
                if (gridSource.AddressTypeId == 1 && gridSource.IsPrimary == true) {                    
                    var gridSourceId = gridSource.Id;
                    if (gridSourceId == 0) { //Identity newly added address with grid uid
                        gridSourceId = gridSource.uid;
                    }
                    primaryAddressSource.push({ Text: gridSource.AddressValue, Value: gridSourceId });
				}
			}

			$.sectionproperties.selectGenerator('PrimaryAddress', primaryAddressSource, selectedValue, 0);

            /* Remove email taken rules */
            $("#PrimaryAddress").rules('remove', 'serverError');
            $('#PrimaryAddress').valid();
        },
		refresh: function (e) {
			$('input[data-role="search-address-item"]').val("");
			$.profile.initGrid();
		},
		resetPassword: function (e) {
			$("#address_userPassword").focus(function () {
				if ($PassIsEncrypted) {
					$TempPassword = $("#address_userPassword").val();
					$("#address_userPassword").val("");
				}
			});
			$("#address_userPassword").keyup(function () {
				$PassIsEncrypted = false;
			});
			$("#address_userPassword").focusout(function () {
				if ($PassIsEncrypted) {
					$("#address_userPassword").val($TempPassword);
				}
			});
		},
		search: function (e) {
			$.profile.initGrid();
		},
		/* End Logic */
		modelData: function () {
			var data = {
				UserId: $("#defaultSelectedID").val(),
				UID: $("#UID").val(),
				DomainId: $userProfileData.DomainId,
				Username: $('#Username').val(),
				Password: $("#Password").val(),
				AuthType: parseInt($('#AuthType').val()),
				IsActive: $('#IsActive').prop('checked'),
				Enable2FA: $('#Enable2FA').prop('checked'),
				Enable2FAProvider: $('#Enable2FAProvider').val(),
				DisplayName: $('#DisplayName').val(),
				FirstName: $('#FirstName').val(),
				MiddleName: $('#MiddleName').val(),
				LastName: $('#LastName').val(),
				Description: $('#Description').val(),
				Role: parseInt($('#RoleID').val()),
				AddressType: parseInt($('#PreferAddressType').val()),
				IsDomainOwner: $("#IsDomainOwner").prop('checked'),
				PrimaryAddress: $("#PrimaryAddress option:selected").text(),
				Addresses: []
			};

			$.each($('#profile').data('kendoGrid').dataSource.data(), function (key, value) {
				data.Addresses.push({
					Id: value.Id,
					Type: value.Type,
					Value: value.Value,
					Format: value.Format,
					ReceiveNotification: value.ReceiveNotification,
					SendNotification: value.SendNotification,
					IsPrimary: value.IsPrimary,
					AddressTypeId: value.AddressTypeId,
					AddressValue: value.AddressValue,
					Number: value.Number,
					LoginUser: value.LoginUser,
					LoginPass: value.LoginPass,
					LoginPassEncrypted: value.LoginPassEncrypted,
					Server: value.Server,
					Path: value.Path,
					PrinterType: value.PrinterType,
					Sequence: value.Sequence
				});
			});

			$.each(deletedAddress, function (key, value) {
				data.Addresses.push({
					Id: value.Id,
					Type: value.Type,
					Value: value.Value,
					Format: value.Format,
					ReceiveNotification: value.ReceiveNotification,
					SendNotification: value.SendNotification,
					IsPrimary: value.IsPrimary,
					AddressTypeId: value.AddressTypeId,
					AddressValue: value.AddressValue,
					Number: value.Number,
					LoginUser: value.LoginUser,
					LoginPass: value.LoginPass,
					Server: value.Server,
					Path: value.Path,
					PrinterType: value.PrinterType,
					Sequence: value.Sequence,
					IsRemoved: true
				});
			});
			return data;
		},
		enable2FAProvider: function () {
			$("#Enable2FAProvider").attr('disabled', $('#Enable2FA').prop('checked'));
        }
	};

	var handleAccessability = function (e) {
		$('.main-pane .form-control').prop('disabled', e);
		$('.main-pane .btn-add').prop('disabled', e);
		$('.main-pane .btn-edit').prop('disabled', e);
		$('.main-pane .btn-delete').prop('disabled', e);

		if (e) {
			$('.btn-lock-account').addClass('hide');
			$('.btn-unlock-account').removeClass('hide');
		} else {
			$('.btn-lock-account').removeClass('hide');
			$('.btn-unlock-account').addClass('hide');
		}

		if (!e) {
			$("#Enable2FAProvider").attr('disabled', $userProfileData.Enable2FA);
        }
	};

	var initModalProfileAddress = false;
	var mapModelToView = function () {
		$.sectionproperties.Hidden("ExchangeIntegrationLink", !$userProfileData.ExchangeIntegrationTab);
		$.sectionproperties.Hidden("DelegationLink", !$userProfileData.DelegationTab);

		$('#Username').val($userProfileData.Username);
        $('#Password').val($userProfileData.Password);
        $('#PrimaryAddress').html($userProfileData.PrimaryAddressSource);
        
        var primaryAddressID = "";
        if ($userProfileData.PrimaryAddress != "") {            
            var primaryAddressOption = $("#PrimaryAddress option").filter(function () { return $(this).text() === $userProfileData.PrimaryAddress; })
            
            if (primaryAddressOption.length > 0) {
                primaryAddressID = primaryAddressOption[0].value;
            }
        }
        $('#PrimaryAddress').val(primaryAddressID);
		$('#AuthType').val($userProfileData.AuthType);
		$("#IsActive").bootstrapSwitch('disabled', false);
		$('#IsActive').bootstrapSwitch('state', $userProfileData.IsActive);
		$("#Enable2FA").bootstrapSwitch('disabled', false);
		$('#Enable2FA').bootstrapSwitch('state', $userProfileData.Enable2FA);
		$('#Enable2FAProvider').val($userProfileData.Enable2FAProvider);
		$('#DisplayName').val($userProfileData.DisplayName);
		$('#FirstName').val($userProfileData.FirstName);
		$('#MiddleName').val($userProfileData.MiddleName);
		$('#LastName').val($userProfileData.LastName);
		$('#Description').val($userProfileData.Description);
		$('#Role').html($userProfileData.RoleSource);
		$('#Role').val($userProfileData.Role);
		$("#RoleID").val($userProfileData.Role);
		$("#RoleText").val($userProfileData.RoleText);
		$("#UID").val($userProfileData.UID);
		$('#Role').attr("Disabled", $userProfileData.DisabledRole);
		$("#AccessRights").val($userProfileData.AccessRights);
		$("#IsDomainOwner").bootstrapSwitch('state', $userProfileData.IsDomainOwner);
		$('#RoleText').attr("Disabled", true);
		if ($("#Role option[value='" + $userProfileData.Role + "']").length === 0) {
			$(".HideRoleDDL").addClass("hide");
			$(".HideRoleTextBox").removeClass("hide");
		}
		else {
			$(".HideRoleDDL").removeClass("hide");
			$(".HideRoleTextBox").addClass("hide");
		}

        updateAccessRightVisibility();

		$('#PreferAddressType').html($userProfileData.PreferAddressTypeSource);
		$('#PreferAddressType').val($userProfileData.AddressType === 0 ? 1 : $userProfileData.AddressType);
		$('#ModalAddressType').html($userProfileData.PreferAddressTypeSource);
		$('#PreferPrinterType').html($userProfileData.PrinterSource);
		$('#address_faxNumber').attr("data-defaultTelco", $userProfileData.FaxNumber);
		$('#address_mobilenumber').attr("data-defaultTelco", $userProfileData.FaxNumber);
		$('#address_phonenumber').attr("data-defaultTelco", $userProfileData.FaxNumber);


		$('#ClientId').val($userProfileData.ClientId);
		$('#ClientSecret').val($userProfileData.ClientSecret);
		$('#lastLoginLabel').text($userProfileData.LastLoginString);

		$('#toggleSecret').unbind('click');
		$('#update-modalApiKeys').unbind('click');
		$('div.api-key-wrapper button').unbind('click');

		$('.btn-lock-account').unbind('click');
		$('.btn-unlock-account').unbind('click');
		if ($userProfileData.RoleText) {

			$('div.api-key-wrapper').show();
			$('div.lock-key-wrapper').show();
			$('div.api-key-wrapper button').click(function () { $('#modalApiKeys').modal('show'); });
			$('#toggleSecret').click(function () {
				var secret = document.getElementById('ClientSecret');
				if ($(this).is(":checked")) secret.type = "text";
				else secret.type = "password";
			});
			$('#update-modalApiKeys').click(function () { updateClientCredentials(); });

			$('.btn-lock-account').click(function () { accountAccessibility(true); });
			$('.btn-unlock-account').click(function () { accountAccessibility(false); });
		} else {
			$('div.api-key-wrapper').hide();
			$('div.lock-key-wrapper').hide();
		}

		$('#completeProfileTab').val(true);
		handleAccessability($userProfileData.IsLocked);

		$('#MFPSyncID').val($userProfileData.MFPSyncID);
		$('#MFPSyncID').attr("disabled", true);
	};

	var accountAccessibility = function (lockaccount) {
		var $text = (lockaccount === true) ? $userResource.swal.LockSwalText : $userResource.swal.UnlockSwalText;
		var $toastText = (lockaccount === true) ? $userResource.swal.LockToastText : $userResource.swal.UnlockToastText;
		var $url = (lockaccount === true) ? '/admin/manage/profile/LockAccount' : '/admin/manage/profile/UnlockAccount';
		swal({
			title: "",
			text: $text,
			type: "info",
			showCancelButton: true,
			closeOnConfirm: false,
			reverseButtons: true,
			showLoaderOnConfirm: true
		}, function () {
			fxcRequest.post($url,
				{
					Id: $userProfileData.UID 
				},
				function (data) {
					swal.close();
					$.toast({
						text: $toastText,
						position: 'top-right',
						loaderBg: '#ff6849',
						icon: 'success',
						hideAfter: 5000,
						stack: 6
					});
					handleAccessability(lockaccount);
				}, null, false);
		});
	};

	var updateClientCredentials = function () {
		fxcRequest.get('/ClientCredential',
			{
				ClientId: $userProfileData.ClientId
			},
			function (data) {
				$('#ClientSecret').val(data);
			}, function () { });
	};
	var modalProfileAddressValidation = function () {
		$("#formModalProfileAddress")
			.validate({
				rules: {
					address_faxNumber: { required: true },
					address_addressEmail: {
						required: true,
						email: true
					},
					address_address: {
						required: true
					},
					address_phonenumber: { required: true },
					address_mobilenumber: { required: true },
					address_path: { required: true },
					address_userID: { checkRequired: "address_userPassword" },
					address_userPassword: { checkRequired: "address_userID" }
				},
				messages: {
					address_faxNumber: { required: $userResource.validation.faxRequired },
					address_addressEmail: { required: $userResource.validation.addrRequired, email: $userResource.validation.emailFormat },
					address_phonenumber: { required: $userResource.validation.phoneRequired },
					address_mobilenumber: { required: $userResource.validation.mobileRequired },
					address_path: { required: $userResource.validation.filePathRequired }
				},
				submitHandler: function (form) {
					$.address.save();
				}
			});
	};
	var mapUserProfileInModel = function () {
		$userProfileData.DomainId = $('#domain-id').val(),
		$userProfileData.Username = $('#Username').val(),
		$userProfileData.Password = $('#Password').val(),
		$userProfileData.AuthType = parseInt($('#AuthType').val()),
		$userProfileData.IsActive = $('#IsActive').bootstrapSwitch('state'),
		$userProfileData.Enable2FA = $('#Enable2FA').bootstrapSwitch('state'),
		$userProfileData.Enable2FAProvider = $('#Enable2FAProvider').val(),
		$userProfileData.Role = parseInt($('#RoleID').val()),
		$userProfileData.DisplayName = $('#DisplayName').val(),
		$userProfileData.FirstName = $('#FirstName').val(),
		$userProfileData.LastName = $('#LastName').val(),
		$userProfileData.Description = $('#Description').val(),
		$userProfileData.AddressType = parseInt($('#PreferAddressType').val()),
		$userProfileData.MFPSyncID = $('#MFPSyncID').val()
	};
	var mapAddressInModel = function () {
		var model,
			gridDataSource = $('#profile').data("kendoGrid").dataSource,
			id = 0;

		if ($currentSelected)
			model = gridDataSource.get($currentSelected.uid);
		else
			model = { Id: id, IsPrimary: false, Sequence: sequence };

		sequence++;
		model["AddressTypeId"] = $('#ModalAddressType').val(),
			model["Type"] = $('#ModalAddressType option:selected').text(),
			model["ReceiveNotification"] = $('#address_NOR').prop('checked'),
			model["SendNotification"] = $('#address_NOS').prop('checked');

		switch (Number(model.AddressTypeId)) {
			case 1: /*email*/
				model.Format = $('#address_Format').bootstrapSwitch('state') ? "PDF" : "TIF",
					model.AddressValue = $('#address_addressEmail').val(),
					model.Value = $('#address_addressEmail').val();
				break;
			case 2: /*fax*/
				model.Number = $('#address_faxNumber').val(),
					model.Value = $('#address_faxNumber').val();
				break;
			case 10: /*phone*/
				model.Number = $('#address_phonenumber').val(),
					model.Value = $('#address_phonenumber').val();
				break;
			case 7: /*mobile*/
				model.Number = $('#address_mobilenumber').val(),
					model.Value = $('#address_mobilenumber').val();
				break;
			case 3: /*http*/
			case 4: /*ftp*/
				var reformatAddress = $('#address_address').val();

				$('#address_address').val(reformatAddress);

				model.Format = $('#address_Format').bootstrapSwitch('state') ? "PDF" : "TIF",
					model.AddressValue = $('#address_address').val(),
					model.LoginUser = $('#address_userID').val(),
					model.LoginPass = $('#address_userPassword').val(),
					model.LoginPassEncrypted = true;
				model.Value = $('#address_address').val();
				/*model.Value = $('#address_address').val() + "usr=" + $('#address_userID').val() + ";pwd=########";*/
				break;
			case 5: /*file*/
				model.Format = $('#address_Format').bootstrapSwitch('state') ? "PDF" : "TIF",
					model.Server = $('#address_server').val(),
					model.Path = $('#address_path').val(),
					model.LoginUser = $('#address_userID').val(),
					model.LoginPass = $('#address_userPassword').val(),
					model.LoginPassEncrypted = true;
				model.Value = $('#address_path').val();
				break;
			case 6: /*printer*/
				model.PrinterType = $("#PreferPrinterType").val(),
					model.Value = $('#PreferPrinterType  option:selected').text();
				break;
			case 9: /*rawfax*/
				model.AddressValue = $('#address_address').val(),
					model.Value = $('#address_address').val();
				break;
		}

		fxcRequest.post('/Admin/Manage/Profile/ParseAddress',
			{
				Id: model.Id,
				Type: model.Type,
				Value: model.Value,
				Format: model.Format,
				AddressTypeId: model.AddressTypeId,
				AddressValue: model.AddressValue,
				Number: model.Number,
				LoginUser: model.LoginUser,
				LoginPass: model.LoginPass,
				LoginPassEncrypted: $PassIsEncrypted,
				Server: model.Server,
				Path: model.Path,
				PrinterType: model.PrinterType
			}, function (data) {
				if ($('input#modalProfileAddress-action').val() === 'save & close') {
					$("#modalProfileAddress").modal('hide');
					$('input#modalProfileAddress-action').val('');
				}
				model.Value = data.Address,
					model.LoginPass = data.Hashed;
				if (!$currentSelected) {
					gridDataSource.add(model);
					$.toast({
						text: $globalMessages.toast.updatedWithNewRecordManualSave,
						position: 'bottom-right',
						loaderBg: '#ff6849',
						loader: false,
						icon: 'info',
						hideAfter: 5000,
						stack: 6
					});
				} else {
					$.toast({
						text: $globalMessages.toast.updatedManualSave,
						position: 'bottom-right',
						loaderBg: '#ff6849',
						loader: false,
						icon: 'info',
						hideAfter: 5000,
						stack: 6
					});
				}
				$.profile.rebindPrimaryAddress();
				$('#profile').data('kendoGrid').refresh();
			}, function (error) {
			}, false);
	};
    var updateAccessRightVisibility = function () {
        if ($('#Role').val() < 3) {
            $("div.hide-access-rights").removeClass('hide');
        } else {
            $("div.hide-access-rights").addClass('hide');
        }

        if ($('#IsSA').val().toLowerCase() == 'true' && $('#Role').val() == 2) {
            $("#domain-owner").removeClass('hide');
        } else {
            $("#domain-owner").addClass('hide');
        }
    }

	$.address = {
		init: function (e) {
			/*Btn Action*/
			modalProfileAddressValidation();
			$.address.resetButtonClickHandler($('#reset-profileAddress'));
			$.address.saveclosemodalHandler($('#saveClose-profileAddress'));
		},

		/*Btn Action*/
		resetButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$.address.reset();
			});
		},
		saveclosemodalHandler: function (e) {
			$(e).on('click', function () {
				$('input#modalProfileAddress-action').val('save & close');
			});
		},
		/*End Btn Action*/
		/* Logic */
		gridChecboxActionHandler: function (dataItem, e) {
			if (dataItem.AddressTypeId == 1) {
				$.profile.rebindPrimaryAddress();
			} else {
				$.each($('#profile').data('kendoGrid').dataSource.data(), function (key, value) {
					if (dataItem.uid == value.uid) {
						value.IsPrimary = dataItem.IsPrimary;
					}
					else if (dataItem.AddressTypeId == value.AddressTypeId) {
						value.IsPrimary = false;
					}
				});

				$('#profile').data('kendoGrid').refresh();
			}
		},
		reset: function (e) {
			$("#modalProfileAddress").modal('show');

			$("#formModalProfileAddress").trigger("reset");
			$("#formModalProfileAddress").validate().resetForm();
			$('#address_faxNumber').val($('#address_faxNumber').attr("data-defaultTelco"));
			$('#address_mobilenumber').val($('#address_faxNumber').attr("data-defaultTelco"));
			$('#address_phonenumber').val($('#address_faxNumber').attr("data-defaultTelco"));
			$PassIsEncrypted = false;
			if ($currentSelected !== null) {
				$('#ModalAddressType').val($currentSelected.AddressTypeId);

				var formatType = $currentSelected.Format === 'PDF';
				switch (Number($currentSelected.AddressTypeId)) {
					case 1: /*email*/
						$('#address_Format').bootstrapSwitch('state', formatType),
							$('#address_addressEmail').val($currentSelected.AddressValue);
						break;
					case 2: /*fax*/
						$('#address_faxNumber').val($currentSelected.Number);
						break;
					case 10: /*phone*/
						$('#address_phonenumber').val($currentSelected.Number);
						break;
					case 7: /*mobile*/
						$('#address_mobilenumber').val($currentSelected.Number);
						break;
					case 3: /*http*/
					case 4: /*ftp*/
						$('#address_Format').bootstrapSwitch('state', formatType),
							$('#address_address').val($currentSelected.AddressValue),
							$('#address_userID').val($currentSelected.LoginUser),
							$('#address_userPassword').val($currentSelected.LoginPass);
						$PassIsEncrypted = $currentSelected.LoginPassEncrypted;
						break;
					case 5: /*file*/
						$('#address_Format').bootstrapSwitch('state', formatType),
							$('#address_server').val($currentSelected.Server),
							$('#address_path').val($currentSelected.Path),
							$('#address_userID').val($currentSelected.LoginUser),
							$('#address_userPassword').val($currentSelected.LoginPass);
						$PassIsEncrypted = $currentSelected.LoginPassEncrypted;
						break;
					case 6: /*printer*/
						$('#PreferPrinterType').val($currentSelected.PrinterType);
						break;
					case 9: /*rawfax*/
						$('#address_address').val($currentSelected.AddressValue);
						break;
				}
				$('#address_NOR').prop('checked', $currentSelected.ReceiveNotification),
					$('#address_NOS').prop('checked', $currentSelected.SendNotification);
			}
			else {
				$("#ModalAddressType").val($("#ModalAddressType option:first").val());
			}
			$(".selectChange").change();
		},
		save: function (e) {
			mapUserProfileInModel();
			if (!e) {
				mapAddressInModel();
			}

		}
		/* End Logic */
	};

	$.fileFormat = {
		init: function (e) {
			/*Btn Action*/
			$.fileFormat.applyButtonClickHandler($('#applyClose-profileFileFormat'));
		},

		/*Btn Action*/
		applyButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$.fileFormat.save();
			});
		},
		resetButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$.fileFormat.reset();
			});
		},
		/*End Btn Action*/
		/* Logic */
		reset: function (e) {
			$("#modalFileFormat").modal('show');

			$("#formModalFileFormat").trigger("reset");
			$("#formModalFileFormat").validate().resetForm();
		},
		save: function (e) {
			var fileType = "PDF";
			if ($('#contactaddress_Format').bootstrapSwitch('state') == false) {
				fileType = "TIF";
			}

			var grid = $(".grid-profile").data("kendoGrid");
			var selectedItem = grid.select();

			for (i = 0; i < selectedItem.length; i++) {
				for (j = 0; j < grid.dataSource.data().length; j++) {
					var gridSource = grid.dataSource.at(j);
					if (gridSource.uid == selectedItem[i].dataset.uid) {
						switch (Number(gridSource.AddressTypeId)) {
							case 1: /*email*/
							case 3: /*http*/
							case 4: /*ftp*/
							case 5: /*file*/
								gridSource.Format = fileType.toUpperCase();
								break;
						}
					}
				}
			}

			$.profile.rebindPrimaryAddress();
			$('#profile').data('kendoGrid').refresh();
			$.toast({
				text: $globalMessages.toast.updatedManualSave,
				position: 'bottom-right',
				loaderBg: '#ff6849',
				loader: false,
				icon: 'info',
				hideAfter: 5000,
				stack: 6
			});

			$("#modalFileFormat").modal('hide');
		}
		/* End Logic */
	};

	$.mfpSync = {
		init: function (e) {
			this.saveButtonClickHandler($('#applyClose-profileMFPSync'));
			this.validation();
		},
		validation: function () {
			$("#formModalMFPSync").find('input').on("keypress", function (e) {
				if (e.which === 13) { // Enter key
					e.preventDefault();
					return false;
				}
			});

			$("#formModalMFPSync").validate({
				ignoreTitle: true,
				rules: {
					mfpSync_ID: {
						noSpace: true
					}
				},
				errorPlacement: function (error, element) {
					var p = element.parent('span').parent();
					if (p.hasClass('form-control')) {
						error.appendTo(p);
					} else {
						error.insertAfter(element);
					}
				}
			});
		},

		/* Btn Action */
		saveButtonClickHandler: function (e) {
			$(e).on('click', function () {
				if ($('#formModalMFPSync').valid()) {
					$.mfpSync.save();
				}
			});
		},
		/* End Btn Action */

		/* Logic */
		save: function (e) {
			$userProfileData.MFPSyncID = $('#mfpSync_ID').val()

			fxcRequest.post("/admin/manage/profile/updateMFPSync",
				{
					MFPSyncID: $userProfileData.MFPSyncID,
					Username: $userProfileData.Username
				},
				function (data) {
					/* Update main form value */
					$('#MFPSyncID').val($userProfileData.MFPSyncID);
					$('#modalMFPSync').modal('hide');
				}, null, false);
		}
		/* End Logic */
	};

})(window.jQuery);