﻿(function ($) {
	var setIsRtl = $("html[dir]").attr("dir") === "rtl" ? true : false;
    var tour = {
        id: "admin-network-faxagent-dialingrules-hopscotch",
        steps: [
            {
                target: "IntlDialPrefix",
                title: "",
                content: $faxAgentResource.uiGuide.dialPrefix,
                placement: "top",
				yOffset: "3",
				isRtl: setIsRtl
            },
            {
                target: "btn-save-DialingRules",
                title: "",
                content: $globalMessages.uiGuide.buttonSaveChanges,
                placement: "bottom",
                arrowOffset: "250",
                xOffset: "-256",
				yOffset: "-2",
				isRtl: setIsRtl
            },
            {
                target: "btn-reset-DialingRules",
                title: "",
                content: $globalMessages.uiGuide.buttonResetChanges,
                placement: "bottom",
                fixedElement: true,
                arrowOffset: "250",
                xOffset: "-256",
				yOffset: "-2",
				isRtl: setIsRtl
            },
            {
                target: "button.btn-create-DialingRules",
                title: "",
                content: $globalMessages.uiGuide.buttonNew,
                placement: "bottom",
                fixedElement: true,
                xOffset: "18",
				yOffset: "-3",
				isRtl: setIsRtl
            },
            {
                target: "action-delete-DialingRules",
                title: "",
                content: $globalMessages.uiGuide.buttonDelete,
                placement: "bottom",
                fixedElement: true,
                xOffset: "-12",
				yOffset: "-3",
				isRtl: setIsRtl
            },
            {
                target: "action-refresh-DialingRules",
                title: "",
                content: $globalMessages.uiGuide.buttonRefresh,
                placement: "bottom",
                fixedElement: true,
                xOffset: "-12",
				yOffset: "-3",
				isRtl: setIsRtl
            }, 
            {
                target: "action-import-rule",
                title: "",
                content: $faxAgentResource.uiGuide.importRules,
                placement: "bottom",
                fixedElement: true,
                xOffset: "-12",
				yOffset: "-3",
				isRtl: setIsRtl
            },
            {
                target: "action-export-rule",
                title: "",
                content: $faxAgentResource.uiGuide.exportRules,
                placement: "bottom",
                fixedElement: true,
                xOffset: "-12",
				yOffset: "-3",
				isRtl: setIsRtl
            },
            {
                target: "searchBox-DialingRules",
                title: "",
                content: $globalMessages.uiGuide.buttonSearch,
                placement: "left",
                fixedElement: true,
                yOffset: "-12",
				xOffset: "2",
				isRtl: setIsRtl
            }
        ],
        showPrevButton: true,
        onPrev: function () {
            if (hopscotch.isActive)
                $.sharedUiGuide.scrollToFixedPlacementTarget(hopscotch.getCurrTour(), hopscotch.getCurrStepNum(), hopscotch.getCurrTarget());
        },
        onNext: function () {
            if (hopscotch.isActive)
                $.sharedUiGuide.scrollToFixedPlacementTarget(hopscotch.getCurrTour(), hopscotch.getCurrStepNum(), hopscotch.getCurrTarget());
        }
    };
    $.faxAgentDialingRulesUiGuide = {
        init: function (tourBtn) {
            $.sharedUiGuide.init({ startTourBtn: tourBtn, tour: tour });
        }
    };
})(window.jQuery);