﻿(function ($) {
    $.faxAgent = {
        init:function(e)
        {
            $.faxAgent.deleteButtonClickHandler($('.faxcoreBreadcrumbBtn .btn-remove'));
            $.faxAgent.resetTabButtonClickHandler($('#FaxAgentList_Value'));
            $.faxAgent.tabButtonClickHandler($('a[data-bs-toggle="tab"]'));
            $.faxAgent.getFaxAgentList();
        },
        resetForm: function (target) {
            var agent = $('#FaxAgentList_Value').val();
            if (agent !== null) {
                switch (target) {
                    case "#ConfigurationTab":
                        $.faxAgent_configuration.initForm();
                        break;
                    case "#PortsTab":
                        $.faxAgent_ports.initGrid();
                        break;
                    case "#DialingRulesTab":
                        $.faxAgent_dialingRules.initForm();
                        $.faxAgent_dialingRules.initGrid();
                        break;
                    case "#AgentMonitorTab":
                        $.faxAgent_agentMonitor.initGrid();
                        break;
                    case "#PortsGroupTab":
                        $.faxAgent_portsGroup.initGrid();
                        break;
                    case "#LicensePortsTab":
                        $.faxAgent_licensePorts.initListView();
                        break;
                    case "#AgentGroupTab":
                        $.faxAgent_agentGroup.initForm();
                        break;
                    default:
                        break;
                }
            }            
        },

        /* BTN Handler */
        deleteButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$(this).blur();
				$.faxAgent.delete();
            });
        },
        resetTabButtonClickHandler: function (e) {
            $(e).change(function () {
                var target = $('.nav-link.active').prop('hash');
                $.faxAgent.resetForm(target);
            });
        },
        tabButtonClickHandler: function (e) {
            $(e).on('shown.bs.tab', function (h) {
              var target = $(h.target).attr("href"); /* activated tab*/
                $.faxAgent.resetForm(target);
            });
        },
        getAgentId: function (e) {
            return $('#FaxAgentList_Value').val();
        },
        /* Post or Get Request */
        getFaxAgentList: function (e) {
            fxcRequest.get('/Admin/FaxAgent/FaxAgentList', null,
                function (data) {
					swal.close();
                    var fa = data.FaxAgentList;
                    if (fa !== null && fa.Source.length > 0) {
                        $.sectionproperties.selectGenerator("FaxAgentList_Value", fa.Source, fa.Value);
                        var target = $('.nav-link.active').prop('hash');
                        $.faxAgent.resetForm(target);
                    } else {
                        var errormsg = $faxAgentResource.alert.noFaxAgent;
                        $invalid.renderPage(errormsg, '');
                    }
                },
                function () {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOccured, "error");
                }, true);
        },
		delete: function (e) {
			swal({
				title: "",
				text: $faxAgentResource.alert.deleteFaxAgent,
				type: "info",
				showCancelButton: true,
				closeOnConfirm: false,
				reverseButtons: true,
				showLoaderOnConfirm: true
			}, function () {
				var deletedAgentId = $('#FaxAgentList_Value').val();
				fxcRequest.post('/Admin/FaxAgent/DeleteFaxAgent',
					{ "AgentID": $('#FaxAgentList_Value').val() },
					function (data) {
						swal({
						  title: $globalMessages.swal.success.title,
						  text: $globalMessages.swal.success.delete,
						  type: "success"
						}, function () {
						  $.faxAgent.getFaxAgentList();
						$('#delete-modal').modal('hide');
						});

						
					},
					function (error) {
						swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
					});
				});
        }
    };
})(window.jQuery);