﻿(function ($) {
    var agentGroupValidation = function () {
      $('#formSubmit-agentGroup').validate({
        rules: {

        },
        messages: {

        },
        submitHandler: function (form) {
          $.faxAgent_agentGroup.save();
        }
      });
    };
    $.faxAgent_agentGroup = {
        init: function (e) {
            /*Form*/
            $.faxAgent_agentGroup.resetFormButtonClickHandler($('#btn-reset-AgentGroup'));
            $.faxAgent_agentGroup.saveButtonClickHandler($('#btn-save-AgentGroup'));
            agentGroupValidation();
        },
        initForm: function (e) {
            fxcRequest.get('/Admin/FaxAgentGroup/Read',
            {
                "AgentID": $('#FaxAgentList_Value').val()
            },
            function (data) {
                $.faxAgent_agentGroup.resetFields(data);
            },
            function (error) {
                console.log(error);
            });
        },

        /*Btn Action*/
        resetFormButtonClickHandler: function (e) {
            $(e).on('click', function () {
				$(this).blur();
                $.faxAgent_agentGroup.initForm();
            });
        },
        saveButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $('#formSubmit-agentGroup').submit();
            });
        },

        /*Logic */
        resetFields: function (obj) {
            $('#formSubmit-agentGroup').trigger("reset");
            $('#formSubmit-agentGroup').validate().resetForm();
            if (obj != null) {
                $('#AgentGroupDiv').html('');

                $.each(obj.AgentGroupList.Source, function (i, l) {

                    var agentId = obj.AgentGroupList.Source[i].AgentID;
                    var isChecked;
                    if (obj.AgentGroupList.Source[i].InGroup === true) {
                        isChecked = 'checked="checked"';
                    }
                    else {
                        isChecked = '';
                    }

                    var Counter = i + 1;
                    var html = '<div class="row">';
                    html += '   <div class="col-md-12">';
                    html += '       <div class="form-group row">';
                    html += '           <div class="col-md-2 agentGroupLabel custom-right control-label-bold">' + Counter + '.';
                    html += '           </div>';
                    html += '           <div class="col-md-9 agentGroupList">';
                    html += '               <div class="demo-checkbox">';
                    html += '                   <input name="agentId" type="hidden" value="' + agentId + '"  />';
                    html += '                   <input id="InGroup_' + agentId + '_IsSet"  name="InGroup' + agentId + '.IsSet" class="filled-in chk-col-blue" type="checkbox"' + isChecked + '/>';
                    html += '                   <label for="InGroup_' + agentId + '_IsSet">' + obj.AgentGroupList.Source[i].ServerName + ' (' + agentId + ')' + '</label>';
                    html += '                </div>';
                    html += '            </div>';
                    html += '            <div class="col-md-1">';
                    html += '            </div>';
                    html += '        </div>';
                    html += '    </div>';
                    html += '</div>';

                    $('#AgentGroupDiv').append(html);
                });
            }
        },

        /* Post or Get Request */
        save: function () {
            var array = new Array();
            form = $('form[id = "formSubmit-agentGroup"]');
            var value = $('#AgentGroupDiv input[type="checkbox"]');
            var agent = $('#AgentGroupDiv input[type="hidden"]');

            $.each(value, function (i, l) {
              var d = value[i];
              var agentid = agent[i];
                var checked = $(d).prop("checked");
                var agentId = $(agentid).val();

              object = { "InGroup": checked, "AgentID": agentId };
                array[i] = object;
            });

            fxcRequest.post('/Admin/FaxAgentGroup/Save',
                {
                    "AgentID": $('#FaxAgentList_Value').val(),
                    "AgentGroupList":
                    {
                        "IsSet": '',
                        "Source": array,
                        "Value": ''
                    }
                },
                function (data) {
                    $.faxAgent_agentGroup.initForm();
                    swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");
                },
                function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
                });
        }
    };
})(window.jQuery);
