﻿(function ($) {
    var $grid;
    $.faxAgent_agentMonitor = {
        init: function (e) {
            $.faxAgent_agentMonitor.refreshButtonClickHandler($(".btn-refresh-AgentMonitor"));
            $.faxAgent_agentMonitor.searchPressEnter($('input[data-role="search-AgentMonitor-detail"]'));
            $.faxAgent_agentMonitor.searchButtonClickHandler($('.btn-search-AgentMonitor'));
        },
        initGrid: function (e) {
            var id = $('.grid-AgentMonitor');
            var dataSource = {
                transport: {
                    read: {
                        url: '/Admin/FaxAgentMonitor/Read',
                        dataType: "json",
                        type: "GET"
                    },
                    parameterMap: function (options) {
                        /* Fix url param for sort values */
                        var result = {
                            Skip: options.skip,
                            Take: options.take,
                            AgentID: $('#FaxAgentList_Value').val()
                        };
                        if (options.sort && options.sort.length > 0) {
                            result.SortBy = options.sort[0].field;
                            result.Direction = options.sort[0].dir;
                        }
                        return result;
                    }
                },
                schema: {
                    data: "Records",
                    total: "Total",
                    model: {
                        id: "Id"
                    }
                },
                serverPaging: false,
                serverSorting: false
            };

            var col = [
                { field: 'ChannelID', hidden: true },
                { field: 'ModuleNo', title: $faxAgentResource.field.module, sortable: true, width: 200 },
                { field: 'PortNo', title: $faxAgentResource.field.ports, type:"number", sortable: true, width: 200  },
                { field: 'PortStatus', title: $faxAgentResource.field.status, sortable: true, width: 200  },
                { field: 'ConnectSpeed', title: $faxAgentResource.field.connectSpeed, type: "number", sortable: true, width: 200  },
                { field: 'ConnectTime', title: $faxAgentResource.field.connectTime, type: "number", sortable: true, width: 200  },
                { field: 'RemoteCSID', title: $faxAgentResource.field.remoteCSID, sortable: true, width: 200  },
                { field: 'CurrentPage', title: $faxAgentResource.field.currentPage, type: "number", sortable: true, width: 200  }
            ];

            var obj = {};
            obj.disablePageable = true;
            var $grid = kendogridcustomization.init(id, dataSource, col, obj);
        },

        /*Btn Action*/
        refreshButtonClickHandler: function (e) {
            $(e).on('click', function (x) {
                $.faxAgent_agentMonitor.refresh();
                $(this).blur();
            });
        },
        searchButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.faxAgent_agentMonitor.search(e);
            });
        },
        searchPressEnter: function (e) {
            $(e).on('keypress', function (enter) {
                if (enter.which === 13) {
                    $.faxAgent_agentMonitor.search(e);
                }
            });
        },

        /* Logic */
        refresh: function (e) {
            $('input[data-role="search-AgentMonitor-detail"]').val("");
            $.faxAgent_agentMonitor.initGrid();
        },
        search: function (e) {
            var val = $('input[data-role="search-AgentMonitor-detail"]').val()!= null ? $('input[data-role="search-AgentMonitor-detail"]').val().trim(): "";
            var grid = $(".grid-AgentMonitor").data("kendoGrid");

            if (val) {
              var filters = [];

              $.each(grid.options.columns, function (index, value) {

                var checkCellEnabled = typeof value.filterable === 'undefined' ? true : value.filterable.cell.enabled;
                var checkCellType = value.type === 'number' ? "eq" : "contains";
                if (!value.hidden && checkCellEnabled) {
                  var filter = {
                    field: value.field,
                    operator: checkCellType,
                    value: val
                  };
                  filters.push(filter);
                }
              });
                grid.dataSource.filter({
                    logic: "or",
                    filters: filters
                });
            }
            else {
                grid.dataSource.filter({
                    logic: "or",
                    filters: []
                });
            }
        }
    };
})(window.jQuery);
