﻿(function ($) {
    var configurationValidation = function () {
      $('#formSubmit-configuration').validate({
        rules: {
          "ServerIP.Value": {
            required: true,
            IPAddress: true
          },
          "CountryCode.Value": {
            number: true
          },
          "AreaCode.Value": {
            number: true
          }
        },
        submitHandler: function (form) {
          $.faxAgent_configuration.save();
        }
      });
    };
    $.faxAgent_configuration = {
        init: function (e) {
            /*Form*/
            $.faxAgent_configuration.resetFormButtonClickHandler($('#btn-reset-Configuration'));
            $.faxAgent_configuration.saveFormButtonClickHandler($('#btn-save-Configuration'));

            configurationValidation();
        },
        initForm: function () {
            swal({
                title: $globalMessages.swal.loader.title,
                text: $globalMessages.swal.loader.text,
                imageUrl: '/Content/img/ajax-loading2.gif',
                showConfirmButton: false,
                closeOnClickOutside: false,
                allowEscapeKey: false,
            });
            fxcRequest.get('/Admin/FaxAgentConfiguration/Read',
                { "AgentID": $('#FaxAgentList_Value').val() },
                function (data) {
                    $.faxAgent_configuration.resetFields(data);
                    swal.close();
                },

                function (error) {
                    swal.close();
                    /*console.log(error);*/
                });
        },
        /* BTN Action */
        resetFormButtonClickHandler: function(e){
            $(e).on('click', function () {
				$(this).blur();
                $.faxAgent_configuration.initForm();
            });
        },
        saveFormButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $('#formSubmit-configuration').submit();
            });
        },

        /*Logic*/
        resetFields: function (obj) {
            $('#formSubmit-configuration').trigger("reset");
            $('#formSubmit-configuration').validate().resetForm();
            if (obj) {
                $("#ServerName_Value").val(obj.ServerName.Value);
                $("#ServerIP_Value").val(obj.ServerIP.Value);
                $("#ServerLabel_Value").val(obj.ServerLabel.Value);
                $("#FaxDriverType_Value").val(obj.FaxDriverType.Value);
                $("#ServicePath_Value").val(obj.ServicePath.Value);
                $("#ConfigurationPath_Value").val(obj.ConfigurationPath.Value);
                $("#CountryCode_Value").val(obj.CountryCode.Value);
                $("#AreaCode_Value").val(obj.AreaCode.Value);

                var status = obj.IsActive.IsSet == "True" ? "Running" : "Stopped";
                $("#Status_Value").val(status);
                $("#NumPorts_Value").val(obj.NumPorts.Value);
                $("#FaxNumberPooling_IsSet").prop('checked', function (n, c) {
                  if (obj.IsFaxPoolingOn.IsSet.toLowerCase() === "true") {
                    return true;
                  }
                  else
                    return false;
                });
            }
        },

        /* Post or Get Request */        
        save: function () {
            fxcRequest.post('/Admin/FaxAgentConfiguration/Save',
                {
                    "AgentID": $('#FaxAgentList_Value').val(),
                    "ServerLabel": {
                        "IsSet": '',
                        "Source": '',
                        "Value": $("#ServerLabel_Value").val()
                    },
                    "ServerIP": {
                        "IsSet": '',
                        "Source": '',
                        "Value": $('#ServerIP_Value').val()
                    },
                    "CountryCode": {
                        "IsSet": '',
                        "Source": '',
                        "Value": $('#CountryCode_Value').val()
                    },
                    "AreaCode": {
                        "IsSet": '',
                        "Source": '',
                        "Value": $('#AreaCode_Value').val()
                    },
                    "IsFaxPoolingOn": {
                        "IsSet": $('#FaxNumberPooling_IsSet').prop('checked')
                    }
                },
                function (data) {
                    $.faxAgent_configuration.initForm();
                    swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");
                }, function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
                });
        }
    };
})(window.jQuery);
