﻿(function ($) {
    var setGrid = true;
    var $grid, movetorowId;
    var dialingRulesValidation = function () {
        $('#formSubmit-dialingrules').validate({
			ignoreTitle: true,
            rules: {
            },
            submitHandler: function (form) {
                $.faxAgent_dialingRules.save();
            }
        });
        $('#formSubmit-newrules').validate({
			ignoreTitle: true,
            rules: {
                DialString: {
                    required: true, noSpace:true
                }
            },
            messages: {
                DialString: {
                    required: $faxAgentResource.requiredMsg
                }
            },
            submitHandler: function (form) {
                $.faxAgent_dialingRules.saveNewRule();
            }
        });

        $("#formSubmit-swapRow").validate({
            rules: {
                txtMoveToRow: {
                    required: true, noSpace:true
                }
            },
            submitHandler: function (form) {
                $.faxAgent_dialingRules.saveSwapRule();
            }
        });
    };
    $.faxAgent_dialingRules = {
        init: function (e) {
            /*Form*/
            $.faxAgent_dialingRules.resetFormButtonClickHandler($('#btn-reset-DialingRules'));
            $.faxAgent_dialingRules.saveFormButtonClickHandler($('#btn-save-DialingRules'));

            /*Grid*/
            $.faxAgent_dialingRules.createButtonClickHandler($(".btn-create-DialingRules"));
            $.faxAgent_dialingRules.deleteButtonClickHandler($(".btn-delete-DialingRules"));
            $.faxAgent_dialingRules.exportButtonClickHandler($(".btn-exportRule-DialingRules"));
            $.faxAgent_dialingRules.importButtonClickHandler($(".btn-importRule-DialingRules"));
            $.faxAgent_dialingRules.refreshButtonClickHandler($(".btn-refresh-DialingRules"));
            $.faxAgent_dialingRules.searchPressEnter($('input[data-role="search-DialingRules-detail"]'));
            $.faxAgent_dialingRules.searchButtonClickHandler($('.btn-search-DialingRules'));

            /*Validation*/
            dialingRulesValidation();

            /*Init New Dial String*/
            $.faxagent_newDialingRules.init();

            /*Init Import Dial String*/
            $.faxagent_importDialingRules.init();
        },
        initGrid: function (e) {
            var id = $('.grid-DialingRules');
            var dataSource = {
                transport: {
                    read: {
                        url: '/Admin/FaxAgentDialingRules/CustomDialRules',
                        dataType: "json",
                        type: "GET"
                    },
                    parameterMap: function (options) {
                        /* Fix url param for sort values */
                        var result = {
                            AgentID: $('#FaxAgentList_Value').val()
                        };
                        return result;
                    }
                },
                schema: {
                    data: "Records",
                    total: "Total",
                    model: {
                        id: "Id"
                    }
                },
                serverPaging: false,
                serverSorting: false
            };
            var col = [
                {
                    selectable: true, width: 45,
                    filterable: {
                        cell: {
                            enabled: false
                        }
                    },
                    attributes: {
                        "class": "checkboxSelection"
                    }
                },
                {
                    field: 'Id',
                    hidden: true
                },
                {
                    attributes: {
                        "class": "disabledClickableRow"
                    },
                    width: 60,
                    sortable: false,
                    filterable: {
                        cell: {
                            enabled: false
                        }
                    },
                    template: function (dataRow) {
                        var result = '<div class="k-move-up-row"><a class="grid-navIcon text-green-color nav-link waves-effect moveUp" data-id="' + dataRow.Id + '" id="moveUp-' + dataRow.Id + '" href="javascript:void(0)"><i class="mdi mdi-arrow-up-bold"></i></a>';
                        return result;
                    }
                },
                {
                    attributes: {
                        "class": "disabledClickableRow"
                    },
                    width: 60,
                    sortable: false,
                    filterable: {
                        cell: {
                            enabled: false
                        }
                    },
                    template: function (dataRow) {
                        var result = '<div class="k-move-down-row"><a class="grid-navIcon text-blue-color nav-link waves-effect moveDown" data-id="' + dataRow.Id + '" id="moveDown-' + dataRow.Id + '" href="javascript:void(0)"><i class="mdi mdi-arrow-down-bold"></i></a>';
                        return result;
                    }
                },
                {
                    attributes: {
                        "class": "disabledClickableRow"
                    },
                    width: 60,
                    sortable: false,
                    filterable: {
                        cell: {
                            enabled: false
                        }
                    },
                    template: function (dataRow) {
                        var result = '<div class="k-move-swap-row"><a class="grid-navIcon text-blue-color nav-link waves-effect moveSwap" data-id="' + dataRow.Id + '" id="moveSwap-' + dataRow.Id + '" href="javascript:void(0)"><i class="mdi mdi-swap-vertical"></i></a>';
                        return result;
                    }
                },
                {
                    field: 'Seq',
					width: 100,
                    title: $faxAgentResource.field.seq,
                    type: 'number',
                    sortable: true
                },
                {
                    field: 'DialString',
					width: 300,
                    title: $faxAgentResource.field.dialString,
                    sortable: true
                },
                {
                    field: 'ReplaceWith',
					width: 250,
                    title: $faxAgentResource.field.replaceWith,
                    sortable: true
                },
                {
                    field: 'AppendWith',
					width: 250,
                    title: $faxAgentResource.field.appendWith,
                    sortable: true
                },
                {
                    attributes: {
                        "class": "checkboxSelection"
                    },
                    field: "IsActive",
                    title: $faxAgentResource.field.active,
                    filterable: {
                        cell: {
                            enabled: false
                        }
                    },
                    width: 100,
                    template: '<div class="custom-checkbox"><input class="k-checkbox-custom rrf" #= IsActive == true ? \'checked="checked"\' : "" # data-role="checkbox" data-id="#= IsActive #" id="IsActive-#= Id #" type="checkbox"> '
                    + '     <label for="IsActive-#= Id #" class="k-checkbox-custom-label k-no-text"></label></div>'
                }
            ];

            var obj = {};
            obj.allowSelectMultipleRow = true;
            obj.customizeCheckbox = true;
            obj.customizeCheckboxFn = $.faxAgent_dialingRules.gridChecboxActionHandler;
            obj.totalInputType = "#TotalGrid-DialingRules";
            /*obj.onSelectionFn = $.faxagent_ports.editHandler;*/

            var $grid = kendogridcustomization.init(id, dataSource, col, obj);
            if (setGrid)
            {
                $.faxAgent_dialingRules.moveDialClickHandler();
                setGrid = false;
            }
        },

        /* BTN Action */
        createButtonClickHandler: function (e) {
            $(e).on('click', function (x) {
                $("#newDialString-modal").modal("show");
                $.faxagent_newDialingRules.resetFields();
            });
        },
        deleteButtonClickHandler: function (e) {
            $(e).on('click', function (x) {
				$(this).blur();
                $.faxAgent_dialingRules.delete();
            });
        },
        exportButtonClickHandler: function (e) {
            $(e).on('click', function (x) {
                $.faxAgent_dialingRules.export();
            });
        },
        importButtonClickHandler: function (e) {
            $(e).on('click', function (x) {
                $("#importDialString-modal").modal("show");
                $.faxagent_importDialingRules.resetFields();
            });
        },
        moveDialClickHandler: function (e) {
            /*Move Up Click Handler*/
            $(".grid-DialingRules tbody").on("click", "a.moveUp", function (e) {
                var tr = $(e.target).closest("tr");
                var row = $(".grid-DialingRules").data("kendoGrid").dataItem(tr);
                if (row != null) {
                    $.faxAgent_dialingRules.moveDial(row.Id, '2', null);
                }
            });

            $(".grid-DialingRules tbody").on("click", "a.moveDown", function (e) {
                var tr = $(e.target).closest("tr");
                var row = $(".grid-DialingRules").data("kendoGrid").dataItem(tr);
                if (row != null) {
                    $.faxAgent_dialingRules.moveDial(row.Id, '1', null);
                }
            });

            $(".grid-DialingRules tbody").on("click", "a.moveSwap", function (e) {
                var tr = $(e.target).closest("tr");
                var row = $(".grid-DialingRules").data("kendoGrid").dataItem(tr);
                if (row != null) {
                    $("#swapRow-Modal").modal("show");
                    $('#formSubmit-swapRow').trigger("reset");
                    $('#formSubmit-swapRow').validate().resetForm();
                    var countGrid = $("#TotalGrid-DialingRules").val();
                    var labelText = $faxAgentResource.enterSeq + countGrid + " :";
                    $("label[for='txtMoveToRow']").text(labelText);
                    $("#txtMoveToRow").attr("min", 1);
                    $("#txtMoveToRow").attr("max", countGrid);
                    $("#txtMoveToRowId").val(row.Id);
                }
            });
        },
        refreshButtonClickHandler: function (e) {
            $(e).on('click', function (x) {
                $.faxAgent_dialingRules.refresh();
                $(this).blur();
            });
        },
        resetFormButtonClickHandler: function (e) {
            $(e).on('click', function () {
				$(this).blur();
                $.faxAgent_dialingRules.initForm();
            });
        },
        saveFormButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $('#formSubmit-dialingrules').submit();
            });
        },
        searchButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.faxAgent_dialingRules.search(e);
            });
        },
        searchPressEnter: function (e) {
            $(e).on('keypress', function (enter) {
                if (enter.which === 13) {
                    $.faxAgent_dialingRules.search(e);
                }
            });
        },
        /* END BTN Action */
        
        /*Logic*/
        getGridSelections: function (event) {
            var entityGrid = event.data("kendoGrid");
            var rows = entityGrid.select();
            var $selectedItem = [];
            rows.each(function (index, row) {
                var selectedItem = entityGrid.dataItem(row);
                $selectedItem[index] = selectedItem.Id;
            });

            return $selectedItem;
        },
        refresh: function (e) {
            $("#searchBox-DialingRules").val("");
            $.faxAgent_dialingRules.initGrid();
        },
        resetFields: function (obj) {
            $('#formSubmit-dialingrules').trigger("reset");
            $('#formSubmit-dialingrules').validate().resetForm();
            if (obj != null) {
                $('#IntlDialPrefix').val(obj.IntlDialPrefix);
                $('#DomesticDialPrefix').val(obj.DomesticDialPrefix);
                $('#CustomDialPrefix').val(obj.CustomDialPrefix);
                $('#RawDialPrefix').val(obj.RawDialPrefix);

                $('#IntlDialSuffix').val(obj.IntlDialSuffix);
                $('#DomesticDialSuffix').val(obj.DomesticDialSuffix);
                $('#CustomDialSuffix').val(obj.CustomDialSuffix);
                $('#RawDialSuffix').val(obj.RawDialSuffix);
            }
        },
        saveSwapRule: function () {
            var moveTo = $('#txtMoveToRow').val();
            var rowId = $('#txtMoveToRowId').val();
            $('#swapRow-Modal').modal('hide');
            $.faxAgent_dialingRules.moveDial(rowId, '3', moveTo);            
        },
        search: function (e) {
            var val = $("#searchBox-DialingRules").val() != null ? $("#searchBox-DialingRules").val().trim() : "";
            var grid = $(".grid-DialingRules").data("kendoGrid");

            if (val) {
              var filters = [];

              $.each(grid.options.columns, function (index, value) {

                var checkCellEnabled = typeof value.filterable === 'undefined' ? true : value.filterable.cell.enabled;
                var checkCellType = value.type === 'number' ? "eq" : "contains";
                if (!value.hidden && checkCellEnabled) {
                  var filter = {
                    field: value.field,
                    operator: checkCellType,
                    value: val
                  };
                  filters.push(filter);
                }
              });
                grid.dataSource.filter({
                    logic: "or",
                    filters: filters
                });
            }
            else {
                grid.dataSource.filter({
                    logic: "or",
                    filters: []
                });
            }
        },
        /* End Logic */

        /*Post or Get Function*/
        delete: function (e) {
            var selectedItem = $.faxAgent_dialingRules.getGridSelections($(".grid-DialingRules"));

            if (selectedItem.length === 0) {
                swal("", $faxAgentResource.swal.noDialString);
                return false;
            }

            swal({
                title: "",
                text: $faxAgentResource.swal.delDialString,
                type: "info",
                showCancelButton: true,
                closeOnConfirm: false,
                reverseButtons: true,
                showLoaderOnConfirm: true
            }, function () {
                fxcRequest.post('/Admin/FaxAgentDialingRules/DeleteDial',
                    { Ids: selectedItem.join().split(',') },
                    function (data) {
                        swal($globalMessages.swal.done, $faxAgentResource.swal.successDialString, "success");
                        $.faxAgent_dialingRules.refresh();
                    }, function () {
                        swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnDelete, "error");
                    }, true);
            });
        },
        export:function(e){
            var winPopup;
            var url = "/admin/FaxAgentDialingRules/exportcustomdial/?aid=" + $('#FaxAgentList_Value').val();
            var name = "ExportCustomDial";

            var features = 'status=no,menubar=no,location=no,resizable=yes,width=300px,height=300px,scrollbars=yes,toolbar=no';
            winPopup = window.open(url, name, features);

            winPopup.focus();
        },
        gridChecboxActionHandler: function (dataItem, e) {
            fxcRequest.post('/Admin/FaxAgentDialingRules/UpdateCheckBox',
                { "CustomID": dataItem.Id, "IsActive": dataItem.IsActive },
                function (data) {
                    $.toast({
                        heading: $globalMessages.toast.success,
                        text: $faxAgentResource.dialStringTableUpdated,
                        position: 'bottom-right',
                        loaderBg: '#ff6849',
                        icon: 'success',
                        hideAfter: 3500,
                        stack: 6
                    });
                    $.faxAgent_dialingRules.refresh();
                },
                function (error) {
                    alert($globalMessages.swal.error.errorOnSubmit);
                }, false);

        },
        initForm: function () {
            fxcRequest.get('/Admin/FaxAgentDialingRules/ReloadDial',
                { "AgentID": $('#FaxAgentList_Value').val() },
                function (data) {
                    $.faxAgent_dialingRules.resetFields(data.DialingRule);
                },
                function (error) {
                    /*console.log(error);*/
                });
        },
        moveDial: function (customID, command, rowNumber) {
            fxcRequest.post('/Admin/FaxAgentDialingRules/MoveDial', {
                        "CustomID": customID,
                        "Command": command,
                        "RowNumber": rowNumber
                    },
                    function (data) {
                        $.toast({
                            heading: $globalMessages.toast.success,
                            text: $faxAgentResource.dialStringTableUpdated,
                            position: 'bottom-right',
                            loaderBg: '#ff6849',
                            icon: 'success',
                            hideAfter: 3500,
                            stack: 6
                        });

                        $.faxAgent_dialingRules.refresh();
                    },
                    function (error) {
                        swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnMove, "error");
                    }, false);            
        },
        save: function () {
            fxcRequest.post('/Admin/FaxAgentDialingRules/SaveDial',
                {
                    "DialingRule": {
                        "IntlDialPrefix": $('#IntlDialPrefix').val(),
                        "DomesticDialPrefix": $('#DomesticDialPrefix').val(),
                        "CustomDialPrefix": $('#CustomDialPrefix').val(),
                        "RawDialPrefix": $('#RawDialPrefix').val(),

                        "IntlDialSuffix": $('#IntlDialSuffix').val(),
                        "DomesticDialSuffix": $('#DomesticDialSuffix').val(),
                        "CustomDialSuffix": $('#CustomDialSuffix').val(),
                        "RawDialSuffix": $('#RawDialSuffix').val()
                    },
                    "AgentID": $('#FaxAgentList_Value').val()
                },
                function (data) {
                    swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");
                    $.faxagent_configuration.initForm();
                },
                function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
                });
        }
    };

    var newDialingRulesValidation = function () {        
        $("#formSubmit-newDialString").validate({
            rules: {
                DialString: {
                    required: true
                }
            },
            submitHandler: function (form) {
                $.faxagent_newDialingRules.save();
            }
        });
    };
    $.faxagent_newDialingRules = {
        init: function (e) {
            /*Form*/
            $.faxagent_newDialingRules.resetFormButtonClickHandler($('#BtnResetNewDialString'));
            $.faxagent_newDialingRules.saveclosemodalHandler($("#BtnSaveCloseNewDialString"));
            /*Validation*/
            newDialingRulesValidation();
        },

        /*Logic*/
        resetFields: function (obj) {
            $('#formSubmit-newDialString').trigger("reset");
            $('#formSubmit-newDialString').validate().resetForm();
        },
        /* End Logic */

        /* BTN Action */
        resetFormButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.faxagent_newDialingRules.resetFields();
            });
        },
        saveclosemodalHandler: function (e) {
            $(e).on('click', function () {
                $('input[name="newDialingrules-modal-action"]').val('save & close');
            });
        },

        /*Post or Get Function*/
        save: function () {
            var formData = JSON.stringify($("#formSubmit-newDialString").serializeArray());

            fxcRequest.post('/Admin/FaxAgentDialingRules/SaveNewRule'
                , { "FormData": formData, "AgentID": $('#FaxAgentList_Value').val() }
                , function (data) {
                    $.faxAgent_dialingRules.initGrid();
                    if ($('input[name="newDialingrules-modal-action"]').val() === 'save & close') {
                        $("#newDialString-modal").modal("hide");
                    }
                    $('input[name="newDialingrules-modal-action"]').val('');
					$.toast({
                        heading: $globalMessages.toast.success,
                        text: $faxAgentResource.dialStringTableUpdated,
                        position: 'bottom-right',
                        loaderBg: '#ff6849',
                        icon: 'success',
                        hideAfter: 3500,
                        stack: 6
                    });
                }
                , function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
                },false);
        }
    };

    var importDialingRulesValidation = function () {
        $("#formSubmit-importDialString").validate({
            rules: {
                "ImportFxAgntSelectItem.Value": {
                    required: true
                },
                ImportDR: {
                    required: true
                }
            },
            submitHandler: function (form) {
                $.faxagent_importDialingRules.save();
            }
        });
    };
    $.faxagent_importDialingRules = {
        init: function (e) {
            /*Form*/
            /*Validation*/
            importDialingRulesValidation();
        },


        /*Logic*/
        resetFields: function (obj) {
            $('#formSubmit-importDialString').trigger("reset");
            $('#formSubmit-importDialString').validate().resetForm();
            $.faxagent_importDialingRules.getFaxAgentList();
        },
        getFaxAgentList: function (e) {
            fxcRequest.get('/Admin/FaxAgent/FaxAgentList', null,
                function (data) {
                    /*console.log(data);*/
                    var fa = data.FaxAgentList;
                    if (fa != null && fa.Source.length > 0) {
                        $.sectionproperties.selectGenerator("ImportFxAgntValue", fa.Source, fa.Value);
                    } else {
                        swal($globalMessages.swal.error.errorCap, $globalMessages.alert.noFaxAgent, "error");
                    }
                },
                function (error) {
                    /*console.log(error);*/
                });
        },
        /* End Logic */

        /*Post or Get Function*/
        save: function () {
            fxcRequest.post('/Admin/FaxAgentDialingRules/ImportCustomDial',
                { "AgentID": $('#ImportFxAgntValue').val(), "ImportDR": $('#ImportDR').val() },
                function (data) {
                    $.faxAgent_dialingRules.initGrid();
                    $("#importDialString-modal").modal("hide");
                }, null, false);
        }
    };
})(window.jQuery);
