var contextMenuTriggerToggle = function () {
	var trigger = $("#configdomainmodal #tree");
	if (trigger.hasClass('context-menu-disabled')) {
		trigger.contextMenu(true);
	} else {
		trigger.contextMenu(false);
	}
};


var itemsDisabled = {};
var createDomain = "1", deleteDomain = "2", renameDomain = "3", moveDomain = "4";
var $SelectedNode;
var $SelectedNodeParent;
var nodeMargin = 0;
$contextmenu = {
	initAdmin: function (e) {
		/*debugger*/
		$.contextMenu({
			selector: e,
			trigger: 'left',
			items: {
				"1": {
					name: $globalMessages.contextMenu.createDomain, icon: "add",
					disabled:
					function (key, opt) {
						return itemsDisabled[key];
					}
				},
				"2": {
					name: $globalMessages.contextMenu.deleteDomain, icon: "delete",
					disabled:
					function (key, opt) {
						return itemsDisabled[key];
					}
				},
				"3": {
					name: $globalMessages.contextMenu.renameDomain, icon: "edit",
					disabled:
					function (key, opt) {
						return itemsDisabled[key];
					}
				},
				"4": {
					name: $globalMessages.contextMenu.moveDomain, icon: "cut",
					disabled:
					function (key, opt) {
						return itemsDisabled[key];
					}
				}
			},
			callback: function (key, options) {
				/*debugger*/
				menuOption = options;

				if (key === '1') {

					$('#DomainModalDialogAction').val(0);

					/* display virtual input box */
					$contextmenu.initVirtualInputBox($SelectedNode);
				}

				if (key === '2') {
					swal({
                        title: "",
                        text: $globalMessages.swal.confirmDeleteDomain,
						type: "info",
						showCancelButton: true,
						closeOnConfirm: false,
						reverseButtons: true
                    }, function () {
                        $(".confirm").prop("disabled", true);
						$contextmenu.delete($('#EditTreeInput').val());
					});
				}

				if (key === '3') {
					$('#DomainModalDialogAction').val(1);
					$contextmenu.initVirtualInputBox($SelectedNode);
					$contextmenu.rename($SelectedNode);
				}

				if (key === '4') {
					$contextmenu.initVirtualMoveBox($SelectedNode);
				}

				$('#IsEditing').val('true');
			},
			events: {
				show: function (opt) {
					/*debugger*/
					$(this).addClass("active");
					$contextmenu.enableRules($(this));
					$SelectedNode = $(this);
					/*console.log($SelectedNode);*/

					if ($SelectedNode.attr('data-id') !== '0')
						$SelectedNodeParent = $(this).parent().parent();

                    nodeMargin = $(this).position().left - 150;
				},
				hide: function (opt) {
					$(this).removeClass("active");
                    $contextmenu.enableRules(null);
				}
			}
		});
	},
	initVirtualInputBox: function (currentNode) {
		$contextmenu.cleanVirtualInput();
		/*debugger*/
        var selectedTree = currentNode.closest(".list-group-item").length !== 0 ? currentNode.closest(".list-group-item") : currentNode;
		var marginLeft = selectedTree.children('div[data-role="wrapper"]').children('[data-role="display"]').position().left;
        var moveDiv =
			'<div class="btn-group fxc-join-button EditTreeView" id="EditTreeView" >' +
			'<input id="EditTreeInput" type= "text" class="domainInput" autofocus maxlength="50" />' +
			'<button class="btn  btn-secondary" title="Save"' +
			'data-command="1" type="button" id="BtnAppendTree">' +
			'<i class="ti-check"></i>' +
			'</button>' +
			'<button class="btn btn-secondary" title="Cancel"' +
			'data-command="2" type="button" id="BtnCancelTree" >' +
			'<i class="ti-close"></i>' +
			'</button>' +
            '</div >';
		if ($('#DomainModalDialogAction').val() == 1 && $('li[data-id="' + $SelectedNode.attr("data-id") + '"]').length > 0) {
			$('li[data-id="' + $SelectedNode.attr("data-id") + '"]').children('div[data-role="wrapper"]').addClass("hide");
		}
		else if ($('#DomainModalDialogAction').val() == 0)
		{
			marginLeft = marginLeft + 24;
		}

        if ($(selectedTree).children("ul").length > 0) {
            selectedTree.children("ul").before(moveDiv);
        }
        else {
            selectedTree.append(moveDiv);
		}	

        $(selectedTree).find('#EditTreeView').css("width", "fit-content");
        $(selectedTree).find("#EditTreeView").css("margin-left", marginLeft);
        $(selectedTree).find("#EditTreeView").css({ "margin-right": "2px", "margin-top": "2px", "margin-bottom": "2px" });
        $('.gj-list').css("background-color", "white");
		$('.ti-check').css('color', 'darkgreen');
		$('.ti-close').css('color', 'darkred');
		$('#EditTreeInput').focus();

		$contextmenu.editDomainEventHandler($("#EditTreeInput"));
		contextMenuTriggerToggle();
	},
	initVirtualMoveBox: function (currentNode) {
		$contextmenu.cleanVirtualInput();
		
		/*debugger*/
		var selectedTree = currentNode.closest(".list-group-item").length !== 0 ? currentNode.closest(".list-group-item") : currentNode;

		var moveDiv = '<div class="MoveTreeView" id="MoveTreeView">' +
			'<div id="container">' +
			'<div class="faxcore-move-to">' +
			'<span class="move-span"><i class="mdi mdi-transfer"></i></span>' +
			'<div class="controls">' +
			'<div class="selectTreeView btn-group fxc-join-button" id="selectTreeView-moveDomain">' +
			'<select id="DomainDLL" class="customDomainDDL"></select>' +
			'<button class="btn btn-secondary" title="move" data-command="1" type="button" id="BtnMoveTree">' +
			'<i class="ti-check"></i>' +
			'</button>' +
			'<button class="btn btn-secondary" title="Cancel" data-command="2" type="button" id="BtnCancelTree">' +
			'<i class="ti-close"></i>' +
			'</button>' +
			'</div>' +
			'</div>' +
			'</div>' +
			'</div>' +
			'</div>';

		if ($(selectedTree).children("ul").length> 0)
		{
			selectedTree.children("ul").before(moveDiv);
		}
		else {
			selectedTree.append(moveDiv);
		}		
		var tempDomainID = [];
		tempDomainID.push(Number($SelectedNode.attr("data-id")));
		$contextmenu.generateDomainDDL($("#DomainDLL"), $treeViewDomain.getAll(), tempDomainID);
		var marginLeft = selectedTree.children('div[data-role="wrapper"]').children('[data-role="display"]').position().left;
		
		$('.gj-list').css("background-color", "white");
		$('.ti-check').css('color', 'darkgreen');
		$('.ti-close').css('color', 'darkred');
		$(selectedTree).find('#MoveTreeView #container').css("width", "auto");
		$(selectedTree).find('#MoveTreeView #container').css("float", "inherit");
		$(selectedTree).find('#MoveTreeView #container').css({ "margin-right": "2px", "margin-top": "2px", "margin-bottom": "2px", "margin-left": marginLeft });
		$('#DomainDLL').focus();

        $contextmenu.editDomainEventHandler($("#EditTreeInput"));
		contextMenuTriggerToggle();
	},
	cleanVirtualInput: function () {
		if ($('div[data-role="wrapper"]').hasClass("hide")) {
			$('div[data-role="wrapper"]').removeClass("hide");
		}
		if ($('.MoveTreeView').length > 0) {
			$('.MoveTreeView').remove();
		}
		if ($('.EditTreeView').length > 0) {
			$('.EditTreeView').remove();
        }
	},
	enableRules: function (e) {
		itemsDisabled[createDomain] = false;
		itemsDisabled[deleteDomain] = false;
		itemsDisabled[renameDomain] = false;
		itemsDisabled[moveDomain] = false;

        if (e !== null) {
            var current = e.closest('.list-group-item');
            var parent = current.parent().closest('.list-group-item');
            var grandparent = parent.parent().closest('.list-group-item');
            var sibling = current.siblings();

            if (e.data("id") === 0) {
				itemsDisabled[deleteDomain] = true;
				itemsDisabled[renameDomain] = true;
				itemsDisabled[moveDomain] = true;
            }
            else if (parent.length === 0) {
                /* Disable moveDomain button when no parent */
                itemsDisabled[moveDomain] = true;
            }
            else if (sibling.length === 0 && grandparent.length === 0) {
                /* Disable moveDomain button if no sibling/grandparent */
                itemsDisabled[moveDomain] = true;
            }
		}
	},
	editDomainEventHandler: function (e) {

		$(e).keyup(function (event) {
			if (event.which === 13) {
				$contextmenu.save();
				contextMenuTriggerToggle();
			}
		});

		$('#BtnAppendTree').on('click', function (event) {
			$contextmenu.save();
			contextMenuTriggerToggle();
		});

		$('#BtnMoveTree').on('click', function (event) {
			$contextmenu.move();
			contextMenuTriggerToggle();
		});

		$('#BtnCancelTree').on('click', function (event) {
            $contextmenu.cancel();
            contextMenuTriggerToggle();
		});
	},
	generateDomainDDL: function (source, nodes, skipDomainID) {
		if (nodes.length > 0)
		{
			var getDDL = source;
			
            $.each(nodes, function (i, v) {
                if (v.children.length) {               
                    if (v.children.some(e => e.id === Number($SelectedNode.attr("data-id")))) {
                        skipDomainID.push(Number(v.id));
                    }
					else if (v.id === Number($SelectedNode.attr("data-id")))
					{
                        $.merge(skipDomainID, nodes[0].children.map(x => x.id));
					}
                }
				if ($.inArray(Number(v.id), skipDomainID) < 0)
				{
					var option = '<option value="' + v.id + '">' + v.text + '</option>';
					$(getDDL).append(option);

					
				}
				if (Number(v.id) !== Number($SelectedNode.attr("data-id")))
					$contextmenu.generateDomainDDL(getDDL, v.children, skipDomainID);
                

            });
		}
	},
    save: function () {
		/**
		 * For Create & Rename Fn
		 * $('#DomainModalDialogAction').val() == 0 --> Create
		 * $('#DomainModalDialogAction').val() == 1 --> Rename
		 */
		var DomainId = $SelectedNode.attr("data-id");
		
		var getInputText = ($('#EditTreeInput').val() + "").trim();
		if (getInputText.length === 0) {
            swal("", $globalMessages.validation.domainNameRequired);
            contextMenuTriggerToggle();
			return false;
		}

		fxcRequest.post('/Common/SaveDomain',
		{
			"DomainID": DomainId,
			"DomainName": getInputText,
			"Action": $('#DomainModalDialogAction').val() === "0" ? 0 : 1
		},
		function (data) {
			var msg = $('#DomainModalDialogAction').val() === '0' ? $globalMessages.toast.domainBeingCreated :
				$globalMessages.toast.domainBeingUpdated;

			$.toast({
				text: msg,
				position: 'top-right',
				loaderBg: '#ff6849',
				icon: 'info',
				hideAfter: 3500,
				stack: 6
			});

			/*debugger*/
			if ($('#DomainModalDialogAction').val() === '1') {
				/* Rename */
				if (data.NewDomainID === $('#dashboardID').val()) {
					$('#dashboardText').text(data.NewDomainName);
				}

				var id = data.NewDomainID,
					record = $treeViewDomain.getDataById(data.NewDomainID);
				record.text = data.NewDomainName;
				$treeViewDomain.updateNode(id, record);

				fxcUserConn.onDomainChanges(data.NewDomainID, false, false, true);
			} else {
				/* Create */
				$treeViewDomain.addNode({ text: data.NewDomainName, id: data.NewDomainID }, $treeViewDomain.getNodeById(DomainId));
				fxcUserConn.onDomainChanges(data.NewDomainID, false, true, true);
			}

			$contextmenu.cancel();
		},
		function (error) {
			swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
		}, false);
	},
	cancel: function () {
		$contextmenu.cleanVirtualInput();
        $('#IsEditing').val('false');      
	},
	delete: function (nodeName) {
		/*debugger*/
		var DomainId = $SelectedNode.attr('data-id');

		$.ajax({
			type: 'POST',
			url: '/Common/DeleteDomain',
			async: true,
			data: { "DomainID": DomainId },
			success: function (data) {
				if (data.TypeName && data.TypeName === "ServerError") {
					swal({
						title: $globalMessages.swal.warningTitle,
						text: data.Message,
						type: "warning",
						showConfirmButton: true,
						closeOnClickOutside: false
					}, function () {
						$('#IsEditing').val('false');
					});
                } else {
                    $(".confirm").prop("disabled", false);
					$.toast({
						text: $globalMessages.toast.domainBeingDeleted,
						position: 'top-right',
						loaderBg: '#ff6849',
						icon: 'info',
						hideAfter: 3500,
						stack: 6
					});

					/*debugger*/

					var treedata = $treeViewDomain.getDataById(Number($SelectedNode.attr('data-id')));
					var node = $treeViewDomain.getNodeByText(treedata.text);

					$treeViewDomain.removeNode(node);

					if ($SelectedNodeParent.children().hasClass('gj-list')) {
						if ($SelectedNodeParent.children('ul')[0].innerText === '') {

							$SelectedNodeParent.children('ul').remove();
							$SelectedNodeParent.children('div').children('.gj-tree-material-icons-expander').empty();
						}
					}

					swal.close();
					fxcUserConn.onDomainChanges(data.NewDomainID, false, true, true);

					$('#IsEditing').val('false');
				}
			},
			error: function (error) {
				if (!error.isResponseValidationErrors && error.responseJSON.TypeName === "ServerError") {
					swal($globalMessages.swal.error.title, error.responseJSON.Value, "error");
				}
			}
		});
	},
	rename: function (currentNode) {
		/*debugger*/
		var selectedTree = currentNode.find('ul').length !== 0 ? currentNode.children('div[data-role="wrapper"]') : currentNode;

		var toBeHideNode = currentNode.find('ul').length !== 0 ? selectedTree :
			selectedTree.children('div[data-role="wrapper"]');

		if (!toBeHideNode.hasClass('hide')) {
			toBeHideNode.addClass('hide');
		}

		var nodeName = $treeViewDomain.getDataById(Number($SelectedNode.attr('data-id'))).text;

		$("#EditTreeInput").val(nodeName);
	},
	move: function () {
		/*debugger*/
		var DomainId = $SelectedNode.attr("data-id");
		var ParentDomainID = $('#DomainDLL').val();
		fxcRequest.post('/Common/MoveDomain',
		{
			"DomainID": DomainId,
			"ParentDomainID": ParentDomainID
		},
		function (data) {

			$.toast({
				text: $globalMessages.toast.domainBeingMoved,
				position: 'top-right',
				loaderBg: '#ff6849',
				icon: 'info',
				hideAfter: 3500,
				stack: 6
			});

			$contextmenu.cancel();

			var relatedDomainID = DomainId + "|" + data;

			/*debugger*/
			fxcUserConn.onDomainChanges(relatedDomainID, false, true, true);

			$('#IsEditing').val('false');
		},
		function (error) {
			swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
		}, false);
	}
};

$.configdomain = {
	init: function (e) {
		$.configdomain.searchPressEnter($('input#config-domain-search'));
		$.configdomain.searchButtonClickHandler($('#config-domain-search-btn'));
	},
	/*Logic*/
	search: function (e) {
		$("#tree li[data-role=\"node\"]").removeClass("searched search-item");
		$('#tree[data-type="tree"]').removeClass("searched");

		$("#config-domain-search-result").text($treeViewDomain.find('ul>li').length);

		var getSearchText = $('input#config-domain-search').val().toLowerCase();

		if (getSearchText.length > 0) {
			$('#tree[data-type="tree"]').addClass("searched");

			var searchNodes = $("#tree li[data-role=\"node\"][data-search*=\"" + getSearchText + "\"]");

			$("#config-domain-search-result").text(searchNodes.length);

			$("#configdomainmodal .domain-modal-inner-body").scrollTop(0);
			if (searchNodes.length > 0) {
				searchNodes.addClass("searched search-item");
				searchNodes.parents("li[data-role=\"node\"]").addClass("searched");
				searchNodes.find("li[data-role=\"node\"]").addClass("searched");

				var firstElement = $("#tree li[data-role=\"node\"].search-item")[0].offsetTop;
				$("#configdomainmodal .domain-modal-inner-body").scrollTop(firstElement);
			}
		}
    },
   /*End Logic*/
	searchButtonClickHandler: function (e) {
		$(e).on('click', function () {
			$.configdomain.search();
		});
	},
	searchPressEnter: function (e) {
		$(e).on('input', function (e) {
			$.configdomain.search();
		}).on('keypress', function (enter) {
			if (enter.which === 13) {
				$.configdomain.search();
			}
		});
	}
};