﻿(function ($) {
    $.errorlog = {
        init: function () {            
            $.errorlog.refreshButtonClickHandler($('.btn-refresh'));
            $.errorlog.deleteButtonClickHandler($('.View1 .btn-delete'));
            $.errorlog.deleteAllButtonClickHandler($('.View1 .btn-delete-all'));
            $.errorlog.deleteHandler($('.btn-delete2'));

            $('.btn-copytoclipboard2').click(function (e) { e.preventDefault(); $.errorlog.clipBoard(); });
            $('.btn-Error-Next').click(function (e) { e.preventDefault(); $.errorlog.showErrorLogPrevious(); });
            $('.btn-Error-Prev').click(function (e) { e.preventDefault(); $.errorlog.showErrorLogNext(); });

            $.sectionproperties.FirstLevel($('.btn-back2'));
            $.errorlog.initGrid();
        },
        getGridSelections: function (e) {
            var selectedId = [];
            var entityGrid = $('#grid').data("kendoGrid");
            var rows = entityGrid.select();

            rows.each(function (index, row) {
                var selectedItem = entityGrid.dataItem(row);
                selectedId[index] = selectedItem.id;
            });

            return selectedId;
        },
        deleteButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $(this).blur();
                var ids = $.errorlog.getGridSelections();
                if (ids.length > 0) {
                    swal({
                        title: "",
                        text: $errorLogResource.swal.delLog,
                        type: "info",
                        showCancelButton: true,
                        closeOnConfirm: false,
                        reverseButtons: true,
                        showLoaderOnConfirm: true
                    }, function () {
                        $.errorlog.delete(ids, false);
                    });
                } else {
                    swal("", $errorLogResource.swal.noLog);
                }
            });
        },
        deleteAllButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $(this).blur();
                swal({
                    title: "",
                    text: $errorLogResource.swal.delAllLog,
                    type: "info",
                    showCancelButton: true,
                    closeOnConfirm: false,
                    reverseButtons: true,
                    showLoaderOnConfirm: true
                }, function () {
                    $.errorlog.delete(null, true);
                });
            });
        },
        deleteHandler: function (e) {
            $(e).on('click', function () {
                swal({
                    title: "",
                    text: $errorLogResource.swal.delThisLog,
                    type: "info",
                    showCancelButton: true,
                    closeOnConfirm: false,
                    reverseButtons: true,
                    showLoaderOnConfirm: true
                }, function () {
                    var id = $('#RecUIDX').val();
                    var ids = [id];
                    $.errorlog.delete(ids, false);
                    $('.btn-back2').click();
                });
            });
        },
        showErrorLogDetails: function (dataItem) {            
            $.errorlog.showDetails(dataItem.id, "Current");
        },
        showErrorLogNext: function (e) {
            /*Next = Latest ErrLog*/
            var id = $('#RecUIDX').val();
            $.errorlog.showDetails(id, "Next");
        },
        showErrorLogPrevious: function (e) {
            /*Previous = Older ErrLog*/
            var id = $('#RecUIDX').val();
            $.errorlog.showDetails(id, "Previous");
        },
        showDetails: function (id, logPosition) {
            $("#Loading").addClass("divLoadingBig");
            var model = {
                "LogID": id,
                "LogPosition": logPosition
            };
            fxcRequest.post('/Admin/ErrorLogging/ShowDetails',
                model,
                function (data) {
                    $.errorlog.mapData(data);
                    $("#Loading").removeClass("divLoadingBig");
                }, null, false);
        },
        mapData: function (data) {            
            $.sectionproperties.SecondLevel();
            $('#formSubmit').BindToForm(data, '#', '');
            
            /*Button name different due to interface next and previous*/
            /*Backend Next = Prev in UI*/
            if (data.HasNext) {
                $('.btn-Error-Prev').show();
            } else {
                $('.btn-Error-Prev').hide();
            }

            if (data.HasPrev) {
                $('.btn-Error-Next').show();
            } else {
                $('.btn-Error-Next').hide();
            }
        },
        clipBoard: function (e) {
            var result = $errorLogResource.field.errorMessage + " : " + $('#ErrorMsg').val() + "\n";
            result += $errorLogResource.field.dateCreated + " : " + $('#CrDateX').val() + "\n";
            result += $errorLogResource.field.errorDetails + " : " + $('#ErrorDetail').val() + "\n";
            result += $errorLogResource.field.errorGroup + " : " + $('#ErrorGroup').val() + "\n";
            result += $errorLogResource.field.errorLevel + " : " + $('#ErrorLevel').val() + "\n";
            result += $errorLogResource.field.sourceFile + " : " + $('#SourceFile').val() + "\n";
            result += $errorLogResource.field.stackTrace + " : " + $('#StackTrace').val() + "\n";
                
            $("#copy-me").text(result);
            copyToClipboard.init("#copy-me");
        },
        delete: function (ids, deleteAll) {
            fxcRequest.post('/Admin/ErrorLogging/Delete',
                {
                    'Ids': ids,
                    'DeleteAll': deleteAll
                },
                function (data) {
                    $.errorlog.initGrid();
                    swal($globalMessages.swal.success.title, $globalMessages.swal.success.delete, "success");
                });
        },
        initGrid: function (e) {
            
            var id = $('#grid');
           
            var dataSource = {
                transport: {
                    read: {
                        url: '/Admin/ErrorLogging/Read',
                        dataType: "json",
                        type: "GET"
                    },
                    parameterMap: function (options) {

                        var result = {
                            Skip: options.skip,
                            Take: options.take,
                            Page: options.page
                        };

                        if (options.sort && options.sort.length > 0) {
                            result.SortBy = options.sort[0].field;
                            result.Direction = options.sort[0].dir;
                        }

                        return result;
                    }
                },
                schema: {
                    data: "Records",
                    total: "Total",
                    model: {
                        id: "RecUID"
                    }
                },
                serverPaging: true,
                serverSorting: true
            };

            var col = [
                {
                    selectable: true, width: "45px",
                    attributes: {
                        "class": "checkboxSelection"
                    }
                },
                { field: 'RecUID', hidden: true },
                { field: 'ErrMsg', title: $errorLogResource.field.errorMessage, width: 400, sortable: true },
                { field: 'ErrGroup', title: $errorLogResource.field.group, width: 200, sortable: true },
                { field: 'ErrLevel', title: $errorLogResource.field.level, width: 150, sortable: true },
                { field: 'CrDate', title: $errorLogResource.field.date, width: 250, sortable: true }
            ];

            var obj = {};
            obj.allowSelectMultipleRow = true;
            obj.customizeCheckbox = true;
            obj.onSelectionFn = $.errorlog.showErrorLogDetails;

            kendogridcustomization.init(id, dataSource, col, obj);
        },
        refreshButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $(this).blur();
                $.errorlog.initGrid();
            });
        }
    };
})(window.jQuery);