(function ($) {
    var $grid, bind = false;
    $.license = {
        init: function () {
            $.license.initGrid();
            $.license.addButtonHandler('#license-NewBtn');
            $.license.saveButtonHandler('#save-license');
        },
        initGrid: function () {
            var id = $('#grid');

            var dataSource = {
                transport: {
                    read: {
                        url: '/Admin/License/Read',
                        dataType: "json",
                        type: "GET"
                    },
                    parameterMap: function (options) {

                        var result = {
                            Skip: options.skip,
                            Take: options.take,
                            Page: options.page
                        };

                        if (options.sort && options.sort.length > 0) {
                            result.SortBy = options.sort[0].field;
                            result.Direction = options.sort[0].dir;
                        }

                        return result;
                    }
                },
                schema: {
                    data: "Records",
                    total: "Total",
                    model: {
                    }
                },
                serverPaging: true,
                serverSorting: true
            };

            var col = [
                { field: 'ServerName', title: $licensingResource.field.serverName, sortable: true, minWidth: 200, width: 250 },
                { field: 'LicSourceID', title: $licensingResource.field.agentId, sortable: true, minWidth: 150, width: 150 },
                { field: 'LicCode', title: $licensingResource.field.channels, minWidth: 150, width: 200, sortable: true },
                { field: 'LicStatus', title: $licensingResource.field.licenseStatus, minWidth: 200, width: 250, sortable: true },
                { field: 'LicEvalInfo', title: $licensingResource.field.evaluationPeriod, sortable: true, minWidth: 200, width: 250 }
            ];

            var obj = {};
            obj.allowSelectMultipleRow = true;
            obj.customizeCheckbox = true;

            $grid = kendogridcustomization.init(id, dataSource, col, obj);
        },
        addButtonHandler: function (e) {
            $(e).on('click', function () {
                $('#licenseModal').modal('show');
            })
        },
        saveButtonHandler: function (e) {
            $(e).on('click', function () {
                $.license.saveLicense();
            });
        },
        saveLicense: function () {
            fxcRequest.upload('/Admin/License/Save'
                , $('#license_upload')
                ,{"Content": $('#license_content').val()}
                , function (data) {
                    swal({
                        title: $globalMessages.swal.done,
                        text: $licensingResource.swal.success,
                        showCancelButton: false,
                        type: "success",
                        closeOnConfirm: true,
                        reverseButtons: false,
                        showLoaderOnConfirm: true
                    }, function () {
                        $('#licenseModal').modal('hide');
                        $('input[id="license_upload"]').val('');
                            setTimeout(function () {
                                $('a#supportgetlicense.sidebar-nav-link.active').click();
                            }, 500);
                    });


                    
                });


        }
    };
})(window.jQuery);