﻿(function ($) {
	var data;
	var getErrorMsg = [];
	var defaultDateTime = $("#defaultDateFormat").val() + " " + $("#defaultTimeFormat").val();

	var auditTrailValidation = function () {
		$('#formSubmit').validate({
			ignoreTitle: true,
			rules: {
				StartDate: { fxcDateFormat: [defaultDateTime] },
				EndDate: { fxcDateFormat: [defaultDateTime] },
			},
			messages: {
                StartDate: { fxcDateFormat: $auditTrialResource.message.valDateFormat },
                EndDate: { fxcDateFormat: $auditTrialResource.message.valDateFormat },
			},
			submitHandler: function (form) {
				$('#search-filter-modal').modal('hide');
				$.auditTrail.initGrid($('#grid'));
			}
		});
	};

	$.auditTrail = {
		init: function () {
			auditTrailValidation();
            $("#ActionGroup").prepend("<option value='*' selected='selected'>" + $auditTrialResource.all + "</option>");
			this.getActionTitle($("#ActionGroup").val());

			this.searchFilterClickHandler($('.btn-filter-grid'));

			this.searchModalButtonClickHandler($("#Searchdefault"));
			this.resetModalButtonClickHandler($("#BtnResetdefault"));

			this.refreshHandler($('.btn-refresh'));
			this.deleteHandler($('.btn-delete'));
			this.deleteAllHandler($('#view1ClearLogBtn'));
			this.saveHandler($('#BtnSavedefault'));
			this.saveCloseHandler($('#BtnSaveClosedefault'));
			this.initDateTime();
			this.previousHandler($('.prev-audit'));
			this.nextHandler($('.next-audit'));

			$('#form-admin-auditTrail').validate({
				ignore: ".ignored",
				submitHandler: function (form) {
					return false;
				}
			});

			$('#ActionGroup').change(function () {
				var optionSelected = $(this).find("option:selected");
				var valueSelected = optionSelected.val();
				$('#ActionTitle')[0].options.length = 0;
				$.auditTrail.getActionTitle(valueSelected);
			});

			/*Initialize Grid*/
			this.initGrid($('#grid'));
		},
		initGrid: function (e) {
			var id = e;
			var dataSource = {
				transport: {
					read: {
						url: '/admin/audittrail/query',
						dataType: "json",
						type: "GET"
					},
					parameterMap: function (options) {
						/* Fix url param for sort values */
						var result = {
							StartDate: $('#StartDate').val(),
							EndDate: $('#EndDate').val(),
							ActionGroup: $('#ActionGroup').val(),
							ActionTitle: $('#ActionTitle').val(),
							PrimaryUser: $('#PrimaryUser').val(),
							SecondaryUser: $('#SecondaryUser').val(),
							IsError: $('#IsError').val(),
							Skip: options.skip,
							Take: options.take,
							Page: options.page,
							Sort: options.sort
						};
						if (options.sort && options.sort.length > 0) {
							result.SortBy = options.sort[0].field;
							result.Direction = options.sort[0].dir;
						}
						return result;
					}
				},
				schema: {
					data: "Records",
					total: "Total",
					model: {
						id: "Id"
					}
				},
				serverPaging: true,
				serverSorting: true
			};

			var col = [
				{
					selectable: true, width: "45px",
					attributes: {
						"class": "checkboxSelection"
					}
				},
				{ field: 'Id', hidden: true },
                { field: 'PrimaryUser', title: $auditTrialResource.text.primaryUser, minWidth: 140, width: 140, sortable: true },
                { field: 'SecondaryUser', title: $auditTrialResource.text.secondaryUser, minWidth: 140, width: 140, sortable: true },
                { field: 'Date', title: $auditTrialResource.text.date, minWidth: 140, width: 220, sortable: true },
                { field: 'ActionGroup', title: $auditTrialResource.text.actionGroup, minWidth: 120, width: 200, sortable: true },
                { field: 'ActionTitle', title: $auditTrialResource.text.actionTitle, minWidth: 300, width: 300, sortable: true },
                { field: 'IsError', title: $auditTrialResource.text.anyError, minWidth: 80, width: 100, sortable: true }
			];

			var obj = {};
			obj.allowSelectMultipleRow = true;
			obj.customizeCheckbox = true;
			obj.onSelectionFn = this.editButtonClickHandler;

			kendogridcustomization.init(id, dataSource, col, obj);
		},
		initDateTime: function (e) {
			/*website: http://www.daterangepicker.com/ */
			var obj = {};

			fxcDateTimePicker.init('input#StartDate, input#EndDate', defaultDateTime, obj);
		},
		getActionTitle: function (e) {
            $("#ActionTitle").prepend("<option value='*' selected='selected'>" + $auditTrialResource.all + "</option>");
			fxcRequest.get('/admin/audittrail/getactionTitle',
				{
					ActionGroup: e
				},
				function (data) {
					$.each(data.ActionTitle, function (e, value) {
						$('#ActionTitle').append($("<option></option>")
							.attr("value", value.Key)
							.text(value.Value));
					});
				},
				function (error) {
					/*console.log(error);*/
				}
			);
		},
		getGridSelections: function (e) {
			var selectedId = [];
			var entityGrid = $('#grid').data("kendoGrid");
			var rows = entityGrid.select();

			rows.each(function (index, row) {
				var selectedItem = entityGrid.dataItem(row);
				selectedId[index] = selectedItem.id;
			});

			return selectedId;
		},
		searchFilterClickHandler: function (e) {
			$(e).on('click', function (x) {
				$('#search-filter-modal').modal('show');
			});
		},
		searchModalButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$('#search-filter-modal').modal('hide');
				$.auditTrail.initGrid($('#grid'));
			});
		},
		resetModalButtonClickHandler: function (e) {
			$(e).on('click', function (x) {
				$.auditTrail.resetModal();
			});
		},
		refreshHandler: function (e) {
			$(e).on('click', function () {
				$(this).blur();
				$.auditTrail.initGrid($('#grid'));
			});
		},
		deleteHandler: function (e) {
			$(e).on('click', function () {
				$(this).blur();
				var ids = $.auditTrail.getGridSelections();
				if (ids.length > 0) {
					swal({
						title: "",
                        text: $auditTrialResource.swal.delete,
						type: "info",
						showCancelButton: true,
						closeOnConfirm: false,
						reverseButtons: true,
						showLoaderOnConfirm: true
					}, function () {
						$.auditTrail.deleteAction(ids);
					});
                } else {
                    swal("", $auditTrialResource.swal.notSelected);
				}
			});
		},
		deleteAllHandler: function (e) {
			$(e).on('click', function () {
				$(this).blur();
				swal({
					title: "",
					text: $auditTrialResource.swal.deleteAllLogs,
					type: "info",
					showCancelButton: true,
					closeOnConfirm: false,
					reverseButtons: true,
					showLoaderOnConfirm: true
				}, function () {
					$.auditTrail.deleteAllAction();
				});
			});
		},
		editButtonClickHandler: function (dataitem) {
			$.auditTrail.getAction(dataitem.Id, 'current');
			$('#edit-auditTrail-modal').modal('show');
		},
		saveHandler: function (e) {
			$(e).on('click', function () {
				$.auditTrail.saveAction(0);
			});
		},
		saveCloseHandler: function (e) {
			$(e).on('click', function () {
				$.auditTrail.saveAction(1);
			});
		},
		previousHandler: function (e) {
			$(e).on('click', function () {
				$.auditTrail.getAction($('#LogId').val(), 'next');
			});
		},
		nextHandler: function (e) {
			$(e).on('click', function () {
				$.auditTrail.getAction($('#LogId').val(), 'previous');
			});
		},

		/*Action Handler*/
		constructGetModel: function (data) {
			$('#LogId').val(data.LogId);
			$('#LogActionGroup').html(data.ActionGroup);
			$('#LogTitle').html(data.ActionTitle);
			$('#LogMessage').html(data.ActionMessage);
			$('#LogSource').html(data.SourceContent);
			$('#LogSourceId').html(data.SourceId);
			$('#LogPrimaryUser').html(data.PrimaryUser);
			$('#LogSecondaryUser').html(data.SecondaryUser);
			$('#LogActionDate').html(data.Date);
			$('#LogIPAddress').html(data.IPAddress);
			$('#LogError').html(data.IsError);
			$('#LogDescription').html(data.Description);
			$('#LogExtraComment').val(data.ExtraComment);
		},
		resetModal: function (e) {
			$('#formSubmit').trigger("reset");
			$("#formSubmit").validate().resetForm();
		},
		getAction: function (id, position) {
			fxcRequest.get('/admin/audittrail/get',
				{
					"Id": id,
					"Position": position
				},
				function (data) {
					$('.btn-next-audit').css("display", "none");
					$('.btn-prev-audit').css("display", "none");

					if (data.LogId !== null) {
						$.auditTrail.constructGetModel(data);

						if (data.HasNext) {
							$('.btn-prev-audit').css("display", "block");
						}
						if (data.HasPrev) {
							$('.btn-next-audit').css("display", "block");
						}
					} else {

						if (position == 'next') {
							$('.btn-next-audit').css("display", "none");
							$('.btn-prev-audit').css("display", "block");
						} else if (position == 'previous') {
							$('.btn-next-audit').css("display", "block");
							$('.btn-prev-audit').css("display", "none");
						}
					}
				},
				function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnDelete, "error");
				});
		},
		saveAction: function (e) {
			fxcRequest.post('/admin/audittrail/save',
				{
					"LogId": $('#LogId').val(),
					"ExtraComment": $('#LogExtraComment').val()
				},
				function () {
					if (e === 1) {
						$('#edit-auditTrail-modal').modal('hide');
					}
                    swal($globalMessages.swal.success.title, $globalMessages.swal.success.delete, "success");
				},
				function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSave, "error");
				});
		},
		deleteAction: function (ids) {
			fxcRequest.post('/admin/audittrail/delete',
				{
					Ids: ids
				},
				function (data) {
					$.auditTrail.initGrid('#grid');
					$('#delete-modal').modal('hide');
                    swal($globalMessages.swal.success.title, $globalMessages.swal.success.delete, "success");
				},
				function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnDelete, "error");
				});
		},
		deleteAllAction: function (e) {
			fxcRequest.post('/admin/audittrail/deleteall',
				{
				},
				function (data) {
					$.auditTrail.initGrid('#grid');
					$('#delete-modal').modal('hide');
                    swal($globalMessages.swal.success.title, $globalMessages.swal.success.deleteAll, "success");
				},
				function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnDelete, "error");
				});
		}
	};
})(window.jQuery);
