﻿(function ($) {
	var setIsRtl = $("html[dir]").attr("dir") === "rtl" ? true : false;
    var tour = {
        id: 'admin-utilities-audittrail-hopscotch',
        onStart: function () {
            $('#search-filter-modal').modal('show');
        },
        steps: [
            {
                target: 'StartDate',
                title: '',
                content: $globalMessages.uiGuide.buttonStartDate,
                placement: 'top',
                yOffset: '5',
				zindex: 1100,
				isRtl: setIsRtl
            },
            {
                target: 'EndDate',
                title: '',
                content: $globalMessages.uiGuide.buttonEndDate,
                placement: 'top',
                yOffset: '5',
				zindex: 1100,
				isRtl: setIsRtl
            },
            {
                target: 'ActionGroup',
                title: '',
                content: $globalMessages.uiGuide.changeActionGroup,
                placement: 'left',
                yOffset: '-11',
                zindex: 1100,
                onNext: function () {
                    $('#search-filter-modal').modal('hide');
                },
				isRtl: setIsRtl
            },
            {
                target: 'view1ClearLogBtn',
                title: '',
                content: $globalMessages.uiGuide.buttonClearLog,
                placement: 'left',
                xOffset: '2',
                yOffset: '-13',
                zindex: 52,
                onPrev: function () {
                    $('#search-filter-modal').modal('show');
                },
				isRtl: setIsRtl
            },
            {
                target: 'gridDeleteBtn',
                title: '',
                content: $globalMessages.uiGuide.buttonDelete,
                placement: 'bottom',
                xOffset: '-13',
                yOffset: '-3',
                zindex: 52,
				isRtl: setIsRtl
            },
            {
                target: 'gridRefreshBtn',
                title: '',
                content: $globalMessages.uiGuide.buttonRefresh,
                placement: 'bottom',
                xOffset: '-13',
                yOffset: '-3',
                zindex: 52,
				isRtl: setIsRtl
            }
        ],
        showPrevButton: true
    };
    $.utilitiesAuditTrailUiGuide = {
        init: function (tourBtn) {
            $.sharedUiGuide.init({ startTourBtn: tourBtn, tour: tour });

            $('#search-filter-modal').on('shown.bs.modal', function () {
                if (hopscotch.isActive) hopscotch.startTour(tour, hopscotch.getCurrStepNum());
            });
        },
        destroy: function() {
            $.sharedUiGuide.destroy();
        }
    };

    $('#search-filter-modal .close').click(function () {
        /* End tour on modal close */
        $.utilitiesAuditTrailUiGuide.destroy();
    });
})(window.jQuery);