﻿var $grid, bind = false;
var reset = true;
var gridId = "#grid";
var $ids = [""];
var refreshBasicSearch;
var $listBoxSelection, $listBoxSelected = null;
var commandID = null;
var defaultDateTime = $("#defaultDateFormat").val() + " " + $("#defaultTimeFormat").val();
var rowAdditionalObj = null;
var rowAdditionalObj2 = null;

var validation = function () {
    $('#formSubmit').validate({
		ignoreTitle: true,
        rules: {
            FromDate: { fxcDateFormat: [defaultDateTime] },
            ToDate: { fxcDateFormat: [defaultDateTime] },
        },
        messages: {
            FromDate: { fxcDateFormat: $searchMsgResource.message.valDateFormat },
            ToDate: { fxcDateFormat: $searchMsgResource.message.valDateFormat }
        },
        submitHandler: function (form) {
            $('#search-advanced-modal').modal('hide');
            $.searchMessages.search(2);
        }
    });
    $('#formUserSelection').validate({
        ignore: [],
		ignoreTitle: true,
        rules: {
            listUserSelected: { multiselectrequired: true },
        },
        messages: {
            listUserSelected: { multiselectrequired: $searchMsgResource.message.valRequiredMsg }
        },
        submitHandler: function (form) {
            $selectedOwner = $.searchMessages.getGridSelections($(gridId));
            ids = $.searchMessages.getListDataSource($("#listUserSelected"));
            $.searchMessages.performAction(commandID, $selectedOwner);
        }
    });
};

$.searchMessages = {
    init: function (e) {
        validation();

        $.searchMessages.advancedLinkClickHandler($(".btn-search-advanced"));
		$.searchMessages.searchAdvanceButtonClickHandler($("#searchAdvanceButton"));
        $.searchMessages.resetButtonClickHandler($(".btn-Reset"));
        $.searchMessages.searchLinkClickHandler($(".btn-search-action"));
        $.searchMessages.searchPressEnter($('input[data-role="search-all-item"]'));

        $.searchMessages.searchUserSelectionButtonClickHandler($("#btn-userSelectionSearchButton"));
        $.searchMessages.searchUserSelectionPressEnter($('input[data-role="search-active-user"]'));

        $.searchMessages.actionButtonClickHandler($('.btn-action'));

        $.searchMessages.searchModalButtonClickHandler($("button[data-role='search-modal']"));
        $.searchMessages.resetModalButtonClickHandler($("button[data-role='reset-modal-value']"));

        $.searchMessages.resetUserSlectionButtonClickHandler($('#BtnResetuserSelection'));

        $.searchMessages.resetPage();

        $.searchMessages.initDateTime();

        $.searchMessages.resetModal();

        /*Set Fax Number As Default Search*/
		$.searchMessages.setSearch($(".btn-search-action"), $("#btn-search-fax"));
		$.searchMessages.initGrid($(gridId), refreshBasicSearch, true);
    },
    initContextMenu: function () {
        $.contextMenu('destroy', ".ctxmenuMsg");
        $.contextMenu({
            selector: '.ctxmenuMsg',
            trigger: 'right',
            items: {
                "1": { name: "View Message Info", icon: "fa-info" }
            },
            className: "messageContextMenu",
            callback: function (key, options) {
                var uid = options.$trigger.attr("data-uid");
                var row = $("tr[data-uid='" + uid + "']");
                var dataItem = $(gridId).data("kendoGrid").dataItem(row);

                if (rowAdditionalObj !== null) {
                    dataItem.rowAdditionalObj = rowAdditionalObj;
                }
                dataItem.rowAdditionalObj.HideImageTab = true;
                $.messageviewer.showMessageViewerAdminSection(dataItem);
            }
        });

        if ($showDotContextMenu) {
            $.contextMenu('destroy', ".dotcontextMenu");
            $.contextMenu({
                selector: '.dotcontextMenu',
                trigger: 'left',
                items: {
                    "1": { name: "View Message Info", icon: "fa-info" }
                },
                callback: function (key, options) {
                    var uid = options.$trigger.attr("data-uid");
                    var row = $("tr[data-uid='" + uid + "']");
                    var dataItem = $(gridId).data("kendoGrid").dataItem(row);

                    if (rowAdditionalObj !== null) {
                        dataItem.rowAdditionalObj = rowAdditionalObj;
                    }
                    dataItem.rowAdditionalObj.HideImageTab = true;
                    $.messageviewer.showMessageViewerAdminSection(dataItem);
                }
            });
        }
    },
    initDateTime: function (e) {
        /*website: http://www.daterangepicker.com/ */
        let fromDateObj = {};
        fromDateObj.parentEl = "#search-advanced-modal";

        fxcDateTimePicker.init('input#FromDate', defaultDateTime, fromDateObj);

        let toDateObj = {};
        toDateObj.parentEl = "#search-advanced-modal";
        toDateObj.startDate = moment().startOf('day').set({ hour: 23, minute: 59, second: 59 });

        fxcDateTimePicker.init('input#ToDate', defaultDateTime, toDateObj);
    },
	initGrid: function (e, isBasicSearch, emptyGrid) {
		emptyGrid = emptyGrid || false;
        refreshBasicSearch = isBasicSearch;
        $(gridId).removeClass("hide");
        var url = "/Admin/searchMessages/Read";
        var obj = {};
        var col = [];

        var x = {
            selectable: true, width: 45,
            attributes: {
                "class": "checkboxSelection"
            }
        };
        col.push(x);

        if ($showDotContextMenu) {
            col.push({
                field: "",
                title: "",
                width: 30,
                attributes: {
                    "class": "checkboxSelection"
                },
                sortable: false,
                template: function (dataRow) {
                    var result = '<span class="dotcontextMenu" data-uid="#= uid #"><i class="fa fa-ellipsis-v" style="padding:0px 5px;"></i></span>';
                    return result;
                }
            });
        }

        col.push(
            {
                field: 'MsgTypeLabel',
                title: " ",
                sortable: false,
                width: 45,
                attributes: {
                    "class": "checkboxSelection"
                },
                template: function (dataRow) {
                    var msgType = dataRow.MsgType == 1 ? "Outbound" : "Inbound";
                    var result = '<span data-msgtype="' + dataRow.MsgType + '" title="' + dataRow.MsgTypeLabel + '"><i class="mdi mdi-' + msgType + '" style="padding:0px 5px;"></i></span>';
                    return result;
                }
            },
            {
                field: 'MessageID',
                title: $searchMsgResource.field.id,
                minWidth: 155, width: 155,
                sortable: true,
                hidden: !$showColMessageId
            },
            {
                field: 'MsgNo',
                title: $searchMsgResource.field.no,
                minWidth: 100, width: 100,
                sortable: true
            },
            {
                field: 'Subject',
                title: $searchMsgResource.field.subject,
                minWidth: 200,
                width: 200
            },
            {
                field: 'CrDate',
                title: $searchMsgResource.field.dateCreated,
                minWidth: 220,
                width: 220
            },
            {
                field: 'Username',
                title: $searchMsgResource.field.user,
                minWidth: 200,
                width: 200,
                sortable: true
            },
            {
                field: 'DomainName',
                title: $searchMsgResource.field.domain,
                minWidth: 150,
                width: 150,
                sortable: true
            },
            {
                field: 'SenderName',
                title: $searchMsgResource.field.from,
                minWidth: 200,
                width: 200,
                sortable: true
            },
            {
                field: "RecipientList",
                title: $searchMsgResource.field.to,
                width: 200,
                template: function (dataRow) {
                    var recipients = dataRow.RecipientList + "";

                    if (recipients.length > 30) {
                        recipients = recipients.substring(0, 30) + "...";
                    }

                    var result = '<span title="' + dataRow.RecipientList+ '">' + recipients + '</span>';
                    return result;
                }
            },
            {
				field: "Status",
                title: $searchMsgResource.field.status,
                width: 250,
                template: function (dataRow) {
                    var MsgStatus = dataRow.MsgStatus + "";
                    var MsgStatusLabel = dataRow.Status + "";

                    var result = '<div class="kendo-container">' +
                        '<span class="badge kendo-span-status badge-pill badge-' + MsgStatus + ' "> '
						+ '             <i class="mdi mdi-check kendo-check-icon-msgstatus' + MsgStatus + '"></i> '
						+ '             <i class="mdi mdi-window-close kendo-window-close-icon-msgstatus' + MsgStatus + '"></i> '
                        + '             ' + MsgStatusLabel + ' '
                        + '         </span>' +
                        '</div>';
                    return result;
                }
            },
            {
                field: 'MsgPageCount',
                title: $searchMsgResource.field.pages,
                minWidth: 100,
                width: 100,
                sortable: true
            },
            {
                field: 'MsgTrackingValue',
                title: $searchMsgResource.field.tracking,
                minWidth: 200, width: 200,
                sortable: true
            },
            {
                field: "Address",
                title: $searchMsgResource.field.address,
                width: 250,
                template: function (dataRow) {
                    var address = dataRow.Address + "";

                    if (address.length > 30) {
                        address = address.substring(0, 30) + "...";
                    }

                    var result = '<span title="' + dataRow.Address + '">' + address + '</span>';
                    return result;
                }
            });

        var id = e;
        var dataSource = {
            transport: {
                read: {
                    url: url,
                    dataType: "json",
                    type: "GET"
                },
                parameterMap: function (options) {
                    var formData = JSON.stringify($("#formSubmit").serializeArray());
                    isBasicSearch = isBasicSearch == 1 ? true : false;
                    var result = {
                        FormData: formData,
                        IsBasicSearch: isBasicSearch,
                        SubDomain: $('#SubDomain').prop('checked'),
                        FixFaxNo: $('#FixFaxNo').prop('checked'),
                        FixFaxId: $('#FixFaxId').prop('checked'),
                        FixUserName: $('#FixUsername').prop('checked'),
                        FixMsgNo: $('#FixMsgNo').prop('checked'),
                        FixMsgId: $('#FixMsgId').prop('checked'),
                        FixTrack: $('#FixTrack').prop('checked'),
                        FixSubject: $('#FixSubject').prop('checked'),
                        FixRecp: $('#FixRecpName').prop('checked'),
                        FixEmail: $('#FixEmail').prop('checked'),
                        FixCSID: $('#FixCSID').prop('checked'),
                        FixRoutingInfo: $('#FixRoutingInfo').prop('checked'),
                        Skip: options.skip,
						Take: emptyGrid ? 0 : options.take,
                        Page: options.page
                    };
                    if (options.sort && options.sort.length > 0) {
                        result.SortBy = options.sort[0].field;
                        result.Direction = options.sort[0].dir;
                    }
                    return result;
                }
            },
            schema: {
                data: "Records",
                model: {
                    id: "MessageID",
                },
				total: emptyGrid ? "" : "Total"
            },
            serverPaging: true,
            serverSorting: true,
            change: function (data) {
                /*Triggered once data load completed*/
                if (data.items.length) {
                    $('#btn-ActionCustom').prop('disabled', false);
                }
            },
        };

        if ($enableDoubleClick) {
            obj.doubleClickFn = $.messageviewer.showMessageViewerAdminSection;
        }
        else {
            obj.onSelectionFn = $.messageviewer.showMessageViewerAdminSection;
        }

        obj.rowClass = "ctxmenuMsg";
        rowAdditionalObj = {
            "RefreshLocation": $('#MessageHubRefreshFlag').val(),
            'IsSearchMsg': 'true',
            'IsAdmin': 'true'
        };

        rowAdditionalObj2 = {
            "RefreshLocation": $('#MessageHubRefreshFlag').val(),
            'IsSearchMsg': 'true',
            'IsAdmin': 'true'
        };

        obj.rowAdditionalObj = rowAdditionalObj2;

        $grid = kendogridcustomization.init(id, dataSource, col, obj);

        $.searchMessages.initContextMenu();
    },
    initListView: function (e) {
        var listBoxID = "listUserSelection";
        var listBoxIDConnectWith = "listUserSelected";
        $('input[data-role="search-active-user"]').val("");
        fxcRequest.post('/Admin/SearchMessages/GetActiveUser',
            {
                DomainID: e,
                SearchText: "",/* $('input[data-role="search-active-user"]').val()*/
                GroupMember: $.searchMessages.getListDataSource($("#" + listBoxIDConnectWith)),
                ResetField: reset
            },
            function (data) {
                var returnObject = [];

                var dataSourceSelection = {
                    data: data.ActiveUserModel.ActiveUserList.Source
                };

                var objUserSelection = {};
                objUserSelection.dataTextField = "Text";
                objUserSelection.dataValueField = "Value";
                objUserSelection.connectWith = listBoxIDConnectWith;
                objUserSelection.staticSelectedListBox = !reset;

                var dataSourceSelected = {
                    data: data.ActiveUserModel.SelectedUserList.Source
                };

                returnObject = listbox.mutual(listBoxID, dataSourceSelection, objUserSelection, dataSourceSelected);

                if (returnObject != null) {
                    $listBoxSelection = returnObject.listBoxSelection;
                    $listBoxSelected = returnObject.listBoxSelected;
                }
                reset = false;
            },
            function (error) {

                swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnLoad, "error");
            }, false);
    },
    initTreeViewAction: function (e) {
        /* Action Forward to user Assign Pop Up*/
        $("#userDomain-id").val($('#dashboardID').val());
        var objUserSelection = {};
        objUserSelection.expandAll = true;
        objUserSelection.declareType = "textbox";
        objUserSelection.postSelectFn = $.searchMessages.initListView;
        treeview.init("userDomain", "userDomain-name", "userDomain-id", objUserSelection);
    },
    initTreeViewAdvanceSearch: function (e) {
        /*Advance Search Pop Up*/
        $("#domain-id").val($('#dashboardID').val());
        var objUser = {};
        objUser.expandAll = true;
        objUser.declareType = "textbox";
        treeview.init("domain", "domain-name", "domain-id", objUser);
    },

    /*Btn Action*/

    actionButtonClickHandler: function (e) {
        $(e).on('click', function () {
            var btnTemp = this;

            commandID = $(this).data('command');

            var $selectedOwner = $.searchMessages.getGridSelections($(gridId));

            if ($selectedOwner.length === 0) {
                swal("", $globalMessages.swal.alert.noMsgSelected);
                return false;
            }
            else if (commandID === 115 && $selectedOwner.length > 1) {
                swal("", $globalMessages.swal.alert.multipleMsgSelected);
                return false;
            }

            switch (commandID) {
                case 115: /*Forward to User*/
                    $.searchMessages.showSendMsgWin('f', $selectedOwner[0].UserMsgID, $selectedOwner[0].MessageID);
                    $(gridId).click();
                    return false;
                case 613: /*Forward to User*/
                    $("#userSelection").text($searchMsgResource.message.fwdToUser);
                    $("#BtnSaveuserSelection").val("Forward");
                    $("#user-selection-modal").modal('show');
                    $.searchMessages.resetUserSelection();
                    return false;
                /*break;*/
                case 621: /*Assign to User*/
                    $("#userSelection").text($searchMsgResource.message.assToUser);
                    $("#BtnSaveuserSelection").val("Assign");
                    $("#user-selection-modal").modal('show');
                    $.searchMessages.resetUserSelection();
                    return false;
                /*break;*/
                default:
            }

            var confirmationMsg = $(this).data('confirmationmsg');
            if (confirmationMsg) {
                swal({
                    title: "",
                    text: confirmationMsg,
                    type: "info",
                    showCancelButton: true,
                    reverseButtons: true,
                }, function () {
                    $.searchMessages.performAction(commandID, $selectedOwner);
                });
            }
            else {
                $.searchMessages.performAction(commandID, $selectedOwner);
            }

            $(this).blur();
        });

    },
    advancedLinkClickHandler: function (e) {
        $(e).on('click', function (x) {
            $('#search-advanced-modal').modal('show');
        });
    },
    resetButtonClickHandler: function (e) {
        $(e).on('click', function (x) {
            $.searchMessages.resetPage();
            $.searchMessages.resetModal();
        });
    },
    resetUserSlectionButtonClickHandler: function (e) {
        $(e).on('click', function (x) {
            $.searchMessages.resetUserSelection();
        });
    },
    searchLinkClickHandler: function (e) {
        $(e).on('click', function (x, y) {
            $.searchMessages.setSearch($(e), $(this));
        });
    },
    searchPressEnter: function (e) {
        $(e).on('keypress', function (enter) {
            if (enter.which === 13) {
                $.searchMessages.search(1);
            }
        });
	},
	searchAdvanceButtonClickHandler: function (e) {
		$(e).on('click', function (x) {
			$.searchMessages.search(1);
			$(this).blur();
		});
	},
    refreshMessageFromHub: function (model) {
        var refreshFlag = $('#MessageHubRefreshFlag').val();
        if (model != null && model.RefreshLocation == refreshFlag) {
            $.searchMessages.search(1);
        }
    },

    searchUserSelectionButtonClickHandler: function (e) {
        $(e).on('click', function (x, y) {
            $.searchMessages.searchUserSelection();
        });
    },
    searchUserSelectionPressEnter: function (e) {
        $(e).on('keypress', function (event) {
            if (event.which === 13) {
                $.searchMessages.searchUserSelection();
                event.preventDefault();
            }
        });
    },

    /*Pop Up Modal*/
    searchModalButtonClickHandler: function (e) {
        $(e).on('click', function (x) {
            $('#formSubmit').submit();
        });
    },
    resetModalButtonClickHandler: function (e) {
        $(e).on('click', function (x) {
            $.searchMessages.resetModal();
        });
    },

    /* Logic */

    getGridSelections: function (event) {
        var entityGrid = event.data("kendoGrid");
        var rows = entityGrid.select();
        var $selectedOwner = [];
        rows.each(function (index, row) {
            var selectedItem = entityGrid.dataItem(row);
            $selectedOwner[index] = { 'MessageID': selectedItem.MessageID, 'UserMsgID': selectedItem.UserMsgID };
        });

        return $selectedOwner;
    },
    getListDataSource: function (event) {
        var entityList = event.data("kendoListBox");

        $ids = [];
        if (entityList != undefined) {
            var rows = entityList.dataItems();
            $(rows).each(function (index, row) {
                $ids[index] = row.Value;
            });
        }
        return $ids;
    },
    performAction: function (command, $selectedOwner) {
        var successType = $(".btn-action[data-command='" + command + "']").data('successtype');
        var successMsg = $(".btn-action[data-command='" + command + "']").data('successmsg');
        var selectedUser = $(".btn-action[data-command='" + command + "']").data('selecteduser');

        var data = {
            Ids: $ids,
            OwnerMsgList: $selectedOwner,
            Action: Number(command),
        };

        var postLoader = false;

        switch (successType) {
            case "Toast":
                postLoader: false;
                break;
            case "Swal":
                postLoader: true;
                break;
            default:
        }

        fxcRequest.post('/Admin/SearchMessages/ExecuteAction'
            , data
            , function (data) {
                $.searchMessages.initGrid($(gridId), refreshBasicSearch);
                switch (successType) {
                    case "Toast":
                        $.toast({
                            heading: $globalMessages.toast.success,
                            text: successMsg,
                            position: 'top-right',
                            loaderBg: '#ff6849',
                            icon: 'success',
                            hideAfter: 3500,
                            stack: 6
                        });
                        break;
                    case "Swal":
                        swal($globalMessages.swal.success.title, successMsg, "success");
                        $("#user-selection-modal").modal('hide');
                        break;
                    default:
                }
            }
            , function (error) {
                swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
            }, postLoader);
    },
    resetModal: function (e) {
        $('#formSubmit').trigger("reset");
        $("#formSubmit").validate().resetForm();
        $.searchMessages.initTreeViewAdvanceSearch();
    },
    resetPage: function (e) {
        $('#search-advanced-modal').modal('hide');
        $(gridId).addClass("hide");

        /*Reset All Field*/
        $('input[data-role="search-all-item"]').val("");

        /*Diabled Action Button*/
        $('#btn-ActionCustom').prop('disabled', true);
    },
    resetUserSelection: function (e) {
        reset = true;
        $("#formUserSelection").trigger("reset");
        $("#formUserSelection").validate().resetForm();
        if (!bind) {
            $.searchMessages.initTreeViewAction();
            bind = true;
        }
        else {
            /*Reselect User From ID*/
            $("#userDomain").tree().unselectAll();
            $("#userDomain-id").val($('#dashboardID').val());
            var getUserData = $("#userDomain").tree().getNodeById($("#userDomain-id").val());

            if (getUserData != undefined) {
                $("#userDomain").tree().select(getUserData);
            }
        }
    },
    setSearch: function (e, currentElement) {
        var searchResult = $(currentElement).attr("data-search");
        $('input[data-role="search-all-item"]').val("");
        $('input[data-role="search-all-item"]').attr("placeholder", searchResult);
        $('input[data-role="search-all-item"]').attr("title", searchResult);

        $(e).removeClass("selected");
        $(currentElement).addClass("selected");
    },
    search: function (isBasicSearch) {
        var searchType = $(".btn-search-action.selected").attr("data-role");
        switch (isBasicSearch) {
            case 1:
                /*Basic Search*/
                $.searchMessages.resetModal();
                var searchValue = $('input[data-role="search-all-item"]').val();
                switch (searchType) {
                    case "1":
                        /*Search by Fax Number*/
                        $("#FaxNo").val(searchValue);
                        break;
                    case "2":
                        /*Search by User*/
                        $("#Username").val(searchValue);
                        break;
                    case "3":
                        /*Search by Message Number*/
                        $("#MsgNo").val(searchValue);
                        break;
                    case "4":
                        /*Search by Tracking Number*/
                        $("#Track").val(searchValue);
                        break;
                    case "5":
                        /*Search by Subject*/
                        $("#Subject").val(searchValue);
                        break;
                    case "6":
                        /*Search by Content*/
                        $("#Content").val(searchValue);
                        break;
                    case "10":
                        /*Search by Content*/
                        $("#MsgId").val(searchValue);
                        break;
                    default:
                }
                break;
            case 2:
                /*Advanced Search*/
                var getSearchValue = "";
                switch (searchType) {
                    case "1":
                        /*Search by Fax Number*/
                        getSearchValue = $("#FaxNo").val();
                        break;
                    case "2":
                        /*Search by User*/
                        getSearchValue = $("#Username").val();
                        break;
                    case "3":
                        /*Search by Message Number*/
                        getSearchValue = $("#MsgNo").val();
                        break;
                    case "4":
                        /*Search by Tracking Number*/
                        getSearchValue = $("#Track").val();
                        break;
                    case "5":
                        /*Search by Subject*/
                        getSearchValue = $("#Subject").val();
                        break;
                    case "6":
                        /*Search by Content*/
                        getSearchValue = $("#Content").val();
                        break;
                    case "10":
                        /*Search by Message Id*/
                        getSearchValue = $("#MsgId").val();
                        break;
                    default:
                }
                $('input[data-role="search-all-item"]').val(getSearchValue);
                break;
            default:
        }
        $.searchMessages.initGrid($(gridId), isBasicSearch);
    },
    searchUserSelection: function (e) {
        /*$.searchMessages.initListView();*/

        var listBoxSelection = $("#listUserSelection").getKendoListBox();
        var searchString = $('input[data-role="search-active-user"]').val();

        listBoxSelection.dataSource.filter({ field: "Text", operator: "contains", value: searchString });
    },
    showSendMsgWin: function (rfType, umid, mid) {
        var url = '/User/Message?rf=' + rfType + '&umid=' + umid + '&mid='
            + mid;
        $.searchMessages.showWin(url, '800', '580', rfType, 'yes');
    },
    showWin: function (winUrl, width, height, winName, resize) {
        var winPopup;
        var url = winUrl;
        var name = winName;

        var features = 'width=' + width + ',height=' + height + ',resizable=' + resize + ',scrollbars=no,toolbar=no,location=no,directories=no,status=no,menubar=no,copyhistory=no';
        winPopup = window.open(url, name, features);
        if (name == "PrintLocalPDF") {
            winPopup.print();
        }
        winPopup.focus();
    }
};