﻿(function ($) {
    var validation = function () {
        $('#formSubmit').validate({
			ignoreTitle: true,
            rules: {
            },
            submitHandler: function (form) {
                $('#search-advanced-modal').modal('hide');
                $.searchUser.search(2);
            }
        });

        $('#formUserProfile').validate({
            ignore: ".ignored",
			ignoreTitle: true,
            rules: {
                "TotalGrid-profile": {
                    required: true,
                    min: 1
                },
                Username: { required: true },
                Password: { required: true, passwordFormat: true },
                PrimaryAddress: { required: true }
            },
            messages: {
                "TotalGrid-profile": {
                    required: "*" + $globalMessages.validation.gridMinLength,
                    min: "*" + $globalMessages.validation.gridMinLength
                },
                PrimaryAddress: {
                    required: $searchUserResource.message.valMinPrimaryEmail
                }
            },
            invalidHandler: function (event, validator) {
                /* 'this' refers to the form*/
                var errors = validator.numberOfInvalids();

                if (errors) {
                    getErrorMsg.push(validator);
                }
            },
            submitHandler: function (form) {
                return false;
            }
        });
        $('#formUserGeneralSetting').validate({
            ignore: ".ignored",
            rules: {
                "GeneralPwdSenderFrm.Value": { email: true },
                "GeneralNotificationFrm.Value": { email: true },
                "GeneralDeliveryFrm.Value": { email: true },
                "SendXmitRetryDelayFax.Value": { number: true },
                "SendXmitRetryDelayFaxRaw.Value": { number: true },
                "SendXmitRetryDelayEmail.Value": { number: true },
                "SendXmitRetryDelayFtp.Value": { number: true },
                "SendXmitRetryDelayFile.Value": { number: true },
                "SendXmitRetryDelayPrinter.Value": { number: true },
                "SendXmitMxAttemptFax.Value": { number: true }
            },
            messages: {

            },
            invalidHandler: function (event, validator) {
                /* 'this' refers to the form*/
                var errors = validator.numberOfInvalids();

                if (errors) {
                    getErrorMsg.push(validator);
                }
            },
            submitHandler: function (form) {
                false;
            }
        });
        $('#formUserFaxSetting').validate({
            ignore: ".ignored",
            rules: {
            },
            messages: {

            },
            invalidHandler: function (event, validator) {
                /* 'this' refers to the form*/
                var errors = validator.numberOfInvalids();

                if (errors) {
                    getErrorMsg.push(validator);
                }
            },
            submitHandler: function (form) {
                return false;
            }
        });
        $('#formUserPermission').validate({
            ignore: ".ignored",
            rules: {

            },
            messages: {

            },
            invalidHandler: function (event, validator) {
                /* 'this' refers to the form*/
                var errors = validator.numberOfInvalids();

                if (errors) {
                    getErrorMsg.push(validator);
                }
            },
            submitHandler: function (form) {
                return false;
            }
        });
        $('#formUserSMTPRelay').validate({
            ignore: ".ignored",
            rules: {
                "EmailSendPort.Value": { checkRequired: "EmailSendServer.Value" },
                "EmailSendAuthPwd.Value": { checkRequired: "EmailSendAuthUsn.Value" },
                "EmailSendTimeout.Value": { number: true }
            },
            messages: {

            },
            invalidHandler: function (event, validator) {
                /* 'this' refers to the form*/
                var errors = validator.numberOfInvalids();

                if (errors) {
                    getErrorMsg.push(validator);
                }
            },
            submitHandler: function (form) {
                return false;
            }
        });
        $('#formUserExchangeIntegration').validate({
            ignore: ".ignored",
            rules: {

            },
            messages: {

            },
            invalidHandler: function (event, validator) {
                /* 'this' refers to the form*/
                var errors = validator.numberOfInvalids();

                if (errors) {
                    getErrorMsg.push(validator);
                }
            },
            submitHandler: function (form) {
                return false;
            }
        });
    };

    var refreshBasicSearch;
    var $grid, bind = false;
    var $data;
    $.searchUser = {
        init: function (e) {
            validation();
            /*Btn Action*/
			$.searchUser.advancedLinkClickHandler($(".btn-search-advanced"));
			$.searchUser.searchAdvanceButtonClickHandler($("#searchAdvanceButton"));
            $.searchUser.resetButtonClickHandler($(".btn-Reset"));
            $.searchUser.searchLinkClickHandler($(".btn-search-action"));
            $.searchUser.searchPressEnter($('input[data-role="search-all-item"]'));

            $.users.actionButtonClickHandler($('.btn-action'));

            $.searchUser.searchModalButtonClickHandler($("button[data-role='search-modal']"));
            $.searchUser.resetModalButtonClickHandler($("button[data-role='reset-modal-value']"));

            $.searchUser.resetPage();
            $.searchUser.resetModal();

            /*Set User Name As Default Search*/
            $.searchUser.setSearch($(".btn-search-action"), $("#btn-search-username"));

            $.form.init();
			$.users.tabButtonClickHandler($('a[data-bs-toggle="tab"]'));
            $.searchUser.initGrid($("#grid"), false, true);

            $('.info-tooltip').tooltip();
        },
		initGrid: function (e, isBasicSearch, emptyGrid) {
			emptyGrid = emptyGrid || false;
            var id = $('#grid');
            $("#grid").removeClass("hide");
            refreshBasicSearch = isBasicSearch;
            var dataSource = {
                transport: {
                    read: {
                        url: '/Admin/SearchUser/Read',
                        dataType: "json",
                        type: "GET"
                    },
                    parameterMap: function (options) {
                        isBasicSearch = isBasicSearch == 1 ? true : false;

                        /* Fix url param for sort values */
                        var result = {
                            IsBasicSearch: isBasicSearch,
                            Username: $('#AdUsername').val(),
                            DisplayName: $('#AdDisplayName').val(),
                            FirstName: $('#AdFirstName').val(),
                            LastName: $('#AdLastName').val(),
                            PreferAddress: $('#AdPreferAddress').val(),
                            DomainID: $('#AdDomain-id').val(),
                            SubDomain: $('#AdSubDomain').prop('checked'),
                            Active: $('#AdActive').val(),
                            Synchronized: $('#AdSynchronized').val(),
                            AuthExternal: $('#AdAuthExternal').val(),
                            Skip: options.skip,
							Take: emptyGrid ? 0 : options.take,
                            Sort: options.sort,
                            SearchText: $('input[data-role="search-all-item"]').val()
                        };
                        if (options.sort && options.sort.length > 0) {
                            result.SortBy = options.sort[0].field;
                            result.Direction = options.sort[0].dir;
                        }
                        return result;
                    }
                },
                schema: {
                    data: "Records",
					total: emptyGrid ? "" : "Total",
                    model: {
                        id: "Id"
                    }
                },
                serverPaging: true,
                serverSorting: true,
                change: function (data) {
                    /*Triggered once data load completed*/
                    if (data.items.length) {
                        $('#btn-ActionCustom').prop('disabled', false);
                    }
                }
            };

            var col = [
                {
                    selectable: true, width: 45,
                    attributes: {
                        "class": "checkboxSelection"
                    }
                },
                { field: 'UserId', hidden: true },
                { field: 'Username', title: $searchUserResource.field.username, minWidth: 120, width: 200, sortable: true },
                { field: 'DomainName', title: $searchUserResource.field.domainName, minWidth: 200, width: 200, sortable: true },
                {
                    field: "IsUserActive",
                    title: $searchUserResource.field.active,
                    width: 120,
                    filterable: {
                        cell: {
                            enabled: false
                        }
                    },
                    template: '<div class="kendo-container"> <i #= IsUserActive == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
                },
                { field: 'RoleName', title: $searchUserResource.field.role, minWidth: 200, width: 200, sortable: true },
                {
                    field: "IsExternalAuth",
                    title: $searchUserResource.field.externalAuth,
                    width: 120,
                    filterable: {
                        cell: {
                            enabled: false
                        }
                    },
                    template: '<div class="kendo-container"> <i #= IsExternalAuth == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
                },
                {
                    field: "IsSync",
                    title: $searchUserResource.field.sync,
                    width: 120,
                    filterable: {
                        cell: {
                            enabled: false
                        }
                    },
                    template: '<div class="kendo-container"> <i #= IsSync == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
                },
                { field: 'DisplayName', title: $searchUserResource.field.displayName, minWidth: 300, width: 300, sortable: true },
                { field: 'FirstName', title: $searchUserResource.field.firstName, minWidth: 300, width: 300, sortable: true },
                { field: 'LastName', title: $searchUserResource.field.lastName, minWidth: 300, width: 300, sortable: true },
                { field: 'PreferredAddress', title: $searchUserResource.field.preferAdd, minWidth: 300, width: 300, sortable: true }
            ];

            var obj = {};
            obj.allowSelectMultipleRow = true;

            /*Link to DomainManagement/user */
            obj.onSelectionFn = $.users.editHandler;

            var $grid = kendogridcustomization.init(id, dataSource, col, obj);
        },
        initForm: function (e) {

        },
        initTreeViewAdvanceSearch: function (e) {
            /*Advance Search Pop Up*/
            $("#AdDomain-id").val($('#dashboardID').val());
            var objUser = {};
            objUser.expandAll = true;
            objUser.declareType = "textbox";
            treeview.init("AdDomain", "AdDomain-name", "AdDomain-id", objUser);
        },

        /*Btn Action*/
        advancedLinkClickHandler: function (e) {
            $(e).on('click', function (x) {
                $('#search-advanced-modal').modal('show');
            });
        },
        createButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $data = null;
                $.searchUser.resetFields();
                $('#modalDocStore').modal('show');
            });
        },
        deleteButtonClickHandler: function (e) {
            $(e).on('click', function (x) {
                $.searchUser.delete();
            });
        },
        resetButtonClickHandler: function (e) {
            $(e).on('click', function (x) {
                $.searchUser.resetPage();
                $.searchUser.resetModal();
            });
        },
        searchLinkClickHandler: function (e) {
            $(e).on('click', function (x, y) {
                $.searchUser.setSearch($(e), $(this));
            });
        },
        searchPressEnter: function (e) {
            $(e).on('keypress', function (enter) {
                if (enter.which === 13) {
                    $.searchUser.search(1);
                }
            });
        },
		searchAdvanceButtonClickHandler: function (e) {
			$(e).on('click', function (x) {
				$.searchUser.search(1);
				$(this).blur();
			});
		},
        /*Pop Up Modal*/
        searchModalButtonClickHandler: function (e) {
            $(e).on('click', function (x) {
                $('#formSubmit').submit();
            });
        },
        resetModalButtonClickHandler: function (e) {
            $(e).on('click', function (x) {
                $.searchUser.resetModal();
            });
        },
        saveclosemodalHandler: function (e) {
            $(e).on('click', function () {
                $('input[name="modal-action"]').val('save & close');
            });
        },

        /* Logic */
        resetModal: function (e) {
            $('#formSubmit').trigger("reset");
            $("#formSubmit").validate().resetForm();
            $.searchUser.initTreeViewAdvanceSearch();
        },
        resetPage: function (e) {
            $('#search-advanced-modal').modal('hide');
            $("#grid").addClass("hide");

            /*Reset All Field*/
            $('input[data-role="search-all-item"]').val("");

            /*Diabled Action Button*/
            $('#btn-ActionCustom').prop('disabled', true);
        },

        resetFields: function () {
        },
        setSearch: function (e, currentElement) {
            var searchResult = $(currentElement).attr("data-search");
            $('input[data-role="search-all-item"]').val("");
            $('input[data-role="search-all-item"]').attr("placeholder", searchResult);
            $('input[data-role="search-all-item"]').attr("title", searchResult);

            $(e).removeClass("selected");
            $(currentElement).addClass("selected");
        },
        search: function (isBasicSearch) {
            var searchType = $(".btn-search-action.selected").attr("data-role");
            switch (isBasicSearch) {
                case 1:
                    /*Basic Search*/
                    $.searchUser.resetModal();
                    var searchValue = $('input[data-role="search-all-item"]').val();
                    switch (searchType) {
                        case "7":
                            /*Search by User Name*/
                            $("#AdUsername").val(searchValue);
                            break;
                        case "8":
                            /*Search by Display Name*/
                            $("#AdDisplayName").val(searchValue);
                            break;
                        case "9":
                            /*Search by Prefer Address*/
                            $("#AdPreferAddress").val(searchValue);
                            break;
                        default:
                    }
                    break;
                case 2:
                    /*Advanced Search*/
                    var getSearchValue = "";
                    switch (searchType) {
                        case "1":
                            /*Search by User Name*/
                            getSearchValue = $("#AdUsername").val();
                            break;
                        case "2":
                            /*Search by Display Name*/
                            getSearchValue = $("#AdDisplayName").val();
                            break;
                        case "3":
                            /*Search by Prefer Address*/
                            getSearchValue = $("#AdPreferAddress").val();
                            break;
                        default:
                    }
                    $('input[data-role="search-all-item"]').val(getSearchValue);
                    break;
                default:
            }
            $.searchUser.initGrid($("#grid"), isBasicSearch);
        },
        /* End Logic */

        /*Post or Get Function*/
        delete: function (e) {

            var selectedItem = $.searchUser.getGridSelections($("#grid"));

            if (selectedItem.length === 0) {
                swal("", $searchUserResource.swal.noUser);
                return false;
            }

            swal({
                title: "",
                text: $searchUserResource.swal.delUser,
                type: "info",
                showCancelButton: true,
                closeOnConfirm: false,
                reverseButtons: true,
                showLoaderOnConfirm: true
            }, function () {

            });
        },
        getGridSelections: function (event) {
            var entityGrid = event.data("kendoGrid");
            var rows = entityGrid.select();
            var $selectedUser = [];
            rows.each(function (index, row) {
                var selectedItem = entityGrid.dataItem(row);
                $selectedUser[index] = selectedItem.Id;
            });

            return $selectedUser;
        },
        save: function () {

        }
    };

    var dataForm;
    var profileFormInit = false;
    var initModalPassword = false;
    var btnCreate = true;
    var getErrorMsg = [];

    var profileTab = true;
    var generalSettingTab = false;
    var faxSettingTab = false;
    var permissionTab = false;
    var smtpRelayTab = false;
    var exchangeIntegrationTab = false;

    $.users = {
        /*Btn Action*/
        actionButtonClickHandler: function (e) {
            $(e).on('click', function () {
                var btnTemp = this;
                commandID = $(this).data('command');
                var selectedItem = $.searchUser.getGridSelections($("#grid"));

                if (selectedItem.length === 0) {
                    swal("", $searchUserResource.swal.noUser);
                    return false;
                }

                switch (commandID) {
                    case 603: /*Reset Password*/
                        $("#modalPassword").modal('show');
                        /*Initialize PopUp Modal Reset on first click*/
                        if (!initModalPassword) {
                            $.password.init();
                            initModalPassword = true;
                        }
                        $.password.actionResetPassword();
                        $(this).blur();
                        return false;
                    /*break;*/
                    default:
                        break;
                }

                var confirmationMsg = $(this).data('confirmationmsg');
                if (confirmationMsg) {
                    swal({
                        title: "",
                        text: confirmationMsg,
                        type: "info",
                        showCancelButton: true,
                        reverseButtons: true
                    }, function () {
                        $.users.performAction(commandID, selectedItem);
                    });
                }
                else {
                    $.users.performAction(commandID, selectedItem);
                }

                $(this).blur();
            });
        },
        editHandler: function (dataItem) {
            generalSettingTab = false;
            faxSettingTab = false;
            permissionTab = false;
            smtpRelayTab = false;
            exchangeIntegrationTab = false;

            $.sectionproperties.TabToForm("TabToFormDiv", "ProfileTab", false);

            var selectedID = dataItem == null ? "" : dataItem.Id;
            $("#defaultSelectedID").val(selectedID);

            $.form.reset();
            $.sectionproperties.SecondLevel();
            var linkFirstTab = document.getElementById('navProfileTab');
            linkFirstTab.click();

            $.sectionproperties.Hidden("EditSection", true);
            $.sectionproperties.Hidden("CreateSection", false);
            $.sectionproperties.Disabled("EditSection", true);
            btnCreate = false;
        },
        tabButtonClickHandler: function (e) {
            $(e).on('shown.bs.tab', function (h) {
                var target = $(h.target).attr("href"); /* activated tab*/
                $.users.resetTab(target);
            });
        },
        /*End Btn Action*/

        /*Post or Get Function*/

        performAction: function (command, selectedItem) {
            var successMsg = $(".btn-action[data-command='']").data('successmsg');
            fxcRequest.post('/Admin/UserSetting/ExecuteAction',
                {
                    Ids: selectedItem.join().split(','),
                    Action: Number(command)
                },
                function (data) {
                    $.searchUser.initGrid();
                    $.toast({
                        heading: $globalMessages.toast.success,
                        text: successMsg,
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'success',
                        hideAfter: 3500,
                        stack: 6
                    });
                },
                function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
                },
                false);
        },
        resetTab: function (target) {
            switch (target) {
                case "#GeneralSettingsTab":
                    if (!generalSettingTab) {
                        $.generalSetting.initForm();
                        generalSettingTab = true;
                    }
                    break;
                case "#FaxSettingsTab":
                    if (!faxSettingTab) {
                        $.faxSetting.initForm();
                        faxSettingTab = true;
                    }
                    break;
                case "#PermissionTab":
                    if (!permissionTab) {
                        $.permission.initForm();
                        permissionTab = true;
                    }
                    break;
                case "#SMTPRelayTab":
                    if (!smtpRelayTab) {
                        $.smtpRelay.initForm();
                        smtpRelayTab = true;
                    }
                    break;
                case "#ExchangeIntegrationTab":
                    if (!exchangeIntegrationTab) {
                        $.exchangeIntegration.initForm();
                        exchangeIntegrationTab = true;
                    }
                    break;
                case "#DelegationTab":
                    $.delegation.initGrid();
                    $.sectionproperties.Hidden("DelegationTable", false);
                    $.sectionproperties.Hidden("DelegationForm", true);
                    break;
                default:
                    break;
            }
        }
    };

    var modalPasswordValidation = function () {
        $("#formModalPassword").validate({
            ignoreTitle: true,
            rules: {
                NewPassword: {
                    required: true,
                    passwordFormat: true
                },
                ConfirmPassword: {
                    equalTo: "#NewPassword",
                    required: true
                }
            },
            messages: {
                ConfirmPassword: {
                    equalTo: $searchUserResource.message.pwdNotMatch
                }
            },
            submitHandler: function (form) {
                $.password.save();
            }
        });
    };
    $.password = {
        init: function (dataItem) {
            /*Btn Action*/
            modalPasswordValidation();
            $.password.resetPasswordButtonClickHandler($("#BtnResetmodalPassword"));
            $.password.saveclosemodalHandler($("#BtnSaveClosemodalPassword"));
        },

        /*Btn Action*/
        resetPasswordButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.password.actionResetPassword();
            });
        },
        saveclosemodalHandler: function (e) {
            $(e).on('click', function () {
                $('input[name="modalPassword-action"]').val('save & close');
            });
        },
        /*End Btn Action*/

        /* Logic */
        actionResetPassword: function (e) {
            $("#formModalPassword").trigger("reset");
            $("#formModalPassword").validate().resetForm();
        },
        save: function (e) {
            var idval = 0;
            var successMsg = $(".btn-action[data-command='603']").data('successmsg');
            var selectedItems = $.searchUser.getGridSelections($("#grid"));
            fxcRequest.post('/Admin/UserSetting/ResetPassword',
                {
                    Ids: selectedItems.join().split(','),
                    Password: $('#ConfirmPassword').val()
                },
                function (data) {
                    $.searchUser.initGrid();
                    $.toast({
                        heading: $globalMessages.toast.success,
                        text: successMsg,
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'success',
                        hideAfter: 3500,
                        stack: 6
                    });
                },
                function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
                },
                false);

            if ($('input[name="modalPassword-action"]').val() === 'save & close') {
                $("#modalPassword").modal('hide');
                $('input[name="modalPassword-action"]').val('');
            }
        }
        /* End Logic */
    };

    $.form = {
        init: function (dataItem) {
            /*Btn Action*/
            $.form.resetButtonClickHandler($(".btn-Reset2"));
            $.form.backButtonClickHandler($(".btn-back2"));
            $.form.saveButtonClickHandler($(".btn-save2"));
        },

        /*Btn Action*/
        resetButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.form.reset();
            });
        },
        backButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.form.back();
            });
        },
        saveButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.form.multipleSubmissionForm();
            });
        },
        /*End Btn Action*/

        /* Logic */
        back: function (e) {
            $.sectionproperties.FirstLevelView();
            $.sectionproperties.Hidden("ExchangeIntegrationLink", true);
            $.sectionproperties.Hidden("DelegationLink", true);
        },
        modelData: function (e) {
            var GeneralSettingModel = $('#completeGeneralTab').val() == "true" ? $("#formUserGeneralSetting").MapFormData() : [];
            var FaxSettingModel = $('#completeFaxTab').val() == "true" ? $("#formUserFaxSetting").MapFormData() : [];
            var PermissionModel = $('#completePermissionTab').val() == "true" ? $("#formUserPermission").MapFormData() : [];
            var SMTPRelayModel = $('#completeSMTPTab').val() == "true" ? $("#formUserSMTPRelay").MapFormData() : [];
            var ExchangeModel = $('#completeExchangeTab').val() == "true" ? $("#formUserExchangeIntegration").MapFormData() : [];

            var data = GeneralSettingModel.concat(FaxSettingModel, PermissionModel, SMTPRelayModel, ExchangeModel);
            var formData = {
                "UserId": $("#defaultSelectedID").val(),
                "DomainID": $('#domain-id').val(),
                "UserProfile": $.profile.modelData(),
                "FormData": data,
                "GeneralSettingActive": data
            };
            if (ExchangeModel.length) {
                formData.ExchangeModel = { ExchangePasswordIsEncrypted: $("#ExchangePasswordIsEncrypted").val() };
            }
            return formData;

        },
        multipleSubmissionForm: function () {
            getErrorMsg = [];
            if (profileTab) {
                $('#formUserProfile').submit();
            }
            if (generalSettingTab) {
                $('#formUserGeneralSetting').submit();
            }
            if (faxSettingTab) {
                $('#formUserFaxSetting').submit();
            }
            if (permissionTab) {
                $('#formUserPermission').submit();
            }
            if (smtpRelayTab) {
                $('#formUserSMTPRelay').submit();
            }
            if (exchangeIntegrationTab) {
                $('#formUserExchangeIntegration').submit();
            }

            if (getErrorMsg[0] != null) {
                $("#Password").val("");
                $.sectionproperties.ActiveTab("TabToFormDiv", $(getErrorMsg[0].errorList[0].element).parent().closest('.tab-pane').attr("id"));
                $('html, body').animate({
                    scrollTop: $(getErrorMsg[0].errorList[0].element).offset().top - 200
                }, 1000);
            } else {
                $.form.saveHandler(btnCreate);
            }
        },
        reset: function (e) {
            $.profile.reset();

            if (generalSettingTab) {
                $.generalSetting.reset();
            }

            if (faxSettingTab) {
                $.faxSetting.reset();
            }

            if (permissionTab) {
                $.permission.reset();
            }

            if (smtpRelayTab) {
                $.smtpRelay.reset();
            }

            if (exchangeIntegrationTab) {
                $.exchangeIntegration.reset();
            }

            generalSettingTab = false;
            faxSettingTab = false;
            permissionTab = false;
            smtpRelayTab = false;
            exchangeIntegrationTab = false;
            if (!btnCreate) {
                var target = $('a[data-bs-toggle="tab"].active').attr("href"); /* get activated tab*/
                $.users.resetTab(target);
            }
        },
        saveHandler: function (e) {
            if (e) {
                $.form.create();
            }
            else {
                $.form.save();
            }
        },
        /* End Logic */

        save: function (e) {
            if ($('#completeProfileTab').val() == "true") {
                $.address.save(true);
                fxcRequest.post('/Admin/UserSetting/Save',
                    $.form.modelData(),
                    function (data) {
                        $.searchUser.initGrid();
                        $.form.reset();
                        swal($globalMessages.swal.success.title, $searchUserResource.swal.successUser, "success");
                    }, function (error) {
                        swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
                }, true);
            }
            else {
                swal($globalMessages.swal.warningTitle, $userResource.validation.stillLoading, "warning");
            }
        },
        create: function (e) {
            $.address.save(true);
            $("#defaultSelectedID").val("");
            generalSettingTab = false;
            faxSettingTab = false;
            permissionTab = false;
            smtpRelayTab = false;
            exchangeIntegrationTab = false;
            fxcRequest.post('/Admin/Manage/Profile/Create',
                $.profile.modelData(),
                function (data) {
                    $.searchUser.initGrid();
                    swal($globalMessages.swal.success.title, $searchUserResource.swal.successUser, "success");
                    $.form.back();

                }, function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
                }, true);
            /*Post Fn*/
        }
    };
})(window.jQuery);