﻿var bodyScroll = $("html[dir]").attr("dir") === "rtl" ? "left" : "right";
var menuScroll = $("html[dir]").attr("dir") === "rtl" ? "right" : "left";

var custom = {
	initHeight: function (resizeWindowFn) {
		resizeWindowFn = resizeWindowFn || false;
		var setMainTimer = 200;
		var setMinWidthFaxCoreBtn = 0;

		jQuery('.faxcoreBreadcrumbBtn > div:visible > *:visible').each(function () {
			var getMarginLeftBtn = parseInt($(this).css("margin-left"));
			var getMarginRightBtn = parseInt($(this).css("margin-right"));
			setMinWidthFaxCoreBtn += $(this).outerWidth() + (getMarginLeftBtn > 0 ? getMarginLeftBtn : 0) + (getMarginRightBtn > 0 ? getMarginRightBtn : 0);
		});
		var getFxcButtonWidth = $("#fxc-button").width();
		setMinWidthFaxCoreBtn = setMinWidthFaxCoreBtn > getFxcButtonWidth ? getFxcButtonWidth : setMinWidthFaxCoreBtn;
		$(".faxcoreBreadcrumbBtn").css("min-width", setMinWidthFaxCoreBtn + 20 + "px");

		$(".modal-body").each(function (e, index) {

			if ($(this).hasClass("specialmodal")) {
				$(this).removeClass("specialmodal");
				var $newdiv1 = $("<div class='specialmodal'></div>"),
					existingChild = $(this).children();
				$newdiv1.append(existingChild);
				$(this).append($newdiv1);
			}
			custom.setModal($(this).closest(".modal"));
		});


		setTimeout(function () {
			$('.dropdown-menu').each(function (e, index) {
				custom.setDropDownMenu($(this));

				custom.setDropDownLocation($(this));
			});
		}, setMainTimer);
	},
	getBrowserVersion: function () {
		var type = '';
		var userAgent = navigator.userAgent;

		if (userAgent.indexOf('Opera') !== -1) {
			return 'opera';
		} else if (userAgent.indexOf('Firefox') !== -1) {
			return 'firefox';
		} else if (userAgent.indexOf('Edge') !== -1) {
			return 'edge';
		} else if (userAgent.indexOf('Chrome') !== -1) {
			return 'chrome';
		}
	},
	setDropDownLocation: function (e) {
		if ($(e).parent().is(":visible")) {
			/*calulcate top bottom position*/
			var windowHeight = $(window).outerHeight();
			var parentTop = $(e).parent().offset().top;
			var parentHeight = $(e).parent().height();
			var elementHeight = $(e).outerHeight();

			if (windowHeight - parentTop - parentHeight < elementHeight + 50 && $(e).closest("header").length === 0) {
				var newTopLocation = elementHeight + 2;
				$(e).css('transform', "translate3d(0px, -" + newTopLocation + "px, 0px)");
			}

			/*calculate left right position*/
			if ($(e).hasClass("dropdown-menu-left")) {
				var parentLeft = $(e).parent().offset().left;
				var parentWidth = $(e).parent().width();
				var elemWidth = $(e).width();
				var windowWidth = $(window).width();
				var isRtl = $(e).closest("html[dir]").length > 0 && $(e).closest("html[dir]").attr("dir") === "rtl";

				$(e).removeClass("exceedLeft");
				$(e).removeClass("exceedRight");

				if (!isRtl && windowWidth < parentLeft + elemWidth) {
					$(e).addClass("exceedRight");
				}
				if (isRtl && windowWidth < parentLeft + elemWidth + 30) {
					$(e).addClass("exceedRight");
				}
				else if (isRtl && parentLeft + parentWidth - 20 < elemWidth) {
					$(e).addClass("exceedLeft");
				}
			}
		}
	},
	setDropDownMenu: function (e) {
		var rowHeight = $(window).height();
		if ($(e).parent().length) {
			var currentLocation = $(e).parent().offset().top;
			var calHeight = (rowHeight - currentLocation) / 2;
			calHeight = calHeight < 150 ? 150 : calHeight;
			calHeight = calHeight > 500 ? 500 : calHeight;
			if (!$(e).has(".menu-scrollbar").length) {
				var $newdiv1 = $("<div class='menu-scrollbar'></div>"),
					existingChild = $(e).children();

				if (existingChild.length > 0) {
					$newdiv1.append(existingChild);
					$(e).append($newdiv1);

					$(e).children(".menu-scrollbar").slimScroll({
						height: 'auto',
						position: bodyScroll,
					});

					$(e).children(".slimScrollDiv").children(".menu-scrollbar").css('max-height', $(e).children(".slimScrollDiv").children(".menu-scrollbar").css('height'));
					$(e).children(".slimScrollDiv").children(".menu-scrollbar").css('height', '');
				}
			}

			if ($(e).has(".slimScrollDiv").length) {
				$(e).children(".slimScrollDiv").css('height', 'auto');
				$(e).children(".slimScrollDiv").children(".menu-scrollbar").css('max-height', calHeight + 'px');
			}
		}
	},
	setCustomHeight: function (e, calHeight) {
		calHeight = calHeight || 150;
		calHeight = calHeight < 150 ? 150 : calHeight;
		if (!$(e).has(".menu-scrollbar").length) {

			$(e).slimScroll({
				height: calHeight,
				position: bodyScroll,
			});
		}

		if ($(e).parent(".slimScrollDiv").length) {
			$(e).css('height', calHeight);
			$(e).parent(".slimScrollDiv").css('height', calHeight);
		}
	},
	setModal: function (modalId) {

		if ($(modalId).length === 0 || !$(modalId).is(":visible")) {
			return false;
		}

		var e = $(modalId).find(".modal-body:not(.noscroll)");
		var getWindowHeight = $(window).outerHeight();
		var calculateMaxModal = getWindowHeight * 80 / 100;
		var getCustomScrollDiv = $(modalId).find(".customScrollDiv");
		if ($(e).length > 0) {
			if ($(e).parent(".slimScrollDiv").length) {
				$(e).css('height', "auto");
				$(e).parent(".slimScrollDiv").css('height', "auto");
			}

			var getModalHeight = $(modalId).find(".modal-dialog").outerHeight();
			var getModalParent = $(e);
			var getModalBottomHeight = 0;
			while (getModalParent.length && getModalParent.is(":visible")) {

				if (getModalParent.next().length && getModalParent.next().is(":visible")) {
					getModalBottomHeight = getModalParent.next().outerHeight();
					break; /* breaks out of loop completely */
				}

				getModalParent = getModalParent.parent();
				if (getModalParent.hasClass("modal")) {
					break;
				}

			}
			var getSpecialBodyOffset = 56;

			var calcHeight = getWindowHeight - getSpecialBodyOffset - getModalBottomHeight - 20;
			calcHeight = calcHeight > calculateMaxModal ? calculateMaxModal : calcHeight;

			calcHeight = getWindowHeight > getModalHeight ? "auto" : calcHeight;

			custom.setCustomHeight($(e), calcHeight);

			getModalHeight = $(modalId).find(".modal-dialog").outerHeight();
			if (getWindowHeight > getModalHeight) {
				$(modalId).find(".modal-dialog").removeClass("fixedTop");
			}
			else {
				$(modalId).find(".modal-dialog").addClass("fixedTop");
			}

			if ($(e).parent(".slimScrollDiv").length) {
				var getMinHeight = $(e).parent(".slimScrollDiv").height() > 250 ? 250 : 150;
				$(e).css('min-height', getMinHeight);
				$(e).parent(".slimScrollDiv").css('min-height', getMinHeight);
			}
		}
		else if ($(getCustomScrollDiv).length > 0) {
			if ($(getCustomScrollDiv).parent(".slimScrollDiv").length) {
				$(getCustomScrollDiv).css('height', "auto");
				$(getCustomScrollDiv).parent(".slimScrollDiv").css('height', "auto");
			}
			var getModalCustomScrollHeight = $(modalId).find(".modal-dialog").outerHeight();

			var getModalCustomScrollParent = $(getCustomScrollDiv);
			var getModalCustomScrollBottomHeight = 0;
			while (getModalCustomScrollParent.length && getModalCustomScrollParent.is(":visible") && getModalCustomScrollParent) {

				if (getModalCustomScrollParent.next().length && getModalCustomScrollParent.next().is(":visible") && !getModalCustomScrollParent.hasClass("customScrollDiv")) {
					getModalCustomScrollBottomHeight = getModalCustomScrollParent.next().outerHeight();
					break; /* breaks out of loop completely */
				}

				getModalCustomScrollParent = getModalCustomScrollParent.parent();
				if (getModalCustomScrollParent.hasClass("customScrollDiv")) {
					break;
				}

			}
			var getModalCustomScrollOffsetTop = Math.abs($(modalId).find(".modal-dialog").offset().top);
			var getCustomScrollModalOffsetTop = Math.abs($(getCustomScrollDiv).offset().top);
			var getCustomScrollSpecialBodyOffset = Math.abs(getModalCustomScrollOffsetTop - getCustomScrollModalOffsetTop);
			calculateMaxModal = calculateMaxModal - getCustomScrollSpecialBodyOffset;

			var calcCustomScrollHeight = getWindowHeight - getModalCustomScrollBottomHeight - 20;

			calcCustomScrollHeight = calcCustomScrollHeight > calculateMaxModal ? calculateMaxModal : calcCustomScrollHeight;

			calcCustomScrollHeight = calculateMaxModal > getModalCustomScrollHeight ? "auto" : calcCustomScrollHeight;

			custom.setCustomHeight($(getCustomScrollDiv), calcCustomScrollHeight);

			getModalCustomScrollHeight = $(modalId).find(".modal-dialog").outerHeight();

			if (getWindowHeight > getModalCustomScrollHeight) {
				$(modalId).find(".modal-dialog").removeClass("fixedTop");
			}
			else {
				$(modalId).find(".modal-dialog").addClass("fixedTop");
			}

			if ($(getCustomScrollDiv).parent(".slimScrollDiv").length) {
				var getCustomScrollMinHeight = $(getCustomScrollDiv).parent(".slimScrollDiv").height() > 250 ? 250 : 150;
				$(getCustomScrollDiv).css('min-height', getCustomScrollMinHeight);
				$(getCustomScrollDiv).parent(".slimScrollDiv").css('min-height', getCustomScrollMinHeight);
			}
		}
		else {
			setTimeout(function () {
				var getModalScrollHeight = $(modalId).find(".modal-dialog").outerHeight();

				if (getWindowHeight > getModalScrollHeight) {
					$(modalId).find(".modal-dialog").removeClass("fixedTop");
				}
				else {
					$(modalId).find(".modal-dialog").addClass("fixedTop");
				}
			}, 200);
		}
	}
};

$(function () {
	"use strict";
	$(function () {
		$(".preloader").fadeOut();
	}), jQuery(document).on("click", ".mega-dropdown", function (i) {
		i.stopPropagation();
	});

	$(window).ready(),
		$(window).on("resize", custom.initHeight),
		$(document).ready(function () {
			$(".fxc-main-content-body, .slimScrollDiv").css("overflow", "hidden").parent().css("overflow", "visible");
		}),  $(function () {
			$('[data-toggle="tooltip"]').tooltip();
		}), $(".scroll-sidebar").slimScroll({
			position: menuScroll,
			size: "5px",
			height: "100%",
			color: "#dcdcdc"
		});
	
		$("body").trigger("resize"), $(".list-task li label").click(function () {
			$(this).toggleClass("task-done")
		}), $('a[data-action="collapse"]').on("click", function (i) {
			i.preventDefault(), $(this).closest(".card").find('[data-action="collapse"] i').toggleClass("ti-minus ti-plus"), $(this).closest(".card").children(".card-body").collapse("toggle");
		}), $('a[data-action="expand"]').on("click", function (i) {
			i.preventDefault(), $(this).closest(".card").find('[data-action="expand"] i').toggleClass("mdi-arrow-expand mdi-arrow-compress"), $(this).closest(".card").toggleClass("card-fullscreen");
		}), $('a[data-action="close"]').on("click", function () {
			$(this).closest(".card").removeClass().slideUp("fast");
	});
});