﻿(function ($) {	

	const electron = require('electron');
	const { ipcRenderer } = electron;
	/*var ipcRenderer = null;*/

	var selectedFilter = 0;
	var countAdd = 1;
	var preventAction = true;
	var valueChange = true;
	var countMe = 0;
	var firstLoad = true;
	var controlRecipient = $('#sender_to');
	var $gridContact;
	var addressType = {
		generic: "generic",
		addrBook: "addrBook"
	};
    var validation = function () {
        $.validator.addMethod("noSpace", function (value, element) {
            return value == '' || value.trim().length != 0;
        }, $printer.validation.noSpace);

		$('#formSubmit').submit(function (e) {
			if ($(this).valid()) {
				$(this).submit(function () {
					return false;
				});
				$("#grid .k-grid-edit-row").find(".k-grid-cancel").click();
				return true;
			}
			else {
				return false;
			}
		});
		$('#formSubmit').validate({
			ignore: ".ignore",
			ignoreTitle: true,
			errorClass: "field-validation-error",
			rules: {
				"totalRowGrid": {required: true, min: 1},
				"sender_from": { required: true, noSpace: true },
				"sender_to": { required: true },
                "sender_approval": { required: true, noSpace: true },
			},
			invalidHandler: function (e, validator) {
				var arrayList = validator.errorList;
				for (x in arrayList) {
					var tempParentID = $("#accordion").find("#" + arrayList[x].element.id).closest(".ui-accordion-content:hidden");
					if (tempParentID.length > 0) {
						$("#" + tempParentID.attr("aria-labelledby") + "").click();
					}
				}
			},
			submitHandler: function (form) {
				$.printer.sent();
			}
		});
	};

	function validateForm(x) {

		/*var x = [{ Key: "DisplayAddr", Message: "This field is required." }, { Key: "DisplayAddr", Message: "This field is required." }];*/
		var errorTemplate = '<div class="k-widget k-tooltip k-tooltip-validation"' +
			'style="margin:0.5em"><span class="k-icon k-i-warning"> </span>' +
			'#=message#<div class="k-callout k-callout-n"></div></div>';
		var result = { rules: {}, messages: {}, errorTemplate: errorTemplate };

		var setRules = {
			CustomRules: function (input) {
				for (var i = 0; i < x.length; i++) {
					var getResult = x[i];
					if (getResult !== null && getResult !== undefined) {
						if (input.is("[name=" + getResult.Key + "]")) {
							return valueChange;
						}
					}

				}
				return true;
			}
		};
		var setmessages = {
			CustomRules: function (input) {
				/*only address will be validated*/
				for (var i = 0; i < x.length; i++) {
					var getResult = x[i];
					if (input.is("[name=" + getResult.Key + "]")) {
						return getResult.Message;
					}
				}
				return "3";
			}
		};
		result.rules = setRules;

		result.messages = setmessages;


		var validator = $("#grid").kendoValidator(result).data("kendoValidator");

		if (validator.validate()) {
			return true;
		}
		else {
			return false;
		}

	}

	function customDisplayEditor(container, options) {

		$('<div class="inputWithIcon"><input type="text" placeholder="Fax Number" maxlength="15" class="k-input k-textbox form-control" name="Address" data-bind="value:' + options.field + '" required><i class="fa fa-fax fa-lg fa-fw" aria-hidden="true"></i></div>').appendTo(container);
	}

	$.printer = {
		init: function (e) {
			var icons = {
				header: "ui-icon-circle-arrow-e",
				activeHeader: "ui-icon-circle-arrow-s"
			};
			$("#accordion").accordion({
				icons: icons,
				heightStyle: "content",
				collapsible: true,
				active: false
			});
			$.printer.addAddressBookBtnClickHandler($(".recipient_addContact"));
			$.printer.initGrid();
			$.addressbook.init();

			validation();
			$.printer.initTracking();
			$.printer.initBootstrapTagInput();
			$.imageViewer.documentChangeClickHandler($("#sender_document"));
			$.printer.addRecipientClickHandler($("#btn-taginput-addRecipient"));
			$.printer.addRecipientModalClickHandler($("#btn-taginput-addRecipientModal"));
			$.printer.addRecipientAddressBookClickHandler($("#btn-taginput-addRecipientAddressBook"));
			$.printer.deleteRecipientClickHandler($("#btn-taginput-deleteRecipient"));

			$("#btn-taginput-addRecipient").click();

			$.ipcRender.init();
		},
		initGrid: function (data) {
			var id = $("#grid");
			var dataSource = {
				data: data,
				schema: {
					model: {
						id: "Id",
						fields: {
							Id: { editable: false, nullable: true },
							IsRRSOn: { editable: false, defaultValue: false },
							IsRRFOn: { editable: false, defaultValue: false },
							Name: {
                                validation: {
                                    required: {
                                        message: "This field is required"
                                    }
                                }
							},
							DisplayAddr: {
								validation: {
									required: {
										message: "This field is required"
									}
								}
							},
							CompanyName: "CompanyName"
						}
					}
				},
				requestStart: function (e) {
					/*prevent grid navigation*/
					if (preventAction) {
						e.preventDefault();
					}
				}
			};
			var columns = [];
			columns = [
				{
					selectable: true, width: 45,
					attributes: {
						"class": "checkboxSelection"
					}
				},
				{ field: "id", title: $globalMessages.grid.id, hidden: true },
				{ field: "Name", title: $printer.grid.colName, width: "180px" },
				{ field: "CompanyName", title: $printer.grid.colCompany, width: "130px" },
				{ field: "DisplayAddr", title: $printer.grid.colAddress, width: "150px", editor: customDisplayEditor },
				{ field: "EncryptStatus", title: $printer.grid.colEncryptStatus, hidden: true },
				{ field: "NotifyList", title: $printer.grid.colNotifyList, hidden: true },
				{
					field: "IsRRSOn",
					title: $globalMessages.grid.ns,
					width: "45px",
					sortable: false,
					editable: function (e) { return false; },
                    template: '<div class="custom-checkbox"><input class="k-checkbox-custom rrs" #= IsRRSOn == true ? \'checked="checked"\' : "" # data-role="checkbox" data-id="#= uid #" id="rrs-#= uid #" type="checkbox"> '
                        + '     <label for="rrs-#= uid #" class="k-checkbox-custom-label k-no-text" title="' + $printer.field.nsTitle + '"></label></div>'
				},
				{
					field: "IsRRFOn",
					title: $globalMessages.grid.ne,
					width: "45px",
					sortable: false,
					editable: function (e) { return false; },
                    template: '<div class="custom-checkbox"><input class="k-checkbox-custom rrf" #= IsRRFOn == true ? \'checked="checked"\' : "" # data-role="checkbox" data-id="#= uid #" id="rrf-#= uid #" type="checkbox"> '
                        + '     <label for="rrf-#= uid #" class="k-checkbox-custom-label k-no-text" title="' + $printer.field.neTitle + '"></label></div>'
				},
				{
					command: [
						{
							name: "edit",
							iconClass: "k-icon k-i-copy",
							text: {
								edit: "Custom edit",
								cancel: "",
								update: ""
							}
						},
                        { name: "destroy", template: "<a role='button' class='k-button-icontext k-grid-delete' title='" + $printer.button.delete + "' ><i class='fa fa-trash-o'></i></a>" }
					],
					title: "&nbsp;", width: 100
				}
			];

			var obj = {};
			obj.editable = {
				mode: "inline",
				createAt: "top",
				confirmation: false
			};
			obj.remove = function (e) {
				$.tempData = e.model;
				controlRecipient.tagsinput('remove', e.model);
				$.toast({
					heading: $globalMessages.toast.success,
					text: $printer.toast.contactDelete,
					position: 'bottom-right',
					loaderBg: '#ff6849',
					icon: 'info',
					hideAfter: 3500,
					stack: 6
				});
			};
			obj.totalInputType = "#totalRowGrid";
			obj.pageSizes = false;
            obj.toolbar = [
                {
                    template: '<a class="k-button k-button-icontext k-grid-add" href="\\#" title="' + $printer.button.generalContactTitle + '"><span class="fa fa-plus"></span></a>'
                },
				/*{ name: "create", text: " "}, */
				{
					template: '<a class="k-button k-button-icontext k-button-outline" href="\\#" onclick="return $.printer.addAddressBookModalClickHandler()" title="' + $printer.button.aBContactTitle + '"><i class="fa fa-address-book-o" aria-hidden="true"></i> ' + $printer.button.aBContact + '</a>'
				},
				{
					template: '<a class="k-button k-button-icontext k-button-outline-danger" href="\\#" onclick="return $.printer.deleteAddressBookClickHandler()" title="' + $printer.button.deleteTitle + '"><span class="k-icon k-i-delete"></span></a>'
				}
			];

			obj.save = function (e) {
				e.preventDefault();
				fxcRequest.post('/PrinterApp/AddressBook/AddRecp',
					{
						RecepientModel: {
							"RecipientDelivery": 2,
							"RecipientDDLAddAdrressBook": $("#DdlAddToAddrBk").val(),
							"RecipientName": e.model.Name,
							"RecipientCompany": e.model.CompanyName,
							"RecipientFaxNumber": e.model.DisplayAddr,
							"RecipientAddress": true,
							"RecipientIsRRFOn": e.model.IsRRFOn,
							"RecipientIsRRSOn": e.model.IsRRSOn,
							"RecipientAddAddressBook": true
						},
						RecpGridData: $.printer.getExistingRecpData(),
						DelegatorID: 0,
						DelgProID: 0
					}
					, function (data) {
						preventAction = false;
						$.toast({
							heading: $globalMessages.toast.success,
							text: $printer.toast.contactSuccess,
							position: 'bottom-right',
							loaderBg: '#ff6849',
							icon: 'info',
							hideAfter: 3500,
							stack: 6
						});

						$.printer.initGrid(data.RecpList);
					}
					, null, false, function (error) {
						valueChange = false;
						if (error.responseJSON !== null && error.responseJSON !== undefined) {
							if (error.responseJSON.TypeName === "ValidationErrors") {
								validateForm(error.responseJSON.Value);
							}
						}

					});

			};
			obj.customizeCheckbox = true;
			obj.edit = function () {
				preventAction = true;
				$("input[name='DisplayAddr']").change(function () {
					valueChange = true;
				});
			};
			obj.dataSourceOnSuccessFn = $.printer.addBootstrapTagInput;
			$gridRec = kendogridcustomization.init(id, dataSource,
				columns, obj);
		},
		initTracking: function (e) {
			$("#trackingInfoForm").addClass("divloading");
			fxcRequest.get('/PrinterApp/Message/GetTrackingInfo',
				{
					"Mid": $('#Mid').val()
				},
				function (data) {
					var tracking = data.Tracking;
					var trackingInfoForm = tracking.TrackingInfoHtml;
					$("#trackingInfoForm").html('');
					$("#trackingInfoForm").append(trackingInfoForm);
					$.printer.trackingValidation();
					$("#trackingInfoForm").removeClass("divloading");
					$.printer.toggleTrackingMandatoryField();
				},
				function (error) {
					/* console.log(error);*/
				},false);


		},
		initBootstrapTagInput: function (e) {
		
			var senderTagInput = controlRecipient.tagsinput({
				trimValue: true,
				itemValue: 'uid',  /* this will be used to set id of tag*/
				itemText: '', /* this will be used to set text of tag*/
				tagClass: function (item) {
					return "tags-fxc label label-primary " + (item.AddressID != undefined && item.AddressID > 0 ? addressType.addrBook : addressType.generic);
				},
				freeInput: false
			});

			controlRecipient.tagsinput('input').prop("readonly", true);
			if (senderTagInput.length > 0) {
				senderTagInput[0].$container.attr("data-input", "sender_to");
				senderTagInput[0].$container.addClass("printer-bootstrap-tagsinput");
				senderTagInput[0].$container.attr("tabindex", "-1");
				senderTagInput[0].$container.focusin(function (e) {
					$(this).addClass("maxHeight");
					var totalRecipient = controlRecipient.tagsinput('items').length;
					if (totalRecipient === 0) {
						$("#btn-taginput-addRecipient").click();
					}
				});

				senderTagInput[0].$container.focusout(function () {
					$(this).removeClass("maxHeight");
				});
			}

			$('#sender_to').on('itemAdded', function (event) {
				/* event.item: contains the item*/
				$.printer.setRecipientTagInput();

				/**
				 * Set Display of Input Tags
				 */
				var item = event.item;
				var getAddressType = item.AddressType != undefined && item.AddressType > 0 ? item.AddressType : 0;
				var setAddrName = $("<div class=\"addrName\"><div class=\" elipsis maxWidth-100\">" + (item.Name != undefined && item.Name.length > 0 ? item.Name : "") + "</div></div>");
				var setAddrCompany = $("<div class=\"addrCompany \">" + (item.CompanyName != undefined && item.CompanyName.length > 0 ? "<div class=\"elipsis\">(</div><div class=\"elipsis maxWidth-80\">" + item.CompanyName + "</div><div class=\"elipsis\">)</div>" : "") + "</div>");
				var setAddrInfo = $("<div class=\"addrInfo\">" + (item.DisplayAddr != undefined && item.DisplayAddr.length > 0 ? "<div class=\"elipsis\">-</div><div class=\" elipsis maxWidth-200\">" + item.DisplayAddr + "</div>": "") + "</div>");
				$($('.printer-bootstrap-tagsinput').children(".tag").last()).attr("title", item.Name);
				$($('.printer-bootstrap-tagsinput').children(".tag").last()).attr("data-addressType", getAddressType);
				$($('.printer-bootstrap-tagsinput').children(".tag").last()).prepend(setAddrInfo).prepend(setAddrCompany).prepend(setAddrName);
			});

			$('#sender_to').on('itemRemoved', function (event, x) {
				/* event.item: contains the item*/
				$.printer.setRecipientTagInput();
				var item = event.item;
				var dataSource =$('#grid').data("kendoGrid").dataSource;
				/*Delete Kendo grid item*/
				var dataItem = item != undefined ? dataSource.getByUid(item.uid): item;
				if (dataItem != undefined)
				{
					dataSource.remove(dataItem);
				}
			});
		},

		/*Btn Action*/
		addRecipientClickHandler: function (e) {
			$(e).on("click", function (e) {
				$("#grid .k-grid-edit-row").find(".k-grid-cancel").click();
				$("#modalAddressRecipient").modal("show");
				$(".AddressBookView").hide();
				$(".RecipientView").show();
				$(".k-grid-add").click();
			});
		},
		addRecipientModalClickHandler: function (e) {
			$(e).on("click", function (e) {
				$("#grid .k-grid-edit-row").find(".k-grid-cancel").click();
				$(".AddressBookView").hide();
				$(".RecipientView").show();
				$(".k-grid-add").click();
			});
		},
		addRecipientAddressBookClickHandler: function (e) {
			$(e).on("click", function (e) {
				$("#grid .k-grid-edit-row").find(".k-grid-cancel").click();
				$("#modalAddressRecipient").modal("show");
				$(".AddressBookView").show();
				$(".RecipientView").hide();
				$('#grid2').data('kendoGrid').refresh();
				kendogridcustomization.customizeGridHeight($('#grid2'));
			});
		},

		deleteRecipientClickHandler: function (e) {
			$(e).on("click", function (e) {
				$.printer.delete(true);
			});
		},
		addAddressBookModalClickHandler: function (e) {
			$("#grid .k-grid-edit-row").find(".k-grid-cancel").click();
			$(".AddressBookView").show();
			$(".RecipientView").hide();
			$('#grid2').data('kendoGrid').refresh();
			kendogridcustomization.customizeGridHeight($('#grid2'));
		},
		deleteAddressBookClickHandler: function (e) {
			$.printer.delete();
		},
		addAddressBookBtnClickHandler: function (e) {
			$(e).on('click', function () {
				$.printer.addRecpFromAddrBook(this);
			});
		},

		/* Logic */
		logout: function (e) {
			window.location = '/logout?returnurl=' + window.location.pathname + "?path=" + $("#documentPath").val();
		},
		toggleTrackingMandatoryField: function () {
			/* Forced accordian to expand if there is mandatory tracking */
			var mandatoryField = $('input[required], select[required]', $('#trackingInfoForm'));
			if (mandatoryField.length > 0) {
				$('[aria-controls="ui-id-2"]:not([aria-selected="true"])').click();
			}
		},
		trackingValidation: function () {
			/*update rules*/
			var allinput = $("#trackingInfoForm input");
			var isRequired = false;
			$.each(allinput, function (index, control) {

				var errMsg = $(control).data("errmessage");

				var regexFormat = $(control).attr("pattern");
				if (regexFormat != null) {
					$(control).rules("add", {
						required: $(control).prop('required'),
						regex: regexFormat,
						messages: {
							regex: errMsg,
							required: $printer.validation.required,
							minlength: errMsg,
							maxlenght: errMsg
						}
					});
				}

				var maskFormat = $(control).data("inputmask");
				if (maskFormat != null) {
					$(control).rules("add", {
						required: $(control).prop('required'),
						messages: {
							required: $printer.validation.required,
							minlength: errMsg,
							maxlenght: errMsg
						}
					});

					$(control).mask(maskFormat);
				}

				if (!isRequired) {
					isRequired = $(control).prop('required');
				}

			});
            /*end update rules*/
		},
		getExistingRecpData: function (e) {
			var recpgrid = $('#grid').data("kendoGrid");
			var rows = recpgrid.dataSource.data();

			var oldData = $.grep(rows, function (item) {
				return !item.dirty;
			});

			return JSON.stringify(oldData);
		},
		getGridSelectionToAddressObj: function (grid) {
			var addressObj = [];
			if (grid !== null) {
				var rows = grid.select();
				rows.each(function (e, row) {
					var selectedItem = grid.dataItem(row);

					var address = {
						"Id": selectedItem.id,
						"SelectableContact": selectedItem.SelectableContact,
						"AddressID": selectedItem.AddressID,
						"Address": selectedItem.Address,
						"Seq": selectedItem.Seq,
						"AddressTypeID": selectedItem.AddressTypeID,
						"CompanyName": selectedItem.CompanyName,
						"DisplayName": selectedItem.DisplayName,
						"CanonicalAddress": selectedItem.CanonicalAddress,
						"DisplayAddress": selectedItem.DisplayAddress,
						"IsRRSOn": selectedItem.IsRRSOn,
						"IsRRFOn": selectedItem.IsRRFOn,
						"ContactTypeID": selectedItem.ContactTypeID,
						"NotifyAddress": selectedItem.NotifyAddress,
						"ContactID": selectedItem.ContactID,
						"Cat": selectedItem.Cat,
						"AddrBookID": selectedItem.AddrBookID,
						"EncryptStatus": Number(selectedItem.EncryptStatus)
					};
					addressObj[e] = address;
				});
			}
			return addressObj;
		},
		getGridSelection: function (grid) {
			var gridSelection = [];
			if (grid !== null) {
				var rows = grid.select();
				rows.each(function (e, row) {
					var selectedItem = grid.dataItem(row);
					gridSelection[e] = selectedItem.id;
				});
			}
			return gridSelection;
		},
		delete: function (deleteAll) {
			/* deleteAll - Delete All item in grid*/
			
			var grid = $("#grid").data("kendoGrid");

			deleteAll = deleteAll || false;
			if (deleteAll) {
				grid.dataSource.data([]);
				controlRecipient.tagsinput("removeAll");
				$.printer.setRecipientTagInput();

			}
			else {
				var selectedItem = grid.select();
				if (selectedItem.length === 0) {
					swal("", $printer.grid.emptySelection);
					return false;
				}
				
				for (i = 0; i < selectedItem.length; i++) {
					for (j = 0; j < grid.dataSource.data().length; j++) {
						var gridSource = grid.dataSource.at(j);
						var getInputTag = controlRecipient.tagsinput('items').find(x => x.uid === gridSource.uid);
						if (getInputTag == null)
						{
							grid.dataSource.remove(gridSource);
						}
						else if (gridSource.uid === selectedItem[i].dataset.uid) {
							controlRecipient.tagsinput("remove", gridSource);
						}
					}
				}
			}
			$.toast({
				heading: $globalMessages.toast.success,
				text: $printer.toast.contactsDelete,
				position: 'bottom-right',
				loaderBg: '#ff6849',
				icon: 'info',
				hideAfter: 3500,
				stack: 6
			});
		},
		addBootstrapTagInput: function (e) {
			var getGridData = $('#grid').data("kendoGrid").dataSource.data();
			controlRecipient.tagsinput('removeAll');
			$.grep(getGridData, function (item) {
				controlRecipient.tagsinput('add', item);
			});
			$('#sender_to').valid();

			/*if (newAddItem) {
				controlRecipient.tagsinput('add', { id: newAddItem.Seq, label: newAddItem.Name, addressType: addressType.addrBook, name: newAddItem.Name, company: newAddItem.CompanyName, address: newAddItem.DisplayAddr, type: "Fax" });
			}*/
		},
		setRecipientTagInput: function () {
			var totalRecipient = controlRecipient.tagsinput('items').length;

			if (totalRecipient > 0) {
				$("#btn-taginput-deleteRecipient").show();
			}
			else {
				$("#btn-taginput-deleteRecipient").hide();
			}
			$("#sender_to_count").text(totalRecipient);
		},

		/*Post or Get Function*/
		addRecpFromAddrBook: function (e) {
			var cGrid = $("#grid2").data("kendoGrid");
			var addresses = $.printer.getGridSelectionToAddressObj(cGrid);
			var ids = $.printer.getGridSelection(cGrid);
			if (ids.length === 0) {
				swal("", $printer.grid.emptySelection);
				return false;
			}

			fxcRequest.post('/PrinterApp/AddressBook/AddRecpFromAddrBook',
				{
					"SelectedAddress": addresses,
					"RecpGridData": $.printer.getExistingRecpData(),
					"DelegatorID": $('input#DelegatorID').val()
				},
				function (data) {
					preventAction = false;
					$("#grid2").data("kendoGrid").clearSelection();
					$.toast({
						heading: $globalMessages.toast.success,
						text: $printer.toast.contactsSuccess,
						position: 'bottom-right',
						loaderBg: '#ff6849',
						icon: 'info',
						hideAfter: 3500,
						stack: 6
					});
					$.printer.initGrid(data.RecpList);
					
					if (e != null && $(e).length > 0 && $(e).attr("data-save") === "close")
					{
						$("#modalAddressRecipient").modal("hide");
					}
					else {
						$(".AddressBookView").hide();
						$(".RecipientView").show();
					}
				},
				function (error) {
					
				}, false);
		},
		sent: function () {
			$.ipcRender.sendProgress(4);
			var formData = JSON.stringify($("#formSubmit").serializeArray());
			var msgmodel = {
				"TxtFrom": $('#sender_from').val(),
				"TxtCompany": $('#sender_company').val(),
				"TxtSubject": $('#sender_subject').val(),
				"TxtNotes": $('#sender_notes').val(),
				"TxtBillingCode": $('#sender_billingcode').val(),
				"TxtApprovalReq": $("#sender_approval").val(),
				"ChkNotifyFailed": $('#sender_notifyfailure').prop('checked'),
				"ChkNotifySuccess": $('#sender_notifysuccess').prop('checked'),
				"DeliveryType": $("#DeliveryType").val()
			};

			fxcRequest.post('/PrinterApp/Message/SendMessage',
				{
					"MessageModel": msgmodel,
					"CoverPage": $("#CoverPage").val(),
					"FormData": formData,
					"RecpGridData": $.printer.getExistingRecpData(),
					"DocumentPath": $("#documentPath").val()
				}
				, function (data) {
					swal.close();
					$.post(data.Url, function (partial) {
						$('#printerApp').html(partial);
						$.ipcRender.sendProgress(5);
						$.ipcRender.autoClose();
					});
				}
				, null, true, null, null
				, function (serverError) {
					$.ipcRender.sendProgress(3);
					$.ipcRender.uploadFile(true);
				});
		}
	};
	$.imageViewer = {
		initDocumentHandler: function (count) {
			for (var i = 1; i < count; i++) {
				var currentPage = i + 1;
				$('#sender_document')
					.append($("<option></option>")
						.attr("value", i)
						.text("Page " + currentPage));
			}
			
		},

		/*Btn Action*/
		documentChangeClickHandler: function (e) {
			$(e).on('change', function (e) {
				$.imageViewer.retrieveMainImage($("#sender_document option:selected").val());
			});
		},
		/*Logic*/
		displayMainImage: function (e) {

			$(".divloading-imgPreview").show();
			fxcRequest.get('/PrinterApp/Message/RetrieveImage',
				{
					"PageNumber": e.page,
					"Path":e.path
				}
				, function (data) {
					$("#imgPreview").attr('src', data.ImageUrl);
					if (firstLoad) {
						$("#sender_documentTotal").val(data.Count);
						$.imageViewer.initDocumentHandler(data.Count);
						firstLoad = false;
					}
					

					$("#imgPreview").attr('src', data.ImageUrl);
					$(".divloading-imgPreview").hide();
					$(".imgPreview").removeClass("hide");
				}
				, null, false);

		},
		displayMainImageTemp: function (e) {

			var imgSrc = '/PrinterApp/Message/RetrieveImageSrc?PageNumber=' + e.page + '&Path=' + e.path;
			$(".divloading-imgPreview").show();
			var img = $("#imgPreview").attr('src', imgSrc)
				.on('load', function () {
					if (!this.complete || typeof this.naturalWidth === undefined || this.naturalWidth === 0) {
						$(".divloading-imgPreview").hide();
					} else {
						$(".divloading-imgPreview").hide();
						$(".imgPreview").removeClass("hide");
					}
				})
				.on('error', function () {
					$(".divloading-imgPreview").hide();
					$(".imgPreview").removeClass("hide");
					$(".imgPreview").removeClass("hide");
					$('button[type="submit"]').attr("disabled", true);
				});
		},
		retrieveMainImage: function (e) {
			var params = {
				page: e,
				path: $("#documentPath").val()
			};

			$.imageViewer.displayMainImage(params);
		},
		getDocumentFrame: function (e) {

			fxcRequest.post('/PrinterApp/Message/RetrieveImageFrameCount',
				{
					"Path": $("#documentPath").val()
				}
				, function (data) {
					$("#sender_documentTotal").val(data.Count);
					$.imageViewer.initDocumentHandler(data.Count);
				}
				, null, false);

		},
		
	};
	$.addressbook = {
		init: function (e) {

			$.addressbook.initTreeView();
		},
		initTreeView: function (e) {

			var objContact = {};
			objContact.dataSource = "/Common/ConfigureAddrBook/";
			objContact.postSelectFn = $.addressbook.getContact;
			objContact.reselectChild = true;
			objContact.selectFirstNode = true;
			objContact.lazyLoading = true;

			treeview.init("recContactTree", "recContactName", "recContactID", objContact);

		},
		getContact: function (e, obj) {
			$('input[data-role="search-contact"]').val('');
			$.addressbook.initgridContact(obj);
			
		},
		initgridContact: function (data) {
			if (data !== null && data !== undefined) {
				contactcat = data.category;

				if (data.id !== null && data.id !== undefined) {
					addrBookID = data.id;
				}
			}

			var id = $("#grid2");

			var dataSource = {
				transport: {
					read: {
						url: "/Common/GetUser",
						dataType: "json",
						type: "GET"
					},
					parameterMap: function (options) {

						var sortBy = "";
						var direction = "";
						if (options.sort !== null && options.sort !== undefined && options.sort.length > 0) {
							var s = options.sort[0];
							sortBy = s.field;
							direction = s.dir;
						}

						var result = {
							Type: "4",
							Category: Number(contactcat),
							AddrBookID: addrBookID,
							SearchText: $('input[data-role="search-contact"]').val(),
							Page: options.page,
							Limit: options.pageSize,
							SortBy: sortBy,
							Direction: direction,
							SelectedFilter: selectedFilter
						};
						return result;
					}
				},
				schema: {
					data: "UserAddrBookList",
					total: "Total",
					model: {
						id: "Id"
					}
				},
				serverPaging: true,
				serverSorting: true
			};

			var columns = [];
			columns = [
				{
					selectable: true, width: "45px",
					attributes: {
						"class": "checkboxSelection"
					}
				},
				{ field: "SelectableContact", title: "Contact Name", width: "500px" },
				{ field: "AddressID", title: "AddressID", hidden: true },
				{ field: "Address", title: "Address", hidden: true },
				{ field: "Seq", title: "Seq", hidden: true },
				{ field: "AddressTypeID", title: "AddressTypeID", hidden: true },
				{ field: "CompanyName", title: "Company Name", hidden: true },
				{ field: "DisplayName", title: "Display Name", hidden: true },
				{ field: "CanonicalAddress", title: "CanonicalAddress", hidden: true },
				{ field: "EncryptStatus", title: "EncryptStatus", hidden: true },
				{ field: "DisplayAddress", title: "DisplayAddress", hidden: true },
				{ field: "IsRRSOn", title: "IsRRSOn", hidden: true },
				{ field: "IsRRFOn", title: "IsRRFOn", hidden: true },
				{ field: "ContactTypeID", title: "ContactTypeID", hidden: true },
				{ field: "NotifyAddress", title: "NotifyAddress", hidden: true },
				{ field: "ContactID", title: "ContactID", hidden: true },
				{ field: "AddrBookID", title: "AddrBookID", hidden: true }
			];

			var obj = {};
			obj.allowSelectMultipleRow = true;
			obj.buttonCount = 2;
			obj.pageSizes = false;
			obj.toolbar = [
				{
					template: '<div class="input-group faxcore-userpanel-search col-md-4 floatRight"> \
												<input type="text" data-role="search-contact" onkeypress="$.addressbook.searchPressEnter(event)" class="form-control" placeholder="' + $printer.button.search + '" title="' + $printer.button.search + '"> \
												<div class="input-group-addon" onclick="$.addressbook.searchButtonClickHandler(event)"><i class="fa fa-search"></i></div> \
											</div>'
				}
			];
			$gridContact = kendogridcustomization.init(id, dataSource, columns, obj);

		},
		searchFunction: function(e){
			$.addressbook.searchPressEnter($('input[data-role="search-contact"]'), obj);
			$.addressbook.searchButtonClickHandler($('.btn-search-grid'), obj);
		},
		searchButtonClickHandler: function (event) {
			event.preventDefault();
			$.addressbook.search(event);
		},
		searchPressEnter: function (event) {
			var x = event.which || event.keyCode;
			if (x === 13) {
				$.addressbook.search(event);
			}
		},

		/* Logic */
		search: function (object, item) {
			$.addressbook.initgridContact(item);
		},
		/* End Logic */
	};
	$.ipcRender = {
		init: function () {
			$.ipcRender.logout();
			$.ipcRender.loginProvider();
			$.ipcRender.getFilePath();
			$.ipcRender.sendProgress(3, $("#displayName").val());
			$.ipcRender.uploadFile(false);
		},
		loginProvider: function (e)
		{
			if (ipcRenderer != null) {
				var loginProvider = document.querySelector("#LoginProvider") ;
				ipcRenderer.send('fxc:loginprovider', loginProvider.value);
			}
		},
		sendProgress: function (progressType, info) {
			if (ipcRenderer != null)
				ipcRenderer.send('fxc:updateProgress', progressType, info);
		},
		autoClose: function () {
			if (ipcRenderer != null)
				ipcRenderer.send('fxc:autoClose');
		},
		logout: function () {
			if (ipcRenderer != null) {
				ipcRenderer.on('electron: logout', function (e, item) {
					$.printer.logout();
				});
			}
		},
		getFilePath: function () {
			if (ipcRenderer != null) {
				
				ipcRenderer.on('electron: getFilePath', function (e, item) {
					$("#documentPath").val(item);
					/*On first load page request = 0*/
					$.imageViewer.retrieveMainImage();
				});
			}
		},
		uploadFile: function (forceUpload) {
			if (ipcRenderer != null) {
				ipcRenderer.send('fxc:uploadFile', forceUpload);
			}
		}
	};
})(window.jQuery);