﻿(function ($) {
    var $grid;

    $('#form-user-contact').submit(function (event) {
        /* Get Action Button: Save = 0, Save = 1 */
        var action = $(event.target).find("input[type=submit]:focus");
        if (action[0].id == 'btn-Save-contact') {
            action = 0;
        }
        else if (action[0].id == 'btn-SaveClose-contact') {
            action = 1;
        }

        $.contactGroup.save(action);
        event.preventDefault();
    });

    $('#form-user-contact-group').submit(function (event) {
        var action = $(event.target).find("input[type=submit]:focus");
        if (action[0].id == 'btn-SaveAsNew-ContactGroup') {
            action = 0;
        }
        else if (action[0].id == 'btn-Save-ContactGroup') {
            action = 1;
        }
        else if (action[0].id == 'btn-SaveClose-ContactGroup') {
            action = 2;
        }

        $.contactGroup.saveContactGroup(action);
        event.preventDefault();
    });

    $.contactGroup = {
        initgrid: function (e) {
            $grid = $(e).kendoGrid({
                dataSource: {
                    schema: {
                        data: "ContactList",
                        total: "Count",
                        model: {
                            id: "ContactId",
                            fields: {
                                DisplayName: { editable: true, type: "string", validation: { required: true } },
                                ContactType: { editable: true, type: "string" },
                                FirstName: { editable: true, type: "string" },
                                LastName: { editable: true, type: "string" },
                                CompanyName: { editable: true, type: "string" },
                                PreferAddress: { editable: true, type: "string" },
                                Visibility: { editable: true, type: "string" },
                                Owner: { editable: false, nullable: false, type: "string" }
                            }
                        }
                    },
                    pageSize: 15
                },
                selectable: "multiple",
                persistSelection: true,
                scrollable: true,
                sortable: true,
                filterable: false,
                pageable: {
                    input: true,
                    numeric: true
                },
                columns: [
                    { field: "ContactId", hidden: true },
                    { field: "AddressId", hidden: true },
                    { field: "AddressTypeId", hidden: true },
                    { field: "IsContactGroupDisplayOnly", hidden: true },
                    { field: "IsRssOn", title: "NS" },
                    { field: "IsRrfOn", title: "NE" },
                    { field: "DisplayName", title: $areaResources.grid.name },
                    { field: "CompanyName", title: $areaResources.grid.company },
                    { field: "DisplayAddress", title: $areaResources.grid.deliveryAddress },
                    { field: "AddressTypeId", title: $areaResources.grid.addressType },
                    { field: "NotifyEmail", title: $areaResources.grid.notifyEmail }
                ],
                toolbar: kendo.template($("#template").html())
            });
            $.contactGroup.createContact($('#contact-group-add'));
            $.contactGroup.setFields($('#AddressTypeId'));
            if ($('#Id').val() != '0') {
                $.contactGroup.getGroup();
            }
        },
        createContact: function (e) {
            $(e).on('click', function () {
                $('#add-user-contact-modal').modal('show');
                $.contactGroup.resetFields();
            });
        },
        resetFields: function (e) {
            /* Set default fields for CSID */
            $('#DisplayName').val('');
            $('#CompanyName').val('');
            $.contactGroup.reset();
            $.contactGroup.showCSID();
        },
        setFields: function (e) {
            $(e).on('change', function () {
                $.contactGroup.reset();
                switch (parseInt(e.val())) {
                    case 1:
                        $.contactGroup.showEmail();
                        break;
                    case 2:
                        $.contactGroup.showFax();
                        break;
                    case 3:
                        $.contactGroup.showHttp();
                        break;
                    case 4:
                        $.contactGroup.showFtp();
                        break;
                    case 5:
                        $.contactGroup.showFile();
                        break;
                    case 6:
                        day = $.contactGroup.showPrinter();
                        break;
                    case 7:
                        $.contactGroup.showMobile();
                        break;
                    case 9:
                        $.contactGroup.showRawFax();
                        break;
                    case 10:
                        $.contactGroup.showPhone();
                        break;
                    case 12:
                        $.contactGroup.showCSID();
                }
            });
        },
        showCSID: function () {
            $('#AddressTypeId').prop('selectedIndex', 0);
            $('#Address').closest(".row").show();

            $('#Printer').closest(".row").hide();
            $('#FaxNumber').closest(".row").hide();
            $('#MobileNumber').closest(".row").hide();
            $('#PhoneNumber').closest(".row").hide();
            $('#Server').closest(".row").hide();
            $('#Path').closest(".row").hide();
            $('#Username').closest(".row").hide();
            $('#Password').closest(".row").hide();
            $('#Format').closest(".row").hide();
        },
        showEmail: function () {
            $('#Address').closest(".row").show();
            $('#Format').closest(".row").show();

            $('#Printer').closest(".row").hide();
            $('#FaxNumber').closest(".row").hide();
            $('#MobileNumber').closest(".row").hide();
            $('#PhoneNumber').closest(".row").hide();
            $('#Server').closest(".row").hide();
            $('#Path').closest(".row").hide();
            $('#Username').closest(".row").hide();
            $('#Password').closest(".row").hide();
        },
        showFax: function () {
            $('#FaxNumber').closest(".row").show();

            $('#Format').closest(".row").hide();
            $('#Printer').closest(".row").hide();
            $('#Address').closest(".row").hide();
            $('#MobileNumber').closest(".row").hide();
            $('#PhoneNumber').closest(".row").hide();
            $('#Server').closest(".row").hide();
            $('#Path').closest(".row").hide();
            $('#Username').closest(".row").hide();
            $('#Password').closest(".row").hide();
        },
        showRawFax: function () {
            $('#Address').closest(".row").show();

            $('#Format').closest(".row").hide();
            $('#Printer').closest(".row").hide();
            $('#FaxNumber').closest(".row").hide();
            $('#MobileNumber').closest(".row").hide();
            $('#PhoneNumber').closest(".row").hide();
            $('#Server').closest(".row").hide();
            $('#Path').closest(".row").hide();
            $('#Username').closest(".row").hide();
            $('#Password').closest(".row").hide();
        },
        showFile: function () {
            $('#Server').closest(".row").show();
            $('#Path').closest(".row").show();
            $('#Username').closest(".row").show();
            $('#Password').closest(".row").show();
            $('#Format').closest(".row").show();

            $('#FaxNumber').closest(".row").hide();
            $('#Printer').closest(".row").hide();
            $('#Address').closest(".row").hide();
            $('#MobileNumber').closest(".row").hide();
            $('#PhoneNumber').closest(".row").hide();
        },
        showFtp: function () {
            $('#Address').closest(".row").show();
            $('#Username').closest(".row").show();
            $('#Password').closest(".row").show();
            $('#Format').closest(".row").show();

            $('#Server').closest(".row").hide();
            $('#Path').closest(".row").hide();
            $('#FaxNumber').closest(".row").hide();
            $('#Printer').closest(".row").hide();
            $('#MobileNumber').closest(".row").hide();
            $('#PhoneNumber').closest(".row").hide();
        },
        showHttp: function () {
            $('#Address').closest(".row").show();
            $('#Username').closest(".row").show();
            $('#Password').closest(".row").show();
            $('#Format').closest(".row").show();

            $('#Server').closest(".row").hide();
            $('#Path').closest(".row").hide();
            $('#FaxNumber').closest(".row").hide();
            $('#Printer').closest(".row").hide();
            $('#MobileNumber').closest(".row").hide();
            $('#PhoneNumber').closest(".row").hide();
        },
        showMobile: function () {
            $('#MobileNumber').closest(".row").show();

            $('#Address').closest(".row").hide();
            $('#Username').closest(".row").hide();
            $('#Password').closest(".row").hide();
            $('#Format').closest(".row").hide();
            $('#Server').closest(".row").hide();
            $('#Path').closest(".row").hide();
            $('#FaxNumber').closest(".row").hide();
            $('#Printer').closest(".row").hide();
            $('#PhoneNumber').closest(".row").hide();
        },
        showPhone: function () {
            $('#PhoneNumber').closest(".row").show();

            $('#MobileNumber').closest(".row").hide();
            $('#Address').closest(".row").hide();
            $('#Username').closest(".row").hide();
            $('#Password').closest(".row").hide();
            $('#Format').closest(".row").hide();
            $('#Server').closest(".row").hide();
            $('#Path').closest(".row").hide();
            $('#FaxNumber').closest(".row").hide();
            $('#Printer').closest(".row").hide();
        },
        showPrinter: function () {
            $('#Printer').closest(".row").show();

            $('#PhoneNumber').closest(".row").hide();
            $('#MobileNumber').closest(".row").hide();
            $('#Address').closest(".row").hide();
            $('#Username').closest(".row").hide();
            $('#Password').closest(".row").hide();
            $('#Format').closest(".row").hide();
            $('#Server').closest(".row").hide();
            $('#Path').closest(".row").hide();
            $('#FaxNumber').closest(".row").hide();
        },
        reset: function () {
            $('#PhoneNumber').val('');
            $('#MobileNumber').val('');
            $('#Address').val('');
            $('#Username').val('');
            $('#Password').val('');
            $('#Server').val('');
            $('#Path').val('');
            $('#FaxNumber').val('');
            $('#NotifyEmail').val('');
            $('#Printer').val('');
        },
        save: function (action) {
            fxcRequest.post('/User/Contact/Add',
                {
                    DisplayName: $('#DisplayName').val(),
                    CompanyName: $('#CompanyName').val(),
                    Address: $('#Address').val(),
                    FaxNumber: $('#FaxNumber').val(),
                    MobileNumber: $('#MobileNumber').val(),
                    PhoneNumber: $('#PhoneNumber').val(),
                    Server: $('#Server').val(),
                    Path: $('#Path').val(),
                    Username: $('#Username').val(),
                    Password: $('#Password').val(),
                    NotifyEmail: $('#NotifyEmail').val(),
                    AddressTypeId: $('#AddressTypeId').val(),
                    IsContactGroupViewOnly: $('#IsContactGroupViewOnly').prop('checked'),
                    AddressBookId: $('#AddressBookId').val(),
                    ContactId: $('#ContactId').val(),
                    Sequence: $('#Sequence').val(),
                    Printer: $('#Printer').val(),
                    Format: $('#Format').val(),
                    Visibility: $('#Visibility').val()
                },
                function (data) {
                    if (action == 1) {
                        $('#add-user-contact-modal').modal('hide');
                    }
                    /*To do: Add data to kendo grid*/

                    var grid = $("#grid").data("kendoGrid");
                    grid.dataSource.add(data);
                    grid.refresh();

                    swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");
                },
                function (error) {
                    swal($globalMessages.swal.error.errorCap, swal.error.errorOnSubmit, "error");
                });
        },
        saveContactGroup: function (action) {
            var grid = $("#grid").data("kendoGrid");
            var data = grid.dataSource.data();
            var totalNumber = data.length;
            var listData = [];

            for (var i = 0; i < totalNumber; i++) {
                listData.push(
                    {
                        DisplayName: data[i]['DisplayName'],
                        CompanyName: data[i]['CompanyName'],
                        AddressBookId: data[i]['AddressBookId'],
                        DisplayAddress: data[i]['DisplayAddress'],
                        IsRrfOn: data[i]['IsRrfOn'],
                        IsRssOn: data[i]['IsRssOn'],
                        ContactId: data[i]['ContactId'],
                        AddressId: data[i]['AddressId'],
                        Sequence: i + 1,
                        NotifyEmail: data[i]['NotifyEmail']
                    });
            }

            fxcRequest.post('/User/Contact/SaveGroup',
                {
                    Id: $('#Id').val(),
                    Action: action,
                    GroupName: $('#GroupName').val(),
                    AddressBookId: $('#AddressBookId').val(),
                    Description: $('#Description').val(),
                    Visibility: $('#Visibility').val(),
                    ListDetail: listData
                },
                function (data) {
                    $('#Id').val(data.Id);
                    swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");
                },
                function (error) {
                    swal($globalMessages.swal.error.errorCap, swal.error.errorOnSubmit, "error");
                });
        },
        getGroup: function () {
            fxcRequest.get('/User/Contact/GetGroup',
                {
                    Id: $('#Id').val()
                },
                function (data) {
                    $('#GroupName').val(data.GroupName);
                    $('#Description').val(data.Description);
                    $('#AddressBookId').val(data.AddressBookId);
                    $('#Visibility').val(data.Visibility);

                    var grid = $("#grid").data("kendoGrid");

                    for (var i = 0; i < data.ListDetail.length; i++) {
                        grid.dataSource.add(data.ListDetail[i]);
                    }

                    grid.refresh();
                },
                function (error) {
                    /* console.log(error);*/
                });
        }
    };
})(window.jQuery);