﻿(function ($) {

    var $grid, folderId, movefolderId, command, sortType, selectedDocIds = [],
        editDoc = false, showCreate = false, showDelete = false, showMove = false;

    $.uDoc = {
        init: function (e) {

        },
        initgrid: function (e, data) {
            var url = "/User/DocIndex/GetDocGrid";
            var folderId = $('input#folderId').val();
            var folderName = $('input#folderName').val();
            var hideOwner = false;
            var obj = {};
            var col = [];

            if (data.EnableCrud) {
                var x = {
                    selectable: true, width: 45,
                    attributes: {
                        "class": "checkboxSelection"
                    }
                };
                col.push(x);
                obj.onSelectionFn = $._document.edit;
                hideOwner = true;
            }

            col.push(
                { field: "DocName", title: $areaResources.grid.documentName, width: 200 },
                { field: "DocTypeName", title: $areaResources.grid.type, width: 200 },
				{ field: "IsMerge", title: $areaResources.grid.merged, width: 100, hidden: true},
                {
                    field: "VisibilityName",
                    title: "Visibility",
                    width: 150,
                    template: function (dataRow) {
                        var icon = '<i class="mdi mdi-check"></i>';
						var statusClass = dataRow.VisibilityID + "";

                        var result = '<div status="kendo-container">' +
                            '<span class="badge kendo-span-status badge-pill badge-visibility' + statusClass.toLowerCase() + '">' + dataRow.VisibilityName + '</span> ' +
                            '</div>';
                        return result;
                    }
                },
                { field: "Desc", title: $areaResources.grid.description, width: 200 },
                { field: "OwnBy", title: $areaResources.grid.owner, width: 200, hidden: hideOwner });

            var id = e;

            var dataSource = {
                transport: {
                    read: {
                        url: url,
                        dataType: "json",
                        type: "GET"
                    },
                    parameterMap: function (options) {
                        /* Fix url param for sort values */
                        var result = {
                            page: options.page,
                            take: options.take,
                            skip: options.skip,
                            pageSize: options.pageSize,
                            filter: $('input[data-role="search-user-doc"]').val(),
                            folderId: folderId,
                            folderName: folderName
                        };

                        return result;
                    }
                },
                schema: {
                    data: "DocList",
                    model: {
                        id: "DocumentID"
                    },
                    total: "Total"
                },
                pageSize: Number(data.Size),
                serverPaging: true
            };

            obj.totalInputType = ".totalData";

            $grid = kendogridcustomization.init(id, dataSource,
                col, obj);
        },
        getSelectedDocIds: function (e) {
            var selectedDocIds = [];
            var grid = $('#grid').data("kendoGrid");
            if (grid != null) {
                var rows = grid.select();
                rows.each(function (e, row) {
                    var selectedItem = grid.dataItem(row);
                    selectedDocIds[e] = selectedItem.id;
                });
            }
            return selectedDocIds;
        },
        getFolderId: function (e) {
            return $('input#folderId').val();
        },
        getDocumentID: function (e) {
            return $('input#DocumentID').val();
        },
        setDocumentID: function (e) {
            $('input#DocumentID').val(e);
        },
        moveAction: function (e) {
            movefolderId = e;
            $.uDoc.moveDoc();
        },
        updateHtml: function (data) {
            $.sectionproperties.Hidden("MoveBtn", !data.EnableCrud);
            $.sectionproperties.Hidden("DeleteBtn", !data.EnableCrud);
            $.sectionproperties.Hidden("NewBtn", !data.EnableCrud);
            $.uDoc.initgrid($('#grid'), data);
            $('span.totalMessage').text(data.Total);

            /*init ddl */
            $("div#moveDropDown").html('');
            $("div#moveDropDown").append(data.DdlMoveFolder);

            /*Remove current folder */
            folderId = $.uDoc.getFolderId();
            var item = document.getElementById(folderId);
            if (item != null) {
                item.parentNode.removeChild(item);
            }

            if (!$("div#moveDropDown").children().length) {
                $("button#mainDropDown").prop('disabled', true);
            }
            else {
                $("button#mainDropDown").prop('disabled', false);
            }

            /*Reset slimscroll ddl*/
            custom.setDropDownMenu($('#moveDropDown'));

            $._document.updateDdl(data);
        },
        getDocList: function (e) {
            folderId = $.uDoc.getFolderId();
            fxcRequest.get('/User/DocIndex/GetDocList',
                {
                    "SearchText": e,
                    "FolderId": folderId,
                    "FolderName": $('input#folderName').val()
                },
                function (data) {
                    $.uDoc.updateHtml(data);

                },
                function (error) {
                    console.log(error);
                });
        },
        sortDocList: function (e) {
            folderId = $.uDoc.getFolderId();
            fxcRequest.post('/User/DocIndex/SortDoc',
                {
                    "FolderId": folderId,
                    "FolderName": $('input#folderName').val(),
                    "UDocSort": Number(sortType)
                },
                function (data) {

                    $.uDoc.updateHtml(data);

                },
                function (error) {
                    console.log(error);
                });
        },

        deleteDoc: function (e) {

            selectedDocIds = $.uDoc.getSelectedDocIds();

            if (selectedDocIds.length === 0) {
                swal("", $areaResources.swal.noDocSelected);
                return false;
            }

            swal({
                title: "",
                text: $areaResources.swal.deleteContacts,
                type: "info",
                showCancelButton: true,
                closeOnConfirm: false,
                reverseButtons: true,
                showLoaderOnConfirm: true
            }, function () {
                fxcRequest.post('/User/DocIndex/DeleteDoc',
                    {
                        "FolderId": folderId,
                        "SelectedDocIds": selectedDocIds
                    },
                    function (data) {

                        $.uDoc.updateHtml(data);
                        selectedDocIds = [];
                        swal($globalMessages.swal.done, $areaResources.swal.docDeletedSuccess, "success");
                    },
                    function (error) {
                        swal($globalMessages.swal.error.title, $globalMessages.swal.error.errorOnDelete, "error");
                    });

            });
        },
        moveDoc: function (e) {
            folderId = $.uDoc.getFolderId();
            selectedDocIds = $.uDoc.getSelectedDocIds();

            if (selectedDocIds.length === 0) {
                swal("", $areaResources.swal.noDocSelected);
                return false;
            }

            fxcRequest.post('/User/DocIndex/MoveDoc',
                {
                    "FolderId": folderId,
                    "MoveToFolderId": movefolderId,
                    "SelectedDocIds": selectedDocIds
                },
                function (data) {
                    $.toast({
                        heading: $globalMessages.toast.success,
                        text: $areaResources.toast.docMovedSuccess,
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'success',
                        stack: 6
                    });

                    $.uDoc.updateHtml(data);
                    selectedDocIds = [];
                    /* Refresh grid everytime after save*/
                },
                function (error) {
                    console.log(error);
                }, false);

        },
        performDocActionHandler: function (e) {
            /*public enum UDocCommand { Grid = 0, Create = 1, Delete = 2, Move =3, Sort = 4 };*/
            $(e).on('click', function () {
                $(this).blur();
                command = $(this).data('command');
                
                if (command == '0') {
                    sortType = null;
                    $.uDoc.getDocList();
                } else if (command == '1') {

                    $(".title2").text($areaResources.actionTitle.createNewDocument);

                    var allowUpload = JSON.parse($('#AllowUpload').val().toLowerCase());
                    if (allowUpload) {
                        $.sectionproperties.SecondLevel();
                        $._document.createHandler();
                    }
                    else {
                        swal({
                            title: $globalMessages.swal.error.title,
                            text: $globalMessages.grid.noPermToUploadDoc,
                            type: "error"
                        },
                            function () {
                                var link = $('a.sidebar-nav-link.active').length > 0 ? $('a.sidebar-nav-link.active')
                                    : $('a.active');
                                link.trigger('click');
                            });
                    }


                } else if (command == '2') {
                    $.uDoc.deleteDoc();
                } else if (command == '3') {
                    /*use moveAction instead*/
                    /*folderId = $(this).data('id');*/
                    /*$.uDoc.moveDoc();*/
                } else if (command == '4') {
                    sortType = $(this).data('sort');
                    $.uDoc.sortDocList();
                }
            });
        }
    };
})(window.jQuery);