﻿(function ($) {
    var $grid;
    var gridId = "#domainContactGrid";
    var $DomainPassIsEncrypted = false;
    var $DomainTempPassword;
    var prevNavs = {};
    var tempData;

    var addrBookValidation = function () {
        $('#formSubmit').validate({
            rules: {
                AddressBookName: { required: true },
                Visibility: { required: true },
                AddressBookType: { required: true },
                ClientId: { required: true },
                TenantId: { required: true }
            },
            submitHandler: function (form) {
                $.domainAddressBook.save();
            }
        });
    };

    var constructsavemodel = function () {
        /*debugger*/
        var isExternal = $('#AddressBookType').val() === '0' ? false : true;

        var arry = {};
        arry = {
            Id: $('#RecordId').val(),
            DomainID: $('#ConfiguredDomainID').val(),
            AddrBookName: $('#AddressBookName').val(),
            Desc: $('#DomainDescription').val(),
            VisibilityID: $('#Visibility').val(),
            IsAddrBookExt: isExternal,
            ConnectionType: $('#ConnectionType').val(),
            ConnectionString: $('#ConnectionString').val(),
            QueryExpression: $('#QueryExpression').val(),
            ServerAddress: $('#ServerAddress').val(),
            LoginDomain: $('#Domain').val(),
            LoginUserID: $('#UserID').val(),
            LoginPassword: $('#Password').val(),
            LoginPasswordIsEncrypted: $DomainPassIsEncrypted,
            PublicAddressBook: $('#PublicAddressBook').val(),
            FormBasedAuthExch2003: $('#FormBasedAuthentication').prop('checked'),
            IsAdmin: false,
            ClientId: $('#ClientId').val(),
            TenantId: $('#TenantId').val()

        };
        return arry;
    };
    var getGridSelections = function (grid) {
        var selectedId = [];
        var entityGrid = grid.data("kendoGrid");
        var rows = entityGrid.select();

        rows.each(function (index, row) {
            var selectedItem = entityGrid.dataItem(row);
            selectedId[index] = selectedItem.Id;
        });

        return selectedId;
    };

    $.domainAddressBook = {
        init: function (e) {
            if ($("#action-edit").length > 0)
                document.getElementById("action-edit").disabled = true;
            addrBookValidation();
            $.domainAddressBook.getPrevNav();
            $.contact.createButtonClickHandler($("#btnAddContact"));
            $.contactGroup.createButtonClickHandler($("#btnAddGroup"));
            $.domainAddressBook.saveCommandHandler($('.btn-save6'));
            $.domainAddressBook.resetCommandHandler($('.btn-Reset6'));
            $.domainAddressBook.editDomainHandler($('#action-edit'));
            $.domainAddressBook.backHandler($('.btn-back2'));
            $.domainAddressBook.backHandler($('.btn-back5'));
            $.domainAddressBook.backHandler($('.btn-back3'));
            $.domainAddressBook.backToMainGridHandler($('.btn-back6'));
            $.sectionproperties.FirstLevel($('.btn-back6'));
            $.domainAddressBook.testButtonClickHandler($('.btn-Test6'));
            $.domainAddressBook.readDataButtonClickHandler($('.btn-ReadData6'));
			$.domainAddressBook.deleteButtonClickHandler($('#action-delete'));

			$.domainAddressBook.resetDomainPassword();
        },
        initGrid: function (e) {
            var addressBookId = $('input#addressBookId').val() + "";
            var addressBookName = $('input#addressBookName').val() + "";
            var pageSize = parseInt($("#pageSize").val());

            var url = "/User/Contact/List";

            var hideVisibility = false;
            var hideOwner = true;

            var id = e;
            var dataSource = {
                transport: {
                    read: {
                        url: url,
                        dataType: "json",
                        type: "GET"
                    },
                    parameterMap: function (options) {
                        /* Fix url param for sort values */
                        var result = {
                            Page: options.page,
                            Take: options.take,
                            Skip: options.skip,
                            SearchText: $("#searchBox-domain").val(),
                            AddressBookId: addressBookId,
                            AddressBookType: ""
                        };
                        if (options.sort && options.sort.length > 0) {
                            result.SortBy = options.sort[0].field;
                            result.Direction = options.sort[0].dir;
                        }

                        return result;
                    }
                },
                schema: {
                    data: "ContactList",
                    total: "Count",
                    model: {
                        id: "ContactId",
                        fields: {
                            DisplayName: { editable: true, type: "string", validation: { required: true } },
                            ContactType: { editable: true, type: "string" },
                            ContactTypeId: { editable: true, type: "string" },
                            FirstName: { editable: true, type: "string" },
                            LastName: { editable: true, type: "string" },
                            CompanyName: { editable: true, type: "string" },
                            PreferAddress: { editable: true, type: "string" },
                            Visibility: { editable: true, type: "string" },
                            Owner: { editable: false, nullable: false, type: "string" }
                        }
                    }
                },
                serverPaging: true,
                serverSorting: true
            };
            var obj = {};

            col = [
                { field: "DisplayName", title: $areaResources.grid.displayName, width: 150 },
                { field: "ContactType", title: $areaResources.grid.contactType, width: 150 },
                { field: "FirstName", title: $areaResources.grid.firstname, width: 150 },
                { field: "LastName", title: $areaResources.grid.lastname, width: 125 },
                { field: "CompanyName", title: $areaResources.grid.companyName, width: 125 },
                { field: "PreferAddress", title: $areaResources.grid.preferDeliveryAddress, width: 150 },
                {
                    field: "Visibility",
                    title: $areaResources.grid.visibility,
                    width: 150,
                    template: function (dataRow) {
                        var icon = '<i class="mdi mdi-check"></i>';
                        var statusClass = dataRow.VisibilityID + "";

                        var result = '<div status="kendo-container">' +
                            '<span class="badge kendo-span-status badge-pill badge-visibility' + statusClass.toLowerCase() + '">' + dataRow.Visibility + '</span> ' +
                            '</div>';
                        return result;
                    }
                },
                { field: "Owner", title: "Owner", width: 150, hidden: hideOwner },
                { field: "ContactTypeId", hidden: true }
            ];

            var x = {
                selectable: true, width: "45px",
                attributes: {
                    "class": "checkboxSelection"
                }
            };

            obj.onDataBoundExtraFn = $.domainAddressBook.grid_dataBound;
            obj.onSelectionFn = $.addressBook.editHandler;
            obj.pageSize = pageSize;
            col.unshift(x);

            $grid = kendogridcustomization.init(id, dataSource, col, obj);
        },
        grid_dataBound: function () {
            var editBtn = document.getElementById('action-edit');
            if (editBtn) editBtn.disabled = false;
        },
        initReadExternalGrid: function (e) {
            var data = JSON.parse(e.JsonArryExternalSource);

            $grid = $('#gridReadExt').kendoGrid({
                dataSource: {
                    data: data,
                    pageSize: 15
                },
                persistSelection: true,
                scrollable: true,
                sortable: true,
                filterable: false,
                pageable: {
                    input: true,
                    numeric: false
                },
                columns: [
                    { field: "xDisplayName", title: $areaResources.grid.name },
                    { field: "xCompanyName", title: $areaResources.grid.company },
                    { field: "xAddress", title: $areaResources.grid.address },
                    { field: "xAddressTypeID", hidden: true },
                    { field: "xAddressTypeLabel", title: $areaResources.grid.addressType },
                    { field: "xNotifyAddress", title: $areaResources.grid.notifyEmail },
                    { field: "xIsRRSOn", hidden: true },
                    { field: "xIsRRSOnLabel", title: $areaResources.grid.ns },
                    { field: "xIsRRFOn", hidden: true },
                    { field: "xIsRRFOnLabel", title: $areaResources.grid.ne }
                ]
            });
        },
        saveCommandHandler: function (e) {
            $(e).on('click', function (event) {
                $('#formSubmit').submit();
            });
        },
        resetCommandHandler: function (e) {
            $(e).unbind('click').click(function (event) {
                $.domainAddressBook.getDomainDetail();
            });
        },
        editDomainHandler: function (e) {
            $(e).on('click', function (x) {
                $.sectionproperties.SixthLevel(e);
                $.domainAddressBook.getDomainDetail();
            });
        },
        backHandler: function (e) {
            $(e).unbind('click').click(function (e) {
                /* when adding contact or contactGroup */
                if ($(this).hasClass('btn-back2') || $(this).hasClass("btn-back5")) {
                    /* remove active class on Contact menu */
                    if ($(this).hasClass("btn-back2") && $('#newgetcontact').hasClass('active')) $('#newgetcontact').removeClass('active');
                    if ($(this).hasClass("btn-back5") && $('#newgetcontactgroup').hasClass('active')) $('#newgetcontactgroup').removeClass('active');

                    if (!prevNavs.prevLevel1NavNemu.parent().hasClass('active')) prevNavs.prevLevel1NavNemu.click();
                    if (!prevNavs.prevLevel2NavMenu.parent().hasClass('active')) prevNavs.prevLevel2NavMenu.click();

                    prevNavs.prevNavMenu.addClass('active');
                }

                $.domainAddressBook.initGrid($('#domainContactGrid'));
                $.sectionproperties.SixthLevel(e);
            });
        },
        backToMainGridHandler: function (e) {
            $(e).unbind('click').click(function (e) {
                $.addressBook.initGrid($('#grid'));
            });
        },
        testButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.domainAddressBook.testConnection();
            });
        },
        readDataButtonClickHandler: function (e) {

            $(e).on('click', function () {
                $.domainAddressBook.readData();

                /* Disable Scrolling */
                $('.faxcoreContent.View2').css('overflow', 'hidden');
                $('.faxcoreContent.View2').css('height', '100%');
                $('#read-ext-modal').css('overflow', 'auto');
            });

            $('#read-ext-modal').on('hidden.bs.modal', function () {
                $('.faxcoreContent.View2').css('overflow', 'visible');
            });
        },

        /*Actions*/
        save: function () {
            /*debugger*/

            var rolename = $('#Role').val();
            var url = '';
            if (rolename === 'SUPER USER' || rolename === 'STANDARD USER') {
                url = '/Common/DomainAddrBook/SaveAddrBooks';
            }
            else {
                url = '/Admin/AddressBooks/SaveAddrBooks';
            }

            var saveModel = constructsavemodel();

            fxcRequest.post(url,
                saveModel,
                function (data) {
                    $.domainAddressBook.initGrid($('#domainContactGrid'));

                    var newName = saveModel.AddrBookName;
                    /*update breadcrumb view6 (edit AB)*/
                    $('#breadcrumbs ol span.title6').text(newName);
                    /*update side navigation*/
                    var navigationControl = $('ul#sidebarnav li.active a[data-id="' + saveModel.Id + '"]');
                    var fullName = navigationControl.text();
                    if (tempData) {
                        newName = fullName.replace(tempData.Name, saveModel.AddrBookName);
                    }
                    /*update text*/
                    navigationControl.text(newName);
                    /*update title*/
                    navigationControl.attr('title', newName);
                    /*update breadcrumb view1 (AB Grid)*/
                    $('#breadcrumbs ol span.title1').text(newName);

                    swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");
                },
                function (error) {
                    swal($globalMessages.swal.error.errorCap, swal.error.errorOnSave, "error");
                });
        },
        getDomainDetail: function () {
            var addressBookId = parseInt($('input#addressBookId').val());
            var url = "/User/AddressBook/DomainDetail";

            fxcRequest.get(url,
                {
                    Id: addressBookId
                },
                function (data) {
                    tempData = data;
                    /*debugger*/
                    $('.title6').html(data.Name);
                    $('#RecordId').val(data.Id);
                    $('#ConfiguredDomainID').val(data.DomainId);
                    $('#AddressBookName').val(data.Name);
                    $('#DomainDescription').val(data.Description);
                    /* VisibilityId - 3 (Global) not available in user panel */
                    $('#Visibility').val($("#Visibility option[value='" + data.VisibilityId + "']").length > 0 ? data.VisibilityId : $("#Visibility option:first").val());
                    $("#ConnectionType").val(data.AddrBookConnTypeID).change();
                    $("#searchBox-domain").val("");

                    if (data.IsAddressBookExt) {
                        $("#AddressBookType").val(1).change();

                        $('#ConnectionString').val(data.ConnectionString);
                        $('#QueryExpression').val(data.QueryExpression);
                        $('#FormBasedAuthentication').bootstrapSwitch('state', data.FBAEnabled);
                        $('#Domain').val(data.LoginDomain);
                        $('#UserID').val(data.LoginUserId);
                        $('#Password').val(data.LoginPassword);
                        $DomainPassIsEncrypted = data.LoginPasswordIsEncrypted;

                        $('#PublicAddressBook').val(data.PublicAddressBook);
                        $('#ServerAddress').val(data.ServerAddress);
                        $('#ClientId').val(data.ClientID);
                        $('#TenantId').val(data.TenantID);

                        /*Hide Grid Controls*/
                        $('.domain-address-book .HiddenAddressDetail').hide();

                        /*Show Read And Test Data */
                        $('.btn-Test6').show();
                        $('.btn-ReadData6').show();
                    }
                    else {
                        $("#AddressBookType").val(0).change();
                        $.domainAddressBook.initGrid($('#domainContactGrid'));

                        /*Show Grid Controls*/
                        $('.domain-address-book .HiddenAddressDetail').show();

                        /*Hide Read And Test Data */
                        $('.btn-Test6').hide();
                        $('.btn-ReadData6').hide();
                    }

                    $.sectionproperties.Hidden("AddressDetail", false);
                    $.sectionproperties.Disabled("AddressBookType", true);

                },
                function (error) {
                    swal($globalMessages.swal.error.errorCap, swal.error.errorOnGet, "error");
                }
            );
        },
        resetDomainPassword: function (e) {
            $("#Password").focus(function () {
                if ($DomainPassIsEncrypted) {
                    $DomainTempPassword = $("#Password").val();
                    $("#Password").val("");
                }
            });
            $("#Password").keyup(function () {
                $DomainPassIsEncrypted = false;
            });
            $("#Password").focusout(function () {
                if ($DomainPassIsEncrypted) {
                    $("#Password").val($DomainTempPassword);
                }

            });
        },
        testConnection: function () {
            /*debugger*/
            var isExternal = $('#AddressBookType').val() === '0' ? false : true;
            var rolename = $('#Role').val();
            var url = '';
            if (rolename === 'SUPER USER' || rolename === 'STANDARD USER') {
                url = '/Common/DomainAddrBook/TestConnection';
            }
            else {
                url = '/Admin/AddressBooks/TestConnection';
            }

            fxcRequest.post(url,
                {
                    UserName: $('input[name="username"]').val(),
                    Filter: $('input[name="filter"]').val(),
                    Id: $('#RecordId').val(),
                    DomainID: $('#obTree-id').val(),
                    AddrBookName: $('#AddressBookName').val(),
                    Desc: $('#DomainDescription').val(),
                    VisibilityID: $('#Visibility').val(),
                    IsAddrBookExt: isExternal,
                    ConnectionType: $('#ConnectionType').val(),
                    ConnectionString: $('#ConnectionString').val(),
                    QueryExpression: $('#QueryExpression').val(),
                    ServerAddress: $('#ServerAddress').val(),
                    LoginDomain: $('#Domain').val(),
                    LoginUserID: $('#UserID').val(),
                    LoginPassword: $('#Password').val(),
                    LoginPasswordIsEncrypted: $DomainPassIsEncrypted,
                    PublicAddressBook: $('#PublicAddressBook').val(),
                    FormBasedAuthExch2003: $('#FormBasedAuthExch2003').prop('checked'),
                    ClientId: $('#ClientId').val(),
                    TenantId: $('#TenantId').val(),
                    Action: 12 /* Test Data */
                },
                function (data) {
                    if (data.result === true)
                        swal($globalMessages.swal.success.title, $globalMessages.swal.externalSrcSuccess, "success");
                    else
                        swal($globalMessages.swal.error.errorCap, data.ErrMsg, "error");
                },
                function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorDBConnection, "error");
                });
        },
        readData: function () {
            /*debugger*/
            var isExternal = $('#AddressBookType').val() === '0' ? false : true;
            var rolename = $('#Role').val();
            var url = '';
            if (rolename === 'SUPER USER' || rolename === 'STANDARD USER') {
                url = '/Common/DomainAddrBook/ReadData';
            }
            else {
                url = '/Admin/AddressBooks/ReadData';
            }

            fxcRequest.post(url,
                {
                    UserName: $('input[name="username"]').val(),
                    Filter: $('input[name="filter"]').val(),
                    Id: $('#RecordId').val(),
                    DomainID: $('#obTree-id').val(),
                    AddrBookName: $('#AddressBookName').val(),
                    Desc: $('#DomainDescription').val(),
                    VisibilityID: $('#Visibility').val(),
                    IsAddrBookExt: isExternal,
                    ConnectionType: $('#ConnectionType').val(),
                    ConnectionString: $('#ConnectionString').val(),
                    QueryExpression: $('#QueryExpression').val(),
                    ServerAddress: $('#ServerAddress').val(),
                    LoginDomain: $('#Domain').val(),
                    LoginUserID: $('#UserID').val(),
                    LoginPassword: $('#Password').val(),
                    LoginPasswordIsEncrypted: $DomainPassIsEncrypted,
                    PublicAddressBook: $('#PublicAddressBook').val(),
                    FormBasedAuthExch2003: $('#FormBasedAuthExch2003').prop('checked'),
                    ClientId: $('#ClientId').val(),
                    TenantId: $('#TenantId').val(),
                    Action: 11 /* Read Data */
                },
                function (data) {
                    if (data.JsonArryExternalSource !== null) {

                        /*Pass data to ReadExternal Modal Page */
                        $('#read-ext-modal').modal('show');
                        $.domainAddressBook.initReadExternalGrid(data);
                    }
                },
                function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorDBConnection, "error");
                }, false);
        },
        deleteButtonClickHandler: function (e) {
            $(e).on('click', function () {
                var ids = getGridSelections($('#domainContactGrid'));
                if (ids.length > 0) {
                    if (ids.length > 0) {
                        swal({
                            title: "",
                            text: $domainAddress.swal.delAddBook,
                            type: "info",
                            showCancelButton: true,
                            closeOnConfirm: false,
                            reverseButtons: true,
                            showLoaderOnConfirm: true
                        }, function () {
                            $.domainAddressBook.delete(ids);
                        });
                    }
                }
                else {
                    swal("", $domainAddress.swal.noAddBookSelected);
                }
            });
        },
        delete: function (ids) {
            /*debugger*/

            var isAdmin = $('#isAdmin').val();
            var url = '';
            if (isAdmin === 'True') {
                url = '/Admin/AddressBooks/DeleteContact';
            }
            else {
                url = '/Common/DomainAddrBook/DeleteAddrBooks';
            }

            fxcRequest.post(url,
                {
                    Ids: ids
                },
                function (data) {
                    $.domainAddressBook.initGrid($('#domainContactGrid'));

                    swal($globalMessages.swal.success.title, $globalMessages.swal.success.delete, "success");
                },
                function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnDelete, "error");
                });
        },
        onDataBound: function (e) {
            document.getElementById("action-edit").disabled = false;
        },
        getPrevNav: function () {
            var prevLevel1Nav = $('#sidebarnav li.active a')[0];
            var prevLevel2Nav = $('#sidebarnav li.active ul').find('li.active');
            var prevNav = $($(prevLevel2Nav).find('ul li a.active')[0]).attr('id');

            prevNavs = {
                prevLevel1NavNemu: $(prevLevel1Nav),
                prevLevel2NavMenu: $($(prevLevel2Nav).find('a')[0]),
                prevNavMenu: $('#' + prevNav)
            };
        }
    };
})(window.jQuery);