﻿var splitMsgValidation = function () {
    $('#splitMessageSelection').validate({
        ignore: [],
        rules: {
            splitInput: { required: true }
        },
        messages: {
            splitInput: { required: $.validator.messages.required }
        }
    });
};
$.messageSplit = {
    init: function (viewBtn, submitBtn) {
        splitMsgValidation();
        $.messageSplit.viewActionHandler(viewBtn);
        $.messageSplit.submitActionHandler(submitBtn);
    },
    initMsgViewer: function (submitBtn) {
        splitMsgValidation();
        $.messageSplit.submitMsgViewerActionHandler(submitBtn);
    },
    viewActionHandler: function (e) {
        $(e).on('click', function () {
            var uid = $(this).attr('data-uid');
            var row = $("tr[data-uid='" + uid + "']");
            var dataItem = $("#grid").data("kendoGrid").dataItem(row);
            var rowAdditionalObj = {
                HideImageTab: false,
                IsSearchMsg: 'false'
            };

            dataItem.rowAdditionalObj = rowAdditionalObj;
            $.messageviewer.showMessageViewer(dataItem);
        })
    },
    submitActionHandler: function (e) {
        $(e).click(function (e) {
            e.preventDefault();
            var uid = $(this).attr('data-uid');
            var row = $("tr[data-uid='" + uid + "']");
            var dataItem = $("#grid").data("kendoGrid").dataItem(row);

            var delId = $('#DelegatorID').val();
            if (delId === '') {
                delId = 0;
            }

            var delProId = $('#DelgProID').val();
            if (delProId === '') {
                delProId = 0;
            }

          var pages = dataItem.Pages;
          var mId = dataItem.Id;
          if (pages === undefined) {
            pages = dataItem.MsgPageCount;
            mId = dataItem.MessageID;
            }

            fxcRequest.post(
                '/User/MsgIndex/Split',
                {
                    split: $('#splitInput').val(),
                    messageId: mId,
                    pages: pages,
                    userMsgId: dataItem.UserMsgID,
                    delegatorId: delId,
                    delegatorProfileId: delProId
                },
                function (data) {
                    swal($globalMessages.swal.success.title, data.Message, "success");
                    $('#split-modal').modal('hide');
                },
                function (error) {
                    swal($globalMessages.swal.error.title, error.Message, "error");
                });
        })
    },
    submitMsgViewerActionHandler: function (e) {
        $(e).click(function (e) {
            e.preventDefault();
            var delId = $('#DelegatorID').val();
            if (delId === '') {
                delId = 0;
            }

            var delProId = $('#DelgProID').val();
            if (delProId === '') {
                delProId = 0;
            }
            fxcRequest.post(
                '/User/MsgIndex/Split',
                {
                    split: $('#splitInputmsgviewer').val(),
                    messageId: $('#MsgID').val(),
                    pages: $('#PageCount').val(),
                    userMsgId: $('#UserMsgID').val(),
                    delegatorId: delId,
                    delegatorProfileId: delProId
                },
                function (data) {
                    swal($globalMessages.swal.success.title, data.Message, "success");
                    $('#splitmsgviewermodal').modal('hide');
                },
                function (error) {
                    swal($globalMessages.swal.error.title, error.Message, "error");
                });
        })
    }
};