﻿(function ($) {
	var $grid, $gridUser, $gridDoc, $selectedOwner = [], $selectedUser = [], $approvalReqIDs = [], intervalevent, intervaltext;
    var array = {};
    var bind = false;
    var reset = true;
    var getCommand;
    var getButton;
    var rowAdditionalObj = null;
    var rowAdditionalObj2 = null;

    $.messages = {
        initContextMenu: function () {
            $.contextMenu('destroy', ".ctxmenuMsg");
            $.contextMenu({
                selector: '.ctxmenuMsg',
                trigger: 'right',
                items: {
                    "1": { name: "View Message Info", icon: "fa-info" },
                    "2": { name: "Split Message", icon: "fa-split" }
                },
                className: "messageContextMenu",
                callback: function (key, options) {
                    var uid = options.$trigger.attr("data-uid");
                    var row = $("tr[data-uid='" + uid + "']");
                    var dataItem = $("#grid").data("kendoGrid").dataItem(row);
                  
                    if (key === "1") {
                        if (rowAdditionalObj !== null) {
                            dataItem.rowAdditionalObj = rowAdditionalObj;
                            dataItem.rowAdditionalObj.HideImageTab = true;
                        }
                       
                        $.messageviewer.showMessageViewer(dataItem);
                    } else if (dataItem.Pages > 1) {
                        $('#BtnViewMessage').attr('data-uid', uid);
                        $('#BtnSubmitSplit').attr('data-uid', uid);

                        $('#splitPages').text($splitresource.pages + ' ' + dataItem.Pages);
                        $('#splitInput').val('1-' + dataItem.Pages);
                        
                        $('#split-modal').modal('show');
                    } else {
                        swal($globalMessages.swal.error.title, $splitresource.unable, "error");
                    }
                }
            });

            if ($showDotContextMenu) {
                $.contextMenu('destroy', ".dotcontextMenu");
                $.contextMenu({
                    selector: '.dotcontextMenu',
                    trigger: 'left',
                    items: {
                        "1": { name: "View Message Info", icon: "fa-info" },
                        "2": { name: "Split Message", icon: "fa-split" }
                    },
                    callback: function (key, options) {
                        var uid = options.$trigger.attr("data-uid");
                        var row = $("tr[data-uid='" + uid + "']");
                        var dataItem = $("#grid").data("kendoGrid").dataItem(row);
                        if (key === "1") {
                            if (rowAdditionalObj !== null) {
                                dataItem.rowAdditionalObj = rowAdditionalObj;
                                dataItem.rowAdditionalObj.HideImageTab = true;
                            }
                            
                            $.messageviewer.showMessageViewer(dataItem);
                        } else if (dataItem.Pages > 1) {
                            $('#BtnViewMessage').attr('data-uid', uid);
                            $('#BtnSubmitSplit').attr('data-uid', uid);

                            $('#splitPages').text($splitresource.pages + ' ' + dataItem.Pages);
                            $('#splitInput').val('1-' + dataItem.Pages);
                            
                            $('#split-modal').modal('show');
                        } else {
                            swal($globalMessages.swal.error.title, $splitresource.unable, "error");
                        }
                    } 
                });
            }
        },
        updateInterval: function (interval, text) {
            intervaltext = text;
            $('span#TlbbtnRefreshInterval').text(intervaltext);
            if (interval == 0) {
                clearInterval(intervalevent);
            } else {
                var updateFlag = $('#IsMessageGrid').val() == "true";
                if (updateFlag) {
                    var millisecond = Number(interval) * 1000;
                    intervalevent = setInterval($.messages.getMessages, millisecond);
                } else {
                    clearInterval(intervalevent);
                }
            }
		},
		updateFilter: function (filter, text) {
			$('#TlbbtnFilterSpan').text(text);
			$('#TlbbtnFilterSpan').attr("data-filter", filter);
			$.messages.initgrid($('#grid'));
		},
        getMessages: function (e) {
            
            /*add check: clear intreval if not in message grid*/
            var clearFlag = $('#IsMessageGrid').val() != "true";
            if (clearFlag) {
                clearInterval(intervalevent);
                return false;
            }
            $.messages.initgrid($('#grid'));
        },
        refreshMessageFromHub: function (model) {
            var folderId = $('input#folderId').val();
            if (folderId == 1000) {
                var refreshFlag = $('#MessageHubRefreshFlag').val();
                if (model != null && model.RefreshLocation == refreshFlag) {
                    $.messages.initgrid($('#grid'));
                }
            }
        },
        initgrid: function (e) {
            var folderId = $('input#folderId').val();
            var folderName = $('input#folderName').val();

            var col = [];
            /*GetColumnData*/
            fxcRequest.get('/User/MsgIndex/GetColumnData',
                {
                    "FolderName": folderName
                },
                function (data) {
                    col = JSON.parse(data.ColumnData);
                    var item = {};
                    item.selectable = true;
                    item.width = "45px";
                    item.field = "checkboxSelection";
                    item.sortable = false;
                    /*Hide Message Status */
                    col.find(x => x.field == "MsgStatusID") ? col.find(x => x.field == "MsgStatusID").hidden = true : "";
                    col.find(x => x.field == "MsgType") ? col.find(x => x.field == "MsgType").sortable = false : "";

                    if (!$showColMessageId) {
                        col.find(x => x.field == "Id") ? col.find(x => x.field == "Id").hidden = true : "";
                    }
                    if (!$ShowColCalledNumber) {
                        col.find(x => x.field == "CalledNumber") ? col.find(x => x.field == "CalledNumber").hidden = true : "";
                    }

                    if ($showDotContextMenu) {
                        col.unshift({
                            field: "",
                            title: "",
                            width: 30,
                            sortable: false,
                            headerAttributes: {
                                "aria-label": "view",
                            }
                        });
                    }

                    col.unshift(item);

                    /*GetColumnData*/
                    var url = "/User/MsgIndex/GetGridMessages";
                    var id = e;
					var appFilter = $('#TlbbtnFilterSpan').attr("data-filter");
                    var dataSource = {
                        transport: {
                            read: {
                                url: url,
                                dataType: "json",
                                type: "GET"
                            },
                            parameterMap: function (options) {
                                /* Fix url param for sort values */
                                var result = {
                                    page: options.page,
                                    take: options.take,
                                    skip: options.skip,
                                    SearchText: $('input[data-role="search-user-message"]').val(),
                                    DelegatorID: $('#DelegatorID').val(),
                                    DelgProID: $('#DelgProID').val(),
                                    folderId: folderId,
                                    folderName: folderName,
                                    AppFilter: appFilter
                                    
                                };
                                if (options.sort && options.sort.length > 0) {
                                    result.SortBy = options.sort[0].field;
                                    result.Direction = options.sort[0].dir;
                                }
                                return result;
                            }
                        },
                        schema: {
                            data: "MessageList",
                            model: {
								id: "uid"
                            },
                            total: "Total"
                        },
                        serverPaging: true,
                        serverSorting: true
                    };

                    var obj = {};
                    var template = '<tr data-uid="#= uid #" data-id="#= id #" role="row" class="ctxmenuMsg #= RowNum %2 ? "": "k-alt" # Row-Readable-#= IsRead #"> ';
                    for (var k = 0; k < col.length; k++) {
                        var visibility = "";
                        if (col[k].hidden == true) {
                            visibility = 'style="display:none"';
                        }
                        if (col[k].field == "checkboxSelection") {
                            template += ' <td class="checkboxSelection" role="gridcell"> '
                                + '     <input class="k-checkbox" data-role="checkbox" id="selection-#= id #" '
                                + '            aria-label="Select row" aria-checked="false" type="checkbox"> '
                                + '     <label for="selection-#= id #" class="k-checkbox-label k-no-text">selection-#= id #</label> '
                                + ' </td> ';
                        }
                        else if (col[k].field == "" ) {
                            template += ' <td class="checkboxSelection" role="gridcell"> '
                                + '     <span class="dotcontextMenu" data-uid="#= uid #"><i class="fa fa-ellipsis-v" style="padding:0px 5px;"></i></span>'
                                + ' </td> ';
                        }
                        else if ((col[k].field + "").toLowerCase() == "msgtype" ) {
                            template += ' <td class="checkboxSelection" role="gridcell"> '
                                + '     <span title="#= MsgTypeLabel #" data-uid="#= uid #" data-msgtype="#= MsgType #"><i class="mdi mdi-#= MsgType == 1 ? "Outbound"  : "Inbound"#" style="padding:0px 5px;"></i></span>'
                                + ' </td> ';
                        }
                        else if ((col[k].field + "").toLowerCase() == "status" && folderId == "1000") {

                            template += ' <td class="" role="gridcell" title="#= ' + col[k].field + ' #"> '
                                + '     <div class="kendo-container"> '
                                + '         <span class="badge kendo-span-status badge-pill badge-#=MsgStatusID# "> '
                                + '             <i class="mdi mdi-check kendo-check-icon-msgstatus#= MsgStatusID #"></i> '
                                + '             <i class="mdi mdi-window-close kendo-window-close-icon-msgstatus#= MsgStatusID #"></i> '
                                + '             #=' + col[k].field + '# '
                                + '         </span> '
                                + '     </div> '
                                + ' </td> ';
                        }
                        else if ((col[k].field + "").toLowerCase() == "status" && folderId != "1000") {

                            template += ' <td class="" role="gridcell" title="#= ' + col[k].field + ' #"> '
                                + '     <div class="kendo-container"> '
                                + '         <span class="badge kendo-span-status badge-pill badge-#=MsgStatusID# "> '
                                + '             <i class="mdi mdi-check kendo-check-icon-msgstatus#= MsgStatusID #"></i> '
                                + '             <i class="mdi mdi-window-close kendo-window-close-icon-msgstatus#= MsgStatusID #"></i> '
                                + '             #=' + col[k].field + '# '
                                + '         </span> '
                                + '         <span title="Printed" class="verticalAlignTop kendo-btn-circle-#= IsPrinted #"> '
                                + '             <i class="mdi mdi-printer"></i> '
                                + '         </span> '
                                + '         <span title="Saved" class="verticalAlignTop kendo-btn-circle-#= IsSave #"> '
                                + '            <i class="mdi mdi-content-save"></i></span> '
                                + '        <span title="Notified" class="verticalAlignTop kendo-btn-circle-#= WithNotification #"> '
                                + '             <i class="mdi mdi-bell"></i> '
                                + '         </span> '
                                + '         <span title="Forwarded" class="verticalAlignTop kendo-btn-circle-#= IsForwarded #"> '
                                + '             <i class="mdi mdi-arrow-right-bold"></i> '
                                + '         </span> '
                                + '     </div> '
                                + ' </td> ';
                        }
                        else {
                            template += '<td class="" ' + visibility + ' role="gridcell">#=' + col[k].field + '#</td>';
                        }
                    }
                    template += ' </tr>';
                  var rowTemplate = kendo.template(template);
                    obj.rowTemplate = rowTemplate;
                    obj.allowSelectMultipleRow = true;
                    rowAdditionalObj = {
                        "RefreshLocation": $('#MessageHubRefreshFlag').val()
                    }
                    rowAdditionalObj2 = {
                        "RefreshLocation": $('#MessageHubRefreshFlag').val()
                    };

                    obj.rowAdditionalObj = rowAdditionalObj2;

                    if ($enableDoubleClick) {
                        obj.doubleClickFn = $.messageviewer.showMessageViewer;
                    }
                    else {
                        obj.onSelectionFn = $.messageviewer.showMessageViewer;
                    }
                    $grid = kendogridcustomization.init(id, dataSource, col, obj);
                });
			var getDisplayUnread = $("#displayTotalUnread").val();
			var boolDisplayTotalUnread = getDisplayUnread ? (getDisplayUnread.toLowerCase() == "true") : false;
			if (boolDisplayTotalUnread)
			{
				$.messages.initGridUnreadMsg();
            }

            $.messages.initContextMenu();
        },
        initGridUnreadMsg: function (e) {
            var folderId = $('input#folderId').val();
            /*GetTotalUnread*/
            fxcRequest.get('/User/MsgIndex/GetTotalUnread',
                {
                    "FolderId": folderId,
                    "DelegatorID": $('input#DelegatorID').val()
                },
                function (data) {
                    $('span.displayTotal1').text(data.TotalUnread);
                });
        },
        initUsergrid: function (e, data) {
            $gridUser = $(e).kendoGrid({
                dataSource: {
                    data: data.RecpList,
                    schema: {
                        model: {
                            id: "UserID",
                            fields: {
                                Name: { editable: false, nullable: true },
                                CompanyName: { validation: { required: true } },
                                IsRRSOn: { editable: true, type: "boolean" }
                            }
                        }
                    },
                    pageSize: 10
                },
                pageable: {
                    input: true,
                    numeric: false
                },
                editable: true,
                columns: [
                    { field: "Name", title: $areaResources.grid.name, width: 110 },
                    { field: "CompanyName", title: $area.$areaResources.grid.companyName, width: 110 },
                    { field: "IsRRSOn", template: '<input class="filled-in chk-col-blue chkbx" type="checkbox" #=IsRRSOn ? checked="checked"  : "" #disabled="disabled" ></input>', width: 110 }]
            });

            $("#gridUser .k-grid-content").on("change", "input.chkbx", function (e) {
                var grid = $("#gridUser").data("kendoGrid"),
                    dataItem = grid.dataItem($(e.target).closest("tr"));

                dataItem.set("IsRRSOn", this.checked);
            });
        },
        initDocgrid: function (e, data) {
            $gridDoc = $(e).kendoGrid({
                dataSource: {
                    data: data.DocList,
                    schema: {
                        model: {
                            id: "DocumentID",
                            fields: {
                                FileName: { editable: false, nullable: true }
                            }
                        }
                    },
                    pageSize: 10
                },
                pageable: {
                    input: true,
                    numeric: false
                },
                editable: true,
                columns: [
                    { field: "FileName", title: "Document", width: 110 }]
            });
        },
        searchButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.messages.getMessages();
            });
        },
        searchHandler: function (e) {
            $(e).keypress(function (event) {
                if (event.which == 13) {
                    $.messages.getMessages();
                }
            });
        },
        getGridSelections: function (arg) {
            var entityGrid = $("#grid").data("kendoGrid");
            var rows = entityGrid.select();
            $selectedOwner = [];
            $approvalReqIDs = [];
            rows.each(function (index, row) {
                var selectedItem = entityGrid.dataItem(row);
                $selectedOwner[index] = { 'UserMsgID': selectedItem.UserMsgID !== '' ? selectedItem.UserMsgID : '0', 'MessageID': selectedItem.Id };
                $approvalReqIDs[index] = selectedItem.ApprovalReqID;
            });
        },
        showDialog: function (type) {

            switch (type) {
                case 1:
                    $("#userSelection").text($areaResources.actionTitle.assignToUsers);
                    $("#BtnSaveuserSelection").val($areaResources.actionTitle.assign);
                    $("#user-selection-modal").modal('show');
                    $.userSelection.reset();
                    return false;
                case 2:
                    $("#userSelection").text($areaResources.actionTitle.forwardToUsers);
                    $("#BtnSaveuserSelection").val($areaResources.actionTitle.forward);
                    $("#user-selection-modal").modal('show');
                    $.userSelection.reset();
                    return false;
                case 3:
                    /*To Do call to controller to get the PrintNetwork*/
                    $.messages.loadNetworkPrinter();
                    break;
                case 4:
                    break;
                default:
                    break;
            }
            /*TODO message viewer*/
            /*var url = './uMessageAction.aspx?at=' + type;	*/
        },
        printLocalAction: function (e) {

            var entityGrid = $("#grid").data("kendoGrid");
            var rows = entityGrid.select();
            var msg = '';
            var printType = $('#UsrPrintSaveFormat').val();

            rows.each(function (index, row) {
                var selectedItem = entityGrid.dataItem(row);
                msg += selectedItem.Id + '|' + selectedItem.UserMsgID + ';';
            });

            msg = msg.substring(0, msg.length - 1);

            var param = {
                'type': printType,
                'data': msg,
                'delg': $('input#DelegatorID').val(),
                'pro': $('input#DelgProID').val()
            }
            var url = '/Print/Local?' + new URLSearchParams(param);

            var winPopup;
            var name = 'PrintLocal';
            var features = 'width=' + 400 + ',height=' + 600 + ',resizable=' + true + ',scrollbars=no,toolbar=no,location=no,directories=no,status=no,menubar=no,copyhistory=no';
            winPopup = window.open(url, name, features);

            if (printType.toLowerCase() == 'pdf') {
                winPopup.print();
            }
            winPopup.focus();
        },
        performMsgAction: function (command, selectedMoveFolder, e) {
            var successType = $(e).data('successtype');
            var successMsg = $(e).data('successmsg');

            var data = {
                "FolderId": $('#folderId').val(),
                "FolderName": $('#folderName').val(),
                "SelectedMoveFolder": selectedMoveFolder,
                "Command": command,
                "DelegatorID": $('input#DelegatorID').val(),
                "DelgProID": $('input#DelgProID').val(),
                "SelectedOwnerMsg": $selectedOwner,
                "ApprovalReqIDs": $approvalReqIDs,
                'PrintNetwork': {
                    'selectedNetPrinter': $('#ddlNetPrinter').val(),
                    'PaperSize': $('#ddlPaperSize').val(),
                    'BannerPg': $('#ddlBannerPg').val()
                }
            };
            if($selectedUser.length > 0){
              data.SelectedUser = $selectedUser.join().split(',');
            }

            var postLoader = false;

            switch (successType) {
                case "Toast":
                    postLoader = false;
                    break;
                case "Swal":
                    postLoader = true;
                    break;
                default:

			}
            fxcRequest.post('/User/MsgIndex/PerformMsgAction'
                , data
                , function (data) {
                    $.messages.initgrid($('#grid'));
                    switch (successType) {
                        case "Toast":
                            $.toast({
                                heading: $globalMessages.toast.success,
                                text: successMsg,
                                position: 'top-right',
                                loaderBg: '#ff6849',
                                icon: 'success',
                                hideAfter: 3500,
                                stack: 6
                            });
                            break;
                        case "Swal":
                            swal($globalMessages.swal.success.title, successMsg, "success");
                            break;
                        default:
                            break;
                    }
                    switch (Number(command)) {
                        case 103:
                            $("#user-selection-modal").modal('hide');
                            break;
                        case 111:
                            $("#user-selection-modal").modal('hide');
                            break;
                        case 110:
                            $('#printNetwork-modal').modal('hide');
                            break;
                    }
                }
                , function (error) {
                    swal("ERROR!", 'An error occured upon submit', "error");
                }, postLoader);
        },
        performMsgActionHandler: function (e) {
            $(e).on('click', function () {
                $selectedUser = [];
                var btnTemp = this;
                getButton = btnTemp;
                $.messages.getGridSelections();
                var command = $(this).attr('data-command').toString();
                getCommand = command;
                var selectedMoveFolder = $(this).data('folder');

                var delegatorID = $('#DelegatorID').val();
                var delgProID = $('#DelgProID').val();
                var isDelegated = false;

                if (delegatorID != "" && delgProID != "") {
                    isDelegated = true;
                }

                if (command == '0') { /*new message*/
                    var url = '/user/message/';
                    if (isDelegated)
                        url += '?DelegatorID=' + delegatorID + '&DelgProID=' + delgProID;

                    fxcontent.load(url);
                } else if (command == '1') { /*new broadcast*/
                    var url = '/user/broadcast/';
                    if (isDelegated)
                        url += '?DelegationID=' + delegatorID + '&DelegationProf=' + delgProID;

                    fxcontent.load(url);
                } else if (command == '111') { /*Assign*/
                    if ($selectedOwner.length === 0) {
                        swal("", $areaResources.swal.noMsgSelected);
                        return false;
                    }
                    $.messages.showDialog(1);
                } else if (command == '103') { /*forward to user*/
                    if ($selectedOwner.length === 0) {
                        swal("", $areaResources.swal.noMsgSelected);
                        return false;
                    }
                    $.messages.showDialog(2);
                } else if (command == '115') { /*forward*/
                    if ($selectedOwner.length === 0) {
                        swal("", $areaResources.swal.noMsgSelected);
                        return false;
                    }
                    else if ($selectedOwner.length > 1) {
                        swal("", $areaResources.swal.multipleMsgSelected);
                        return false;
                    }

                    $.messages.showSendMsgWin('f', $selectedOwner[0].UserMsgID, $selectedOwner[0].MessageID, delegatorID, delgProID);
                } else if (command == '110') { /*PrintNetwork*/
                    if ($selectedOwner.length === 0) {
                        swal("", $areaResources.swal.noMsgSelected);
                        return false;
                    }
                    else {
                        $.messages.showDialog(3);
                    }
                    /*url = './uPrintMsg.aspx';*/
                } else if (command == '109') { /*PrintLocal*/

                    if ($selectedOwner.length === 0) {
                        swal("", $areaResources.swal.noMsgSelected);
                        return false;
                    }

                    $.messages.printLocalAction();

                } else if (command == '5') {
                    var interval = $(this).data('interval');
                    var text = $(this).data('text');
                    $.messages.updateInterval(interval, text);
                } else if (command == '3') { /*Refresh*/
                    $('input[data-role="search-user-message"]').val("");
                    $.messages.getMessages();
				} else if (command == '200') { /*Filter*/
					var filter = $(this).data('filter');
					var getText = $(this).data('text');
					$.messages.updateFilter(filter, getText);
				}
				else {
					if ($selectedOwner.length === 0) {
						$(this).blur();
						swal("", $areaResources.swal.noMsgSelected);
                        return false;
                    }

                    var confirmationMsg = $(this).data('confirmationmsg');
                    if (confirmationMsg) {
                        swal({
                            title: "",
                            text: confirmationMsg,
                            type: "info",
                            showCancelButton: true,
                            reverseButtons: true
                        }, function () {
                            $.messages.performMsgAction(command, selectedMoveFolder, btnTemp);
                        });
                    }
                    else {
                        $.messages.performMsgAction(command, selectedMoveFolder, btnTemp);
                    }
				}
                $(this).blur();
            });

        },

        /*NetworkPrinter DataSource to load page content*/
        loadNetworkPrinter: function () {
            fxcRequest.get('/User/MsgIndex/GetNetworkPrinterDataSource'
                , null
                , function (data) {
                    $.messages.getGridSelections();
                    $.sectionproperties.selectGenerator('ddlNetPrinter', data.NetworkPrinter.NetworkPrinterConfigType.Source, data.NetworkPrinter.NetworkPrinterConfigType.Value, 0);
                    $('#ddlPaperSize').html(data.NetworkPrinter.XmlData);

                    $('#printNetwork-modal').modal('show');
                }
                , function (error) {
                    swal("ERROR!", 'An error occured upon submit', "error");
                }
            );
        },
        performPrintNetworkActionHandler: function (e) {
            $(e).on('click', function () {
                $.messages.performMsgAction('110', null, $('#TlbbtnPrintNetwork'));               
            });
        },

        showSendMsgWin: function (rfType, umid, mid, delegatorID, delgProID) {

            //url += '?DelegationID=' + delegatorID + '&DelegationProf=' + delgProID;

            var url = '/User/Message?rf=' + rfType + '&umid=' + umid + '&mid='
                + mid;

            url = url + '&delegatorID=' + delegatorID + '&delgProID=' + delgProID;

            var des = $('#hfDeselectedPages').val();
            if (des)
                url = url + '&des=' + des;

            $.messages.showWin(url, '800', '580', rfType, 'yes');
        },

        showWin: function (winUrl, width, height, winName, resize) {
            var winPopup;
            var url = winUrl;
            var name = winName;

            var features = 'width=' + width + ',height=' + height + ',resizable=' + resize + ',scrollbars=no,toolbar=no,location=no,directories=no,status=no,menubar=no,copyhistory=no';
            winPopup = window.open(url, name, features);
            if (name == "PrintLocalPDF") {
                winPopup.print();
            }
            winPopup.focus();
        },
    };

  var validation = function () {
    $('#formUserSelection').validate({
      ignore: [],
      rules: {
        listUserSelected: { multiselectrequired: true }
      },
      messages: {
        listUserSelected: { multiselectrequired: $.validator.messages.required }
      },
      submitHandler: function (form) {
        $selectedUser = $.userSelection.getListDataSource($("#listUserSelected"));
        $.messages.performMsgAction(getCommand, null, getButton);
      }
    });
  };
    $.userSelection = {
        init: function (e) {
            validation();
            $.userSelection.searchButtonClickHandler($("#btn-userSelectionSearchButton"));
            $.userSelection.searchPressEnter($('input[data-role="search-active-user"]'));
            $.userSelection.resetButtonClickHandler($('#BtnResetuserSelection'));
        },
        initListView: function (e) {
            $('input[data-role="search-active-user"]').val("");
            var listBoxID = "listUserSelection";
            var listBoxIDConnectWith = "listUserSelected";

            fxcRequest.post('/Common/PopulateActiveUser',
                {
                    DomainID: e,
                    SearchText: "",
                    GroupMember: $.userSelection.getListDataSource($("#" + listBoxIDConnectWith)),
                    ResetField: reset
                },
                function (data) {
                    var returnObject = [];

                    var dataSourceSelection = {
                        data: data.ActiveUserModel.ActiveUserList.Source
                    };

                    var objUserSelection = {};
                    objUserSelection.dataTextField = "Text";
                    objUserSelection.dataValueField = "Value";
                    objUserSelection.connectWith = listBoxIDConnectWith;
                    objUserSelection.staticSelectedListBox = !reset;

                    var dataSourceSelected = {
                        data: data.ActiveUserModel.SelectedUserList.Source
                    };

                    returnObject = listbox.mutual(listBoxID, dataSourceSelection, objUserSelection, dataSourceSelected);

                    if (returnObject != null) {
                        $listBoxSelection = returnObject.listBoxSelection;
                        $listBoxSelected = returnObject.listBoxSelected;
                    }

                    reset = false;
                },
                function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnLoad, 'error');
                }, false);
        },
        initTreeViewAction: function (e) {
            /* Action Forward to user // Assign Pop Up*/
            $("#userDomain-id").val($('#defaultDomainID').val());
            var objUserSelection = {};
            objUserSelection.expandAll = true;
            objUserSelection.declareType = "textbox";
            objUserSelection.postSelectFn = $.userSelection.initListView;
            objUserSelection.selectFirstNode = true;
            treeview.init("userDomain", "userDomain-name", "userDomain-id", objUserSelection);
        },

        /*Btn Action*/
        resetButtonClickHandler: function (e) {
            $(e).on('click', function (x) {
                $.userSelection.reset();
            });
        },
        searchButtonClickHandler: function (e) {
            $(e).on('click', function (x, y) {
                $.userSelection.search();
            });
        },
        searchPressEnter: function (e) {
            $(e).on('keypress', function (event) {
                if (event.which === 13) {
                    $.userSelection.search();
                    event.preventDefault();
                }
            });
        },
        /*End Btn Action*/

        /* Logic */
        getListDataSource: function (event) {
            var entityList = event.data("kendoListBox");
            var result = [];
            if (entityList != undefined) {
                var rows = entityList.dataItems();

                $(rows).each(function (index, row) {
                    result[index] = row.Value;
                });
            }
            return result;
        },
        reset: function (e) {
            reset = true;
            $("#formUserSelection").trigger("reset");
            $("#formUserSelection").validate().resetForm();

            if (!bind) {
                $.userSelection.initTreeViewAction();
                bind = true;
            }
            else {
                /*Reselect User From ID*/
                $("#userDomain").tree().unselectAll();
                $("#userDomain-id").val($('#defaultDomainID').val());
                var getUserData = $("#userDomain").tree().getNodeById($("#userDomain-id").val());

                if (getUserData != undefined) {
                    $("#userDomain").tree().select(getUserData);
                }
            }
        },
        search: function (e) {
            /*$.userSelection.initListView();*/

            var listBoxSelection = $("#listUserSelection").getKendoListBox();
            var searchString = $('input[data-role="search-active-user"]').val();

            listBoxSelection.dataSource.filter({ field: "Text", operator: "contains", value: searchString });
        }
    };
})(window.jQuery);
