﻿(function ($) {
	var setIsRtl = $("html[dir]").attr("dir") === "rtl" ? true : false;
    var tour = {
        id: "user-messages-hopscotch",
        steps: [
            {
                target: "button.btnNew.btn-TlbbtnNew",
                title: "",
                content: $globalMessages.uiGuide.buttonNew,
                placement: "bottom",
                xOffset: "18",
				yOffset: "-3",
				isRtl: setIsRtl
            },
            {
                target: "button.btn-delete.btn-TlbbtnMoveToTrash",
                title: "",
                content: $globalMessages.uiGuide.buttonDelete,
                placement: "bottom",
                xOffset: "-12",
				yOffset: "-3",
				isRtl: setIsRtl
            },
            {
                target: "button.btn-repeat.btn-TlbbtnRefresh",
                title: "",
                content: $globalMessages.uiGuide.buttonRefresh,
                placement: "bottom",
                xOffset: "-12",
				yOffset: "-3",
				isRtl: setIsRtl
            },
            {
                target: "gridRefreshIntervalBtn",
                title: "",
                content: $globalMessages.uiGuide.buttonRefreshInterval,
                placement: "bottom",
                xOffset: "22",
				yOffset: "-3",
				isRtl: setIsRtl
            },
            {
                target: "gridActionsBtn",
                title: "",
                content: $globalMessages.uiGuide.buttonAction,
                placement: "bottom",
                xOffset: "12",
				yOffset: "-3",
				isRtl: setIsRtl
            },
            {
                target: "input[data-role='search-user-message']",
                title: "",
                content: $globalMessages.uiGuide.buttonSearch,
                placement: "left",
                yOffset: "-12",
				xOffset: "2",
				isRtl: setIsRtl
            },
            {
                target: "personalFolderLink",
                title: "",
                content: $globalMessages.uiGuide.buttonPersonalFolder,
                placement: "right",
                yOffset: "-12",
                xOffset: "-76",
				zindex: 1002,
				isRtl: setIsRtl
            }
        ],
        showPrevButton: true
    };
    $.userMessagesUiGuide = {
        init: function (tourBtn) {
            $.sharedUiGuide.init({ startTourBtn: tourBtn, tour: tour });
            $('button.btnNew.btn-TlbbtnNew').click(function () {
                hopscotch.endTour();
            });
        }
    };
})(window.jQuery);