﻿(function ($) {
    var countdownFileSession = false;
    var timerCountdown = false;
    var fileSessionExpired;

    var defaultDateTime = $("#defaultDateFormat").val() + " " + $("#defaultTimeFormat").val();
    /*var defaultDateTime = $("#ScheduleDateFormat").val(); */

    var validationForm = function () {

        $('#formSubmit').validate({
            ignore: [],
            ignoreTitle: true,
            rules: {
                SenderName: {
                    required: true,
                    noSpace: true
                },
                Schedule: { fxcDateFormat: [defaultDateTime] },
                PriorityList: {
                    required: true,
                    noSpace: true
                },
                "TotalGrid-gridDocument": {
                    required: true,
                    min: 1
                },
                "TotalGrid-gridRecipient": {
                    required: true,
                    min: 1
                }
            },
            messages: {
                /* Step 1 */
                Schedule: { fxcDateFormat: $globalMessages.validation.fxcDateFormat },

                /* Step 2 -Document */
                "TotalGrid-gridDocument": {
                    required: $globalMessages.validation.gridMinLength,
                    min: $globalMessages.validation.gridMinLength
                },

                /* Step 3 - Recipient - add function */
                "TotalGrid-gridRecipient": {
                    required: $globalMessages.validation.gridMinLength,
                    min: $globalMessages.validation.gridMinLength
                },
            },
            submitHandler: function (form) {
                $.broadcast.send();
            }
        });
    };
    $.broadcast = {
        init: function (e) {
            validationForm();
            $.broadcast.getTrackingInfo();
            $.broadcast.initDateTime();

            $.broadcast.initDocumentTreeview();
            $.broadcast.notifyOnChangeHandler($("#EnableBatchNotification"));
            $.broadcast.contactListOnChangeHandler($("#ContactList"));
            $.broadcast.retrieveCntListOnClickHandler($("#linkRetrieveContact"));
            $.broadcast.sendBtnOnClickHandler($("#view1SendBtn"));
            $.broadcast.retrieveImportCntListOnClickHandler($("#linkRetrieveContactImport"));
            $.broadcast.resetBtnOnClickHandler($("#view1ResetBtn"));
            dropzone.init();
            $.broadcast.resetFields();

            $(window).on('unload', function () {
                /* Check if the page is in Broadcast */
                if ($("#sidebarnav li a#newgetbroadcast").hasClass("active")) {
                    $.broadcast.deleteAllAttachments();
                }
            });

            /* Call deleteAllAttachments when user navigates away from current page */
            $('nav.sidebar-nav ul li a[href!="#"][data-href]').on('click.removeattachment', function (e) {
                $.broadcast.deleteAllAttachments();

                /* Unbind the click function after called */
                $('nav.sidebar-nav ul li a[href!="#"][data-href]').off('click.removeattachment');
            });

        },
        initDateTime: function (e) {
            /*website: http://www.daterangepicker.com/ */
            var obj = {};
            obj.minDate = $("#MinDate").val();
            fxcDateTimePicker.init('#Schedule', defaultDateTime, obj);
        },
        initDocumentTreeview: function (e) {
            var objDoc = {};
            objDoc.postSelectFn = $.broadcast.addDocument;
            objDoc.dataSource = "/User/UserCommon/DocFolderTree?delegatorID=" + $('input#DelegationID').val();
            objDoc.expandNodeValue = [1];
            objDoc.declareType = "button"; /*Required Declare for DropDownList type*/

            treeview.init("docTree", "docTreeName", "docTreeID", objDoc);
        },
        initDocumentGrid: function (data) {
            var id = $('#gridDocument');
            var dataSource = {
                data: data,

                schema: {
                    model: {
                        id: "DocumentID"
                    }
                }
            };
            var columns = [];
            columns = [
                { field: "id", title: $globalMessages.grid.id, hidden: true },
                { field: "DocUid", hidden: true },
                {
                    field: "FileName",
                    title: $broadcast.grid.fileName,
                    width: 100,
                    template: function (dataRow) {
                        var result = '<span class="documentIcon-' + dataRow.DriveAccessType + '">' + dataRow.FileName + '</span>';
                        var signBtn = '<button class="btn btn-outline-success signDocBtn m-l-15" title="' + $broadcast.annotateTooltip + '">' + $broadcast.annotate + '</button>';
                        return result;
                    }
                },
                {
                    field: "Status",
                    title: "&nbsp;",
                    width: 50,
                    sortable: false,
                    headerAttributes: {
                        "aria-label": "Status",
                    },
                    template: function (dataRow) {
                        var removeBtn = '<div class="text-right"><a class="imageSizeTopBarIcons nav-link color-red waves-effect remove" href="javascript:void(0)" title="' + $globalMessages.grid.delTooltip + '"><i class="fa fa-trash-o"></i></a></div>';
                        return removeBtn;
                    }
                }
            ];

            var obj = {};
            obj.disablePageable = true;
            obj.rowSortable = true;
            obj.totalInputType = $("#TotalGrid-gridDocument");
            var $grid = kendogridcustomization.init(id, dataSource, columns, obj);
            $.broadcast.promptExpiringSession();
            $.broadcast.delete(id, $("#TotalGrid-gridDocument"));
        },
        initRecipientGrid: function (dataSource) {
            var id = $("#gridRecipient");

            dataSource.schema = {
                data: "Records",
                total: "Total",
                model: {
                    id: "Seq"
                }
            };
            console.log("gridRecipient");
            console.log(dataSource);
            dataSource.serverPaging = false;
            dataSource.serverSorting = false;

            var col = [
                { field: "Seq", title: $areaResources.grid.encStatus, hidden: true },
                { field: 'CompanyName', title: $broadcast.grid.companyName, sortable: true, minWidth: 200, width: 150 },
                { field: 'DisplayName', title: $broadcast.grid.displayName, sortable: true, minWidth: 200, width: 150 },
                { field: 'DisplayAddress', title: $broadcast.grid.address, sortable: true, minWidth: 200, width: 150 },
                {
                    field: "Seq",
                    title: $broadcast.grid.action,
                    width: "100px",
                    sortable: false,
                    template: function (dataRow) {
                        var result = '<a class="imageSizeTopBarIcons nav-link color-red waves-effect remove" data-id="' + dataRow.Seq + '" id="del-' + dataRow.Seq + '" href="javascript:void(0)" title="' + $globalMessages.grid.delTooltip + '"><i class="fa fa-trash-o"></i></a>';
                        return result;
                    }
                }
            ];

            var obj = {};
            obj.allowSelectMultipleRow = true;
            obj.totalInputType = $("#TotalGrid-gridRecipient");
            var $grid = kendogridcustomization.init(id, dataSource, col, obj);
            $.broadcast.delete(id, $("#TotalGrid-gridRecipient"));
        },

        /*logic*/
        notifyOnChangeHandler: function (e) {
            $(e).change(function () {
                var disabledSelection = false;
                if ($(this).is(":checked"))
                    disabledSelection = true;
                $("#NotifyMessageSuccess").attr("Disabled", disabledSelection);
                $("#NotifyMessageFailure").attr("Disabled", disabledSelection);

            });
        },
        contactListOnChangeHandler: function (e) {
            $(e).change(function () {
                var selVal = $(this).val();
                var chkSndMsgToMulCnt = document.getElementById("SendMultipleContact");

                var chkSndAsRaw = document.getElementById("SendRawFax");
                chkSndMsgToMulCnt.disabled = false;
                chkSndAsRaw.disabled = true;
                if (selVal.endsWith('6')) {
                    chkSndAsRaw.disabled = false;
                    document.getElementById('FilterDiv').style.display = '';
                }
                else {
                    document.getElementById('FilterDiv').style.display = 'none';
                    if (selVal.endsWith('7')) {
                        chkSndMsgToMulCnt.disabled = true;
                        chkSndMsgToMulCnt.checked = false;
                        chkSndAsRaw.disabled = false;
                    }
                    else if (selVal.endsWith('3') || selVal.endsWith('5')) {
                        chkSndAsRaw.disabled = false;
                    }
                }
            });
        },
        retrieveCntListOnClickHandler: function (e) {
            $(e).click(function () {
                var selectedContact = $("#ContactList").val();
                if (selectedContact == '|7') {
                    $("#linkRetrieveContactImport").click();
                    return false;
                }
                $.broadcast.retrieveContactInfo();
                console.log("You clicked me!");
            });
        },
        retrieveImportCntListOnClickHandler: function (e) {
            $(e).click(function () {
                console.log("You clicked import me!");
                $.importContact.resetFields();
                $("#modalImport").modal('show');
            });
        },
        delete: function (f, total) {
            f.find(".k-grid-content").on("click", "a.remove", function (e) {
                var tr = $(e.target).closest("tr");
                var row = f.data("kendoGrid").dataItem(tr);
                if (row !== null && row != undefined) {
                    if (row.DocType == 3) { /* Attachment */
                        /*Remove from temp file*/
                        fxcRequest.post('/User/NewMessage/RemoveAttachment',
                            {
                                "DocUids": [row.DocUid]
                            },
                            function (data) {
                            }, null, false);
                    }

                    f.data("kendoGrid").dataSource.remove(row);
                    kendogridcustomization.refreshTotalCount(f, total);

                    $.broadcast.promptExpiringSession();
                }
            });
        },
        getExistingData: function (e) {
            var gridData = $(e).data("kendoGrid");
            var rows = gridData.dataSource.data();
            return JSON.stringify(rows);
        },
        resetBtnOnClickHandler: function (e) {
            $(e).click(function () {
                $.broadcast.resetFields();
            });
        },
        sendBtnOnClickHandler: function (e) {
            $(e).click(function () {
                $('#formSubmit').submit();
            });
        },
        resetFields: function () {
            $.broadcast.deleteAllAttachments();
            $.broadcast.initDocumentGrid();
            var dataSource = {
                data: null
            };
            $.broadcast.initRecipientGrid(dataSource);

            $("#formSubmit").trigger("reset");
            $("#formSubmit").validate().resetForm();

            $("#EnableBatchNotification").change();
            $("#ContactList").change();
        },

        /*Post or Get Back */
        addDocument: function (e) {
            var disabled = obj.disabled === "true";
            if (!disabled) {

                fxcRequest.post('/User/NewBroadcast/AddServerDoc',
                    {
                        "SelectedDocId": e,
                        "DocGridData": $.broadcast.getExistingData($("#gridDocument"))
                    },
                    function (data) {
                        $.broadcast.initDocumentGrid(data.DocList);

                        /*Auto close dropdown mneu after click*/
                        /*$("div.dropdown-menu").click(); */
                    },
                    function (error) {
                        /*console.log(error);*/
                    }, false);
            }
        },
        getTrackingInfo: function (e) {
            $("#trackingInfoForm").addClass("divLoading");
            fxcRequest.post('/User/NewBroadcast/GetTrackingInfo',
                {
                    "DelegationID": $('#DelegationID').val(),
                },
                function (data) {
                    console.log(data);
                    var tracking = data.Tracking;
                    var trackingInfoForm = tracking.TrackingInfoHtml;
                    $("#trackingInfoForm").html('');
                    $("#trackingInfoForm").append(trackingInfoForm);
                    $("#trackingInfoForm").removeClass("divLoading");
                },
                function (error) {
                    /* console.log(error);*/
                }, false);
        },
        openOneDriveDocClickHandler: function (clientid) {
            $('#btnOneDrive').on('click', function (e) {

                /* follow this */
                var odOptions = {
                    clientId: clientid,
                    action: "download",
                    multiSelect: true,
                    openInNewWindow: true,
                    advanced:
                    {
                        filter: validExtensions,
                        redirectUri: window.location.origin + "/OneDrivePickerRedirect.html"
                    },
                    success: function (files) {
                        var oneDriveFiles = [];
                        for (var i = 0; i < files.value.length; i++)
                            oneDriveFiles.push({ Name: files.value[i].name, Link: files.value[i]["@microsoft.graph.downloadUrl"] });

                        /*console.log(oneDriveFiles);*/
                        $.broadcast.attachCloudDoc(oneDriveFiles, "OneDrive");
                        /* success handler */
                    },
                    cancel: function () { /* cancel handler */ },
                    error: function (e) {
                        /*console.log(e);*/

                        /* error handler */
                    }
                };
                OneDrive.open(odOptions);
            });
        },
        attachDropBoxDoc: function (dropBoxFiles) {
            $.broadcast.attachCloudDoc(dropBoxFiles, "DropBox");
        },
        attachDoc: function (e) {
            if ($('#document_upload')[0].files.length !== 0) {
                fxcRequest.upload('/User/NewMessage/AddAttachment', $('#document_upload'),
                    {
                        "DocGridData": $.broadcast.getExistingData($("#gridDocument"))
                    },
                    function (data) {
                        swal.close();
                        $.broadcast.initDocumentGrid(data.DocList);
                        $('input[id="document_upload"]').val('');
                    }, null, false);
            }
        },
        attachCloudDoc: function (fileData, driveAccessType, token = "") {
            fxcRequest.post('/User/NewMessage/AddCloudAttachment',
                {
                    "DriveAccessType": driveAccessType,
                    "Attachments": fileData,
                    "DocGridData": $.broadcast.getExistingData($("#gridDocument")),
                    "Token": token
                },
                function (data) {
                    swal.close();
                    $.broadcast.initDocumentGrid(data.DocList);
                    $('input[id="document_upload"]').val('');
                });
        },
        retrieveContactInfo: function (e) {
            $("#ContactId").val($('#ContactList').val());
            var dataSource = {
                transport: {
                    read: {
                        url: '/User/NewBroadcast/GetContactInfo',
                        dataType: "json",
                        type: "POST"
                    },
                    parameterMap: function (options) {
                        /* Fix url param for sort values */
                        var result = {
                            Skip: options.skip,
                            Take: options.take,
                            Sort: options.sort,
                            SearchText: $('#Filter').val(),
                            ContactValue: $('#ContactList').val(),
                        };
                        if (options.sort && options.sort.length > 0) {
                            result.SortBy = options.sort[0].field;
                            result.Direction = options.sort[0].dir;
                        }
                        return result;
                    }
                },

            };

            $.broadcast.initRecipientGrid(dataSource);
        },
        send: function (e) {
            var docData = $.broadcast.getExistingData($("#gridDocument"));
            var recpData = $.broadcast.getExistingData($("#gridRecipient"));

            var formData = JSON.stringify($("#formSubmit").serializeArray());

            fxcRequest.post('/User/NewBroadcast/Send',
                {
                    "SenderName": $('#SenderName').val(),
                    "Subject": $('#Subject').val(),
                    "SenderCompany": $('#SenderCompany').val(),
                    "Priority": $('#PriorityList').val(),
                    "Note": $('#Note').val(),
                    "Schedule": $('#Schedule').val(),
                    "BillingCode": $('#BillingCode').val(),

                    "NotifyMessageSuccess": $('#NotifyMessageSuccess').prop('checked'),
                    "NotifyMessageFailure": $('#NotifyMessageFailure').prop('checked'),
                    "EnableBatchNotification": $('#EnableBatchNotification').prop('checked'),
                    "SendRawFax": $('#SendRawFax').prop('checked'),
                    "SendMultipleContact": $('#SendMultipleContact').prop('checked'),

                    "Filter": $('#Filter').val(),
                    "ContactValue": $('#ContactId').val(),

                    "FormData": formData,
                    "RecpGridData": recpData,
                    "DocGridData": docData,
                    "DelegatorID": $('#DelegationID').val(),
                    "DelgProID": $('#DelegationProf').val()
                }
                , function (data) {
                    $.broadcast.stopExpiringSessionTimer();

                    var msg = data.Result;
                    swal({
                        title: $globalMessages.swal.success.title,
                        text: msg,
                        type: "success",
                        showConfirmButton: true
                    }, function (e) {
                            window.setTimeout(function () {
                                var delegatorid = $('#DelegationID').val();
                                var delgproid = $('#DelegationProf').val();

                                var inboxUrl = "/user/msg/?id=1002&name=Outbox";

                                if (delegatorid != "" & delgproid != "") {
                                    var linkID = "#df" + delegatorid + delgproid + '1002';
                                    inboxUrl = $(linkID).attr("value");
                                }

                                fxcontent.load(inboxUrl);
                        }, 10);

                    });
                });
        },
        deleteAllAttachments: function () {
            var grid = $("#gridDocument").data("kendoGrid");

            if (grid !== null && typeof grid != 'undefined') {
                $.broadcast.stopExpiringSessionTimer();

                var gridData = grid.dataSource.data();
                var docUids = [];

                for (i = 0; i < gridData.length; i++) {
                    var currentDoc = gridData.at(i);
                    if (currentDoc.DocType == 3) { /* Attachment */
                        docUids.push(currentDoc.DocUid);
                    }
                }

                var data = new Blob([JSON.stringify({ "DocUids": docUids })], { type: 'application/json' });

                if (docUids.length > 0) {
                    navigator.sendBeacon('/User/NewMessage/RemoveAttachment', data);
                }
            }
        },
        stopExpiringSessionTimer: function () {
            clearTimeout(fileSessionExpired);
            countdownFileSession = false;
        },
        promptExpiringSession: function () {
            var hasAttachments = $("#gridDocument").data("kendoGrid").dataSource.data().some(
                function (dataItem) {
                    return dataItem.DocType == 3; /* Attachment */
                });

            /* If no more attachments and the timer is counting down, stop the timer */
            if (!hasAttachments && countdownFileSession) {
                $.broadcast.stopExpiringSessionTimer();
            }
            /* Start the timer if there is attachment and the timer is not started yet */
            else if (hasAttachments && !countdownFileSession) {
                countdownFileSession = true;
                fileSessionExpired = setTimeout(function () {
                    var timer = 30, // timer in seconds
                        isTimerStarted = false;

                    (function countDownFileSession() {
                        swal({
                            title: $broadcast.swal.sessionExpiring.title,
                            text: $broadcast.swal.sessionExpiring.desc,
                            type: "warning",
                            confirmButtonClass: "btn-danger",
                            confirmButtonText: $globalMessages.swal.continue + " (" + timer + ")",
                            closeOnConfirm: true,
                            timer: !isTimerStarted ? timer * 1000 : 0,
                            allowEscapeKey: false,
                            allowOutsideClick: false
                        }, function (isConfirm) {
                            if (isConfirm) {
                                fxcRequest.post('/User/NewMessage/ResetFileSession',
                                    {},
                                    function (data) {
                                    }, null, false);

                                countdownFileSession = false;
                                clearTimeout(timerCountdown);
                                $.broadcast.promptExpiringSession();
                            }
                        });

                        isTimerStarted = true;
                        if (timer) {
                            timer--;
                            timerCountdown = setTimeout(countDownFileSession, 1000);
                        }
                        else {
                            $.broadcast.deleteAllAttachments();

                            swal({
                                title: $broadcast.swal.sessionExpired.title,
                                text: $broadcast.swal.sessionExpired.desc,
                                type: "error",
                                confirmButtonClass: "btn-danger",
                                confirmButtonText: $broadcast.swal.sessionExpired.btnConfirm,
                                closeOnConfirm: true
                            }, function (isConfirm) {
                                if (isConfirm) {
                                    var inboxUrl = "/user/msg/?id=1001&name=Inbox";
                                    fxcontent.load(inboxUrl);
                                }
                            });
                        }
                    })();

                }, (fileSessionTimeout - 1) * 60 * 1000);
            }
        }
    };

    var validationImport = function () {
        jQuery.validator.addMethod("allowedDelimiter", function (value, element) {
            var reg = new RegExp('^[~!#%^*|]+$');
            return this.optional(element) || reg.test(value);
        }, $.validator.messages.delimiter);

        $('#formImport').validate({
            ignoreTitle: true,
            errorPlacement: function (error, element) {
                var p = element.parent(".dropify-wrapper");
                if (p.length) {
                    error.insertAfter(p);
                }
                else {
                    error.insertAfter(element);
                }
            },
            rules: {
                ImportFile: {
                    required: true,
                    noSpace: true
                },
                CustomDelimiterFormat: {
                    required: {
                        depends: function (element) {

                            var delimiterFormat = $('#DelimiterFormat').val();

                            if (delimiterFormat == 'CustomDelimiter') {
                                return true;
                            } else {
                                return false;
                            }
                        }
                    },
                    allowedDelimiter: true,
                    maxlength: 1
                }
            },
            messages: {
                CustomDelimiterFormat: {
                    allowedDelimiter: $broadcast.validation.delimiter
                }
            },
            submitHandler: function (form) {
                $.importContact.save();
            }
        });
    };

    $.importContact = {
        init: function () {
            validationImport();
            $.importContact.importOnClickHandler($("button[data-role='import-modal']"));
        },

        /*logic*/
        importOnClickHandler: function (e) {
            $(e).click(function () {
                if ($("#ContactList option[value='|7']").length > 0) {
                    $("#ContactList").val("|7").change();
                }
                $("#ContactId").val($('#ContactList').val());

                $('#formImport').submit();
            });
        },
        getFileProperty: function (input) {
            var name = document.getElementById(input);

            try {
                return {
                    'name': name.files.item(0).name,
                    'size': name.files.item(0).size,
                    'type': name.files.item(0).type,
                    'Path': $('#' + input).val(),
                    'FileByte': FileList.Byte
                };
            }
            catch (err) {
                return "";
            }
        },
        resetFields: function () {
            $("#formImport").trigger("reset");
            $("#formImport").validate().resetForm();
            /* Remove uploaded file */
            var drop = $('#ImportFile').dropify({ allowedFileExtensions: ['csv', 'txt', 'mdb', 'accdb'] });
            drop = drop.data('dropify');
            drop.resetPreview();
            drop.clearElement();
        },
        /*Post or Get Back*/
        save: function () {
            fxcRequest.upload('/User/NewBroadcast/ImportContact', $('#ImportFile'),
                {
                    ContactValue: $('#ContactList').val(),
                    DelimeterFormat: $('#DelimiterFormat').val(),
                    CustomDelimiterFormat: $('#CustomDelimiterFormat').val()
                },
                function (data) {
                    swal.close();
                    var dataSource = {
                        data: data
                    };
                    $("#modalImport").modal('hide');
                    $.broadcast.initRecipientGrid(dataSource);
                });
        }
    };

})(window.jQuery);

var dropbox = {
    init: function () {
        var options = options = {

            /* Required. Called when a user selects an item in the Chooser. */
            success: function (files) {
                var getFileLink = [];

                for (var i = 0; i < files.length; i++) {
                    getFileLink.push({ Name: files[i].name, Link: files[i].link });
					/* Unique ID for the file, compatible with Dropbox API v2.
					console.log("[" + i + "]link: " + files[i].id);*/
					/* Name of the file. 
					console.log("name: " + files[i].name);*/
					/* URL to access the file, which varies depending on the linkType specified when the Chooser was triggered. 
				  console.log("link: " + files[i].link);* /
					/* Size of the file in bytes. 
					console.log("size: " + files[i].bytes + "bytes");*/
					/* URL to a 64x64px icon for the file based on the file's extension. 
					console.log("icon: " + files[i].icon);*/
                }

                $.broadcast.attachDropBoxDoc(getFileLink);
            },

            /*Optional. Called when the user closes the dialog without selecting a file and does not include any parameters. */
            cancel: function () {

            },

			/* Optional. "preview" (default) is a preview link to the document for sharing,
			 "direct" is an expiring link to download the contents of the file. For more
			 information about link types, see Link types below. */
            linkType: "preview", /*or "direct" */

			/* Optional. A value of false (default) limits selection to a single file, while
			 true enables multiple file selection. */
            multiselect: true,

			/* Optional. This is a list of file extensions. If specified, the user will
			 only be able to select files with these extensions. You may also specify
			 file types, such as "video" or "images" in the list. For more information,
			 see File types below. By default, all extensions are allowed. */
            extensions: validExtensions,

			/*Optional. A value of false (default) limits selection to files,
			  while true allows the user to select both folders and files.
			  You cannot specify `linkType: "direct"` when using `folderselect: true`. */
            folderselect: false
        };
        var button = Dropbox.createChooseButton(options);
        document.getElementById("btnDropbox").appendChild(button);
    }
};

var dropzone = {
    init: function () {
        dropzone.makeDroppable(window.document.querySelector('.demo-droppable'), function (files) {
            $.broadcast.attachDoc();
        });
    },
    makeDroppable: function (ele, callback) {
        var input = window.document.querySelector('#document_upload');
        input.addEventListener('change', function (e) {
            dropzone.triggerCallback(e, callback);
        });
        ele.appendChild(input);

        ele.addEventListener('dragover', function (e) {
            e.preventDefault();
            e.stopPropagation();
            ele.classList.add('dragover');
        });

        ele.addEventListener('dragleave', function (e) {
            e.preventDefault();
            e.stopPropagation();
            ele.classList.remove('dragover');
        });

        ele.addEventListener('drop', function (e) {
            e.preventDefault();
            e.stopPropagation();
            ele.classList.remove('dragover');

            var files;
            if (e.dataTransfer) {
                files = e.dataTransfer.files;
            } else if (e.target) {
                files = e.target.files;
            }
            $('#document_upload')[0].files = files;

            $.broadcast.attachDoc();
        });

        var btnBrowse = window.document.querySelector('#btnBrowse');

        btnBrowse.addEventListener('click', function (e) {
            this.blur();
            input.value = null;
            input.click();
        });
    },
    triggerCallback: function (e, callback) {

        if (!callback || typeof callback !== 'function') {
            return;
        }
        var files;
        if (e.dataTransfer) {
            files = e.dataTransfer.files;
        } else if (e.target) {
            files = e.target.files;
        }

        callback.call(null, files);

        window.makeDroppable = dropzone.makeDroppable;
    },
};
