﻿(function ($) {
	var setIsRtl = $("html[dir]").attr("dir") === "rtl" ? true : false;
	var tour = {
		id: "user-newbroadcast-hopscotch",
		steps: [
			{
				target: "SenderName",
				title: "",
				content: $globalMessages.uiGuide.fieldRequired,
				placement: "bottom",
				yOffset: "-3",
				isRtl: setIsRtl
			},
			{
				target: "PriorityList",
				title: "",
				content: $broadcast.uiGuide.priority,
				placement: "bottom",
				yOffset: "-3",
				isRtl: setIsRtl
			},
			{
				target: "Schedule",
				title: "",
				content: $broadcast.uiGuide.schedule,
				placement: "bottom",
				yOffset: "-3",
				isRtl: setIsRtl
			},
			{
				target: "btnBrowse",
				title: "",
				content: $broadcast.uiGuide.btnBrowse,
				placement: "bottom",
				xOffset: "-20",
				width: 80,
				zindex: 1100,
				isRtl: setIsRtl
			},
			{
				target: "docTreeBtn",
				title: "",
				content: $broadcast.uiGuide.docTreeBtn,
				placement: "bottom",
				width: 80,
				xoffset: "-30",
				zindex: 1100,
				isRtl: setIsRtl
			},
			{
				target: "btnOnline",
				title: "",
				content: $broadcast.uiGuide.btnOnline,
				placement: "left",
				width: 80,
				yOffset: "-15",
				zindex: 1100,
				isRtl: setIsRtl
			},
			{
				target: "linkRetrieveContact",
				title: "",
				content: $broadcast.uiGuide.linkRetrieveContact,
				placement: "bottom",
				xOffset: "-20",
				width: 80,
				zindex: 1100,
				isRtl: setIsRtl
			},
			{
				target: "linkRetrieveContactImport",
				title: "",
				content: $broadcast.uiGuide.linkRetrieveContactImport,
				placement: "bottom",
				xOffset: "-20",
				width: 80,
				zindex: 1100,
				isRtl: setIsRtl
			},
		],
		showPrevButton: true,
		onPrev: function () {
			if (hopscotch.isActive)
				$.sharedUiGuide.scrollToFixedPlacementTarget(hopscotch.getCurrTour(), hopscotch.getCurrStepNum(), hopscotch.getCurrTarget());
		},
		onNext: function () {
			if (hopscotch.isActive)
				$.sharedUiGuide.scrollToFixedPlacementTarget(hopscotch.getCurrTour(), hopscotch.getCurrStepNum(), hopscotch.getCurrTarget());
		}
	};
	$.newBroadcastUiGuide = {
		init: function (tourBtn) {
			$.sharedUiGuide.init({ startTourBtn: tourBtn, tour: tour });
		}
	};
})(window.jQuery);