﻿(function ($) {    
    var $annotationWindow = null;
    /* Helper method to parse the title tag from the response.*/
    function getTitle(text) {
        return text.match('<title>(.*)?</title>')[1];
    }

    function toJSDate(datetime) {

        var dateTimes = datetime.split(" ");/*dateTime[0] = date, dateTime[1] = time*/

        var date = dateTimes[0].split("-");
        var time = dateTimes[1].split(":");
        var daylight = dateTimes[2];

        var jsYear = date[0];
        var jsMonth = date[1] - 1;
        var jsDay = date[2];
        var jsHours = daylight === 'A' ? time[0] : Number(time[0]) + 12;
        var jsSeconds = time[1];

        /*(year, month, day, hours, minutes, seconds, milliseconds)
        subtract 1 from month because Jan is 0 and Dec is 11*/
        var jsDate = new Date(jsYear, jsMonth, jsDay, jsHours, jsSeconds, 0, 0);
        return jsDate;

    }

    /*Check to see if the DateTime is in the future
    param: dateTime must be a JS Date Object
    return True if DateTime is after Now
    return False if DateTIme is before Now*/
    function futureDateTime(dateTime) {
        var now = new Date();
        var future = false;
        if (Date.parse(dateTime) < Date.parse(now)) {
            future = true;
        }

        return future;
    }

    var $gridDoc, currentDocIds = [];
    var gridDocID = "#gridDocument";
    var totalDoc = "#document_GridDocumentTotal";
    var docpGridData;
    var $clientId = '';
    var countdownFileSession = false;
    var timerCountdown = false;
    var fileSessionExpired;

    var getWindowFeatures = function () {
        var w = 1500, h = 840;
        var dualScreenLeft = window.screenLeft ? window.screenLeft : window.screenX;
        var dualScreenTop = window.screenTop ? window.screenTop : window.screenY;
        var width = window.innerWidth ? window.innerWidth : document.documentElement.clientWidth ? document.documentElement.clientWidth : screen.width;
        var height = window.innerHeight ? window.innerHeight : document.documentElement.clientHeight ? document.documentElement.clientHeight : screen.height;
        var left = ((width / 2) - (w / 2)) + dualScreenLeft;
        var top = ((height / 2) - (h / 2)) + dualScreenTop;
        var features = 'width=' + w + ',height=' + h + ',resizable=' + true + ',scrollbars=no,' +
            'toolbar=no,location=no,directories=no,status=no,menubar=no,copyhistory=no' +
            ', top=' + top + ', left=' + left;

        return features;
    };

    /* Validation */
    $.newmessage_document = {
        /* initialization */
        init: function (e) {
            var data = { "DocList": [] };
            if (e.DocList !== null) {
                data = { "DocList": e.DocList };
			}
            $.newmessage_document.initgridDoc($(gridDocID), data);

            $('#onApiLoad').on('click', function () {
                $(this).blur();
                onApiLoad();
            });

			dropzone.init();
            $.newmessage_document.initTreeView();

            $(window).on('unload', function () {
                /* Check if the page is in New Message or Resend/Forward Message window */
                if ($("#sidebarnav li a#newgetmessage").hasClass("active") || $('#Rf').val().length !== 0) {                    
                    $.newmessage_document.deleteAllAttachments();
                }  
            });

            /* Call deleteAllAttachments when user navigates away from current page */
            $('nav.sidebar-nav ul li a[href!="#"][data-href]').on('click.removeattachment', function (e) {
                $.newmessage_document.deleteAllAttachments();  

                /* Unbind the click function after called */
                $('nav.sidebar-nav ul li a[href!="#"][data-href]').off('click.removeattachment');
            });
		},
		initTreeView: function ()
		{
			var objDoc = {};
			objDoc.postSelectFn = $.newmessage_document.addServerDoc;
            objDoc.dataSource = "/User/UserCommon/DocFolderTree?delegatorID=" + $('input#DelegatorID').val();
			objDoc.expandNodeValue = [1];
			objDoc.declareType = "button"; /*Required Declare for DropDownList type*/

			treeview.init("docTree", "docTreeName", "docTreeID", objDoc);
		},
        initgridDoc: function (e, data) {
            var result = data.DocList;
            var id = e;

            var dataSource = {
                data: result,

                sort: { field: "Sequence", dir: "asc" },
                schema: {
                    model: {
                        id: "DocumentID"
                    }
                }
            };
            var columns = [];
            columns = [
                { field: "id", title: $globalMessages.grid.id, hidden: true },
                { field: "DocUid", hidden: true },
                { field: "EncryptedFilePath", hidden: true },
                { field: "IsAnnotated", hidden: true },
                { field: "Sequence", hidden: true },
                {
                    field: "FileName",
                    title: $globalMessages.grid.fileName,
                    width: 100,
                    template: function (dataRow) {
                        console.log(dataRow.DeselectedPages.length);
                        var invalidList = ["xltx", "pps", "ppsx", "potx", "pcl", "ps"];
                        var file = (dataRow.FileName).toLowerCase();
                        /*Get file extension*/
                        var ext = file.substr((file.lastIndexOf('.') + 1));
                        var signBtn = "";
                        if (dataRow.DocType != 2 && dataRow.DocType != "2" && ($.inArray(ext, invalidList)) == -1) {
                            signBtn = '<button type="button" class="btn btn-sm btn-outline-success signDocBtn m-l-15" title="' + $newMessage.annotateTooltip + '">' + $newMessage.annotate + '</button>';
                        }
                        var result = '<span class="documentIcon-' + dataRow.DriveAccessType + '">' + dataRow.FileName + '</span>';
                        return result + signBtn;
                    }
                },
                {
                    field: "Status",
                    title: "&nbsp;",
                    width: 50,
                    sortable: false,
                    headerAttributes: {
                        "aria-label": "Status",
                    },
                    template: function (dataRow) {
						var removeBtn = '<div class="text-right"><a class="imageSizeTopBarIcons nav-link color-red waves-effect remove" href="javascript:void(0)" title="' + $globalMessages.grid.delTooltip+'"><i class="fa fa-trash-o"></i></a></div>';
                        return removeBtn;
                    }
                }
            ];

            var obj = {};
            obj.totalInputType = totalDoc;
            obj.rowSortable = true;
            obj.onDataBoundExtraFn = $.newmessage_document.signDocumentBtnHandler;
            $gridDoc = kendogridcustomization.init(id, dataSource, columns, obj);
            
            $.newmessage_document.promptExpiringSession();
            $.newmessage_document.delete();
        },
        signDocumentBtnHandler: function () {
            $('#gridDocument table tbody tr td button.signDocBtn').click(function (e) {
                var tr = $(e.target).closest("tr");
                var row = $('#gridDocument').data('kendoGrid').dataItem(tr);
                var deselectedPage = row.DeselectedPages || [];
                var url = '/annotation/index/' + row.FileName + '/' + row.DocUid + '/' + row.id + '/' + row.DocType;
                if ($("#SourceMsgID").val().length > 0 && deselectedPage.length > 0 ) {
                    url = '/annotation/index/' + row.FileName + '/' + row.DocUid + '/' + row.id + '/' + row.DocType + '/' + $("#SourceMsgID").val() + '/' + JSON.stringify(deselectedPage);
                }
                else if ($("#SourceMsgID").val().length > 0) {
                    url = '/annotation/index/' + row.FileName + '/' + row.DocUid + '/' + row.id + '/' + row.DocType + '/' + $("#SourceMsgID").val();
                }

                $annotationWindow = window.open(url, 'new-message', getWindowFeatures());
                $annotationWindow.focus();

            });
        },
        annotationWindowCallback: function () {
            $.newmessage_document.getExistingDocData();
            fxcRequest.post('/Annotation/UpdateNewDocListBinary',
                {
                    "DocGridData": docpGridData
                },
                function (data) {
                    console.log(data);
                    var docList = { "DocList": data.DocList };
                    $.newmessage_document.initgridDoc($(gridDocID), docList);

                }, null, false);
        },


        /* Reset Field */

        /* Button Action */
        delete: function (e) {
            $("#gridDocument .k-grid-content").on("click", "a.remove", function (e) {
                var tr = $(e.target).closest("tr");
                var row = $("#gridDocument").data("kendoGrid").dataItem(tr);
                
                if (row !== null && row != undefined) {
                    if ($annotationWindow !== null && typeof $annotationWindow !== 'undefined' && !$annotationWindow.closed) {
                        if ($annotationWindow.location.pathname.includes(row.DocUid)) {
                            swal($newMessage.swal.docAnnotating.title, $newMessage.swal.docAnnotating.desc, 'error');
                            return false;
                        }
                    }

                    if (row.DocType == 3) { /* Attachment */
                        /*Remove from temp file*/
                        fxcRequest.post('/User/NewMessage/RemoveAttachment',
                            {
                                "DocUids": [row.DocUid]
                            },
                            function (data) {
                            }, null, false);
                    }

                    $('#gridDocument').data("kendoGrid").dataSource.remove(row);
                    kendogridcustomization.refreshTotalCount($gridDoc, totalDoc);

                    $.newmessage_document.promptExpiringSession();
                }
            });
        },

        /*Post or Get Back */
        addServerDoc: function (e, obj) {
            
            var disabled = obj.disabled === "true";
            if (!disabled) {
                $.newmessage_document.getExistingDocData();
                fxcRequest.post('/User/NewMessage/AddServerDoc',
                    {
                        "SelectedDocId": e,
                        "DocGridData": docpGridData
                    },
                    function (data) {
                        $.newmessage_document.initgridDoc($(gridDocID), data);
                        console.log(data);
                        $('#docTree').tree().unselectAll();
                    },
                    function (error) {
                        /*console.log(error);*/
                    }, false);
            }

        },
        removeRow: function (e) {
            var grid = $('#gridDocument').data("kendoGrid");
			var tr = $(e.target).closest("tr");

			grid.removeRow(tr);
        },
        getAllRow: function (e) {
            currentDocIds = [];
            var grid = $("#gridDocument").data("kendoGrid");

            if (grid !== null) {
                var allrow = grid.dataSource.data();

                if (allrow !== null) {
                    $.each(allrow, function (index, value) {
                        currentDocIds[index] = value.id;
                    });
                }
            }
            return currentDocIds;
        },
        getExistingDocData: function (e) {
            var docpgrid = $(gridDocID).data("kendoGrid");
            var rows = docpgrid.dataSource.data();
            docpGridData = JSON.stringify(rows);
            return docpGridData;
        },
        attachDoc: function (e) {
            $.newmessage_document.getExistingDocData();

            if ($('#document_upload')[0].files.length !== 0) {
				fxcRequest.upload('/User/NewMessage/AddAttachment', $('#document_upload'),
                    {
                        "DocGridData": docpGridData
                    },
                    function (data) {
                        swal.close();
                        $.newmessage_document.initgridDoc($(gridDocID), data);
                        $('input[id="document_upload"]').val('');
                    });
            }
        },
        attachCloudDoc: function (fileData, driveAccessType, token = "") {
            $.newmessage_document.getExistingDocData();

            fxcRequest.post('/User/NewMessage/AddCloudAttachment',
                {
                    "DriveAccessType": driveAccessType,
                    "Attachments": fileData,
                    "DocGridData": docpGridData,
                    "Token": token
                },
                function (data) {
                    swal.close();
                    $.newmessage_document.initgridDoc($(gridDocID), data);
                    $('input[id="document_upload"]').val('');
                });
        },
        attachDropBoxDoc: function (dropBoxFiles) {
            $.newmessage_document.attachCloudDoc(dropBoxFiles, "DropBox");
        },
        openOneDriveDocClickHandler: function (clientid) {
            $('#onOneDriveLoad').on('click', function (e) {

                /* follow this */
                var odOptions = {
                    clientId: clientid,
                    action: "download",
                    multiSelect: true,
                    openInNewWindow: true,
                    advanced:
                        {
                            filter: validExtensions,
                            redirectUri: window.location.origin + "/OneDrivePickerRedirect.html"
                        },
                    success: function (files) {
                        var oneDriveFiles = [];
                        for (var i = 0; i < files.value.length; i++) 
                            oneDriveFiles.push({ Name: files.value[i].name, Link: files.value[i]["@microsoft.graph.downloadUrl"] });

                        /*console.log(oneDriveFiles);*/
                        $.newmessage_document.attachCloudDoc(oneDriveFiles, "OneDrive");                       
                        /* success handler */
                    },
                    cancel: function () { /* cancel handler */ },
                    error: function (e) {
                        /*console.log(e);*/

                        /* error handler */
                    }
                };
                OneDrive.open(odOptions);
            });
        },
        deleteAllAttachments: function () {
            var grid = $("#gridDocument").data("kendoGrid");

            if (grid !== null && typeof grid != 'undefined') {
                $.newmessage_document.stopExpiringSessionTimer();

                /* Close annotation window if it is opened */
                if ($annotationWindow !== null && typeof $annotationWindow !== 'undefined') {
                    $annotationWindow.close();
                }

                var gridData = grid.dataSource.data();
                var docUids = [];

                for (i = 0; i < gridData.length; i++) {
                    var currentDoc = gridData.at(i);
                    if (currentDoc.DocType == 3) { /* Attachment */
                        docUids.push(currentDoc.DocUid);
                    }
                }

                var data = new Blob([JSON.stringify({ "DocUids": docUids })], { type: 'application/json' });

                if (docUids.length > 0) {
                    navigator.sendBeacon('/User/NewMessage/RemoveAttachment', data);
                }
            }
            
        },
        stopExpiringSessionTimer: function () {
            clearTimeout(fileSessionExpired);
            countdownFileSession = false;
        },
        promptExpiringSession: function () {   
            var hasAttachments = $("#gridDocument").data("kendoGrid").dataSource.data().some(
                function (dataItem) {
                    return dataItem.DocType == 3; /* Attachment */
                });

            /* If no more attachments and the timer is counting down, stop the timer */
            if (!hasAttachments && countdownFileSession) {
                $.newmessage_document.stopExpiringSessionTimer();
            }
            /* Start the timer if there is attachment and the timer is not started yet */
            else if (hasAttachments && !countdownFileSession) {
                countdownFileSession = true;
                fileSessionExpired = setTimeout(function () {
                    var isResendForward = $('#Rf').val().length !== 0;
                    var sessionExpiringDesc = isResendForward ? $newMessage.swal.sessionExpiring.resendForwardDesc : $newMessage.swal.sessionExpiring.desc;
                    var timer = 30, // timer in seconds
                        isTimerStarted = false;

                    (function countDownFileSession() {
                        swal({
                            title: $newMessage.swal.sessionExpiring.title,
                            text: sessionExpiringDesc,
                            type: "warning",
                            confirmButtonClass: "btn-danger",
                            confirmButtonText: $globalMessages.swal.continue + " (" + timer + ")",
                            closeOnConfirm: true,
                            timer: !isTimerStarted ? timer * 1000 : 0,
                            allowEscapeKey: false,
                            allowOutsideClick: false
                        }, function (isConfirm) {
                            if (isConfirm) {
                                fxcRequest.post('/User/NewMessage/ResetFileSession',
                                    {},
                                    function (data) {
                                    }, null, false);

                                countdownFileSession = false;
                                clearTimeout(timerCountdown);
                                $.newmessage_document.promptExpiringSession();
                            }
                        });

                        isTimerStarted = true;
                        if (timer) {
                            timer--;
                            timerCountdown = setTimeout(countDownFileSession, 1000);
                        }
                        else {
                            $.newmessage_document.deleteAllAttachments();

                            swal({
                                title: $newMessage.swal.sessionExpired.title,
                                text: $newMessage.swal.sessionExpired.desc,
                                type: "error",
                                confirmButtonClass: "btn-danger",
                                confirmButtonText: $newMessage.swal.sessionExpired.btnConfirm,
                                closeOnConfirm: true
                            }, function (isConfirm) {
                                if (isConfirm) {
                                    if (isResendForward) {
                                        /* Close New Message popup window opened from Message Viewer */
                                        window.close();
                                    }
                                    else {
                                        var inboxUrl = "/user/msg/?id=1001&name=Inbox";
                                        fxcontent.load(inboxUrl);
                                    }
                                }
                            });
                        }
                    })();

                }, (fileSessionTimeout - 1) * 60 * 1000);
            }
        }
    };
})(window.jQuery);

var dropbox = {
    init: function () {
        var options = options = {

            /* Required. Called when a user selects an item in the Chooser. */
            success: function (files) {
                var getFileLink = [];

                for (var i = 0; i < files.length; i++) {
                    getFileLink.push({ Name: files[i].name, Link: files[i].link });
                    /* Unique ID for the file, compatible with Dropbox API v2.
                    console.log("[" + i + "]link: " + files[i].id);*/
                    /* Name of the file. 
                    console.log("name: " + files[i].name);*/
                    /* URL to access the file, which varies depending on the linkType specified when the Chooser was triggered. 
                  console.log("link: " + files[i].link);* /
                    /* Size of the file in bytes. 
                    console.log("size: " + files[i].bytes + "bytes");*/
                    /* URL to a 64x64px icon for the file based on the file's extension. 
                    console.log("icon: " + files[i].icon);*/
                }

                $.newmessage_document.attachDropBoxDoc(getFileLink);
            },

            /*Optional. Called when the user closes the dialog without selecting a file and does not include any parameters. */
            cancel: function () {

            },

            /* Optional. "preview" (default) is a preview link to the document for sharing,
             "direct" is an expiring link to download the contents of the file. For more
             information about link types, see Link types below. */
            linkType: "direct", /*"preview" or "direct" */

            /* Optional. A value of false (default) limits selection to a single file, while
             true enables multiple file selection. */
            multiselect: true,

            /* Optional. This is a list of file extensions. If specified, the user will
             only be able to select files with these extensions. You may also specify
             file types, such as "video" or "images" in the list. For more information,
             see File types below. By default, all extensions are allowed. */

            extensions: validExtensions,

            /*Optional. A value of false (default) limits selection to files,
              while true allows the user to select both folders and files.
              You cannot specify `linkType: "direct"` when using `folderselect: true`. */
            folderselect: false
        };
        var button = Dropbox.createChooseButton(options);
        document.getElementById("dropBoxLink").appendChild(button);
    }
};

var dropzone = {
    init: function () {
        dropzone.makeDroppable(window.document.querySelector('.demo-droppable'), function (files) {
            $.newmessage_document.attachDoc();
        });
    },
    makeDroppable: function (ele, callback) {
        var input = window.document.querySelector('#document_upload');
        input.addEventListener('change', function (e) {
            dropzone.triggerCallback(e, callback);
        });
        ele.appendChild(input);

        ele.addEventListener('dragover', function (e) {
            e.preventDefault();
            e.stopPropagation();
            ele.classList.add('dragover');
        });

        ele.addEventListener('dragleave', function (e) {
            e.preventDefault();
            e.stopPropagation();
            ele.classList.remove('dragover');
        });

        ele.addEventListener('drop', function (e) {
            e.preventDefault();
            e.stopPropagation();
            ele.classList.remove('dragover');

            var files;
            if (e.dataTransfer) {
                files = e.dataTransfer.files;
            } else if (e.target) {
                files = e.target.files;
            }
            $('#document_upload')[0].files = files;

            $.newmessage_document.attachDoc();
        });

        var btnBrowse = window.document.querySelector('#btnBrowse');

        btnBrowse.addEventListener('click', function (e) {
            this.blur();
            input.value = null;
            input.click();
        });
    },
    triggerCallback: function (e, callback) {
        if (!callback || typeof callback !== 'function') {
            return;
        }

        var files;
        if (e.dataTransfer) {
            files = e.dataTransfer.files;
        } else if (e.target) {
            files = e.target.files;
        }

        callback.call(null, files);

        window.makeDroppable = dropzone.makeDroppable;
    }
};