﻿(function ($) {

    var $gridId = $("#delegation");
    var $grid = $("#delegation").data("kendoGrid");

    var firstLoadGrid = false;
    var firstLoadDelegatee = true;
    var showLoaderBar = false;
    var selectedProfileID;

    var validation = function () {
        $("#formDelegationProfile").validate({
			ignoreTitle: true,
            rules: {
                "DelgProfile.Name": {
                    required: true,
					noSpace: true
                }
            },
            submitHandler: function (form) {
                $.delegationSetting.save();
            }
        });
    };

    $.delegationSetting = {
        init: function () {
            validation();
            $.delegationSetting.createButtonClickHandler($(".btn-new-delegation"));
            $.delegationSetting.deleteButtonClickHandler($(".btn-delete-delegation"));
            $.delegationSetting.refreshButtonClickHandler($(".btn-refresh-delegation"));
            $.delegationSetting.backButtonClickHandler($(".btn-back-delegation"));
            $.delegationSetting.searchPressEnter($('input[data-role="search-delegation-item"]'));
            $.delegationSetting.searchButtonClickHandler($('.btn-search-delegation'));
            $.delegationSetting.initAccordion($("#accordion"));
            $.delegationSetting.resetButtonClickHandler($('#btn-reset-delegation'));
            $.delegationSetting.saveButtonClickHandler($("#btn-save-delegation"));
            $.delegationSetting.saveCloseButtonClickHandler($("#btn-save-close-delegation"));
            $.delegationSetting.initGrid();
        },
        createButtonClickHandler: function (e) {
            $(e).on('click', function (x) {
                selectedProfileID = "";
                $.sectionproperties.Hidden("DelegationTable", true);
                $.sectionproperties.Hidden("DelegationForm", false);
                $.delegationSetting.resetFields();
                disabledClick = true;
                $("#collapseOne").collapse('show');
            });
        },
        deleteButtonClickHandler: function (e) {
            $(e).on('click', function (x) {
                $(this).blur();
                $.delegationSetting.delete();
            });
        },
        refreshButtonClickHandler: function (e) {
            $(e).on('click', function (x) {
                $.delegationSetting.refresh(e);
                $(this).blur();
            });
        },
        backButtonClickHandler: function (e) {
            $(e).on('click', function (x) {
                $.sectionproperties.Hidden("DelegationTable", false);
                $.sectionproperties.Hidden("DelegationForm", true);
                $.delegationSetting.refresh(e);
            });
        },
        searchButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.delegationSetting.search(e);
            });
        },
        searchPressEnter: function (e) {
            $(e).on('keypress', function (enter) {
                if (enter.which === 13) {
                    $.delegationSetting.search(e);
                }
            });
        },
        initAccordion: function (e) {
            $(e).on('hide.bs.collapse', function (e) {

            });
        },
        resetButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.delegationSetting.resetFields(selectedProfileID);
            });
        },
        saveButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $('input[name="formDelegation-action"]').val('');
                showLoaderBar = false;
                $("#formDelegationProfile").submit();
            });
        },
        saveCloseButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $('input[name="formDelegation-action"]').val('save & close');
                showLoaderBar = false;
                $("#formDelegationProfile").submit();
            });
        },
        refresh: function (e) {
            $.delegationSetting.initGrid();
        },
        editHandler: function (dataItem) {
            $.sectionproperties.Hidden("DelegationTable", true);
            $.sectionproperties.Hidden("DelegationForm", false);

            selectedProfileID = dataItem == null ? "" : dataItem.ProfileID;
            $.delegationSetting.resetFields(selectedProfileID);
        },
        resetFields: function (data) {
            data = data || null;
            $("#formDelegationProfile").trigger("reset");
            $("#formDelegationProfile").validate().resetForm();

            $("#formDelegation-profileID").val("");
            $.sectionproperties.Visible("EditGrid", false);
            $.sectionproperties.Hidden("EditGrid", true);
            $.delegationSetting.getDelegationProfile(data);

            if (data !== null) {
                $("#formDelegation-profileID").val(data);

                $.sectionproperties.Visible("EditGrid", true);
                $.sectionproperties.Hidden("EditGrid", false);

                disabledClick = false;
                if (firstLoadDelegatee) {
                    $.delegatee.init();
                    firstLoadDelegatee = false;
                }

                $.delegatee.initGrid();
                $("#collapseTwo").collapse('show');
            }
        },
        search: function (e) {
            $.delegationSetting.initGrid();
        },
        getDelegationProfile: function (profileID) {
            fxcRequest.get('/User/DelegationSetting/GetDelegationProfile'
                , { "ProfileID": profileID }
                , function (data) {
                    $('#formDelegationProfile').BindJson(data, '#', '');
                    if (data.Name != null) {
                        $(".infoDelegationProfile").text(data.Name.Value);
                    }
                });
        },
        initGrid: function (e) {
            var id = $gridId;

            var dataSource = {
                transport: {
                    read: {
                        url: '/User/DelegationSetting/Read',
                        dataType: "json",
                        type: "GET"
                    },
                    parameterMap: function (options) {

                        var result = {
                            Filter: $('input[data-role="search-delegation-item"]').val(),
                            Skip: options.skip,
                            Take: options.take,
                            Page: options.page
                        };

                        if (options.sort && options.sort.length > 0) {
                            result.SortBy = options.sort[0].field;
                            result.Direction = options.sort[0].dir;
                        }

                        return result;
                    }
                },
                schema: {
                    data: "DelegationSettings",
                    total: "Total",
                    model: {
                        id: "ProfileID"
                    }
                },
                serverPaging: true,
                serverSorting: true
            };

            var col = [
                {
                    selectable: true, width: "45px",
                    attributes: {
                        "class": "checkboxSelection"
                    }
                },
                { field: 'ProfileID', hidden: true },
                { field: 'Name', title: $delegateResources.grid.name, width: 300, sortable: true },
                { field: 'DelegateeCount', title: $delegateResources.grid.count, width: 100, sortable: true },
                {
                    field: "MoveToTrash",
                    title: $delegateResources.grid.moveToTrash,
                    width: 120,
                    filterable: {
                        cell: {
                            enabled: false
                        }
                    },
                    template: '<div class="kendo-container"> <i #= MoveToTrash == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
                },
                {
                    field: "ForwardToUser",
                    title: $delegateResources.grid.forwardToUser,
                    width: 120,
                    filterable: {
                        cell: {
                            enabled: false
                        }
                    },
                    template: '<div class="kendo-container"> <i #= ForwardToUser == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
                },
                {
                    field: "ForwardToFax",
                    title: $delegateResources.grid.forwardToFax,
                    width: 120,
                    filterable: {
                        cell: {
                            enabled: false
                        }
                    },
                    template: '<div class="kendo-container"> <i #= ForwardToFax == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
                },
                {
                    field: "Print",
                    title: $delegateResources.grid.print,
                    width: 120,
                    filterable: {
                        cell: {
                            enabled: false
                        }
                    },
                    template: '<div class="kendo-container"> <i #= Print == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
                },
                {
                    field: "Send",
                    title: $delegateResources.grid.send,
                    width: 120,
                    filterable: {
                        cell: {
                            enabled: false
                        }
                    },
                    template: '<div class="kendo-container"> <i #= Send == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
                },
                {
                    field: "ResendMsg",
                    title: $delegateResources.grid.resend,
                    width: 120,
                    filterable: {
                        cell: {
                            enabled: false
                        }
                    },
                    template: '<div class="kendo-container"> <i #= ResendMsg == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
                },
                {
                    field: "RetryFailed",
                    title: $delegateResources.grid.retryFailed,
                    width: 120,
                    filterable: {
                        cell: {
                            enabled: false
                        }
                    },
                    template: '<div class="kendo-container"> <i #= RetryFailed == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
                },
                {
                    field: "Assign",
                    title: $delegateResources.grid.assign,
                    width: 120,
                    filterable: {
                        cell: {
                            enabled: false
                        }
                    },
                    template: '<div class="kendo-container"> <i #= Assign == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
                },
                {
                    field: "Delete",
                    title: $delegateResources.grid.delete,
                    width: 120,
                    filterable: {
                        cell: {
                            enabled: false
                        }
                    },
                    template: '<div class="kendo-container"> <i #= Delete == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
                },
                {
                    field: "Approval",
                    title: $delegateResources.grid.approval,
                    width: 120,
                    filterable: {
                        cell: {
                            enabled: false
                        }
                    },
                    template: '<div class="kendo-container"> <i #= Approval == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
                },
                {
                    field: "Tracking",
                    title: $delegateResources.grid.tracking,
                    width: 120,
                    filterable: {
                        cell: {
                            enabled: false
                        }
                    },
                    template: '<div class="kendo-container"> <i #= Tracking == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
                },
                {
                    field: "PersonalFolder",
                    title: $delegateResources.grid.personalFolder,
                    width: 120,
                    filterable: {
                        cell: {
                            enabled: false
                        }
                    },
                    template: '<div class="kendo-container"> <i #= PersonalFolder == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
                }
            ];

            var obj = {};
            obj.allowSelectMultipleRow = true;
            obj.customizeCheckbox = true;
            obj.onSelectionFn = $.delegationSetting.editHandler;

            kendogridcustomization.init(id, dataSource, col, obj);
        },
        save: function (e) {
            /*Not Done*/
            fxcRequest.post('/User/DelegationSetting/SaveDelegationProfile',
                {
                    "ProfileID": $("#formDelegation-profileID").val(),
                    DelgProfile: {
                        "Name": $("#Name").val(),
                        "Desc": $("#Desc").val(),
                        "AllowMoveToTrash": $('#AllowMoveToTrash').bootstrapSwitch('state'),
                        "AllowForwardToUser": $('#AllowForwardToUser').bootstrapSwitch('state'),
                        "AllowForwardToFax": $('#AllowForwardToFax').bootstrapSwitch('state'),
                        "AllowPrint": $('#AllowPrint').bootstrapSwitch('state'),
                        "AllowDownload": $('#AllowDownload').bootstrapSwitch('state'),
                        "AllowViewImage": $('#AllowViewImage').bootstrapSwitch('state'),
                        "AllowSend": $('#AllowSend').val(),
                        "AllowResendMsg": $('#AllowResendMsg').bootstrapSwitch('state'),
                        "AllowRetryFailed": $('#AllowRetryFailed').bootstrapSwitch('state'),
                        "AllowAssign": $('#AllowAssign').bootstrapSwitch('state'),
                        "AllowDelete": $('#AllowDelete').bootstrapSwitch('state'),
                        "AllowApproval": $('#AllowApproval').bootstrapSwitch('state'),
                        "AllowTracking": $('#AllowTracking').bootstrapSwitch('state'),
                        "DelgDisplayName": $("#DelgDisplayName").val(),
                        "DelgUserName": $("#DelgUserName").val(),
                        "DelegatorName": $("#DelegatorName").val(),
                        "AllowPersonalFolder": $("#AllowPersonalFolder").val()
                    }
                },
                /*constructsavemodel(),*/
                function (data) {

                    $.delegationSetting.refresh(e);

                    if ($('input[name="formDelegation-action"]').val() === 'save & close') {
                        $('input[name="formDelegation-action"]').val('');
                        showLoaderBar = false;
                        swal("Good job!", 'Saved successfully', "success");
                        $.sectionproperties.Hidden("DelegationTable", false);
                        $.sectionproperties.Hidden("DelegationForm", true);
                    }
                    else {
                        var selectedProfileID = data == null ? "" : data.ProfileID;
                        $.delegationSetting.resetFields(selectedProfileID);

                        $.toast({
                            text: 'Saved successfully',
                            position: 'top-right',
                            loaderBg: '#ff6849',
                            icon: 'success',
                            hideAfter: 3500,
                            stack: 6
                        });
                    }
                },
                function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnDelete, "error");
                }, showLoaderBar);
        },
        delete: function (e) {

            var selectedItem = $.delegationSetting.getGridSelections($(".grid-delegation"));

            if (selectedItem.length === 0) {
                swal("", $delegateResources.swal.noDelegationProfileSelected);
                return false;
            }

            swal({
                title: "",
                text: $delegateResources.swal.delDelegationProfile,
                type: "info",
                showCancelButton: true,
                closeOnConfirm: false,
                reverseButtons: true,
                showLoaderOnConfirm: true
            }, function () {
                fxcRequest.post('/User/DelegationSetting/Delete',
                    { Ids: selectedItem.join().split(',') },
                    function (data) {
                        swal.close();
                        $.toast({
                            text: $delegateResources.swal.delDelegationProfileSuccess,
                            position: 'top-right',
                            loaderBg: '#ff6849',
                            icon: 'success',
                            hideAfter: 3500,
                            stack: 6
                        });
                        /* Refresh grid everytime after save*/
                        $.delegationSetting.initGrid();
                    }, function () {
                        swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnDelete, "error");
                    }, false);
            });
        },
        getGridSelections: function (event) {
            var entityGrid = event.data("kendoGrid");
            var rows = entityGrid.select();
            var $selectedUser = [];
            rows.each(function (index, row) {
                var selectedItem = entityGrid.dataItem(row);
                $selectedUser[index] = selectedItem.ProfileID;

            });

            return $selectedUser;
        }
    };

    $.delegatee = {
        init: function () {
            $.delegatee.createButtonClickHandler($(".btn-new-delegatee"));
            $.delegatee.deleteButtonClickHandler($(".btn-delete-delegatee"));
            $.delegatee.refreshButtonClickHandler($(".btn-refresh-delegatee"));
            $.delegatee.searchPressEnter($('input[data-role="search-delegatee-item"]'));
            $.delegatee.searchButtonClickHandler($('.btn-search-delegatee'));
        },

        /*Btn Action*/
        createButtonClickHandler: function (e) {
            $(e).on('click', function (x) {
                $("#modal-delegateeUser").modal("show");
            });
        },
        deleteButtonClickHandler: function (e) {
            $(e).on('click', function (x) {
                $(this).blur();
                $.delegatee.delete();
            });
        },
        refreshButtonClickHandler: function (e) {
            $(e).on('click', function (x) {
                $.delegatee.refresh();
                $(this).blur();
            });
        },
        searchButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.delegatee.search(e);
            });
        },
        searchPressEnter: function (e) {
            $(e).on('keypress', function (enter) {
                if (enter.which === 13) {
                    $.delegatee.search(e);
                }
            });
        },
        /*End Btn Action*/

        initGrid: function (e) {
            var id = $('.grid-delegatee');

            var dataSource = {
                transport: {
                    read: {
                        url: '/User/DelegationSetting/GetDelegationDelegatee',
                        dataType: "json",
                        type: "GET"
                    },
                    parameterMap: function (options) {

                        var result = {
                            Skip: options.skip,
                            Take: options.take,
                            Filter: $('input[data-role="search-delegatee-item"]').val(),
                            ProfileID: $("#formDelegation-profileID").val()
                        };
                        if (options.sort && options.sort.length > 0) {
                            result.SortBy = options.sort[0].field;
                            result.Direction = options.sort[0].dir;
                        }
                        return result;
                    }
                },
                schema: {
                    data: "Records",
                    total: "Total",
                    model: {
                        Id: "AssignID"
                    }

                },
                serverPaging: true,
                serverSorting: true
            };

            var col = [
                {
                    selectable: true, width: 45,
                    attributes: {
                        "class": "checkboxSelection"
                    }
                },
                { field: 'AssignID', hidden: true },
                { field: 'Name', title: 'Name', minWidth: 150, width: 300, sortable: true },
                { field: 'DomainName', title: 'Domain Name', minWidth: 150, width: 150, sortable: true }
            ];

            var obj = {};
            obj.allowSelectMultipleRow = true;

            kendogridcustomization.init(id, dataSource, col, obj);
        },
        getGridSelections: function (event) {
            var entityGrid = event.data("kendoGrid");
            var rows = entityGrid.select();
            var $selectedUser = [];
            rows.each(function (index, row) {
                var selectedItem = entityGrid.dataItem(row);
                $selectedUser[index] = selectedItem.AssignID;
            });

            return $selectedUser;
        },
        getGridUserSelections: function (event) {
            var entityGrid = event.data("kendoGrid");
            var rows = entityGrid.select();
            var $selectedUser = [];
            rows.each(function (index, row) {
                var selectedItem = entityGrid.dataItem(row);
                $selectedUser[index] = selectedItem.id;
            });

            return $selectedUser;
        },
        add: function () {
            var selectedItem = $.delegatee.getGridUserSelections($('.grid-delegateeUser'));

            if (selectedItem.length === 0) {
                swal("", "No user(s) selected!");
                return false;
            }

            fxcRequest.post('/User/DelegationSetting/AssignDelegatee',
                {
                    Ids: selectedItem.join().split(','),
                    ProfileID: $("#formDelegation-profileID").val()
                },
                function (data) {

                    $.toast({
                        text: 'Save ',
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'success',
                        hideAfter: 3500,
                        stack: 6
                    });

                    $.delegatee.initGrid();
                    $("#modal-delegateeUser").modal("hide");

                }, function () {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnDelete, "error");
                }, false);
        },
        refresh: function (e) {
            $('input[data-role="search-delegatee-item"]').val("");
            $.delegatee.initGrid();
        },
        search: function (e) {
            $.delegatee.initGrid();
        },
        delete: function (e) {

            var selectedItem = $.delegatee.getGridSelections($(".grid-delegatee"));

            if (selectedItem.length === 0) {
                swal("", $delegateResources.swal.noDelegateeSelected);
                return false;
            }

            swal({
                title: "",
                text: $delegateResources.swal.delDelegatee,
                type: "info",
                showCancelButton: true,
                closeOnConfirm: false,
                reverseButtons: true,
                showLoaderOnConfirm: true
            }, function () {
                fxcRequest.post('/User/DelegationSetting/GetDelegationDelegateeDelete',
                    {
                        Ids: selectedItem.join().split(','),
                        ProfileID: $("#formDelegation-profileID").val()
                    },
                    function (data) {
                        swal.close();
                        $.toast({
                            text: $delegateResources.swal.delDelegateeSuccess,
                            position: 'top-right',
                            loaderBg: '#ff6849',
                            icon: 'success',
                            hideAfter: 3500,
                            stack: 6
                        });
                        /* Refresh grid everytime after save*/
                        $.delegatee.refresh();
                    }, function () {
                        swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnDelete, "error");
                    }, false);
            });
        }
    };
})(window.jQuery);