﻿(function ($) {
	var setIsRtl = $("html[dir]").attr("dir") === "rtl" ? true : false;
    var tour = {
        id: "user-settings-general-hopscotch",
        steps: [
            {
                target: "view1SaveBtn",
                title: "",
                content: $globalMessages.uiGuide.buttonSave,
                placement: "bottom",
                arrowOffset: "250",
                xOffset: "-230",
                yOffset: "-2",
				zindex: 51,
				isRtl: setIsRtl
            },
            {
                target: "view1ResetBtn",
                title: "",
                content: $globalMessages.uiGuide.buttonReset,
                placement: "bottom",
                arrowOffset: "250",
                xOffset: "-232",
                yOffset: "-2",
				zindex: 51,
				isRtl: setIsRtl
            },
            {
                target: "Language",
                title: "",
                content: $globalMessages.uiGuide.changeLanguage,
                placement: "bottom",
                fixedElement : true,
				yOffset: "-3",
				isRtl: setIsRtl
            },
            {
                target: "TimeZone",
                title: "",
                content: $globalMessages.uiGuide.timeZone,
                placement: "bottom",
                fixedElement: true,
				yOffset: "-3",
				isRtl: setIsRtl
            }
        ],
        showPrevButton: true,
        onPrev: function () {
            if (hopscotch.isActive)
                $.sharedUiGuide.scrollToFixedPlacementTarget(hopscotch.getCurrTour(), hopscotch.getCurrStepNum(), hopscotch.getCurrTarget());
        },
        onNext: function () {
            if (hopscotch.isActive)
                $.sharedUiGuide.scrollToFixedPlacementTarget(hopscotch.getCurrTour(), hopscotch.getCurrStepNum(), hopscotch.getCurrTarget());
        }
    };
    $.generalSettingstUiGuide = {
        init: function (tourBtn) {
            $.sharedUiGuide.init({ startTourBtn: tourBtn, tour: tour });
        }
    };
})(window.jQuery);