﻿var generalSettingValidation = function () {
    $('#FormUser-General_Settings').validate({
        ignoreTitle: true,
        rules: {
        },
        messages: {
        },
        submitHandler: function (form) {
            $.generalsettings.save();
        }
    });
};
var resetFields = function () {
    $('#FormUser-General_Settings').trigger("reset");
};
constructModel = function () {

    /* Construct Model Helper 
    param = form id */
    var arr = $commonModelMapping.constructModel('FormUser-General_Settings');

    /* end */

    return {
        ObjectModel: arr
    };
};

var $prevLang, $currLang;

$.generalsettings = {
    init: function () {
        $('.btn-save').on('click', function () {
            $('#FormUser-General_Settings').submit();
        });

        $('.btn-Reset').on('click', function () {
            $.generalsettings.populate();
        });

        generalSettingValidation();
    },
    populate: function () {

        fxcRequest.get('/User/GeneralSetting/Populate', {},
            function (data) {

                if (data !== null) {
                    $('#CompanyName').val(data.CompanyName);
                    $('#Street1').val(data.Street1);
                    $('#Street2').val(data.Street2);
                    $('#Street3').val(data.Street3);
                    $('#City').val(data.City);
                    $('#State').val(data.State);
                    $('#Postal').val(data.Postal);
                    $('#Country').val(data.Country).change();
                    $prevLang = data.Language;
                    $('#Language').val(data.Language).change();
                    $('#DateFormat').val(data.DateFormat).change();
                    $('#TimeFormat').val(data.TimeFormat).change();
                    $('#TimeZone').val(data.TimeZone).change();
                    $('#DefaultCoverPage').val(data.DefaultCoverPage).change();
                    $('#LocalCSID').val(data.LocalCSID);
                    $('#NRS').bootstrapSwitch('state', data.NRS);
                    $('#NRF').bootstrapSwitch('state', data.NRF);
                    $('#NSS').bootstrapSwitch('state', data.NSS);
                    $('#NSF').bootstrapSwitch('state', data.NSF);
                    $('#NS').bootstrapSwitch('state', data.NS);

                    if (data.PrintSaveFormat === "TIF")
                        $('#PrintSaveFormat').bootstrapSwitch('state', false);
                    else
                        $('#PrintSaveFormat').bootstrapSwitch('state', true);

                    if (data.FileFormat === "TIF")
                        $('#FileFormat').bootstrapSwitch('state', false);
                    else
                        $('#FileFormat').bootstrapSwitch('state', true);


                    $('#DefaultPageSize').val(data.DefaultPageSize).change();
                    $('#RefreshInterval').val(data.RefreshInterval).change();
                    $('#IBCallerIdentity').val(data.IBCallerIdentity).change();
                    $('#ExchDomain').val(data.ExchDomain);
                    $('#ExchUsername').val(data.ExchUsername);
                    $('#ExchPassword').val(data.ExchPassword);

                    if (data.EnabledExch)
                        $.sectionproperties.Hidden("Exchange", false);
                }
            },
            function (error) {
                swal($globalMessages.swal.error.error, $globalMessages.swal.error.errorDBConnection, "error");
            });
    },
    save: function () {
        $currLang = $('#Language').val();
        fxcRequest.post('/User/GeneralSetting/Save',
            constructModel(),
            function (data) {
                var refreshPage = false;
                if ($prevLang !== $currLang) {
                    refreshPage = true;
                }
                fxcUserConn.onUpdateUser($('#FxUserId').val(), refreshPage, true);
                swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");
            },
            function (error) {
                swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSave, "error");
            });
    }
};
