﻿(function ($) {
    var $grid;
    var action = 0;
    var formID = "#form-user-addressbook";
    var addressBook = $('#addressBook').val();
    var dataForm;
    var backToGrid = 0;

    var $FtpPasswordIsEncrypted = false;
    var $TempFTPPassword;

    var $HttpPasswordIsEncrypted = false;
    var $TempHTTPPassword;

    var $FilePasswordIsEncrypted = false;
	var $TempFilePassword;

	var submitTriggered = false;

    var contactValidation = function () {
        $(formID).validate({
			ignoreTitle: true,
            rules: {
                DisplayName: {
                    required: true,
                    noSpace: true
				},
				/*List of Address Book */
				"NewContactDropDownList.ContactAddrBookList.Value": { required: true },
				/*List of Prefferd Address Type */
				"NewContactDropDownList.ContactPreferAddrTypeList.Value": { required: true },
				Email: {
					email: true,
					required: {
						depends: function (element) {
							return parseInt($("#AddressPreferred").val()) === 1;
						}
					},
					noSpace: true
				},
				FaxNumber: {
					required: {
						depends: function (element) {
							return parseInt($("#AddressPreferred").val()) === 2;
						}
					},
					noSpace: true
				},
				RawFax: {
					required: {
						depends: function (element) {
							return parseInt($("#AddressPreferred").val()) === 9;
						}
					},
					noSpace: true
				},
				PhoneNumber: {
					required: {
						depends: function (element) {
							return parseInt($("#AddressPreferred").val()) === 10;
						}
					},
					noSpace: true
				},
				MobileNumber: {
					required: {
						depends: function (element) {
							return parseInt($("#AddressPreferred").val()) === 7;
						}
					},
					noSpace: true
				},
				/*List of Printer */
				"NewContactDropDownList.NetworkPrinterList.Value": {
					required: {
						depends: function (element) {
							return parseInt($("#AddressPreferred").val()) === 6;
						}
					}
				},

				
				FtpAddress: {
					checkRequired: "FtpLogin",
					required: {
						depends: function (element) {
							return parseInt($("#AddressPreferred").val()) === 4;
						}
					},
					noSpace: true
				},
				FtpLogin: {
					checkRequired: "FtpPassword",
					noSpace: true
				},
				FtpPassword: { checkRequired: "FtpLogin" },

				HttpAddress: {
					checkRequired: "HttpLogin",
					required: {
						depends: function (element) {
							return parseInt($("#AddressPreferred").val()) === 3;
						}
					},
					noSpace: true
				},
				HttpLogin: {
					checkRequired: "HttpPassword",
					noSpace: true
				},
				HttpPassword: { checkRequired: "HttpLogin" },

				FileFolderName: {
					checkOptionalRequired: ["FileLogin", "FileServerName"],
					required: {
						depends: function (element) {
							return parseInt($("#AddressPreferred").val()) === 5;
						}
					},
					noSpace: true
				},
				FileLogin: {
					checkRequired: "FilePassword",
					noSpace: true
				},
				FilePassword: { checkRequired: "FileLogin" }

            },
			errorPlacement: function (error, element) {
				submitTriggered = true;
                var p = element.parent('div').parent();
                if (p.hasClass('form-group')) {
                    error.appendTo(p);
                } else {
                    error.insertAfter(element);
                }
            },
			submitHandler: function (form) {
				submitTriggered = false; 
                $.contact.save(action);
            }
        });
    };

    $.contact = {
        init: function (e) {
            contactValidation();

            /* Network Printer default value */
            $("#NetworkPrinter").prepend("<option value='' selected='selected'></option>");
            /* End */

            /*Create New Contact */
            $('.btn-save').click(function (e) {
                action = 0;
                backToGrid = 0;
                $('#ContactId').val(0);
				$.contact.submitForm();
            });
            /* End */

            /* Update Entry Page*/
            $('.btn-save-new2').click(function (e) {
                action = 0;
                $('#ContactId').val(0);
				$.contact.submitForm();
            });

            $('.btn-save2').click(function (e) {
                action = 1;
				$.contact.submitForm();
                backToGrid = 1;
            });
            /* End */

            /* Reset Btn */
            $.contact.resetButtonClickHandler();
            /* End */

            $.contact.resetFTPPassword();
            $.contact.resetHTTPPassword();
			$.contact.resetFilePassword();

			$.contact.addrTypeOnChangeHandler($('#AddressPreferred'));

			$('#collapseContact').on('shown.bs.collapse', function (e) {
				var getItemPosition = null;
				if ($('#collapseContact').attr("data-scrollTo") != null) {
					getItemPosition = parseInt($('#collapseContact').attr("data-scrollTo"));
				}
				else if ($('#collapseContact').attr("data-scrollTo") === 'false') {
					return false;
				}
				else {
					getItemPosition = $(this).offset().top;
				}
                $(".fxc-main-content").scrollTop(getItemPosition);
				$('#collapseContact').removeAttr("data-scrollTo");
			});
        },

        /*Btn Action*/
        createButtonClickHandler: function (e, isAddrBook = false) {
            $(e).on('click', function (x) {
                
                dataForm = null;
                $.contact.resetFields(dataForm);
                $.sectionproperties.SecondLevel();
                $('#form-user-addressbook').validate().resetForm();
            });
        },
        editHandler: function (dataItem) {
            $.contact.getForm(dataItem.Id);
            $.sectionproperties.SecondLevel();
        },
        resetButtonClickHandler: function (e) {
            $('.btn-Reset2, .btn-Reset').on('click', function (x) {
                $.contact.resetFields(dataForm);
            });
		},
		addrTypeOnChangeHandler: function (elem) {
			$(elem).on('change', function (e) {
				var getElemValue = parseInt($(this).val());

				if ($(formID).validate().toShow.length > 0 || submitTriggered) {
					$('#Email').valid();
					$("#FaxNumber").valid();
					$('#RawFax').valid();
					$("#PhoneNumber").valid();
					$("#MobileNumber").valid();
					$('#NetworkPrinter').valid();
					$("#FtpAddress").valid();
					$('#HttpAddress').valid();
					$("#FileFolderName").valid();
				}

				if (!$("#collapseContact").is(':visible') && (getElemValue === 3 || getElemValue === 4 || getElemValue === 5)) {
					$("#collapseContact").attr("data-scrollTo", "false");
					$('#collapseContact').collapse('show');
				}
			});
		},

        /* Logic */
		resetFields: function (data) {
			submitTriggered = false;
			if ($("#collapseContact").is(':visible')) {
				$('#collapseContact').collapse('hide');
			}

            $(formID).trigger("reset");
            $(formID).validate().resetForm();
            $('#ContactId').val('0');
            $.sectionproperties.HideField(".btn-save2", true);
            $(".btn-save-new2").text($globalMessages.button.save);
            backToGrid = 1;

            $(".title2").text($areaResources.actionTitle.createNewContact);

            if ($('input#addressBookId').length > 0) {
                if ($('#AddressBookId option').filter(function () { return $(this).val() == $('input#addressBookId').val(); }).length) {
                    /*found*/
                    $("#AddressBookId").val($('input#addressBookId').val()).change();
                }
            }

            $FtpPasswordIsEncrypted = false;

            $HttpPasswordIsEncrypted = false;

            $FilePasswordIsEncrypted = false;

            if (data != null) {

                $.sectionproperties.HideField(".btn-save2", false);
                backToGrid = 0;

                $(".title2").text($areaResources.actionTitle.updateContactEntry);
                $(".btn-save-new2").text($globalMessages.button.saveAsNew);
                $('#ContactId').val(data.ContactId);
                $('#DisplayName').val(data.DisplayName);
                $('#FirstName').val(data.FirstName);
                $('#MiddleName').val(data.MiddleName);
                $('#LastName').val(data.LastName);
                $('#CompanyName').val(data.CompanyName);
                $('#Description').val(data.Description);

                /* If AddressType is 12 (CSID) */
                if (data.PreferAddress == 12) {
                    data.PreferAddress = 1;
                }
                /* End */

                $('#AddressPreferred').val(data.PreferAddress);
                 /* Visibility - 3 (Global) not available in user panel */
                $('#VisibilityDDL').val($("#VisibilityDDL option[value='" + data.Visibility + "']").length > 0 ? data.Visibility : $("#VisibilityDDL option:first").val());
                $('#IsRffOn').bootstrapSwitch('state', data.IsRffOn);
                $('#IsRssOn').bootstrapSwitch('state', data.IsRssOn);
                $('#Email').val(data.Email);

                var checkDeliveryEmail = $.parseJSON(isPDFFileType.toLowerCase());
                if (data.DeliveryEmail === "PDF") {
                    checkDeliveryEmail = true;
				}
				else if (data.DeliveryEmail === "TIF") {
					checkDeliveryEmail = false;
				}

                $('#DeliveryEmail').bootstrapSwitch('state', checkDeliveryEmail);

                $('#FaxNumber').val(data.FaxNumber);
                $('#PhoneNumber').val(data.PhoneNumber);
                $('#MobileNumber').val(data.MobileNumber);
                $('#FtpAddress').val(data.FtpAddress);
                $('#FtpLogin').val(data.FtpLogin);
                $('#FtpPassword').val(data.FtpPassword);
                $FtpPasswordIsEncrypted = data.FtpPasswordIsEncrypted;

                var checkFtpDelivery = $.parseJSON(isPDFFileType.toLowerCase());

                if (data.FtpDelivery === "PDF") {
                    checkFtpDelivery = true;
				}
				else if (data.FtpDelivery === "TIF") {
					checkFtpDelivery = false;
				}
                $('#FtpDelivery').bootstrapSwitch('state', checkFtpDelivery);

                $('#HttpAddress').val(data.HttpAddress);
                $('#HttpLogin').val(data.HttpLogin);
                $('#HttpPassword').val(data.HttpPassword);
                $HttpPasswordIsEncrypted = data.HttpPasswordIsEncrypted;

                var checkHttpDelivery = $.parseJSON(isPDFFileType.toLowerCase());
                if (data.HttpDelivery == "PDF") {
                    checkHttpDelivery = true;
				}
				else if (data.HttpDelivery === "TIF") {
					checkHttpDelivery = false;
				}

                $('#HttpDelivery').bootstrapSwitch('state', checkHttpDelivery);

                $('#NetworkPrinter').val(data.NetworkPrinter);
                $('#RawFax').val(data.RawFax);
                $('#FileServerName').val(data.FileServerName);
                $('#FileFolderName').val(data.FileFolderName);
                $('#FileLogin').val(data.FileLogin);
                $('#FilePassword').val(data.FilePassword);
                $FilePasswordIsEncrypted = data.FilePasswordIsEncrypted;

                var checkFileDelivery = $.parseJSON(isPDFFileType.toLowerCase());
                if (data.FileDelivery == "PDF") {
                    checkFileDelivery = true;
				}
				else if (data.FileDelivery === "TIF") {
					checkFileDelivery = false;
				}

                $('#FileDelivery').bootstrapSwitch('state', checkFileDelivery);

                $('#CsidCallerId').val(data.CsidCallerId);
            }
        },
        resetFTPPassword: function (e) {
            $("#FtpPassword").focus(function () {
                if ($FtpPasswordIsEncrypted) {
                    $TempFTPPassword = $("#FtpPassword").val();
                    $("#FtpPassword").val("");
                }
            });
            $("#FtpPassword").keyup(function () {
                $FtpPasswordIsEncrypted = false;
            });
            $("#FtpPassword").focusout(function () {
                if ($FtpPasswordIsEncrypted) {
                    $("#FtpPassword").val($TempFTPPassword);
                }
            });
        },
        resetHTTPPassword: function (e) {
            $("#HttpPassword").focus(function () {
                if ($HttpPasswordIsEncrypted) {
                    $TempHTTPPassword = $("#HttpPassword").val();
                    $("#HttpPassword").val("");
                }
            });
            $("#HttpPassword").keyup(function () {
                $HttpPasswordIsEncrypted = false;
            });
            $("#HttpPassword").focusout(function () {
                if ($HttpPasswordIsEncrypted) {
                    $("#HttpPassword").val($TempHTTPPassword);
                }
            });
        },
        resetFilePassword: function (e) {
            $("#FilePassword").focus(function () {
                if ($FilePasswordIsEncrypted) {
                    $TempFilePassword = $("#FilePassword").val();
                    $("#Password").val("");
                }
            });
            $("#FilePassword").keyup(function () {
                $FilePasswordIsEncrypted = false;
            });
            $("#FilePassword").focusout(function () {
                if ($FilePasswordIsEncrypted) {
                    $("#FilePassword").val($TempFilePassword);
                }
            });
		},
		submitForm: function () {
			submitTriggered = true;
			/*Handle error form*/
			var getItems = $(formID).validate().toShow;
			for (var i = 0; i < getItems.length; i++) {
				if ($(getItems[i]).closest("#collapseContact").length > 0 && !$("#collapseContact").is(':visible')) {
					$('#collapseContact').collapse('show');
					$('#collapseContact').attr("data-scrollTo", $(getItems[0]).offset().top);
					break;
				}
			}
			$(formID).submit();
		},

        /*Post or Get Function*/
        save: function (action) {
            var checkDeliveryEmail = "TIF";
            var addressBook = $('#addressBook').val();

            if ($('#DeliveryEmail').prop('checked')) {
                checkDeliveryEmail = "PDF";
            }

            var checkFtpDelivery = "TIF";
            if ($('#FtpDelivery').prop('checked')) {
                checkFtpDelivery = "PDF";
            }

            var checkHttpDelivery = "TIF";
            if ($('#HttpDelivery').prop('checked')) {
                checkHttpDelivery = "PDF";
            }

            var checkFileDelivery = "TIF";
            if ($('#FileDelivery').prop('checked')) {
                checkFileDelivery = "PDF";
            }

            var AddressBookID = $('#AddressBookId').val();
            /*if ($('#addressBook').val() == "domain") {
                AddressBookID = $('input#addressBookId').val();
            }*/

            fxcRequest.post('/User/Contact/Save',
                {
                    Action: action,
                    ContactId: $('#ContactId').val(),
                    AddressBookId: AddressBookID,
                    DisplayName: $('#DisplayName').val(),
                    FirstName: $('#FirstName').val(),
                    MiddleName: $('#MiddleName').val(),
                    LastName: $('#LastName').val(),
                    CompanyName: $('#CompanyName').val(),
                    Description: $('#Description').val(),
                    PreferAddress: $('#AddressPreferred').val(),
                    Visibility: $('#VisibilityDDL').val(),
                    IsRffOn: $('#IsRffOn').prop('checked'),
                    IsRssOn: $('#IsRssOn').prop('checked'),
                    Email: $('#Email').val(),
                    DeliveryEmail: checkDeliveryEmail,
                    FaxNumber: $('#FaxNumber').val(),
                    PhoneNumber: $('#PhoneNumber').val(),
                    MobileNumber: $('#MobileNumber').val(),
                    FtpAddress: $('#FtpAddress').val(),
                    FtpLogin: $('#FtpLogin').val(),
                    FtpPassword: $('#FtpPassword').val(),
                    FtpPasswordIsEncrypted: $FtpPasswordIsEncrypted,
                    FtpDelivery: checkFtpDelivery,
                    HttpAddress: $('#HttpAddress').val(),
                    HttpLogin: $('#HttpLogin').val(),
                    HttpPassword: $('#HttpPassword').val(),
                    HttpPasswordIsEncrypted: $HttpPasswordIsEncrypted,
                    HttpDelivery: checkHttpDelivery,
                    NetworkPrinter: $('#NetworkPrinter').val(),
                    RawFax: $('#RawFax').val(),
                    FileServerName: $('#FileServerName').val(),
                    FileFolderName: $('#FileFolderName').val(),
                    FileLogin: $('#FileLogin').val(),
                    FilePassword: $('#FilePassword').val(),
                    FilePasswordIsEncrypted: $FilePasswordIsEncrypted,
                    FileDelivery: checkFileDelivery,
                    CsidCallerId: $('#CsidCallerId').val()
                },
                function (data) {
                    $('#ContactId').val(data.ContactId);

                    swal({
                        title: $globalMessages.swal.success.title,
                        text: $globalMessages.swal.success.text,
                        type: "success",
                        showConfirmButton: true
                    }, function (e) {
                        window.setTimeout(function () {
                            var url = $("#RedirectTo").val();
                            if ($("#RedirectTo").length > 0) {
                                var Id = $("#AddressBookId option:selected").val() + "";
                                var Name = $("#AddressBookId option:selected").text() + "";
                                fxcontent.load(url.replace('__ID__', Id).replace('__Name__', Name));
                            }

                            if (backToGrid == 1) {
                                if (addressBook == 'domain') {
                                    $.domainAddressBook.getDomainDetail();
                                    $.sectionproperties.SixthLevel(this);
                                }
                                else {
                                    $.addressBook.refresh();
                                    $.sectionproperties.FirstLevelView();
                                }
                            }
                        }, 10);

                    }, function (error) {
                        /*console.log(error);*/
                    });
                });
        },
        getForm: function (contactId) {
            fxcRequest.get('/User/Contact/Get',
                {
                    ContactId: contactId
                },
                function (data) {
                    dataForm = data;
                    $.contact.resetFields(dataForm);
                });
        }
    };

})(window.jQuery);