﻿(function ($) {
    var $grid;
    var action = 0;
    var formID = "#formSubmit_document";
    var formBarcode = "#formBarcode";
    var dataForm;
    var editDoc = false;
    var tempEditorContent = "";
    var editorContent = "";

    var customErrorPlacement = function (error, element) {
		var p = element.parent(".dropify-wrapper");
		if (p.length) {
			error.insertAfter(p);
		} 
        else {
            error.insertAfter(element);
        }
    };
    var documentValidation = function () {
        $(formID).validate({
			ignoreTitle: true,
            rules: {
				"Document.DocName": { required: true, noSpace: true },
				"DdlFolderID": { required: true }
			},
			errorPlacement: customErrorPlacement,
            submitHandler: function (form) {
				if (editDoc) {
					$._document.save();
				} else {
					$._document.save(action);
				}
            }
        });

        $(formBarcode).validate({
            rules: {
                BarcodeData: {
                    required: true
                },
                BarcodeSizeOther: {
                    required: true,
                    number: true,
                    min: 2,
                    max: 100
                }
            },
            errorPlacement: customErrorPlacement,
            submitHandler: function (form) {
                $._document.createBarcode(action);
            }
        });
    };

    $._document = {
        init: function (e) {

            $('#BarcodeSizeOther').mask('999');
            document.getElementById('BarcodeSize').onchange = function () {
                if ($('#BarcodeSize').val() == '0') {
                    $('div#BarcodeSizeOtherPanel').css('display', 'block');
                    $('#BarcodeSizeOther').val('');
                    $('#BarcodeSizeOther').focus();
                } else {
                    $('div#BarcodeSizeOtherPanel').css('display', 'none');
                }
            };

            documentValidation();

            /*Save or Create document*/
            $('.btn-save2').click(function (e) {
                action = 1;
				$(formID).submit();
            });
            $('.btn-save3').click(function (e) {
                tempEditorContent = $._document.getEditorContent();
                if (!tempEditorContent) {
                    swal("", $areaResources.swal.coverPageNotEmpty, "warning");
                    return false;
                }

                $.sectionproperties.SecondLevel();

                $(".linkEditorDiv").removeClass("blink_me");
            });
            /* End */

            $('.btn-insert-barcode').click(function (e) {
                $(formBarcode).submit();
            });

            $('.btn-insert-token').click(function (e) {

                var token = "$$" + $("#Token").val() + "$$";

                $._document.pasteEditorContent(token);

                $('#token-modal').modal('hide');
            });

            $._document.searchUserDocHandler($('input[data-role="search-user-doc"]'));

            $._document.searchButtonClickHandler($('#searchButton'));

            $._document.refreshButtonClickHandler($('#action-refresh-grid'));

            $._document.resetHandler();

            $._document.backClickHandler();

            $('#Link-CreateEditor').on('click', function (e) {
                $.sectionproperties.ThirdLevel($(e));
            });

            $._document.onChangeFileInput();

            /* End */
        },
        initNewDocForm: function (e) {

            fxcRequest.get('/User/NewDocument/InitNewDocForm',
				{
					"FolderId": $('#DdlFolderID option:selected').val(),
					"FolderName": $('#DdlFolderID option:selected').text()
				},
                function (data) {

                    $._document.updateDdl(data);
                    $._document.onChangeDocType(null);

                },
                function (error) {
                    /*console.log(error);*/
                });
        },
        updateDdl: function (data) {

            $("#DdlDocTypeID").html('');
            $("#DdlDocTypeID").append(data.DdlDocType);

            $("#DdlVisibilityID").html('');
            $("#DdlVisibilityID").append(data.DdlVisibility);

            $("#DdlFolderID").html('');
            $("#DdlFolderID").append(data.DdlFolder);

            $("#BarcodeSize").html('');
            $("#BarcodeSize").append(data.DdlBarcodeSize);

            /*TokenGroups, Token*/
            $("#TokenGroups").html('');
            $("#TokenGroups").append(data.DdlTokenGroups);

            $("#Token").html('');
            $("#Token").append(data.DdlToken);

        },
        onChangeTokenGroups: function (e) {
            fxcRequest.post('/User/DocIndex/GetTokenByTokenGroup',
                {
                    "SelectedTokenGroupId": e
                },
                function (data) {
                    $("#Token").html('');
                    $("#Token").append(data.DdlToken);
                },
                function (error) {
                    /*console.log(error);*/
                }, false);
        },
        onChangeDocType: function (e) {
            if (e == '2') {
                $('div.HiddenDdlDocTypeID').css('display', 'block');
                $('div#docUploadpanel').css('display', 'block');
                $('div#docUploadpanel .text-danger').hide();
                $('#DocumentUpload').prop('required', false);
            } else {
                $('div.HiddenDdlDocTypeID').css('display', 'none');
                $('div#docUploadpanel').css('display', 'block');
                $('div#docUploadpanel .text-danger').show();
                $('#DocumentUpload').prop('required', true);
            }

            $('span.title2').text('Create New Document');
            $('#optionText').show();
            $('#Link-CreateEditor').text("Create Cover Page");

            if (editDoc) {
                $('span.title2').text('Edit Document');
                $('div#docUploadpanel').css('display', 'none');

                $('#optionText').hide();
                $('#Link-CreateEditor').text("Edit Cover Page");
            }
        },
        onChangeFileInput: function () {
            $("#DocumentUpload").on('change', function () {
                if (this.files.length > 0) {
                    $._document.setEditorContent("");
                    $('div.linkEditorDiv').addClass("disabled");
                }
            });

            /* Enable Editor if there's no documents 
             * Onchange event won't work in this so use dropify events
             */
            var drEvent = $('#DocumentUpload').dropify();

            drEvent.on('dropify.afterClear', function (event, element) {
                $('div.linkEditorDiv').removeClass("disabled");
            });
        },
        getDocumentID: function (e) {
            return $('input#DocumentID').val();
        },
        setDocumentID: function (e) {
            $('input#DocumentID').val(e);
        },
        edit: function (dataItem) {
            $._document.getForm(dataItem.id);
            $.sectionproperties.SecondLevel();
            $.sectionproperties.Hidden("BackBtn", false);
		},
		createHandler: function (e) {
			dataForm = null;
			$._document.resetfields(dataForm);
		},
        resetHandler: function (e) {
            $(".btn-Reset2").on('click', function (x) {
                $._document.resetfields(dataForm);
            });
            $(".btn-Reset3").on('click', function (x) {
                $._document.setEditorContent(editorContent);
            });
        },
		resetfields: function (data) {
            $(formID).trigger("reset");
            $(formID).validate().resetForm();
            $('#DocumentID').val('0');

            $._document.removeUploadedFile();

			$('#DdlDocTypeID').prop("disabled", $('#DdlDocTypeID option').length === 1);
            if ($('input#folderId').length > 0) {
                if ($('#DdlFolderID option').filter(function () { return $(this).val() == $('input#folderId').val(); }).length) {
                    /*found*/
					$("#DdlFolderID").val($('input#folderId').val()).change();
		
				}
            }
            editDoc = false;
            if (data != null) {
                $._document.getForm(data.DocumentID);
            } else {
                tempEditorContent = editorContent = "";
                $._document.setEditorContent(editorContent);
				$._document.onChangeDocType(null);
				
				$('#DdlFolderID').prop("disabled", $('#DdlFolderID option').length === 1);
            }
        },
        removeUploadedFile: function () {
            /* Remove uploaded file */
            var drop = $('.dropify').dropify();
            drop = drop.data('dropify');
            drop.resetPreview();
            drop.clearElement();
        },
        backClickHandler: function (e) {
            $('.btn-back2').on('click', function (enter) {
                $.sectionproperties.FirstLevelView(this);
            });
            $('.btn-back3').on('click', function (enter) {
                $._document.setEditorContent(editorContent);
                $.sectionproperties.SecondLevel(this);
            });
        },
        refreshButtonClickHandler: function (e) {
            $(e).on('click', function (event) {
                $('input[data-role="search-user-doc"]').val("");
                $.uDoc.getDocList();
                $(this).blur();
            });
        },
        searchUserDocHandler: function (e) {
            $(e).keypress(function (event) {
                if (event.which == 13) {
                    $.uDoc.getDocList($(this).val());
                }
            });
        },
        searchButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.uDoc.getDocList($('input[data-role="search-user-doc"]').val());
            });
        },
        save: function (e) {
            var savefolderId = $('#DdlFolderID').val();
            var checkDocType = $("#DdlDocTypeID").val();
            var attachDoc = $("#DocumentUpload").get(0).files.length;

            /* if (checkDocType == 2) $._document.removeUploadedFile(); */

            /* Add New Doc only */
            if (!editDoc && !tempEditorContent && checkDocType == 2 && attachDoc == 0) {
                $(".linkEditorDiv").addClass("blink_me");
                swal("", $areaResources.swal.coverPageMustCreate, "warning");
                return false;
            }

            fxcRequest.upload('/User/NewDocument/SaveDoc', $('#DocumentUpload'),
                {
					"FolderId": $('#DdlFolderID option:selected').val(),
					"FolderName": $('#DdlFolderID option:selected').text(),
                    "Document": $._document.readForm()
                },
                function (data) {

                    $._document.initNewDocForm();
                    if (editDoc || $("#RedirectTo").length == 0 ) {
                        $.uDoc.getDocList();
                        $.sectionproperties.FirstLevelView();
                    } else {
                        var selectOptionid = '#DdlFolderID option[value="' + savefolderId + '"]';
                        var saveText = $(selectOptionid).text();

                        var url = $._document.createDocRedirectLink($("#RedirectTo").val(),savefolderId, saveText);
                        fxcontent.load(url);
                    }

                    swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");
                });
        },
        createDocRedirectLink: function (url, id, name) {
            url = url.replace('__ID__', id);
            return url;
        },
        readForm: function (e) {
            var temp = {
                "DocumentID": $._document.getDocumentID(),
                "DocName": $('#DocName').val(),
                "DocTypeID": Number($('#DdlDocTypeID').val()),
                "FolderID": $('#DdlFolderID').val(),
                "VisibilityID": Number($('#DdlVisibilityID').val()),
                "Desc": $('#Desc').val(),
                "Content": tempEditorContent
            };
            return temp;
        },
        setFormData: function (doc) {
            $._document.removeUploadedFile();

			$(formID).trigger("reset");
			$(formID).validate().resetForm();
            $._document.setDocumentID(doc.DocumentID);
            $('#DocName').val(doc.DocName);
            $('#DdlDocTypeID').val(doc.DocTypeID);
            $('#DdlDocTypeID').prop("disabled", true);
			$('#DdlFolderID').val(doc.FolderID);
			$('#DdlFolderID').prop("disabled", $('#DdlFolderID option').length === 1);
            $('#DdlVisibilityID').val(doc.VisibilityID);
            $('#Desc').val(doc.Desc);

            $('div.linkEditorDiv').addClass("disabled");
            
            if (doc.Content) {
                editorContent = doc.Content;
                $._document.setEditorContent(editorContent);
                tempEditorContent = doc.Content;

                $('div.linkEditorDiv').removeClass("disabled");
            }
            else {
                tempEditorContent = editorContent = "";
                $._document.setEditorContent(editorContent);
            }

            editDoc = true;
			$._document.onChangeDocType(doc.DocTypeID);

        },
        getEditorContent: function (e) {
            var editor = $("#editor").data("kendoEditor");
            return editor.value();
        },
        setEditorContent: function (e) {
            var editor = $("#editor").data("kendoEditor");
            return editor.value(e);
        },
        pasteEditorContent: function (e) {
            var editor = $("#editor").data("kendoEditor");
            editor.exec("inserthtml", { value: e });
        },
        getForm: function (id) {
            /* /admin/document/readdocument, /user/docindex/readdocument*/
            fxcRequest.get('/User/DocIndex/ReadDocument',
                {
                    "SelectedDocId": id
                },
                function (data) {
                    swal.close();

                    if (data && data.Document) {
                        dataForm = data.Document;
                        $._document.setFormData(dataForm);
                    } else {
                        console.log(data);
                    }
                }, null, true);

        },
        barcodeButtonClickHandler: function (e) {
            $('#formBarcode').trigger("reset");
            $('#barcode-modal').modal('show');
            $('div#BarcodeSizeOtherPanel').css('display', 'none');
        },
        createBarcode: function (e) {
            var bd = $('#BarcodeData').val();
            var bs = $('#BarcodeSize').val();
            if ($('#BarcodeSize').val() == '0') {
                bs = $('#BarcodeSizeOther').val();
            }

            fxcRequest.get('/User/UserCommon/GenerateBarcodeBase64',
                {
                    "bd": bd,
                    "bs": bs
                },
                function (data) {
                    var img = '<img alt="bootstraps.png"  src="data:image/png;base64, ' + data.Base64String + '" />';
                    $._document.pasteEditorContent(img);
                },
                function (error) {
                    /*console.log(error);*/
                });

            $('#barcode-modal').modal('hide');
        },
        handleError: function (data) {
            if (data.TypeName && data.TypeName === 'ServerError') {
                swal($globalMessages.swal.error.title, data.Value, "error");
            }
        }
    };
})(window.jQuery);