﻿(function ($) {
	var actionType, folderId, folderType, newName = "", routeName, menuOption, liId, requestFolderId, requestLevel, requestAllowLevel;
	var pfolder = "1", addrbook = "2", doc = "3";/*folderType*/
	var createMenu = "1", renameMenu = "2", deleteMenu = "3";/*actionType*/
	var itemsDisabled = {};
	var enableContextMenu = false;
	var getErrorMsg = [];

	var userCommonValidation = function () {
		$('#formSubmit-newName').validate({
			rules: {
				txtFolderName: {
					required: true
				},
			},
			submitHandler: function (form) {
				newName = $('#txtFolderName').val();
				$contextmenu.performAction();
			},
		});
	};

	var addressBookCommonValidation = function () {
		$('#form-addressbook-contextmenu').validate({
			ignore: ".ignored",
			rules: {
				AddressBookNameModal: {
					required: true
				},
			},
			invalidHandler: function (event, validator) {
				var errors = validator.numberOfInvalids();
				if (errors) {
					getErrorMsg.push(validator);
				}
			},
			submitHandler: function (form) {
				addressBookId = $('#AddressBookIdModal').val();
				if (addressBookId == 0) {
					$contextmenu.addressBookSave();
				} else {
					$contextmenu.addressBookRename();
				}
				return false;
			},
		});
	};

	$contextmenu = {
		init: function (e) {
			userCommonValidation();
			addressBookCommonValidation();
			$contextmenu.exchangeMenuClickHandler($('#exchangeABContextMenu'));
		},
		enableRules: function (e) {
            /*console.log('fType: ' + fType + ' fId: ' + fId + ' category: ' + category, ' enableContextMenu: ' + enableContextMenu);
            console.log('enter enableRules');*/
			itemsDisabled[createMenu] = true;
			itemsDisabled[renameMenu] = true;
			itemsDisabled[deleteMenu] = true;

			if (e != null) {
				/*console.log('enter enableRules not null');*/

				var fType = e.data('folder');
				var fId = e.data('id');
				var category = e.data('category');
				var enable = e.data('enablecontextmenu');
				/*console.log(enable);*/
				var enableContextMenu = 'True' == enable;

				if (enableContextMenu) {
					/*console.log('enter enableContextMenu');*/
					if (fType == pfolder) {
						/*console.log('enter folder condition');*/
						var currentlevel = e.data('currentlevel');
						var allowlevel = e.data('allowlevel');
						var disablecreate = currentlevel >= allowlevel;

						var conditionParent = fId == '1009';
						if (!conditionParent) {
							itemsDisabled[renameMenu] = false;
							itemsDisabled[deleteMenu] = false;
						}

						if (!disablecreate) {
							itemsDisabled[createMenu] = false;
						}

					} else if (fType == addrbook) {
						var abCurrentlevel = e.data('currentlevel');

						if (abCurrentlevel == 0) {
							itemsDisabled[renameMenu] = true;
							itemsDisabled[deleteMenu] = true;
							itemsDisabled[createMenu] = false;
						}

						if (abCurrentlevel == 1) {
							itemsDisabled[renameMenu] = false;
							itemsDisabled[deleteMenu] = false;
							itemsDisabled[createMenu] = true;
						}

					} else if (fType == doc) {
						/*console.log('enter doc condition');*/

						var condition1 = fId == '0';
						var condition2 = fId == '9999';

						if (condition2 && category == '0') {
							itemsDisabled[createMenu] = false;
						}

						if (!condition1 && !condition2) {
							itemsDisabled[renameMenu] = false;
							itemsDisabled[deleteMenu] = false;
						}
					}
				}
			}
		},
		personalfolder: function (e) {
			$.contextMenu({
				selector: e,
				items: {
					"1": {
						name: "Add", icon: "add", disabled: function (key, opt) {
							return !!itemsDisabled[key];
						}
					},
					"2": {
						name: "Rename", icon: "edit", disabled: function (key, opt) {
							return !!itemsDisabled[key];
						}
					},
					"3": {
						name: "Delete", icon: "delete", disabled: function (key, opt) {
							return !!itemsDisabled[key];
						}
					},
				},
				callback: function (key, options) {
					actionType = key;
					folderId = options.$trigger.attr("data-id");
					folderType = options.$trigger.attr("data-folder");
					routeName = options.$trigger.attr("data-route");
					requestFolderId = folderId;
					requestLevel = options.$trigger.attr("data-currentlevel") != null ? options.$trigger.attr("data-currentlevel") : "0";
					requestAllowLevel = options.$trigger.attr("data-allowlevel") != null ? options.$trigger.attr("data-allowlevel") : "0";
					/*open dialong for create and rename*/
					if (actionType === pfolder || actionType === renameMenu) {
						$('#txtFolderName').val($areaResources.actionTitle.newFolder);
						if (actionType === renameMenu) {
							$('#txtFolderName').val($("span[data-parentId='" + folderId+"']").text());
						}
						$('#newName-Modal').modal('show');
                        if (actionType === pfolder) {
                            $("#context-title").text($areaResources.actionTitle.createFolder);
						}
						else {
                            $("#context-title").text($areaResources.actionTitle.renameFolder);
						}

					} else {
						$contextmenu.performAction();
						var getParentId = options.$trigger.parent("ul").parent("li");
						getParentId = getParentId != null && getParentId.length ? options.$trigger.parent("ul").parent("li").data("id") + "" : "";
						requestFolderId = getParentId;
					}
				},
				events: {
                    show: function (opt) {
                        $contextmenu.enableRules($(this));
                        
                        /*check sidebar toggle*/
						var miniSideBar = $('body:not(.show-sidebar)').hasClass('mini-sidebar');
                        if (miniSideBar) {
                            /*open side nav*/
                            $('.sidebartoggler').click();

                            /*get menu link element*/
                            var menuElem = $(this).children('a:not(".clickablelink-arrow")');
                            if (menuElem && menuElem.length === 0) {
                                menuElem = $(this).children('a');
                            }

                            /*check link attr*/
                            var ulExpand = menuElem.attr('aria-expanded');
                            var hrefAttr = menuElem.attr('href');

                            /*select new menu*/
                            if ("#" === hrefAttr) {
                                /*non clickable*/
                                var parenttMenu = menuElem.parent().parent().parent();
                                var parentMenuLink = parenttMenu.children('a');
                                var parentMenuLinkExpand = parentMenuLink.attr('aria-expanded');
                                if ("true" !== parentMenuLinkExpand) {
                                    
                                    var childMenu = menuElem.parent().children('ul');
                                    var firstMenuParent = $(childMenu.children('li')[0]);
                                    var firstMenu = firstMenuParent.children('a:not(".clickablelink-arrow")');
                                    if (firstMenu && firstMenu.length === 0) {
                                        firstMenu = $(this).children('a');
                                    }
                                    /*select first menu*/
                                    firstMenu.click();
                                }
                            } else {
                                var isExpand = 'true' === ulExpand;
                                if (menuElem && menuElem.length > 0 && !isExpand) {
                                    menuElem.click();
                                }
                            }
                        }
					},
                    hide: function (opt) {
						$contextmenu.enableRules(null);
					}
				},
			});
		},
		performAction: function (e) {

			var obj = {
				"NodeValue": Number(folderId),
				"ActionType": Number(actionType),
				"FolderType": Number(folderType),
				"NewName": newName,
				"RouteName": routeName,
				"RequestFolderId": Number(requestFolderId),
				"RequestLevel": Number(requestLevel),
				"RequestAllowLevel": Number(requestAllowLevel)
			};
			var textString = $areaResources.swal.userDataFolder;

			if (actionType === deleteMenu) {
				swal({
					title: "",
					text: textString,
					type: "info",
					showCancelButton: true,
					closeOnConfirm: false,
					reverseButtons: true,
					showLoaderOnConfirm: true
				}, function () {
					fxcRequest.post('/User/UserCommon/ContextMenuAction',
						obj,
						function (data) {
							var getRouteName = data.RouteName + "";
							var getLink = $("nav.sidebar-nav ul li[data-route='" + getRouteName + "'][data-id='" + data.Value + "']");
							var getSiblingId = getLink.prev("li").length > 0 ? getLink.prev("li").attr("data-id") : getLink.siblings("li:first").attr("data-id");
							var getRelatedId = getLink.siblings("li").length > 0 ? getSiblingId : getLink.parent().parent().attr("data-id");

							$contextmenu.removeFolder(data.Value);
							$contextmenu.reloadContent("", getRouteName, getRelatedId);
							swal($globalMessages.swal.success.title, $globalMessages.swal.success.delete, "success");
						},
						function (error) {

                            swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
						});
				});
			}
			else {
				fxcRequest.post('/User/UserCommon/ContextMenuAction',
					obj,
					function (data) {
						var menuList = data.MenuHtml;
						var getMenuLink = data.MenuLink + "";
						var getValueLink = data.ValueLink + "";
						var getRequestID = data.RequestFolderId + "";
						var getRouteName = data.RouteName + "";
						if (actionType === renameMenu) {
							$contextmenu.renameFolder(data.Value, data.Text, data.MenuLink, getValueLink);
						}
						else if (actionType === createMenu) {
							$contextmenu.addFolder(menuList, getRouteName, getRequestID);
						}
						$contextmenu.reloadContent(getMenuLink, getRouteName);
						swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");
					},
					function (error) {
                        swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
					});
			}
			$('#newName-Modal').modal('hide');
		},
		removeFolder: function (id) {
			var liId = 'li[data-id="' + id + '"]';
			var parentLink = $(liId).parent("ul");
			$(liId).remove();
			if (!$(parentLink).children().length) {
				$(parentLink).siblings("a").removeClass("has-arrow");
			}
		},
		addFolder: function (menuList, route, requestId) {

			var parentLink = "nav.sidebar-nav ul li[data-route='" + route + "'][data-id='" + requestId + "'] ul:first";
			$(parentLink).append(menuList);
			if (!$(parentLink).children("li").length || !$(parentLink).siblings("a[href='#']:not(.clickablelink)").hasClass("has-arrow")){
				$(parentLink).siblings("a[href='#']:not(.clickablelink)").addClass("has-arrow");

				$("nav.sidebar-nav").metisMenu('dispose');
				$("nav.sidebar-nav").metisMenu();
			
			}
		},
		renameFolder: function (id, title, link, getValueLink) {
			var liId = 'li[data-id="' + id + '"]';
			var getLink = $(liId).children("a[data-id='" + id + "']");
			if ($(liId).children("a[data-id='" + id + "']").length) {
				$(liId).children("a[data-id='" + id + "']").attr("title", title);
				$(liId).children("a[data-id='" + id + "']").attr("value", getValueLink);
				$(liId).children("a[data-id='" + id + "']").attr("data-href", link);
				$(liId).children("a[data-id='" + id + "']").children("span[data-parentId='" + id + "']").text(title);
			}
		},

		exchangeMenuClickHandler: function (e) {
			$(e).on('click', function () {
				$contextmenu.getExchangeFolders();
			});
		},

		/* Action Handler */
		getExchangeFolders: function (e) {
			var count = $("#exchangeABULMenu li").length;

			if (count == 0) {
                $("#exchangeABULMenu").append('<li class="sub_menu">' + $areaResources.swal.pleaseWait + '</li>');

				fxcRequest.get('/user/addressbook/exchange',
					{
					},
					function (data) {
						$("#exchangeABULMenu").empty();
						Object.keys(data).forEach(function (key) {
							var idURL = data[key].Id.replace(/[_\W]+/g, "_").toLowerCase();
							$("#exchangeABULMenu").append('<li class="sub_menu"><a title="' + data[key].Name + '" href="/user/?linkID=exchange_' + data[key].Id + '" id="exchange_' + idURL + '" value="/user/addrbook/?id=' + data[key].Id + '&name=' + data[key].Name + '&addressbook=exchange" data-href="/user/addrbook/?id=' + data[key].Id + '&name=' + data[key].Name + '&addressbook=exchange&linkID=exchange_' + idURL + '">' + data[key].Name + '</a></li>');
						});
					},
					function (error) {
                        $("#exchangeABULMenu").empty();
                        swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.SwalErrorOccured, "error");
					});
			}
		},

		reloadContent: function (linkId, route, parentId) {
			linkId = linkId + "";
			var defaultLink = "nav.sidebar-nav ul li[data-route='" + route + "'][data-category]";

			setTimeout(function () {
				if (linkId.length) {
					linkId = "a[data-href=\'" + linkId + "\']";

					var getNavLink = defaultLink + " " + linkId;
					getNavLink = getNavLink.split("&#39;").join("'");
					if ($(getNavLink).length > 0) {
						$(getNavLink).trigger('click');
					}
					else {
						/*Select first default link if unable to load */
						$('nav.sidebar-nav ul li a[href!="#"][data-href]:first').trigger('click');
					}
				}
				else {
					var currentLink = $("nav.sidebar-nav ul li[data-route='" + route + "'][data-id='" + parentId + "']");
					$contextmenu.resetLink(currentLink);
				}
			}, 200);
		},
		resetLink: function (route) {
			var success = false;
			var getLink = $(route);

			for (var count = 0; count < getLink.length; count++) {
				if ($(getLink[count]).find("a[href!='#'][data-href]:first").length) {
					success = true;
					$(getLink[count]).find("a[href!='#'][data-href]:first").click();
					break;
				}
			}
			if (!success) {
				var getParentRoute = getLink.parent().parent("li");
				$contextmenu.resetLink(getParentRoute);
			}
		}
	};

	$commontree = {
		setNodeAttribute: function (treeArr, treeid) {

			if (treeid === 'recContactTree') {
				$.each(treeArr, function (index, value) {

					var icon = "<span>" + value.icon + "</span> ";
					var category = value.category;
					var id = value.id.toString();
					/*$("li[data-id='" + id + "']").attr("data-icon", icon);*/
					$("li[data-id='" + id + "']").attr("data-category", category);

					if (id === '9999' || id === '0') {
						var root = $('.list-group-item[data-id="' + id + '"]').children('div')
							.children('[data-role="display"]');

						/* prevent click on header */
						if (id === '9999') {

							root.css("pointer-events", "none");
						}

						/**/

						var selectedtext = value.text;

						$.each(root, function (i, v) {
							if (v.textContent === selectedtext) {

								$(this).html('<span><i class="fa fa-address-book"></i></span> ' + v.textContent);
							}
						});
					}
					else {
						var span = $('.list-group-item [data-id="' + id + '"]').children()
							.children('[data-role="display"]');

						span.prepend(icon);
					}

					var treeArrchild = value.children;
					$commontree.setNodeAttribute(treeArrchild, treeid);
				});
			}

			if (treeid == 'docTree') {
				$.each(treeArr, function (index, value) {

					var icon = "<span>" + value.icon + "</span> ";
					var category = value.category;
					var id = value.id.toString();
					/*$("li[data-id='" + id + "']").attr("data-icon", icon);*/
					$("li[data-id='" + id + "']").attr("data-category", category);


					if (id === '9999' || id === '0') {
						var root = $('.list-group-item[data-id="' + id + '"]').children('div')
							.children('[data-role="display"]');

						/* prevent click on header */
						if (id === '9999' || id === '0') {

							root.css("pointer-events", "none");
						}

						/**/

						var selectedtext = value.text;

						$.each(root, function (i, v) {
							if (v.textContent === selectedtext) {

								$(this).html('<span><i class="mdi mdi-file-document"></i></span> ' + v.textContent);
							}
						});
					}
					else {
						var span = $('.list-group-item [data-id="' + id + '"]').children()
							.children('[data-role="display"]');

						if (span.length > 1) {
							var string = '<span>' + span[0].innerText + '</span>';

							$('.list-group-item [data-id="' + id + '"]').children()
								.children('[data-role="display"]').html(string);
						}

						$('.list-group-item [data-id="' + id + '"]').children()
							.children('[data-role="display"]').prepend(icon);
					}

					var treeArrchild = value.children;
					$commontree.setNodeAttribute(treeArrchild, treeid);
				});
			}
		}
	};

	$commonModelMapping = {
		constructModel: function (formId) {
			var arr = {};

			$.each($("#" + formId + " input"), function (i, v) {

				if (v.type == 'text' || v.type == 'password')
					arr[v.id] = v.value;

				if (v.type == 'checkbox')
					arr[v.id] = $(this).prop("checked");
			});

			$.each($("#" + formId + " select"), function (i, v) {
				arr[v.id] = $(this).val();
			});

			return arr;
		}
	};
})(window.jQuery);