﻿var form = (function ($, host) {
  return {
    load: function (options) {
      this.keepAll = false;

      this.settings = $.extend({}, this._formLoadOptions, options);
      this.settings = this._setInitialState(this.settings);

      if (this.settings.hasBootstrapSwitch) {
        $('.switch-radio1').bootstrapSwitch();
      }

      if (this.settings.hasSelect) {
        $('.select2_single').select2();
      }

      if (this.settings.hasICheckbox) {
        $("input.flat.edit").iCheck({
          checkboxClass: "icheckbox_flat-green",
          radioClass: "iradio_flat-green"
        });
      }

      if ($('[data-tooltip="tooltip"]').length > 0)
        $('[data-tooltip="tooltip"]').tooltip();
      if ($('[rel="tooltip"]').length > 0)
        $('[rel="tooltip"]').tooltip();

      if (this.settings.multiple.length > 0) {
        $.each(this.settings.multiple, $.proxy(function (k, v) {
          this._init(v);
        }, this));
      }
      else {
        this._init(this.settings.name);
      }
    },

    _init: function (name) {
      var $edit_click = '.' + name + (this.settings.edit.suffix.startsWith('_') ? this.settings.edit.suffix : '_' + this.settings.edit.suffix); /*edit_click',*/
      $edit_cancel = '.' + name + (this.settings.cancel.suffix.startsWith('_') ? this.settings.cancel.suffix : '_' + this.settings.cancel.suffix); /* edit_cancel',*/
      $edit_save = '.' + name + (this.settings.save.suffix.startsWith('_') ? this.settings.save.suffix : '_' + this.settings.save.suffix);/*edit_save',*/
      $edit = name;
      /*console.log('id:' + this.settings.id);
      console.log('name: ' + name);
      console.log((this.settings.multiple.length > 0 && this.settings.id));*/
      if (this.settings.id || (this.settings.multiple.length > 0 && this.settings.id)) {
        console.log('here');
        $edit = name + ((this.settings.multiple.length > 0) ? '' : '_' + this.settings.id);
        console.log('edit: ' + $edit);
        $edit_click = '.' + $edit + (this.settings.edit.suffix.startsWith('_') ? this.settings.edit.suffix : '_' + this.settings.edit.suffix); /*edit_click';*/
        console.log('edit click: ' + $edit_click);
        $edit_cancel = '.' + $edit + (this.settings.cancel.suffix.startsWith('_') ? this.settings.cancel.suffix : '_' + this.settings.cancel.suffix); /* edit_cancel';*/
        $edit_save = '.' + $edit + (this.settings.save.suffix.startsWith('_') ? this.settings.save.suffix : '_' + this.settings.save.suffix);/*edit_save';*/
        var $edit_div = '.' + name + '_edit',
            $view_div = '.' + name + '_view',
            $edit_div_id = '.' + $edit + '_edit',
            $view_div_id = '.' + $edit + '_view';

        /* console.log('name: ' + name);
        console.log('$edit_click: ' + $edit_click);
        console.log('$edit_cancel: ' + $edit_cancel);
        console.log('$edit_save: ' + $edit_save);
        console.log('$edit_div: ' + $edit_div); */

        if (this.settings.multiple.length == 0) {
          var $exist_EditClick = $edit_click.replace('_' + this.settings.id, '');
          $($exist_EditClick).removeClass($exist_EditClick.substr(1)).addClass($edit_click.substr(1));

          var $exist_EditCancel = $edit_cancel.replace('_' + this.settings.id, '');
          $($exist_EditCancel).removeClass($exist_EditCancel.substr(1)).addClass($edit_cancel.substr(1));

          var $exist_EditSave = $edit_save.replace('_' + this.settings.id, '');
          $($exist_EditSave).removeClass($exist_EditSave.substr(1)).addClass($edit_save.substr(1));

          $('div' + $edit_div).removeClass($edit_div.substr(1)).addClass($edit_div_id.substr(1));
          $('div' + $view_div).removeClass($view_div.substr(1)).addClass($view_div_id.substr(1));
        }
        else {
          $($edit_click).attr('data-name', name);
          $($edit_cancel).attr('data-name', name);
          $($edit_save).attr('data-name', name);
        }
      }
      else {
        $($edit_click).attr('data-name', name);
        $($edit_cancel).attr('data-name', name);
        $($edit_save).attr('data-name', name);
        console.log('toggle click');
        this.toggleClick(true, name);
      }

      if (this.settings.edit.enabled) {
        if (typeof (this.settings.edit.onClick) === 'function') {
          $($edit_click).on('click', $.proxy(this.settings.edit.onClick, this));
        }
        $($edit_click).on('click', $.proxy(this._editClick, this));
      }

      if (this.settings.save.enabled) {
        if (typeof (this.settings.save.onClick) === 'function') {
          $($edit_save).on('click', $.proxy(this.settings.save.onClick, this));
        }
        $($edit_save).on('click', $.proxy(this._saveClick, this));
      }

      if (this.settings.cancel.enabled) {
        if (typeof (this.settings.cancel.onClick) === 'function') {
          $($edit_cancel).on('click', $.proxy(this.settings.cancel.onClick, this));
        }
        $($edit_cancel).on('click', $.proxy(this._cancelClick, this));
      }

      if (this.settings.add.enabled) {
        /*var addName = this.settings.add.id.startsWith('.') ? this.settings.add.id : '.' + this.settings.add.id;*/
        var addName = (this.settings.add.multiple === undefined) ? (this.settings.add.id.startsWith('.') ? this.settings.add.id : '.' + this.settings.add.id) :
         ('.' + name + (this.settings.add.id.startsWith('_') ? '' : '_') + (this.settings.add.id.startsWith('.') ? this.settings.add.id.substr(1) : this.settings.add.id));


        if (typeof (this.settings.add.onClick) === 'function') {
          $(addName).on('click', $.proxy(this.settings.add.onClick, this));
        }
      }

      if (this.settings.refresh.enabled) {
        var refresh = this.settings.refresh.id.startsWith('.') ? this.settings.refresh.id : '.' + this.settings.refresh.id;
        if (typeof (this.settings.refresh.onClick) === 'function') {
          $(refresh).on('click', $.proxy(this.settings.refresh.onClick, this));
        }
        $(refresh).on('click', function (ev) { location.reload(); });
      }

      if (this.settings.keepAll.enabled) {
        /*var keepAll = '.' + name + '_edit_' + (this.settings.keepAll.id.startsWith('.') ? this.settings.keepAll.id.substr(1) : this.settings.keepAll.id);*/
        var keepAll = (this.settings.keepAll.multiple === undefined) ? (this.settings.keepAll.id.startsWith('.') ? this.settings.keepAll.id : '.' + this.settings.keepAll.id) :
          ('.' + name + (this.settings.keepAll.id.startsWith('_') ? '' : '_') + (this.settings.keepAll.id.startsWith('.') ? this.settings.keepAll.id.substr(1) : this.settings.keepAll.id));

        console.log('keepAll = ' + keepAll);
        if (typeof (this.settings.keepAll.onClick) === 'function') {
          $(keepAll).on('click', $.proxy(this.settings.keepAll.onClick, this));
        }
        $(keepAll).on('click', $.proxy(this._keepAll, this));
      }

      $.each(this.settings.others, function (index, btn) {
        if (typeof (btn.onClick) === 'function' && btn.enabled && (!btn.name || (btn.name == name && btn.name))) {
          var elName = btn.id.startsWith('.') ? btn.id : '.' + btn.id; /*btn.name.startsWith('.') ? btn.name : '.' + btn.name;*/
          $(elName).on('click', $.proxy(btn.onClick, this));
        }
      });

      $.each(this.settings.bindJsonLib, $.proxy(function (k, v) {
        $.getJSON(v.url, function (jsData) {
          $('[name="' + v.name + '"]').select2({
            placeholder: v.placeholder, /*"Select a priority",*/
            templateResult: form.formatJson,
            templateSelection: form.formatJson,
            data: jsData,
          });
        });
      }, this));
    },

    formatJson: function (data) {
      if (!data.value) { return data.text; }
      return $('<span value="' + data.value + '">' + data.text + "</span>");
    },

    _setInitialState: function (options) {
      options = this._checkProperty(options, 'edit', {
        'suffix': options.edit.suffix !== undefined ? options.edit.suffix : 'edit_click',
        'onClick': options.edit.onClick,
        'enabled': options.edit.enabled
      });
      options = this._checkProperty(options, 'save', {
        'suffix': options.save.suffix !== undefined ? options.save.suffix : 'edit_save',
        'onClick': options.save.onClick,
        'enabled': options.save.enabled
      });
      options = this._checkProperty(options, 'cancel', {
        'suffix': options.cancel.suffix !== undefined ? options.cancel.suffix : 'edit_cancel',
        'onClick': options.cancel.onClick,
        'enabled': options.cancel.enabled
      });
      options = this._checkProperty(options, 'keepAll', {
        'suffix': options.keepAll.suffix !== undefined ? options.keepAll.suffix : 'keep_all',
        'onClick': options.keepAll.onClick,
        'enabled': (options.keepAll.enabled === undefined ? false : options.keepAll.enabled),
        'id': options.keepAll.id
      });
      options = this._checkProperty(options, 'add', {
        'suffix': options.add.suffix !== undefined ? options.add.suffix : 'add',
        'onClick': options.add.onClick,
        'enabled': (options.add.enabled === undefined ? false : options.add.enabled),
        'id': options.add.id
      });
      options = this._checkProperty(options, 'refresh', {
        'suffix': options.refresh.suffix !== undefined ? options.refresh.suffix : 'refresh',
        'onClick': options.refresh.onClick,
        'enabled': (options.refresh.enabled === undefined ? false : options.refresh.enabled),
        'id': options.refresh.id
      });

      if (options.others) {
        $.each(options.others, $.proxy(function (index, value) {
          options.others = this._checkProperty(options.others, value.id, value);/* null, null, value.onClick, null);*/
        }, this));
      }

      return options;
    },

    _editClick: function (ev) { this.toggleClick(null, (this.settings.multiple.length > 0 ? $(ev.currentTarget).data('name') : null)); },
    _saveClick: function (ev) {
      if (!this.settings.id && (typeof (this.settings.table) === 'object')) {
        this.settings.table.data().tbl.closeEditRow(null, (this.settings.multiple.length > 0 ? $(ev.currentTarget).data('name') : this.settings.name), this.settings.isModal);
      }
      else {
        if (this.settings.id)
          this.toggleClick(false, (this.settings.multiple.length > 0 ? $(ev.currentTarget).data('name') : null));
      }
    },
    _cancelClick: function (ev) {
      if (!this.settings.id && (this.settings.table !== null)) {
        this.settings.table.data().tbl.closeEditRow(null, (this.settings.multiple.length > 0 ? $(ev.currentTarget).data('name') : this.settings.name), this.settings.isModal);
      }
      else {
        if (this.settings.id)
          this.toggleClick(false, (this.settings.multiple.length > 0 ? $(ev.currentTarget).data('name') : null));
      }
    },

    _checkProperty: function (object, propName, obj) {
      if (object.hasOwnProperty(propName)) {
        if (obj.suffix !== undefined) {
          if (!object[propName].hasOwnProperty('suffix')) {
            object[propName].suffix = obj.suffix;
          }
        }

        if (obj.onClick !== undefined) {
          if (!object[propName].hasOwnProperty('onClick') || object[propName].onClick === undefined) {
            object[propName].onClick = obj.onClick;
          }
        }
        
        if (!object[propName].hasOwnProperty('enabled')) {
          object[propName].enabled = (obj.enabled !== undefined) ? obj.enabled : true;
        }

        if (obj.name !== undefined) {
          if (!object[propName].hasOwnProperty('name')) {
            object[propName].name = obj.name;
          }
        }

        if (obj.id !== undefined) {
          if (!object[propName].hasOwnProperty('id')) {
            object[propName].id = obj.id;
          }
        }
      }
      else {
        object[propName] = {
          'id': propName,
          'name': obj.name ? obj.name : undefined,
          'onClick': obj.onClick ? obj.onClick : undefined,
          'enabled': (obj.enabled === undefined) ? true : obj.enabled,
        };

        if (obj.suffix !== undefined)
          object[propName].suffix = obj.suffix;
      }

      return object;
    },

    _formLoadOptions: {
      'id': '',
      'name': '',
      'multiple': [],
      'isModal': false,
      'hasBootstrapSwitch': false,
      'hasSelect': false,
      'hasICheckbox': false,
      'edit': {
        'suffix': 'edit_click',
        'enabled': true,
        'onClick': undefined
      },
      'save': {
        'suffix': 'edit_save',
        'enabled': true,
        'onClick': undefined
      },
      'cancel': {
        'suffix': 'edit_cancel',
        'enabled': true,
        'onClick': undefined
      },
      'add': {
        'enabled': false,
        'id': 'addrbook_add',
        'onClick': undefined,
        'multiple': [],
      },
      'refresh': {
        'enabled': false,
        'id': 'refresh',
        'onClick': undefined
      },
      'keepAll': {
        'id': 'keep_all',
        'enabled': false,
        'onClick': undefined,
        'multiple': [],
      },
      'others': {
        
      },
      'domain': undefined, 
      'table': undefined, 
      'bindJsonLib': [
      ]
    },

    _toggleBtn: function (options, btnName, editMode, name) {
      /*console.log(btnName + ' | ' + name + ' | ' + options[btnName].multiple + ' | ' + jQuery.inArray(name, options[btnName].multiple));*/
      if (options[btnName].enabled && (options[btnName].multiple === undefined ||
        (options[btnName].multiple.length > 0 && jQuery.inArray(name, options[btnName].multiple) > -1))) {

        var elName = (options[btnName].multiple === undefined) ? (options[btnName].id.startsWith('.') ? options[btnName].id : '.' + options[btnName].id) :
          ('.' + name + (options[btnName].id.startsWith('_') ? '' : '_') + (options[btnName].id.startsWith('.') ? options[btnName].id.substr(1) : options[btnName].id));
        /*console.log('toggle btn: ' + elName);*/

        if ($(elName).length > 0) {
          if (editMode) {
            if ($(elName).hasClass('hidden'))
              $(elName).removeClass('hidden');
            $(elName).show();
          }
          else {
            $(elName).hide();
          }
        }
      }
    },

    _toggleEdit: function (options, editMode, save, cancel, div, divEdit, name) {
      if (editMode) { /* edit mode is on toggle Edit form
        if ($(div).is(':visible')) {*/
        if ($(divEdit).hasClass('hidden'))
          $(divEdit).removeClass('hidden');
        if ($(save).hasClass('hidden'))
          $(save).removeClass('hidden');
        if ($(cancel).hasClass('hidden'))
          $(cancel).removeClass('hidden');

        $(div).hide();
        $(divEdit).show();
        $(cancel).show();
        $(save).show();


        if (options.others) {
          $.each(options.others, $.proxy(function (index, value) {
            if (options.multiple.length == 0 || (value.name && value.name == name && options.multiple.length > 0)) {
              var elName = value.id.startsWith('.') ? value.id : '.' + value.id; /*value.name.startsWith('.') ? value.name : '.' + value.name;*/
              if ($(elName).length > 0) {
                if ($(elName).hasClass('hidden'))
                  $(elName).removeClass('hidden');
                $(elName).show();
              }
            }
          }, this));
        }

        this._checkOverflow();
      }
      else {
        this._checkOverflow();
        $(div).show();
        $(divEdit).hide();
        $(cancel).hide();
        $(save).hide();


        if (options.others) {
          $.each(options.others, $.proxy(function (index, value) {
            if (options.multiple.length == 0 || (value.name == name && options.multiple.length > 0)) {
              var elName = value.id.startsWith('.') ? value.id : '.' + value.id;/*value.name.startsWith('.') ? value.name : '.' + value.name;*/
              if ($(elName).length > 0) {
                $(elName).hide();
              }
            }
          }, this));
        }
      }

      this._toggleBtn(options, 'add', editMode, name);
      this._toggleBtn(options, 'refresh', editMode, name);
      this._toggleBtn(options, 'keepAll', editMode, name);
    },

    toggleClick: function (editMode, multipleName) {
      var name = (multipleName) ? multipleName : (this.settings.id) ? this.settings.name + '_' + this.settings.id : this.settings.name;
      var save = '.' + name + '_' + this.settings.save.suffix;
      var cancel = '.' + name + '_' + this.settings.cancel.suffix;
      var div = 'div.' + name + '_view';
      var divEdit = 'div.' + name + '_edit';

      this._toggleEdit(this.settings, (editMode == null) ? $(div).is(':visible') : editMode, save, cancel, div, divEdit, name);
      this.adjustAdminContentHeight();
    },

    _checkOverflow: function () {
      var $rightCol = $('.right_col');
      if ($rightCol.get(0).scrollHeight > $rightCol.get(0).clientHeight && this.settings.domain != undefined) {
        domain.setFixedBlankWidth();
      }
    },

    _keepAll: function (ev) {
      var elName = this.settings.keepAll.id.startsWith('.') ? this.settings.keepAll.id : '.' + this.settings.keepAll.id;
      /*console.log(this.settings.keepAll.multiple);*/
      var chkName = 'input[type="checkbox"]' + (this.settings.keepAll.multiple === undefined ? '[name="keepLocal"]' : '[data-name="' + $(ev.currentTarget).data('name') + '"]');
      /*console.log('keep all : ' + chkName + '|' + this.keepAll);*/
      if (this.keepAll == true) {
        $(chkName).iCheck('uncheck');
        this.keepAll = false;
        $('.has_words' + elName).html('<i class="fa fa-check-square-o bottom-right-xs"></i> Keep All Local Setting');
        $(elName).attr('data-original-title', 'Keep all local setting');
      }
      else {
        $(chkName).iCheck('check');
        this.keepAll = true;
        $('.has_words' + elName).html('<i class="fa fa-check-square-o bottom-right-xs"></i> Allow Override All Local Settings');
        $(elName).attr('data-original-title', 'Allow override all local setting');
      }
    },

    adjustAdminContentHeight: function () {
      var winWidth = $(window).width();

      if ($('.div_panel_toolbox').length > 0) {
        if ($('.div_panel_toolbox').innerHeight() > 30) {
          if (window.matchMedia('(min-width:768px) and (max-width:991px)').matches) {
            if ($('.div_panel_toolbox').hasClass('col-sm-2')) {
              $('.div_panel_toolbox').removeClass('col-sm-2').addClass('col-sm-12');
              $('.admin_content').css('padding-top', '80px');
            }
          }
          else if (window.matchMedia('(min-width:992px) and (max-width:1199px)').matches) {
            if ($('.div_panel_toolbox').hasClass('col-md-1')) {
              $('.div_panel_toolbox').removeClass('col-md-1').addClass('col-md-12');
              $('.admin_content').css('padding-top', '80px');
            }
            else if ($('.div_panel_toolbox').hasClass('col-md-2')) {
              $('.div_panel_toolbox').removeClass('col-md-2').addClass('col-md-12');
              $('.admin_content').css('padding-top', '80px');
            }
          }
          else if (window.matchMedia('(min-width:1200px)').matches) {
            if ($('.div_panel_toolbox').hasClass('col-lg-2')) {
              $('.div_panel_toolbox').removeClass('col-lg-2').addClass('col-lg-12');
              $('.admin_content').css('padding-top', '80px');
            }
          }
        }
        else {
          if (window.matchMedia('(min-width:768px) and (max-width:991px)').matches) {
            if ($('.div_panel_toolbox').hasClass('col-sm-12')) {
              $('.div_panel_toolbox').removeClass('col-sm-12').addClass('col-sm-2');
              $('.admin_content').css('padding-top', '50px');
            }
          }
          else if (window.matchMedia('(min-width:992px) and (max-width:1199px)').matches) {
            if ($('.div_panel_toolbox').hasClass('col-md-12')) {
              if ($('.dmn-dropdown-outer').hasClass('col-md-7')) {
                $('.div_panel_toolbox').removeClass('col-md-12').addClass('col-md-1');
              }
              else {
                $('.div_panel_toolbox').removeClass('col-md-12').addClass('col-md-2');
              }

              $('.admin_content').css('padding-top', '50px');
            }

          }
          else if (window.matchMedia('(min-width:1200px)').matches) {
            if ($('.div_panel_toolbox').hasClass('col-lg-12')) {
              $('.div_panel_toolbox').removeClass('col-lg-12').addClass('col-lg-2');
              $('.admin_content').css('padding-top', '50px');
            }
          }
        }
      }
    }
  };

})(jQuery, document);
