﻿; (function ($, window, document, undefined) {
  var pluginName = 'tbl';

  function fxTbl(element, options) {
    this.element = $(element);
    this._name = pluginName;
    this._defaults = $.fn.table.defaults;

    this.options = $.extend({}, this._defaults, options);
    this.options = this._setInitialState(this.options);
    this.init();
  }

  $.extend(fxTbl.prototype, {
    /* initialize function*/
    init: function () {      
      this.buildCache();
      this.render();
      this.bindEvents();
    },

    /* set initial state of options (set default value)*/
    _setInitialState: function (options) {      
      $.each(options.actions, $.proxy(function (k, v) {
        v = this._checkProperty(v, k);
      }, this));

      return options;
    },

    /* check property of actions in options.*/
    _checkProperty: function (object, objName) {
      object = this._addObjProperty(object, 'enabled', false);
      object = this._addObjProperty(object, 'row', false);
      var defaultIcon = '';
      var defaultClass = '';
      if (objName == 'edit') {
        defaultIcon = 'fa fa-eye';
        defaultClass = 'btn btn-primary btn-xs';
      }
      else if (objName.indexOf('delete') > -1) {
        defaultIcon = 'fa fa-trash';
        defaultClass = 'btn btn-danger btn-xs';
      }
      object = this._addObjProperty(object, 'icon', defaultIcon);

      object = this._addObjProperty(object, 'class', defaultClass);
      object = this._addObjProperty(object, 'tooltip', '');
      object = this._addObjProperty(object, 'label', '');
      object = this._addObjProperty(object, 'onClick', undefined);
      object = this._addObjProperty(object, 'name', objName);

      return object;
    },

    /* add action object's property if it is not exist in the options */
    _addObjProperty: function (object, propName, defValue) {
      if (!object.hasOwnProperty(propName)) {
        object[propName] = defValue;
      }

      return object;
    },

    destroy: function () {

      if (!this.initialized) return;

      this.$wrapper.remove();
      this.$wrapper = null;

      this.unbindEvents();
      this.$element.removeData();

      /* Reset this.initialized flag*/
      this.initialized = false;
    },

    buildCache: function () {
      this.$element = $(this.element);
      /*this.$element.append('')*/
    },

    /* get default events handler method*/
    _getHandler: function (name) {
      var handler = undefined;
      switch (name) {
        case 'add':
          handler = this.add_new;
          break;
        case 'edit':
          handler = this.edit_row;
          break;
        case 'delete':
          handler = this.delete_selected;
          break;
        case 'deleteRow':
          handler = this.delete_row;
          break;
        case 'deleteAll':
          handler = this.delete_all;
          break;
        case 'refresh':
          handler = this.refresh;
          break;
      }
      return handler;
    },
    
    /* bind event handler to controllers*/
    bindEvents: function () {
      $.each(this.options.actions, $.proxy(function (k, v) {
        if (v.enabled) {
          var name = this.getClassName(v.name ? v.name : k);
          var n = '[name="' + (v.name ? v.name : k) + '"]';
          var el = $(n);/*$(this.getElClassName(name));*/
          console.log('name: ' + n);
          if (el.length == 0) {
            n = this.getElClassName(name);
            console.log('name2: ' + n);
            el = $(n);
          }

          if (el.length > 0) {
            var a = ['add', 'edit', 'delete', 'refresh', 'deleteAll', 'deleteRow'];
            if ($.inArray(k, a) > -1) {
              if (k == 'edit' && this.options.editLayout.toLowerCase() == 'new') {
                var url = (this.options.url.endsWith('/') ? this.options.url : this.options.url + '/') + '?id=' + el.data('id');
                el.attr('href', url);
              }
              else {
                el.on('click', $.proxy(function (ev) { this._getHandler(k).call(this, $(ev.currentTarget)); }, this));
              }
            }

            if (v.onClick) {
              el.on('click', $.proxy(v.onClick, this));
            }
          }
        }
      }, this));

      if ($('#' + this.element.attr('id') + ' .bulk_action').length > 0) {
        $('#' + this.element.attr('id') + ' .bulk_action input').on('ifChecked', $.proxy(function (ev) {
          this.checkState = "";
          if ($('#' + this.element.attr('id') + ' .bulk_action input[name="table_records"]').filter(':checked').length == ($('#' + this.element.attr('id') + ' .bulk_action input[name="table_records"]').length)) {
            this.checkState = 'all';
            $('#' + this.element.attr('id') + ' .bulk_action input#check-all').iCheck('check');
          }
          
          $(ev.currentTarget).parents().closest('tr').addClass('selected'), 
           this.cchecked();
        }, this)), $('#' + this.element.attr('id') + ' .bulk_action input').on("ifUnchecked", $.proxy(function (ev) {
          
          this.checkState = ($($(ev.target)[0]).attr('id') == 'check-all' && this.checkState != "uncheck") ? "" : "uncheck";
          $('#' + this.element.attr('id') + ' .bulk_action input#check-all').iCheck('uncheck');
          
          $(ev.currentTarget).parents().closest('tr').removeClass('selected'),
           this.cchecked();
        }, this)), $('#' + this.element.attr('id') + ' .bulk_action input#check-all').on('ifChecked', $.proxy(function (ev) {
          this.checkState = "all",
          this.cchecked();
        }, this)), $('#' + this.element.attr('id') + ' .bulk_action input#check-all').on('ifUnchecked', $.proxy(function (ev) {
          if (this.checkState != 'uncheck') {
            this.checkState = "none",
            this.cchecked();
          }
          else {
            this.checkState = '';
          }
        }, this));
      }
      else {
        $('#' + this.element.attr('id') + ' table input').on("ifChecked", $.proxy(function (ev) {
          this.checkState = "",
          
          $(ev.currentTarget).parents().closest('tr').addClass("selected"),
          this.cchecked();
        }, this)), $('#' + this.element.attr('id') + ' table input').on("ifUnchecked", $.proxy(function () {
          this.checkState = "",
          
          $(ev.currentTarget).parents().closest('tr').removeClass("selected"),
          this.cchecked();
        }, this));
      }

      $(window).resize($.proxy(this.resize, this));
    },

    unbindEvents: function () {
      /*this.$element.off('.' + this._name);*/
    },

    /* default edit row event handler*/
    edit_row: function (el) {
      var tbl_name = this.options.tbl_name,
          colspan = this.colSpan + 2,
          url = this.options.url,
          closeClass = '.' + tbl_name + '_close',
          _this = this,
          editFormClass = tbl_name + '_edit_form';

      if (el != null) {
        if (!el.hasClass('clicked')) {
          var $curr = el.attr('id'),
            $id = el.attr('data-id');
          if (el.attr('id')) url = url + (url.endsWith('/') ? '' : '/') + '?id=' + $id;          

          switch (this.options.editLayout.toLowerCase()) {
            case 'bottom':
              this._editRowBottom(el, tbl_name, colspan, url, closeClass, editFormClass, _this, $curr);
              break;
            case 'side':
              if (window.matchMedia('(min-width:1200px)').matches) {
                if ($('a.clicked').length > 0) {
                  $('a.clicked').removeClass('clicked');
                  $('.edit-panel').remove();
                }

                this.element.parents().closest('.' + this.options.tbl_name + '_tbl').addClass('col-lg-3');
                var div = $(this.template.div);

                div.load(url);                
                var divEditPanel = $(this.template.div).addClass('edit-panel col-lg-9').attr('id', $curr);
                
                divEditPanel.append(div);                

                divEditPanel.outerHeight(this.$element.parents().closest('.x_panel').outerHeight());
                this.element.parents().closest('.' + this.options.tbl_name + '_tbl').parent().append(divEditPanel);

                setTimeout(function () {
                  var $close = $(closeClass);
                  $close.click(function (e) {
                    _this.closeEditRow($close, tbl_name, false, true);
                  });
                }, 100);
              }
              else if (window.matchMedia('(max-width:767px)').matches) {
                this.closeEditRow($(closeClass), tbl_name, false, $('.edit-panel').length > 0 ? true : false);

                var $tbl = $('.' + this.options.tbl_name + '_tbl');
                if ($tbl.is(':visible')) {
                  $('.' + tbl_name + '_new').load(url);
                  $tbl.hide();

                  setTimeout(function () {
                    var $close = $(closeClass);
                    $close.click(function (e) {
                      _this.closeEditRow(null, tbl_name, false, true);
                    });
                  }, 100);
                }
              }
              else {
                this._editRowBottom(el, tbl_name, colspan, url, closeClass, editFormClass, _this, $curr);
              }
              break;
          }

          el.addClass('clicked');
        } else {
          _this.closeEditRow($(closeClass), tbl_name, false, $('.edit-panel').length > 0 ? true : false); 
        }
      }
    },

    /* setting edit view right below the row*/
    _editRowBottom: function (el, tbl_name, colspan, url, closeClass, editFormClass, _this, $curr) {      
      var $edit_form = $('.' + editFormClass), 
        $edit_row = $(this.getElClassName(this.getClassName(this.options.actions.edit.name ? this.options.actions.edit.name : 'edit')) + '.clicked'); 

      if ($edit_form.length > 0) {
        if ($edit_row.length > 0)
          $edit_row.removeClass('clicked');
        $edit_form.closest('tr').remove();
        $edit_form.remove();
      }
      
      el.closest('tr').after('<tr id="' + $curr + '"><td colspan="' + colspan + '"><div class="' + editFormClass + '" id="' + $curr + '"></div></td></tr>');

      $('#' + $curr + '.' + editFormClass).load(url);
      setTimeout(function () {
        var $close = $(closeClass);
        $close.click(function (e) {
          _this.closeEditRow($close, tbl_name);
        });
      }, 100);
    },

    /* close edit row */
    closeEditRow: function (el, tbl_name, isModal, side) {
      if (el) {
        this._closeEdit(el);
      }
      else {
        if (isModal == true) {
          $modal = $('#modal' + tbl_name);
          $modal.modal('hide');
        }
        else {
          $('.' + tbl_name + '_new').empty();
          $('.' + tbl_name + '_tbl').show();
          /* add additional coding to refresh table */
        }
      }
    },

    /* close edit row */
    _closeEdit: function (el) {
      var $edit_row = $('.clicked');
      if ($edit_row)
        $edit_row.removeClass('clicked');

      if ((window.matchMedia('(min-width:1200px)').matches) && this.options.editLayout.toLowerCase() === 'side') {
        this.element.parents().closest('.' + this.options.tbl_name + '_tbl').removeClass('col-lg-3');
        $('.edit-panel').remove();/*$('.edit-side.col-lg-9').remove();*/
      }
      else {
        var $edit_form = $('.' + this.options.tbl_name + '_edit_form');

        if ($edit_form && el) {
          if (el.closest('tr').attr('id') == $id)
            el.closest('tr').remove();
        }
      }
    },

    /* default add new event handler . required a div with class this.options.tbl_name + '_new'*/
    add_new: function () {
      var tbl_name = this.options.tbl_name,
        url = this.options.url;

      var $edit_form = $('.' + tbl_name + '_edit_form'),
        $tbl = $('.' + tbl_name + '_tbl');

      this._closeEdit();      

      if ($tbl.is(':visible')) {
        $('.' + tbl_name + '_new').empty();
        $('.' + tbl_name + '_new').load(url);
        $tbl.hide();
      }
    },

    /* default delete row event handler*/
    delete_row: function () {
      this.showDeleteConfirm(false);
    },

    /* default delete selected rows event handler */
    delete_selected: function () {
      this.showDeleteConfirm(true);
    },

    /* default delete all rows event handler */
    delete_all: function () {
      this.showDeleteConfirm(false, true);
    },

    /* render controls*/
    render: function () {
      if (!this.initialized) {
        this.$wrapper = $(this.template.table);
      }

      var $thead = this.buildHeader(this);

      this.$wrapper.append($thead);

      var $body = this.buildBody(this);
      this.$wrapper.append($body);

      this.$element.empty().addClass('table-responsive').append(this.$wrapper);

      this.initialized = true;

      setTimeout($.proxy(function () {
        this.resize();
      }, this), 100);

      $("input.flat")[0] && $(document).ready(function () {
        $("input.flat").iCheck({
          checkboxClass: "icheckbox_flat-green",
          radioClass: "iradio_flat-green"
        });
      });
    },

    /* default resize event handler to set table height */
    resize: function () {
      console.log('resize');
      if (this.options.setAutoHeight) {
        var $rightCol = $('.right_col');
        var $topNavi = $('.navbar-fixed-top');
        var $pageTitle = $('.page-title');
        var $pageTitleClearfix = $('.page-title').siblings('.clearfix');
        var titleHeight = $pageTitle.length > 0 ? $pageTitle.outerHeight() : 0;
        var topNaviHeight = $topNavi.length > 0 ? $topNavi.outerHeight() : 0;
        var clearfixHeight = $pageTitleClearfix.length > 0 ? $pageTitleClearfix.outerHeight() : 0;
        var tblHeight = $rightCol.outerHeight() - titleHeight - topNaviHeight - clearfixHeight;
        this.$element.parents().closest('.x_panel').height(tblHeight);
        this.$element.outerHeight(tblHeight);
      }
    },

    /* build table header*/
    buildHeader: function (_this) {
      var thead = $(this.template.thead);
      var tr = $(this.template.tr);
      var chkAll = $(this.template.th).append((this.template.checkboxAll));
      var hasBulkActions = (this.options.bulkActions !== undefined && this.options.bulkActions.enabled);
      var colspan = 0;

      if (this.options.showCheckbox)
        chkAll.appendTo(tr);

      $.each(this.options.column, $.proxy(function (key, value) {
        if (value.Display == true) {
          var th = $(this.template.th).html(value.Label).attr('Name', value.Name);
          if (value.Width) {
            th.attr('style', 'width:' + value.Width);
          }

          if (hasBulkActions)
            th.attr('class', 'column-title');
          th.appendTo(tr);
          colspan = colspan + 1;
        }
      }, this));
      if (this.options.showRowActions) {
        $(this.template.thAction).appendTo(tr);
        colspan = colspan + 1;
      }
      this.colSpan = colspan;

      tr.children().last().attr('class', (hasBulkActions) ? 'column-title no-link last' : 'no-link last');

      if (hasBulkActions) {
        var th = $(this.template.th).attr('class', 'bulk-actions').attr('colspan', this.colSpan);
        var div = $(this.template.baDiv);
        var linkDdl = $(this.template.baLinkDdl);
        var list = $(this.template.baList);
        $.each(this.options.bulkActions.actions, $.proxy(function (k, v) {
          var item = $(this.template.baListItem);
          if (v.divider) {
            var divider = $(this.template.baDivider);
            item.append(divider);
          } else {
            var link = $(this.template.baLink);
            if (v.icon) {
              var icon = $(this.template.baIcon);
              icon.attr('class', v.icon).html(' ' + v.name);
              link.append(icon);
            }
            else {
              link.html(v.name);
            }

            link.appendTo(item);

            if (v.onClick) {
              link.on('click', $.proxy(v.onClick, this));
            }
          }
          item.appendTo(list);
        }, this));

        div.append(linkDdl).append(list);
        th.append(div);
        th.appendTo(tr);
      }

      tr.appendTo(thead);
      return thead;
    },

    /* table body*/
    buildBody: function (_this) {
      var tbody = $(this.template.tbody);
      var odd = true;
      $.each(this.options.data, $.proxy(function (key, value) {

        var row = (odd) ? $(this.template.trOdd) : $(this.template.trEven);
        if (this.options.showCheckbox)
          $(this.template.tdCheckbox).appendTo(row);

        $.each(this.options.column, $.proxy(function (k, v) {
          if (v.Display == true) {
            var val = value[v.Name];

            var td = $(this.template.td).html(val);
            if (v.Width) {
              td.attr('style', 'width:' + v.Width);
            }

            td.appendTo(row);
          }
          else {
            if (v.Name == 'ID') {
              row.attr('id', value[v.Name]);
            }
          }
        }, this));

        if (this.options.showRowActions) {
          var tdAction = $(this.template.td);

          $.each(this.options.actions, $.proxy(function (k, v) {
            var action = this._createRowActions(v, row.attr('id'), k);
            if (action)
              action.appendTo(tdAction);
            /*if (v.onClick)
              action.on('click', $.proxy(v.onClick, this));*/
          }, this));

          tdAction.appendTo(row);
        }
        odd = !odd;
        tbody.append(row);
      }, this));

      return tbody;
    },

    /* create actions column per row*/
    _createRowActions(object, id, objName) {
      var link = undefined;
      if (object.enabled && object.row) {
        link = $(this.template.link);
        link.attr('class', object.class ? object.class : 'btn btn-primary btn-xs');
        var name = this.getClassName(object.name ? object.name : objName);
        var name_id = this._getId(name, id);
        if (name)
          link.attr('class', link.attr('class') + ' ' + name);

        link.attr('data-toggle', 'tooltip');
        link.attr('data-original-title', object.tooltip);
        link.attr('data-placement', 'top');
        link.attr('data-id', id);
        link.attr('id', name_id);/*this._getId(name, id));*/
        if (object.label) {
          link.html(object.label);
        }
        if (object.icon) {
          var icon = $(this.template.icon);
          icon.attr('class', object.icon);
          icon.appendTo(link);
        }
      }
      return link;
    },

    _getId: function (name, id) {
      return name + '_' + id;
    },

    /* template list */
    template: {
      mainDiv: '<div class="table-responsive"></div>',
      table: '<table class="table table-striped projects table_selection bulk_action"></table>',
      thead: '<thead></thead>',
      tr: '<tr></tr>',
      th: '<th></th>',
      thAction: '<th>Actions</th>',
      checkboxAll: '<input type="checkbox" id="check-all" class="flat" />',
      tbody: '<tbody></tbody>',
      trOdd: '<tr class="odd pointer"></tr>',
      trEven: '<tr class="even pointer"></tr>',
      tdCheckbox: '<td class="a-center "><input type="checkbox" class="flat" name="table_records"></td>',
      td: '<td></td>',
      /*editLink: '<a href="#" class="btn btn-primary btn-xs" data-placement="top" data-toggle="tooltip" data-original-title=""><i class="fa fa-eye"></i></a>',
      delLink: '<a href="#" class="btn btn-danger btn-xs" data-placement="top" data-toggle="tooltip" data-original-title=""><i class="fa fa-trash"></i></a>',*/
      baLinkDdl: '<a class="antoo dropdown-toggle" data-toggle="dropdown" aria-expanded="false" style="font-weight:500;">Actions (<span class="action-cnt"></span>) <i class="fa fa-chevron-down"></i></a>',
      baList: '<ul class="dropdown-menu animated fadeInDown" role="menu"></ul>',
      baListItem: '<li role="presentation"></li>',
      baLink: '<a></a>',
      baIcon: '<i></i>',
      baDivider: '<li role="presentation" class="divider"></li>',
      baDiv: '<div class="dropdown"></div>',
      link: '<a></a>',
      icon: '<i></i>',
      div: '<div></div>'
    },
    
    /* get element classname with dot at the front*/
    getElClassName: function (className) {
      return className.startsWith('.') ? className : '.' + className;
    },

    /* get class name by combine table name (options) with suffix. */
    getClassName: function (suffix) {
      return (suffix.startsWith(this.options.tbl_name)) ? suffix : (this.options.tbl_name) + (suffix.startsWith('_') ? suffix : '_' + suffix);
    },

    /* display delete confirm notification*/
    showDeleteConfirm: function (selection, deleteAll) {
      if (selection) {
        if (!this.showNoneSelected()) {
          return;
        }
      }

      (new PNotify({
        title: (deleteAll) ? this.options.notifyOptions.delAllTitle : this.options.notifyOptions.delTitle,
        text: (deleteAll) ? this.options.notifyOptions.delAllText : this.options.notifyOptions.delText,
        icon: 'fa fa-trash',
        hide: false,
        confirm: {
          confirm: true
        },
        buttons: {
          closer: false,
          sticker: false
        },
        history: {
          history: false
        },
        styling: 'bootstrap3',
        addclass: 'stack-modal',
        type: 'info',
        stack: { 'dir1': 'down', 'dir2': 'right', 'modal': true }
      })).get().on('pnotify.confirm', function () {
        
      }).on('pnotify.cancel', function () {
        
      });
    },

    /* display none selected notification*/
    showNoneSelected: function () {
      if ($('#' + this.element.attr('id') + ' .bulk_action input[name="table_records"]:checked').length == 0) {
        new PNotify({
          title: this.options.notifyOptions.selTitle,/*'None selected!',*/
          text: this.options.notifyOptions.selText,
          type: 'error',
          styling: 'bootstrap3'
        });
        return false;
      }
      return true;
    },

    /* default refresh event handler*/
    refresh: function () {
      location.reload();
    },

    /* show action menu on the table header if there are rows checked */
    cchecked: function () {
      "all" === this.checkState && $('#' + this.element.attr('id') + ' .bulk_action input[name="table_records"]').iCheck('check');
      "none" === this.checkState && $('#' + this.element.attr('id') + ' .bulk_action input[name="table_records"]').iCheck('uncheck');
      var e = $('#' + this.element.attr('id') + ' .bulk_action input[name="table_records"]:checked').length;
      e ? ($('#' + this.element.attr('id') + ' .column-title').hide(), $('#' + this.element.attr('id') + ' .bulk-actions').show(),
      $('#' + this.element.attr('id') + ' .action-cnt').html(e + " Records Selected")) :
      ($('#' + this.element.attr('id') + ' .column-title').show(),
      $('#' + this.element.attr('id') + ' .bulk-actions').hide());
    },
  });

  $.fn.table = function (options, args) {
    var result;

    this.each(function () {
      var _this = $.data(this, pluginName);

      if (typeof options === 'string') {
        if (!_this) {
          logError('Not initialized, can not call method : ' + options);
        }
        else if (!$.isFunction(_this[options]) || options.charAt(0) === '_') {
          logError('No such method : ' + options);
        }
        else {
          if (!(args instanceof Array)) {
            args = [args];
          }
          result = _this[options].apply(_this, args);
        }
      }
      else if (typeof options === 'boolean') {
        result = _this;
      }
      else {
        $.data(this, pluginName, new fxTbl(this, $.extend(true, {}, options)));
      }
    });

    return result || this;    
  };

  /* options sample and default value */
  $.fn.table.defaults = {
    column: [{ 'Name': 'Seq', 'Label': 'Sequence', 'Display': true, 'Format': '', 'DataType': 'string', 'ShowDeleteButton': false }], /* list of table columns */
    data: [
      { 'col1': 'value', 'col2': 'value' } /* 'col1' value is based on the column.Name and 'value' is value to be display under the column. */
    ],
    notifyOptions: [{
      'delText': '', /* delete confirm's message*/
      'delTitle': '', /* delete confirm's title*/
      'selText': '', /* none selection alert's message*/
      'selTitle': '', /* none selection alert's title*/
      'delAllText': '', /* delete all confirm's message*/
      'delAllTitle': '', /* delete all confirm's title*/
    }],
    tbl_name: '', /* table name*/
    url: '', /* edit url */
    editLayout: 'bottom', /* bottom or side or new*/
    showCheckbox: true, /* show check box column on the most left */
    showRowActions: true, /* show actions button column on the most right*/
    bulkActions: { /* bulk actions that will appear as menu when there are row selections */
      'enabled': false,
      'actions': [{
        'icon': undefined, /* icon to be displayed on the left. eg: fa fa-eye*/
        'name': 'Delete', /* name to be display on the menu*/
        'onClick': undefined, /* event handler when action is clicked*/
        'divider': false /* indicates whether this is action or divider */
      }, {
        'divider': true /* if this item is divider, the rest of the properties can be left empty*/
      }
      ]
    },
    setAutoHeight: true, /* whether to set the table height automatically (only if the table display as a whole on the UI)*/
    actions: { /* list of actions */
      'edit': {
        'enabled': false,
        'onClick': undefined
      },
      'delete': {
        'enabled': false,
        'onClick': undefined,
      },
      'deleteRow': {
        'enabled': false,
        'onClick': undefined,
      },
      'deleteAll': {
        'enabled': false,
        'onClick': undefined,
      },
      'add': {
        'enabled': false,
        'onClick': undefined,
      },
      'refresh': {
        'enabled': false,
        'row': false, /* indicate whether this action is to be on the action column*/
        'icon': '',/* no need if its not action column*/
        'class': '', /* no need if its not action column */
        'tooltip': '', /* no need if its not action column*/
        'label': '',/* no need if its not action column*/
        'onClick': undefined, /* event handler if the action is clicked*/
        'name': '', 
      }
    },
    /*customButton: [],*/
  };

})(jQuery, window, document);